/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.oidc.flows;

import java.util.Collections;
import java.util.List;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.representations.IDToken;
import org.keycloak.representations.idm.EventRepresentation;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.oidc.flows.AbstractOIDCResponseTypeTest;
import org.keycloak.testsuite.util.OAuthClient;

public class OIDCHybridResponseTypeCodeTokenTest
extends AbstractOIDCResponseTypeTest {
    @Before
    public void clientConfiguration() {
        this.clientManagerBuilder().standardFlow(true).implicitFlow(true);
        this.oauth.clientId("test-app");
        this.oauth.responseType("code token");
    }

    @Override
    protected boolean isFragment() {
        return true;
    }

    @Override
    protected List<IDToken> testAuthzResponseAndRetrieveIDTokens(OAuthClient.AuthorizationEndpointResponse authzResponse, EventRepresentation loginEvent) {
        Assert.assertEquals((Object)"code token", loginEvent.getDetails().get("response_type"));
        Assert.assertNotNull((Object)authzResponse.getAccessToken());
        Assert.assertNull((Object)authzResponse.getIdToken());
        OAuthClient.AccessTokenResponse authzResponse2 = this.sendTokenRequestAndGetResponse(loginEvent);
        IDToken idToken2 = this.oauth.verifyIDToken(authzResponse2.getIdToken());
        this.assertValidAccessTokenHash(idToken2.getAccessTokenHash(), authzResponse2.getAccessToken());
        Assert.assertNotNull((Object)authzResponse.getTokenType());
        Assert.assertNotNull((Object)authzResponse.getExpiresIn());
        return Collections.singletonList(idToken2);
    }

    @Test
    public void nonceNotUsedErrorExpected() {
        super.validateNonceNotUsedErrorExpected();
    }

    @Test
    public void errorStandardFlowNotAllowed() throws Exception {
        super.validateErrorStandardFlowNotAllowed();
    }

    @Test
    public void errorImplicitFlowNotAllowed() throws Exception {
        super.validateErrorImplicitFlowNotAllowed();
    }
}

