/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.oidc.flows;

import java.util.Arrays;
import java.util.List;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.jose.jws.crypto.HashUtils;
import org.keycloak.representations.IDToken;
import org.keycloak.representations.idm.EventRepresentation;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.oidc.flows.AbstractOIDCResponseTypeTest;
import org.keycloak.testsuite.util.OAuthClient;

public class OIDCHybridResponseTypeCodeIDTokenTokenTest
extends AbstractOIDCResponseTypeTest {
    @Before
    public void clientConfiguration() {
        this.clientManagerBuilder().standardFlow(true).implicitFlow(true);
        this.oauth.clientId("test-app");
        this.oauth.responseType("code id_token token");
    }

    @Override
    protected boolean isFragment() {
        return true;
    }

    @Override
    protected List<IDToken> testAuthzResponseAndRetrieveIDTokens(OAuthClient.AuthorizationEndpointResponse authzResponse, EventRepresentation loginEvent) {
        Assert.assertEquals((Object)"code id_token token", loginEvent.getDetails().get("response_type"));
        Assert.assertNotNull((Object)authzResponse.getAccessToken());
        String idTokenStr = authzResponse.getIdToken();
        IDToken idToken = this.oauth.verifyIDToken(idTokenStr);
        this.assertValidAccessTokenHash(idToken.getAccessTokenHash(), authzResponse.getAccessToken());
        this.assertValidCodeHash(idToken.getCodeHash(), authzResponse.getCode());
        Assert.assertNotNull((Object)idToken.getStateHash());
        Assert.assertEquals((Object)idToken.getStateHash(), (Object)HashUtils.oidcHash((String)this.getIdTokenSignatureAlgorithm(), (String)authzResponse.getState()));
        Assert.assertNotNull((Object)authzResponse.getTokenType());
        Assert.assertNotNull((Object)authzResponse.getExpiresIn());
        IDToken idToken2 = this.sendTokenRequestAndGetIDToken(loginEvent);
        return Arrays.asList(idToken, idToken2);
    }

    @Test
    public void nonceNotUsedErrorExpected() {
        super.validateNonceNotUsedErrorExpected();
    }

    @Test
    public void errorStandardFlowNotAllowed() throws Exception {
        super.validateErrorStandardFlowNotAllowed();
    }

    @Test
    public void errorImplicitFlowNotAllowed() throws Exception {
        super.validateErrorImplicitFlowNotAllowed();
    }
}

