/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.oidc.flows;

import java.io.IOException;
import java.security.Provider;
import java.security.Security;
import java.util.List;
import javax.ws.rs.core.UriBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.jose.jws.JWSHeader;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.crypto.HashUtils;
import org.keycloak.representations.IDToken;
import org.keycloak.representations.idm.EventRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.AbstractTestRealmKeycloakTest;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.pages.AppPage;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.util.ClientManager;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.TokenSignatureUtil;

public abstract class AbstractOIDCResponseTypeTest
extends AbstractTestRealmKeycloakTest {
    @Rule
    public AssertEvents events = new AssertEvents(this);
    @Page
    protected AppPage appPage;
    @Page
    protected LoginPage loginPage;
    private String idTokenSigAlgName = "RS256";

    @BeforeClass
    public static void addBouncyCastleProvider() {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
    }

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation realm = AbstractAdminTest.loadJson(this.getClass().getResourceAsStream("/testrealm.json"), RealmRepresentation.class);
        testRealms.add(realm);
    }

    @Test
    public void nonceAndSessionStateMatches() {
        EventRepresentation loginEvent = this.loginUser("abcdef123456");
        OAuthClient.AuthorizationEndpointResponse authzResponse = new OAuthClient.AuthorizationEndpointResponse(this.oauth, this.isFragment());
        Assert.assertNotNull((Object)authzResponse.getSessionState());
        List<IDToken> idTokens = this.testAuthzResponseAndRetrieveIDTokens(authzResponse, loginEvent);
        for (IDToken idToken : idTokens) {
            Assert.assertEquals((Object)"abcdef123456", (Object)idToken.getNonce());
            Assert.assertEquals((Object)authzResponse.getSessionState(), (Object)idToken.getSessionState());
        }
    }

    @Test
    public void initialSessionStateUsedInRedirect() {
        EventRepresentation loginEvent = this.loginUserWithRedirect("abcdef123456", OAuthClient.APP_ROOT + "/auth?session_state=foo");
        OAuthClient.AuthorizationEndpointResponse authzResponse = new OAuthClient.AuthorizationEndpointResponse(this.oauth, this.isFragment());
        Assert.assertNotNull((Object)authzResponse.getSessionState());
        List<IDToken> idTokens = this.testAuthzResponseAndRetrieveIDTokens(authzResponse, loginEvent);
        for (IDToken idToken : idTokens) {
            Assert.assertEquals((Object)authzResponse.getSessionState(), (Object)idToken.getSessionState());
        }
    }

    @Test
    public void authorizationRequestMissingResponseType() throws IOException {
        this.oauth.responseType(null);
        UriBuilder b = UriBuilder.fromUri((String)this.oauth.getLoginFormUrl());
        this.driver.navigate().to(b.build(new Object[0]).toURL());
        OAuthClient.AuthorizationEndpointResponse errorResponse = new OAuthClient.AuthorizationEndpointResponse(this.oauth, false);
        org.junit.Assert.assertTrue((boolean)errorResponse.isRedirected());
        org.junit.Assert.assertEquals((Object)errorResponse.getError(), (Object)"invalid_request");
        this.events.expectLogin().error("invalid_request").user((String)null).session((String)null).clearDetails().assertEvent();
    }

    protected void validateNonceNotUsedErrorExpected() {
        this.oauth.nonce(null);
        this.driver.navigate().to(this.oauth.getLoginFormUrl());
        org.junit.Assert.assertFalse((boolean)this.loginPage.isCurrent());
        org.junit.Assert.assertTrue((boolean)this.appPage.isCurrent());
        OAuthClient.AuthorizationEndpointResponse resp = new OAuthClient.AuthorizationEndpointResponse(this.oauth);
        Assert.assertNull((Object)resp.getCode());
        Assert.assertNull((Object)resp.getIdToken());
        Assert.assertEquals((Object)"invalid_request", (Object)resp.getError());
        Assert.assertEquals((Object)"Missing parameter: nonce", (Object)resp.getErrorDescription());
    }

    protected void validateErrorImplicitFlowNotAllowed() throws Exception {
        this.clientManagerBuilder().implicitFlow(false);
        UriBuilder b = UriBuilder.fromUri((String)this.oauth.getLoginFormUrl());
        this.driver.navigate().to(b.build(new Object[0]).toURL());
        OAuthClient.AuthorizationEndpointResponse errorResponse = new OAuthClient.AuthorizationEndpointResponse(this.oauth);
        Assert.assertTrue((boolean)errorResponse.isRedirected());
        Assert.assertEquals((Object)errorResponse.getError(), (Object)"unauthorized_client");
        Assert.assertEquals((Object)errorResponse.getErrorDescription(), (Object)"Client is not allowed to initiate browser login with given response_type. Implicit flow is disabled for the client.");
        this.events.expectLogin().error("not_allowed").user((String)null).session((String)null).clearDetails().assertEvent();
        this.clientManagerBuilder().implicitFlow(true);
    }

    protected void validateErrorStandardFlowNotAllowed() throws Exception {
        this.clientManagerBuilder().standardFlow(false);
        UriBuilder b = UriBuilder.fromUri((String)this.oauth.getLoginFormUrl());
        this.driver.navigate().to(b.build(new Object[0]).toURL());
        OAuthClient.AuthorizationEndpointResponse errorResponse = new OAuthClient.AuthorizationEndpointResponse(this.oauth);
        Assert.assertTrue((boolean)errorResponse.isRedirected());
        Assert.assertEquals((Object)errorResponse.getError(), (Object)"unauthorized_client");
        Assert.assertEquals((Object)errorResponse.getErrorDescription(), (Object)"Client is not allowed to initiate browser login with given response_type. Standard flow is disabled for the client.");
        this.events.expectLogin().error("not_allowed").user((String)null).session((String)null).clearDetails().assertEvent();
        this.clientManagerBuilder().standardFlow(true);
    }

    protected EventRepresentation loginUser(String nonce) {
        if (nonce != null) {
            this.oauth.nonce(nonce);
        }
        this.driver.navigate().to(this.oauth.getLoginFormUrl());
        this.loginPage.assertCurrent();
        this.loginPage.login("test-user@localhost", "password");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        return this.events.expectLogin().detail("username", "test-user@localhost").assertEvent();
    }

    protected EventRepresentation loginUserWithRedirect(String nonce, String redirectUri) {
        if (nonce != null) {
            this.oauth.nonce(nonce);
        }
        if (redirectUri != null) {
            this.oauth.redirectUri(redirectUri);
        }
        this.driver.navigate().to(this.oauth.getLoginFormUrl());
        this.loginPage.assertCurrent();
        this.loginPage.login("test-user@localhost", "password");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        return this.events.expectLogin().detail("redirect_uri", redirectUri).detail("username", "test-user@localhost").assertEvent();
    }

    protected abstract boolean isFragment();

    protected abstract List<IDToken> testAuthzResponseAndRetrieveIDTokens(OAuthClient.AuthorizationEndpointResponse var1, EventRepresentation var2);

    protected ClientManager.ClientManagerBuilder clientManagerBuilder() {
        return ClientManager.realm(this.adminClient.realm("test")).clientId("test-app");
    }

    private void oidcFlow(String expectedAccessAlg, String expectedIdTokenAlg) throws Exception {
        EventRepresentation loginEvent = this.loginUser("abcdef123456");
        OAuthClient.AuthorizationEndpointResponse authzResponse = new OAuthClient.AuthorizationEndpointResponse(this.oauth, this.isFragment());
        Assert.assertNotNull((Object)authzResponse.getSessionState());
        JWSHeader header = null;
        String idToken = authzResponse.getIdToken();
        String accessToken = authzResponse.getAccessToken();
        if (idToken != null) {
            header = new JWSInput(idToken).getHeader();
            org.junit.Assert.assertEquals((Object)expectedIdTokenAlg, (Object)header.getAlgorithm().name());
            org.junit.Assert.assertEquals((Object)"JWT", (Object)header.getType());
            org.junit.Assert.assertNull((Object)header.getContentType());
        }
        if (accessToken != null) {
            header = new JWSInput(accessToken).getHeader();
            org.junit.Assert.assertEquals((Object)expectedAccessAlg, (Object)header.getAlgorithm().name());
            org.junit.Assert.assertEquals((Object)"JWT", (Object)header.getType());
            org.junit.Assert.assertNull((Object)header.getContentType());
        }
        List<IDToken> idTokens = this.testAuthzResponseAndRetrieveIDTokens(authzResponse, loginEvent);
        for (IDToken idt : idTokens) {
            Assert.assertEquals((Object)"abcdef123456", (Object)idt.getNonce());
            Assert.assertEquals((Object)authzResponse.getSessionState(), (Object)idt.getSessionState());
        }
    }

    @Test
    public void oidcFlow_RealmRS256_ClientRS384() throws Exception {
        this.oidcFlowRequest("RS256", "RS384");
    }

    @Test
    public void oidcFlow_RealmES256_ClientES384() throws Exception {
        this.oidcFlowRequest("ES256", "ES384");
    }

    @Test
    public void oidcFlow_RealmRS256_ClientPS256() throws Exception {
        this.oidcFlowRequest("RS256", "PS256");
    }

    @Test
    public void oidcFlow_RealmPS256_ClientES256() throws Exception {
        this.oidcFlowRequest("PS256", "ES256");
    }

    private void oidcFlowRequest(String expectedAccessAlg, String expectedIdTokenAlg) throws Exception {
        try {
            this.setIdTokenSignatureAlgorithm(expectedIdTokenAlg);
            TokenSignatureUtil.changeRealmTokenSignatureProvider((Keycloak)this.adminClient, (String)expectedAccessAlg);
            TokenSignatureUtil.changeClientIdTokenSignatureProvider((ClientResource)ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app"), (String)expectedIdTokenAlg);
            this.oidcFlow(expectedAccessAlg, expectedIdTokenAlg);
        }
        finally {
            this.setIdTokenSignatureAlgorithm("RS256");
            TokenSignatureUtil.changeRealmTokenSignatureProvider((Keycloak)this.adminClient, (String)"RS256");
            TokenSignatureUtil.changeClientIdTokenSignatureProvider((ClientResource)ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app"), (String)"RS256");
        }
    }

    private void setIdTokenSignatureAlgorithm(String idTokenSigAlgName) {
        this.idTokenSigAlgName = idTokenSigAlgName;
    }

    protected String getIdTokenSignatureAlgorithm() {
        return this.idTokenSigAlgName;
    }

    protected void assertValidAccessTokenHash(String accessTokenHash, String accessToken) {
        Assert.assertNotNull((Object)accessTokenHash);
        Assert.assertNotNull((Object)accessToken);
        org.junit.Assert.assertEquals((Object)accessTokenHash, (Object)HashUtils.oidcHash((String)this.getIdTokenSignatureAlgorithm(), (String)accessToken));
    }

    protected void assertValidCodeHash(String codeHash, String code) {
        Assert.assertNotNull((Object)codeHash);
        Assert.assertNotNull((Object)code);
        Assert.assertEquals((Object)codeHash, (Object)HashUtils.oidcHash((String)this.getIdTokenSignatureAlgorithm(), (String)code));
    }
}

