/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.oidc;

import java.net.URI;
import java.security.PublicKey;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.ClientScopesResource;
import org.keycloak.admin.client.resource.ProtocolMappersResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.common.util.PemUtils;
import org.keycloak.common.util.Time;
import org.keycloak.events.EventType;
import org.keycloak.jose.jws.Algorithm;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.crypto.RSAProvider;
import org.keycloak.protocol.oidc.OIDCAdvancedConfigWrapper;
import org.keycloak.protocol.oidc.OIDCLoginProtocolService;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.representations.UserInfo;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ClientScopeRepresentation;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.services.Urls;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.util.AdminClientUtil;
import org.keycloak.testsuite.util.ClientBuilder;
import org.keycloak.testsuite.util.ClientManager;
import org.keycloak.testsuite.util.KeycloakModelUtils;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.RealmBuilder;
import org.keycloak.testsuite.util.RoleBuilder;
import org.keycloak.testsuite.util.TokenSignatureUtil;
import org.keycloak.testsuite.util.UserInfoClientUtil;
import org.keycloak.util.BasicAuthHelper;
import org.keycloak.util.JsonSerialization;

public class UserInfoTest
extends AbstractKeycloakTest {
    @Rule
    public AssertEvents events = new AssertEvents(this);

    @Override
    public void beforeAbstractKeycloakTest() throws Exception {
        super.beforeAbstractKeycloakTest();
    }

    @Before
    public void clientConfiguration() {
        ClientManager.realm(this.adminClient.realm("test")).clientId("test-app").directAccessGrant(true);
    }

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation realmRepresentation = AbstractAdminTest.loadJson(this.getClass().getResourceAsStream("/testrealm.json"), RealmRepresentation.class);
        RealmBuilder realm = RealmBuilder.edit(realmRepresentation).testEventListener();
        RealmRepresentation testRealm = realm.build();
        testRealms.add(testRealm);
        ClientRepresentation samlApp = KeycloakModelUtils.createClient(testRealm, "saml-client");
        samlApp.setSecret("secret");
        samlApp.setServiceAccountsEnabled(Boolean.valueOf(true));
        samlApp.setDirectAccessGrantsEnabled(Boolean.valueOf(true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSuccess_getMethod_header() throws Exception {
        try (ResteasyClient client = AdminClientUtil.createResteasyClient();){
            AccessTokenResponse accessTokenResponse = this.executeGrantAccessTokenRequest((Client)client);
            Response response = UserInfoClientUtil.executeUserInfoRequest_getMethod((Client)client, (String)accessTokenResponse.getToken());
            UserInfo userInfo = this.testSuccessfulUserInfoResponse(response);
            this.testRolesAreNotInUserInfoResponse(userInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSuccess_postMethod_header() throws Exception {
        try (ResteasyClient client = AdminClientUtil.createResteasyClient();){
            AccessTokenResponse accessTokenResponse = this.executeGrantAccessTokenRequest((Client)client);
            WebTarget userInfoTarget = UserInfoClientUtil.getUserInfoWebTarget((Client)client);
            Response response = userInfoTarget.request().header("Authorization", (Object)("bearer " + accessTokenResponse.getToken())).post(Entity.form((Form)new Form()));
            this.testSuccessfulUserInfoResponse(response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSuccess_postMethod_body() throws Exception {
        try (ResteasyClient client = AdminClientUtil.createResteasyClient();){
            AccessTokenResponse accessTokenResponse = this.executeGrantAccessTokenRequest((Client)client);
            Form form = new Form();
            form.param("access_token", accessTokenResponse.getToken());
            WebTarget userInfoTarget = UserInfoClientUtil.getUserInfoWebTarget((Client)client);
            Response response = userInfoTarget.request().post(Entity.form((Form)form));
            this.testSuccessfulUserInfoResponse(response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSuccess_dotsInClientId() throws Exception {
        ClientRepresentation clientRep = ClientBuilder.create().clientId("my.foo.client").addRedirectUri("http://foo.host").secret("password").directAccessGrants().build();
        RealmResource realm = this.adminClient.realm("test");
        Response resp = realm.clients().create(clientRep);
        String clientUUID = ApiUtil.getCreatedId((Response)resp);
        resp.close();
        this.getCleanup().addClientUuid(clientUUID);
        realm.clients().get(clientUUID).roles().create(RoleBuilder.create().name("my.foo.role").build());
        RoleRepresentation fooRole = realm.clients().get(clientUUID).roles().get("my.foo.role").toRepresentation();
        UserResource userResource = ApiUtil.findUserByUsernameId((RealmResource)realm, (String)"test-user@localhost");
        userResource.roles().clientLevel(clientUUID).add(Collections.singletonList(fooRole));
        OAuthClient.AccessTokenResponse accessTokenResponse = this.oauth.clientId("my.foo.client").doGrantAccessTokenRequest("password", "test-user@localhost", "password");
        AccessToken accessToken = this.oauth.verifyToken(accessTokenResponse.getAccessToken());
        Assert.assertNames(accessToken.getResourceAccess("my.foo.client").getRoles(), "my.foo.role");
        this.events.clear();
        try (ResteasyClient client = AdminClientUtil.createResteasyClient();){
            Response response = UserInfoClientUtil.executeUserInfoRequest_getMethod((Client)client, (String)accessTokenResponse.getAccessToken());
            this.testSuccessfulUserInfoResponse(response, "my.foo.client");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSuccess_postMethod_header_textEntity() throws Exception {
        try (ResteasyClient client = AdminClientUtil.createResteasyClient();){
            AccessTokenResponse accessTokenResponse = this.executeGrantAccessTokenRequest((Client)client);
            WebTarget userInfoTarget = UserInfoClientUtil.getUserInfoWebTarget((Client)client);
            Response response = userInfoTarget.request().header("Authorization", (Object)("bearer " + accessTokenResponse.getToken())).post(Entity.text((Object)""));
            this.testSuccessfulUserInfoResponse(response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSuccessSignedResponse() throws Exception {
        ClientResource clientResource = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app");
        ClientRepresentation clientRep = clientResource.toRepresentation();
        OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).setUserInfoSignedResponseAlg(Algorithm.RS256);
        clientResource.update(clientRep);
        try (ResteasyClient client = AdminClientUtil.createResteasyClient();){
            AccessTokenResponse accessTokenResponse = this.executeGrantAccessTokenRequest((Client)client);
            Response response = UserInfoClientUtil.executeUserInfoRequest_getMethod((Client)client, (String)accessTokenResponse.getToken());
            this.events.expect(EventType.USER_INFO_REQUEST).session((Matcher<String>)Matchers.notNullValue(String.class)).detail("auth_method", "validate_access_token").detail("username", "test-user@localhost").detail("signature_required", "true").detail("signature_algorithm", Algorithm.RS256.toString()).assertEvent();
            PublicKey publicKey = PemUtils.decodePublicKey((String)ApiUtil.findActiveSigningKey((RealmResource)this.adminClient.realm("test")).getPublicKey());
            Assert.assertEquals((long)200L, (long)response.getStatus());
            Assert.assertEquals((Object)response.getHeaderString("Content-Type"), (Object)"application/jwt");
            String signedResponse = (String)response.readEntity(String.class);
            response.close();
            JWSInput jwsInput = new JWSInput(signedResponse);
            Assert.assertTrue((boolean)RSAProvider.verify((JWSInput)jwsInput, (PublicKey)publicKey));
            UserInfo userInfo = (UserInfo)JsonSerialization.readValue((byte[])jwsInput.getContent(), UserInfo.class);
            Assert.assertNotNull((Object)userInfo);
            Assert.assertNotNull((Object)userInfo.getSubject());
            Assert.assertEquals((Object)"test-user@localhost", (Object)userInfo.getEmail());
            Assert.assertEquals((Object)"test-user@localhost", (Object)userInfo.getPreferredUsername());
            Assert.assertTrue((boolean)userInfo.hasAudience("test-app"));
            String expectedIssuer = Urls.realmIssuer((URI)new URI(OAuthClient.AUTH_SERVER_ROOT), (String)"test");
            Assert.assertEquals((Object)expectedIssuer, (Object)userInfo.getIssuer());
        }
        OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).setUserInfoSignedResponseAlg(null);
        clientResource.update(clientRep);
    }

    @Test
    public void testSuccessSignedResponseES256() throws Exception {
        this.testSuccessSignedResponse(Algorithm.ES256);
    }

    @Test
    public void testSuccessSignedResponsePS256() throws Exception {
        this.testSuccessSignedResponse(Algorithm.PS256);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSessionExpired() {
        try (ResteasyClient client = AdminClientUtil.createResteasyClient();){
            AccessTokenResponse accessTokenResponse = this.executeGrantAccessTokenRequest((Client)client);
            String realmName = "test";
            this.testingClient.testing().removeUserSessions(realmName);
            Response response = UserInfoClientUtil.executeUserInfoRequest_getMethod((Client)client, (String)accessTokenResponse.getToken());
            org.junit.Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.getStatus());
            String wwwAuthHeader = response.getHeaderString("WWW-Authenticate");
            org.junit.Assert.assertNotNull((Object)wwwAuthHeader);
            org.junit.Assert.assertThat((Object)wwwAuthHeader, (Matcher)CoreMatchers.containsString((String)"Bearer"));
            org.junit.Assert.assertThat((Object)wwwAuthHeader, (Matcher)CoreMatchers.containsString((String)("realm=\"" + realmName + "\"")));
            org.junit.Assert.assertThat((Object)wwwAuthHeader, (Matcher)CoreMatchers.containsString((String)"error=\"invalid_request\""));
            response.close();
            this.events.expect(EventType.USER_INFO_REQUEST_ERROR).error("user_session_not_found").user((Matcher<String>)Matchers.nullValue(String.class)).session((Matcher<String>)Matchers.nullValue(String.class)).detail("auth_method", "validate_access_token").assertEvent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAccessTokenExpired() {
        try (ResteasyClient client = AdminClientUtil.createResteasyClient();){
            AccessTokenResponse accessTokenResponse = this.executeGrantAccessTokenRequest((Client)client);
            this.setTimeOffset(600);
            Response response = UserInfoClientUtil.executeUserInfoRequest_getMethod((Client)client, (String)accessTokenResponse.getToken());
            org.junit.Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.getStatus());
            String wwwAuthHeader = response.getHeaderString("WWW-Authenticate");
            org.junit.Assert.assertNotNull((Object)wwwAuthHeader);
            org.junit.Assert.assertThat((Object)wwwAuthHeader, (Matcher)CoreMatchers.containsString((String)"Bearer"));
            org.junit.Assert.assertThat((Object)wwwAuthHeader, (Matcher)CoreMatchers.containsString((String)"error=\"invalid_token\""));
            response.close();
            this.events.expect(EventType.USER_INFO_REQUEST_ERROR).error("invalid_token").user((Matcher<String>)Matchers.nullValue(String.class)).session((Matcher<String>)Matchers.nullValue(String.class)).detail("auth_method", "validate_access_token").client((String)null).assertEvent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAccessTokenAfterUserSessionLogoutAndLoginAgain() {
        OAuthClient.AccessTokenResponse accessTokenResponse = this.loginAndForceNewLoginPage();
        String refreshToken1 = accessTokenResponse.getRefreshToken();
        this.oauth.doLogout(refreshToken1, "password");
        this.events.clear();
        this.setTimeOffset(2);
        this.oauth.fillLoginForm("test-user@localhost", "password");
        this.events.expectLogin().assertEvent();
        Assert.assertFalse((boolean)this.loginPage.isCurrent());
        this.events.clear();
        try (ResteasyClient client = AdminClientUtil.createResteasyClient();){
            Response response = UserInfoClientUtil.executeUserInfoRequest_getMethod((Client)client, (String)accessTokenResponse.getAccessToken());
            org.junit.Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.getStatus());
            String wwwAuthHeader = response.getHeaderString("WWW-Authenticate");
            org.junit.Assert.assertNotNull((Object)wwwAuthHeader);
            org.junit.Assert.assertThat((Object)wwwAuthHeader, (Matcher)CoreMatchers.containsString((String)"Bearer"));
            org.junit.Assert.assertThat((Object)wwwAuthHeader, (Matcher)CoreMatchers.containsString((String)"error=\"invalid_token\""));
            response.close();
            this.events.expect(EventType.USER_INFO_REQUEST_ERROR).error("invalid_token").user((Matcher<String>)Matchers.nullValue(String.class)).session((Matcher<String>)Matchers.nullValue(String.class)).detail("auth_method", "validate_access_token").client("test-app").assertEvent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNotBeforeTokens() {
        try (ResteasyClient client = AdminClientUtil.createResteasyClient();){
            AccessTokenResponse accessTokenResponse = this.executeGrantAccessTokenRequest((Client)client);
            int time = Time.currentTime() + 60;
            RealmResource realm = this.adminClient.realm("test");
            RealmRepresentation rep = realm.toRepresentation();
            rep.setNotBefore(Integer.valueOf(time));
            realm.update(rep);
            Response response = UserInfoClientUtil.executeUserInfoRequest_getMethod((Client)client, (String)accessTokenResponse.getToken());
            org.junit.Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.getStatus());
            response.close();
            this.events.expect(EventType.USER_INFO_REQUEST_ERROR).error("invalid_token").user((Matcher<String>)Matchers.nullValue(String.class)).session((Matcher<String>)Matchers.nullValue(String.class)).detail("auth_method", "validate_access_token").client((String)null).assertEvent();
            this.events.clear();
            rep.setNotBefore(Integer.valueOf(0));
            realm.update(rep);
            ClientResource clientResource = realm.clients().get(((ClientRepresentation)realm.clients().findByClientId("test-app").get(0)).getId());
            ClientRepresentation clientRep = clientResource.toRepresentation();
            clientRep.setNotBefore(Integer.valueOf(time));
            clientResource.update(clientRep);
            response = UserInfoClientUtil.executeUserInfoRequest_getMethod((Client)client, (String)accessTokenResponse.getToken());
            org.junit.Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.getStatus());
            response.close();
            this.events.expect(EventType.USER_INFO_REQUEST_ERROR).error("invalid_token").user((Matcher<String>)Matchers.nullValue(String.class)).session((Matcher<String>)Matchers.nullValue(String.class)).detail("auth_method", "validate_access_token").client((String)null).assertEvent();
            clientRep.setNotBefore(Integer.valueOf(0));
            clientResource.update(clientRep);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSessionExpiredOfflineAccess() throws Exception {
        try (ResteasyClient client = AdminClientUtil.createResteasyClient();){
            AccessTokenResponse accessTokenResponse = this.executeGrantAccessTokenRequest((Client)client, true);
            this.testingClient.testing().removeUserSessions("test");
            Response response = UserInfoClientUtil.executeUserInfoRequest_getMethod((Client)client, (String)accessTokenResponse.getToken());
            this.testSuccessfulUserInfoResponse(response);
            response.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnsuccessfulUserInfoRequest() throws Exception {
        try (ResteasyClient client = AdminClientUtil.createResteasyClient();){
            Response response = UserInfoClientUtil.executeUserInfoRequest_getMethod((Client)client, (String)"bad");
            response.close();
            org.junit.Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.getStatus());
            String wwwAuthHeader = response.getHeaderString("WWW-Authenticate");
            org.junit.Assert.assertNotNull((Object)wwwAuthHeader);
            org.junit.Assert.assertThat((Object)wwwAuthHeader, (Matcher)CoreMatchers.containsString((String)"Bearer"));
            org.junit.Assert.assertThat((Object)wwwAuthHeader, (Matcher)CoreMatchers.containsString((String)"error=\"invalid_token\""));
            this.events.expect(EventType.USER_INFO_REQUEST_ERROR).error("invalid_token").client((String)null).user((Matcher<String>)Matchers.nullValue(String.class)).session((Matcher<String>)Matchers.nullValue(String.class)).detail("auth_method", "validate_access_token").assertEvent();
        }
    }

    @Test
    public void testUnsuccessfulUserInfoRequestWithEmptyAccessToken() {
        try (ResteasyClient client = AdminClientUtil.createResteasyClient();){
            Response response = UserInfoClientUtil.executeUserInfoRequest_getMethod((Client)client, (String)"");
            response.close();
            org.junit.Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatus());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUserInfoRequestWithSamlClient() throws Exception {
        String accessToken = this.oauth.doGrantAccessTokenRequest("test", "test-user@localhost", "password", null, "saml-client", "secret").getAccessToken();
        ClientRepresentation samlClient = (ClientRepresentation)this.adminClient.realm("test").clients().findByClientId("saml-client").get(0);
        samlClient.setProtocol("saml");
        this.adminClient.realm("test").clients().get(samlClient.getId()).update(samlClient);
        try (ResteasyClient client = AdminClientUtil.createResteasyClient();){
            this.events.clear();
            Response response = UserInfoClientUtil.executeUserInfoRequest_getMethod((Client)client, (String)accessToken);
            response.close();
            org.junit.Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatus());
            this.events.expect(EventType.USER_INFO_REQUEST).error("invalid_client").client((String)null).user((Matcher<String>)Matchers.nullValue(String.class)).session((Matcher<String>)Matchers.nullValue(String.class)).detail("auth_method", "validate_access_token").assertEvent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRolesAreAvailable_getMethod_header() throws Exception {
        this.switchIncludeRolesInUserInfoEndpoint(true);
        ResteasyClient client = AdminClientUtil.createResteasyClient();
        try {
            AccessTokenResponse accessTokenResponse = this.executeGrantAccessTokenRequest((Client)client);
            Response response = UserInfoClientUtil.executeUserInfoRequest_getMethod((Client)client, (String)accessTokenResponse.getToken());
            UserInfo userInfo = this.testSuccessfulUserInfoResponse(response);
            this.testRolesInUserInfoResponse(userInfo);
        }
        finally {
            client.close();
            this.switchIncludeRolesInUserInfoEndpoint(false);
        }
    }

    private AccessTokenResponse executeGrantAccessTokenRequest(Client client) {
        return this.executeGrantAccessTokenRequest(client, false);
    }

    private AccessTokenResponse executeGrantAccessTokenRequest(Client client, boolean requestOfflineToken) {
        UriBuilder builder = UriBuilder.fromUri((String)OAuthClient.AUTH_SERVER_ROOT);
        URI grantUri = OIDCLoginProtocolService.tokenUrl((UriBuilder)builder).build(new Object[]{"test"});
        WebTarget grantTarget = client.target(grantUri);
        String header = BasicAuthHelper.createHeader((String)"test-app", (String)"password");
        Form form = new Form();
        form.param("grant_type", "password").param("username", "test-user@localhost").param("password", "password");
        if (requestOfflineToken) {
            form.param("scope", "offline_access");
        }
        Response response = grantTarget.request().header("Authorization", (Object)header).post(Entity.form((Form)form));
        org.junit.Assert.assertEquals((long)200L, (long)response.getStatus());
        AccessTokenResponse accessTokenResponse = (AccessTokenResponse)response.readEntity(AccessTokenResponse.class);
        response.close();
        this.events.clear();
        return accessTokenResponse;
    }

    private UserInfo testSuccessfulUserInfoResponse(Response response) {
        return this.testSuccessfulUserInfoResponse(response, "test-app");
    }

    private UserInfo testSuccessfulUserInfoResponse(Response response, String expectedClientId) {
        this.events.expect(EventType.USER_INFO_REQUEST).session((Matcher<String>)Matchers.notNullValue(String.class)).detail("auth_method", "validate_access_token").detail("username", "test-user@localhost").detail("signature_required", "false").client(expectedClientId).assertEvent();
        return UserInfoClientUtil.testSuccessfulUserInfoResponse((Response)response, (String)"test-user@localhost", (String)"test-user@localhost");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testSuccessSignedResponse(Algorithm sigAlg) throws Exception {
        try {
            ClientResource clientResource = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app");
            ClientRepresentation clientRep = clientResource.toRepresentation();
            OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).setUserInfoSignedResponseAlg(sigAlg);
            clientResource.update(clientRep);
            try (ResteasyClient client = AdminClientUtil.createResteasyClient();){
                AccessTokenResponse accessTokenResponse = this.executeGrantAccessTokenRequest((Client)client);
                Response response = UserInfoClientUtil.executeUserInfoRequest_getMethod((Client)client, (String)accessTokenResponse.getToken());
                this.events.expect(EventType.USER_INFO_REQUEST).session((Matcher<String>)Matchers.notNullValue(String.class)).detail("auth_method", "validate_access_token").detail("username", "test-user@localhost").detail("signature_required", "true").detail("signature_algorithm", sigAlg.toString()).assertEvent();
                Assert.assertEquals((long)200L, (long)response.getStatus());
                Assert.assertEquals((Object)response.getHeaderString("Content-Type"), (Object)"application/jwt");
                String signedResponse = (String)response.readEntity(String.class);
                response.close();
                JWSInput jwsInput = new JWSInput(signedResponse);
                org.junit.Assert.assertEquals((Object)sigAlg.toString(), (Object)jwsInput.getHeader().getAlgorithm().name());
                UserInfo userInfo = (UserInfo)JsonSerialization.readValue((byte[])jwsInput.getContent(), UserInfo.class);
                Assert.assertNotNull((Object)userInfo);
                Assert.assertNotNull((Object)userInfo.getSubject());
                Assert.assertEquals((Object)"test-user@localhost", (Object)userInfo.getEmail());
                Assert.assertEquals((Object)"test-user@localhost", (Object)userInfo.getPreferredUsername());
                Assert.assertTrue((boolean)userInfo.hasAudience("test-app"));
                String expectedIssuer = Urls.realmIssuer((URI)new URI(OAuthClient.AUTH_SERVER_ROOT), (String)"test");
                Assert.assertEquals((Object)expectedIssuer, (Object)userInfo.getIssuer());
            }
            OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).setUserInfoSignedResponseAlg(null);
            clientResource.update(clientRep);
        }
        finally {
            TokenSignatureUtil.changeRealmTokenSignatureProvider((Keycloak)this.adminClient, (String)"RS256");
        }
    }

    private OAuthClient.AccessTokenResponse loginAndForceNewLoginPage() {
        this.oauth.doLogin("test-user@localhost", "password");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        this.oauth.clientSessionState("client-session");
        OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doAccessTokenRequest(code, "password");
        this.setTimeOffset(1);
        String loginFormUri = UriBuilder.fromUri((String)this.oauth.getLoginFormUrl()).queryParam("prompt", new Object[]{"login"}).build(new Object[0]).toString();
        this.driver.navigate().to(loginFormUri);
        this.loginPage.assertCurrent();
        return tokenResponse;
    }

    private void switchIncludeRolesInUserInfoEndpoint(boolean includeRoles) {
        ClientScopesResource clientScopesResource = this.adminClient.realm("test").clientScopes();
        ClientScopeRepresentation rolesClientScope = clientScopesResource.findAll().stream().filter(clientScope -> "roles".equals(clientScope.getName())).findAny().get();
        ProtocolMappersResource protocolMappersResource = clientScopesResource.get(rolesClientScope.getId()).getProtocolMappers();
        ProtocolMapperRepresentation realmRolesMapper = protocolMappersResource.getMappers().stream().filter(mapper -> "realm roles".equals(mapper.getName())).findAny().get();
        realmRolesMapper.getConfig().put("userinfo.token.claim", String.valueOf(includeRoles));
        ProtocolMapperRepresentation clientRolesMapper = protocolMappersResource.getMappers().stream().filter(mapper -> "client roles".equals(mapper.getName())).findAny().get();
        clientRolesMapper.getConfig().put("userinfo.token.claim", String.valueOf(includeRoles));
        protocolMappersResource.update(realmRolesMapper.getId(), realmRolesMapper);
        protocolMappersResource.update(clientRolesMapper.getId(), clientRolesMapper);
    }

    private void testRolesInUserInfoResponse(UserInfo userInfo) {
        Map realmAccess = (Map)userInfo.getOtherClaims().get("realm_access");
        Map resourceAccess = (Map)userInfo.getOtherClaims().get("resource_access");
        MatcherAssert.assertThat((Object)((Collection)realmAccess.get("roles")), (Matcher)CoreMatchers.hasItems((Object[])new String[]{"offline_access", "user"}));
        MatcherAssert.assertThat((Object)((Collection)((Map)resourceAccess.get("test-app")).get("roles")), (Matcher)CoreMatchers.hasItems((Object[])new String[]{"customer-user"}));
    }

    private void testRolesAreNotInUserInfoResponse(UserInfo userInfo) {
        org.junit.Assert.assertNull(userInfo.getOtherClaims().get("realm_access"));
        org.junit.Assert.assertNull(userInfo.getOtherClaims().get("resource_access"));
    }
}

