/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.oidc;

import java.security.MessageDigest;
import java.util.UUID;
import org.keycloak.common.util.Base64Url;

public class PkceGenerator {
    private String codeVerifier;
    private String codeChallenge;

    public PkceGenerator() {
        this.codeVerifier = UUID.randomUUID().toString() + "-" + UUID.randomUUID().toString();
        this.codeChallenge = this.generateS256CodeChallenge(this.codeVerifier);
    }

    public PkceGenerator(String codeVerifier) {
        this.codeVerifier = codeVerifier;
        this.codeChallenge = this.generateS256CodeChallenge(codeVerifier);
    }

    public String getCodeVerifier() {
        return this.codeVerifier;
    }

    public String getCodeChallenge() {
        return this.codeChallenge;
    }

    private String generateS256CodeChallenge(String codeVerifier) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(codeVerifier.getBytes("ISO_8859_1"));
            byte[] digestBytes = md.digest();
            String codeChallenge = Base64Url.encode((byte[])digestBytes);
            return codeChallenge;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

