/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.oauth;

import java.util.List;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.util.AdminClientUtil;
import org.keycloak.testsuite.util.ClientBuilder;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.UserInfoClientUtil;

public class UserInfoEndpointCorsTest
extends AbstractKeycloakTest {
    private static final String VALID_CORS_URL = "http://localtest.me:8180";
    private static final String INVALID_CORS_URL = "http://invalid.localtest.me:8180";

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation realm = AbstractAdminTest.loadJson(this.getClass().getResourceAsStream("/testrealm.json"), RealmRepresentation.class);
        realm.getClients().add(ClientBuilder.create().redirectUris("http://localtest.me:8180/realms/master/app").addWebOrigin(VALID_CORS_URL).clientId("test-app2").publicClient().directAccessGrants().build());
        testRealms.add(realm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void userInfoCorsValidRequestWithValidUrl() throws Exception {
        this.oauth.realm("test");
        this.oauth.clientId("test-app2");
        this.oauth.redirectUri("http://localtest.me:8180/realms/master/app");
        OAuthClient.AccessTokenResponse accessTokenResponse = this.oauth.doGrantAccessTokenRequest(null, "test-user@localhost", "password");
        try (ResteasyClient resteasyClient = AdminClientUtil.createResteasyClient();){
            WebTarget userInfoTarget = UserInfoClientUtil.getUserInfoWebTarget((Client)resteasyClient);
            Response userInfoResponse = userInfoTarget.request().header("Authorization", (Object)("bearer " + accessTokenResponse.getAccessToken())).header("Origin", (Object)VALID_CORS_URL).get();
            UserInfoClientUtil.testSuccessfulUserInfoResponse((Response)userInfoResponse, (String)"test-user@localhost", (String)"test-user@localhost");
            UserInfoEndpointCorsTest.assertCors(userInfoResponse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void userInfoCorsInvalidRequestWithValidUrl() throws Exception {
        this.oauth.realm("test");
        this.oauth.clientId("test-app2");
        this.oauth.redirectUri("http://localtest.me:8180/realms/master/app");
        OAuthClient.AccessTokenResponse accessTokenResponse = this.oauth.doGrantAccessTokenRequest(null, "test-user@localhost", "password");
        this.setTimeOffset(600);
        try (ResteasyClient resteasyClient = AdminClientUtil.createResteasyClient();){
            WebTarget userInfoTarget = UserInfoClientUtil.getUserInfoWebTarget((Client)resteasyClient);
            Response userInfoResponse = userInfoTarget.request().header("Authorization", (Object)("bearer " + accessTokenResponse.getAccessToken())).header("Origin", (Object)VALID_CORS_URL).get();
            Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)userInfoResponse.getStatus());
            UserInfoEndpointCorsTest.assertCors(userInfoResponse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void userInfoCorsValidRequestWithInvalidUrlShouldFail() throws Exception {
        this.oauth.realm("test");
        this.oauth.clientId("test-app2");
        this.oauth.redirectUri("http://localtest.me:8180/realms/master/app");
        OAuthClient.AccessTokenResponse accessTokenResponse = this.oauth.doGrantAccessTokenRequest(null, "test-user@localhost", "password");
        try (ResteasyClient resteasyClient = AdminClientUtil.createResteasyClient();){
            WebTarget userInfoTarget = UserInfoClientUtil.getUserInfoWebTarget((Client)resteasyClient);
            Response userInfoResponse = userInfoTarget.request().header("Authorization", (Object)("bearer " + accessTokenResponse.getAccessToken())).header("Origin", (Object)INVALID_CORS_URL).get();
            UserInfoClientUtil.testSuccessfulUserInfoResponse((Response)userInfoResponse, (String)"test-user@localhost", (String)"test-user@localhost");
            UserInfoEndpointCorsTest.assertNotCors(userInfoResponse);
        }
    }

    private static void assertCors(Response response) {
        Assert.assertEquals((Object)"true", (Object)response.getHeaders().getFirst((Object)"Access-Control-Allow-Credentials"));
        Assert.assertEquals((Object)VALID_CORS_URL, (Object)response.getHeaders().getFirst((Object)"Access-Control-Allow-Origin"));
        response.close();
    }

    private static void assertNotCors(Response response) {
        Assert.assertNull((Object)response.getHeaders().get((Object)"Access-Control-Allow-Credentials"));
        Assert.assertNull((Object)response.getHeaders().get((Object)"Access-Control-Allow-Origin"));
        Assert.assertNull((Object)response.getHeaders().get((Object)"Access-Control-Expose-Headers"));
        response.close();
    }
}

