/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.oauth;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.hamcrest.Matcher;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.OAuth2ErrorRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.idm.UserSessionRepresentation;
import org.keycloak.representations.oidc.TokenMetadataRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.util.ClientManager;
import org.keycloak.testsuite.util.Matchers;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.RealmBuilder;
import org.keycloak.util.JsonSerialization;

public class TokenRevocationTest
extends AbstractKeycloakTest {
    private RealmResource realm;
    @Rule
    public AssertEvents events = new AssertEvents(this);
    @Page
    protected LoginPage loginPage;

    @Override
    public void beforeAbstractKeycloakTest() throws Exception {
        super.beforeAbstractKeycloakTest();
    }

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation realmRepresentation = AbstractAdminTest.loadJson(this.getClass().getResourceAsStream("/testrealm.json"), RealmRepresentation.class);
        RealmBuilder realm = RealmBuilder.edit(realmRepresentation).testEventListener();
        testRealms.add(realm.build());
    }

    @Before
    public void clientConfiguration() {
        this.realm = this.adminClient.realm("test");
        ClientManager.realm(this.realm).clientId("test-app").directAccessGrant(true);
        ClientManager.realm(this.realm).clientId("test-app-scope").directAccessGrant(true);
    }

    @Test
    public void testRevokeToken() throws Exception {
        this.oauth.clientSessionState("client-session");
        OAuthClient.AccessTokenResponse tokenResponse1 = this.login("test-app", "test-user@localhost", "password");
        OAuthClient.AccessTokenResponse tokenResponse2 = this.login("test-app-scope", "test-user@localhost", "password");
        UserResource testUser = this.realm.users().get(((UserRepresentation)this.realm.users().search("test-user@localhost").get(0)).getId());
        List userSessions = testUser.getUserSessions();
        Assert.assertEquals((long)1L, (long)userSessions.size());
        Map clients = ((UserSessionRepresentation)userSessions.get(0)).getClients();
        Assert.assertEquals((Object)"test-app", clients.get(((ClientRepresentation)this.realm.clients().findByClientId("test-app").get(0)).getId()));
        Assert.assertEquals((Object)"test-app-scope", clients.get(((ClientRepresentation)this.realm.clients().findByClientId("test-app-scope").get(0)).getId()));
        this.isTokenEnabled(tokenResponse1, "test-app");
        this.isTokenEnabled(tokenResponse2, "test-app-scope");
        this.oauth.clientId("test-app");
        CloseableHttpResponse response = this.oauth.doTokenRevoke(tokenResponse1.getRefreshToken(), "refresh_token", "password");
        Assert.assertThat((Object)response, (Matcher)Matchers.statusCodeIsHC((Response.Status)Response.Status.OK));
        userSessions = testUser.getUserSessions();
        Assert.assertEquals((long)1L, (long)userSessions.size());
        clients = ((UserSessionRepresentation)userSessions.get(0)).getClients();
        Assert.assertNull(clients.get(((ClientRepresentation)this.realm.clients().findByClientId("test-app").get(0)).getId()));
        Assert.assertEquals((Object)"test-app-scope", clients.get(((ClientRepresentation)this.realm.clients().findByClientId("test-app-scope").get(0)).getId()));
        this.isTokenDisabled(tokenResponse1, "test-app");
        this.isTokenEnabled(tokenResponse2, "test-app-scope");
        response = this.oauth.doTokenRevoke(tokenResponse2.getRefreshToken(), "refresh_token", "password");
        Assert.assertThat((Object)response, (Matcher)Matchers.statusCodeIsHC((Response.Status)Response.Status.OK));
        userSessions = testUser.getUserSessions();
        Assert.assertEquals((long)0L, (long)userSessions.size());
    }

    @Test
    public void testRevokeAccessToken() throws Exception {
        this.oauth.clientId("test-app");
        OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doGrantAccessTokenRequest("password", "test-user@localhost", "password");
        this.isTokenEnabled(tokenResponse, "test-app");
        CloseableHttpResponse response = this.oauth.doTokenRevoke(tokenResponse.getAccessToken(), "access_token", "password");
        Assert.assertThat((Object)response, (Matcher)Matchers.statusCodeIsHC((Response.Status)Response.Status.OK));
        this.isAccessTokenDisabled(tokenResponse.getAccessToken(), "test-app");
    }

    @Test
    public void testRevokeOfflineToken() throws Exception {
        this.oauth.scope("offline_access");
        this.oauth.clientId("test-app");
        OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doGrantAccessTokenRequest("password", "test-user@localhost", "password");
        this.isTokenEnabled(tokenResponse, "test-app");
        CloseableHttpResponse response = this.oauth.doTokenRevoke(tokenResponse.getRefreshToken(), "refresh_token", "password");
        Assert.assertThat((Object)response, (Matcher)Matchers.statusCodeIsHC((Response.Status)Response.Status.OK));
        this.isTokenDisabled(tokenResponse, "test-app");
    }

    @Test
    public void testTokenTypeHint() throws Exception {
        this.oauth.clientId("test-app");
        OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doGrantAccessTokenRequest("password", "test-user@localhost", "password");
        this.isTokenEnabled(tokenResponse, "test-app");
        CloseableHttpResponse response = this.oauth.doTokenRevoke(tokenResponse.getRefreshToken(), "access_token", "password");
        Assert.assertThat((Object)response, (Matcher)Matchers.statusCodeIsHC((Response.Status)Response.Status.OK));
        this.isTokenDisabled(tokenResponse, "test-app");
        this.oauth.clientId("test-app");
        tokenResponse = this.oauth.doGrantAccessTokenRequest("password", "test-user@localhost", "password");
        this.isTokenEnabled(tokenResponse, "test-app");
        response = this.oauth.doTokenRevoke(tokenResponse.getRefreshToken(), "invalid_token_type_hint", "password");
        Assert.assertThat((Object)response, (Matcher)Matchers.statusCodeIsHC((Response.Status)Response.Status.OK));
        this.isTokenDisabled(tokenResponse, "test-app");
    }

    @Test
    public void testRevokeTokenFromDifferentClient() throws Exception {
        this.oauth.clientId("test-app");
        OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doGrantAccessTokenRequest("password", "test-user@localhost", "password");
        this.isTokenEnabled(tokenResponse, "test-app");
        this.oauth.clientId("test-app-scope");
        CloseableHttpResponse response = this.oauth.doTokenRevoke(tokenResponse.getRefreshToken(), "refresh_token", "password");
        Assert.assertThat((Object)response, (Matcher)Matchers.statusCodeIsHC((Response.Status)Response.Status.BAD_REQUEST));
        this.isTokenEnabled(tokenResponse, "test-app");
    }

    @Test
    public void testRevokeAlreadyRevokedToken() throws Exception {
        this.oauth.clientId("test-app");
        OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doGrantAccessTokenRequest("password", "test-user@localhost", "password");
        this.isTokenEnabled(tokenResponse, "test-app");
        this.oauth.doLogout(tokenResponse.getRefreshToken(), "password");
        this.isTokenDisabled(tokenResponse, "test-app");
        CloseableHttpResponse response = this.oauth.doTokenRevoke(tokenResponse.getRefreshToken(), "refresh_token", "password");
        Assert.assertThat((Object)response, (Matcher)Matchers.statusCodeIsHC((Response.Status)Response.Status.OK));
        this.isTokenDisabled(tokenResponse, "test-app");
    }

    @Test
    public void testRevokeRequestParamsMoreThanOnce() throws Exception {
        this.oauth.clientId("test-app");
        OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doGrantAccessTokenRequest("password", "test-user@localhost", "password");
        this.isTokenEnabled(tokenResponse, "test-app");
        String revokeResponse = this.doTokenRevokeWithDuplicateParams(tokenResponse.getRefreshToken(), "refresh_token", "password");
        OAuth2ErrorRepresentation errorRep = (OAuth2ErrorRepresentation)JsonSerialization.readValue((String)revokeResponse, OAuth2ErrorRepresentation.class);
        Assert.assertEquals((Object)"duplicated parameter", (Object)errorRep.getErrorDescription());
        Assert.assertEquals((Object)"invalid_request", (Object)errorRep.getError());
    }

    private OAuthClient.AccessTokenResponse login(String clientId, String username, String password) {
        this.oauth.clientId(clientId);
        this.oauth.openLoginForm();
        if (this.loginPage.isCurrent()) {
            this.loginPage.login(username, password);
        }
        String code = new OAuthClient.AuthorizationEndpointResponse(this.oauth).getCode();
        return this.oauth.doAccessTokenRequest(code, "password");
    }

    private void isTokenEnabled(OAuthClient.AccessTokenResponse tokenResponse, String clientId) throws IOException {
        String introspectionResponse = this.oauth.introspectAccessTokenWithClientCredential(clientId, "password", tokenResponse.getAccessToken());
        TokenMetadataRepresentation rep = (TokenMetadataRepresentation)JsonSerialization.readValue((String)introspectionResponse, TokenMetadataRepresentation.class);
        Assert.assertTrue((boolean)rep.isActive());
        this.oauth.clientId(clientId);
        OAuthClient.AccessTokenResponse tokenRefreshResponse = this.oauth.doRefreshTokenRequest(tokenResponse.getRefreshToken(), "password");
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)tokenRefreshResponse.getStatusCode());
    }

    private void isTokenDisabled(OAuthClient.AccessTokenResponse tokenResponse, String clientId) throws IOException {
        this.isAccessTokenDisabled(tokenResponse.getAccessToken(), clientId);
        this.oauth.clientId(clientId);
        OAuthClient.AccessTokenResponse tokenRefreshResponse = this.oauth.doRefreshTokenRequest(tokenResponse.getRefreshToken(), "password");
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)tokenRefreshResponse.getStatusCode());
    }

    private void isAccessTokenDisabled(String accessTokenString, String clientId) throws IOException {
        String introspectionResponse = this.oauth.introspectAccessTokenWithClientCredential(clientId, "password", accessTokenString);
        TokenMetadataRepresentation rep = (TokenMetadataRepresentation)JsonSerialization.readValue((String)introspectionResponse, TokenMetadataRepresentation.class);
        Assert.assertFalse((boolean)rep.isActive());
    }

    private String doTokenRevokeWithDuplicateParams(String token, String tokenTypeHint, String clientSecret) throws IOException {
        try (CloseableHttpClient client = HttpClientBuilder.create().build();){
            UrlEncodedFormEntity formEntity;
            HttpPost post = new HttpPost(this.oauth.getTokenRevocationUrl());
            LinkedList<BasicNameValuePair> parameters = new LinkedList<BasicNameValuePair>();
            parameters.add(new BasicNameValuePair("token", token));
            parameters.add(new BasicNameValuePair("token", "foo"));
            parameters.add(new BasicNameValuePair("token_type_hint", tokenTypeHint));
            parameters.add(new BasicNameValuePair("client_id", this.oauth.getClientId()));
            parameters.add(new BasicNameValuePair("client_secret", clientSecret));
            try {
                formEntity = new UrlEncodedFormEntity(parameters, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            post.setEntity((HttpEntity)formEntity);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            client.execute((HttpUriRequest)post).getEntity().writeTo((OutputStream)out);
            String string = new String(out.toByteArray());
            return string;
        }
    }
}

