/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.oauth;

import java.io.IOException;
import java.util.List;
import javax.ws.rs.core.Response;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.oidc.TokenMetadataRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.util.ClientBuilder;
import org.keycloak.testsuite.util.Matchers;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.util.JsonSerialization;

public class TokenRevocationCorsTest
extends AbstractKeycloakTest {
    private static final String VALID_CORS_URL = "http://localtest.me:8180";
    private static final String INVALID_CORS_URL = "http://invalid.localtest.me:8180";

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation realm = AbstractAdminTest.loadJson(this.getClass().getResourceAsStream("/testrealm.json"), RealmRepresentation.class);
        realm.getClients().add(ClientBuilder.create().redirectUris("http://localtest.me:8180/realms/master/app").addWebOrigin(VALID_CORS_URL).clientId("test-app2").publicClient().directAccessGrants().build());
        testRealms.add(realm);
    }

    @Test
    public void testTokenRevocationCorsRequestWithValidUrl() throws Exception {
        this.oauth.realm("test");
        this.oauth.clientId("test-app2");
        this.oauth.redirectUri("http://localtest.me:8180/realms/master/app");
        OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doGrantAccessTokenRequest(null, "test-user@localhost", "password");
        this.oauth.origin(VALID_CORS_URL);
        CloseableHttpResponse response = this.oauth.doTokenRevoke(tokenResponse.getRefreshToken(), "refresh_token", "password");
        Assert.assertThat((Object)response, (Matcher)Matchers.statusCodeIsHC((Response.Status)Response.Status.OK));
        TokenRevocationCorsTest.assertCors(response);
        this.isTokenDisabled(tokenResponse, "test-app2");
    }

    @Test
    public void userTokenRevocationCorsRequestWithInvalidUrlShouldFail() throws Exception {
        this.oauth.realm("test");
        this.oauth.clientId("test-app2");
        this.oauth.redirectUri("http://localtest.me:8180/realms/master/app");
        OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doGrantAccessTokenRequest(null, "test-user@localhost", "password");
        this.oauth.origin(INVALID_CORS_URL);
        CloseableHttpResponse response = this.oauth.doTokenRevoke(tokenResponse.getRefreshToken(), "refresh_token", "password");
        Assert.assertThat((Object)response, (Matcher)Matchers.statusCodeIsHC((Response.Status)Response.Status.OK));
        TokenRevocationCorsTest.assertNotCors(response);
        this.isTokenDisabled(tokenResponse, "test-app2");
    }

    private static void assertCors(CloseableHttpResponse response) {
        Assert.assertEquals((Object)"true", (Object)response.getHeaders("Access-Control-Allow-Credentials")[0].getValue());
        Assert.assertEquals((Object)VALID_CORS_URL, (Object)response.getHeaders("Access-Control-Allow-Origin")[0].getValue());
        Assert.assertEquals((Object)"Access-Control-Allow-Methods", (Object)response.getHeaders("Access-Control-Expose-Headers")[0].getValue());
    }

    private static void assertNotCors(CloseableHttpResponse response) {
        Assert.assertEquals((long)0L, (long)response.getHeaders("Access-Control-Allow-Credentials").length);
        Assert.assertEquals((long)0L, (long)response.getHeaders("Access-Control-Allow-Origin").length);
        Assert.assertEquals((long)0L, (long)response.getHeaders("Access-Control-Expose-Headers").length);
    }

    private void isTokenDisabled(OAuthClient.AccessTokenResponse tokenResponse, String clientId) throws IOException {
        String introspectionResponse = this.oauth.introspectAccessTokenWithClientCredential(clientId, "password", tokenResponse.getAccessToken());
        TokenMetadataRepresentation rep = (TokenMetadataRepresentation)JsonSerialization.readValue((String)introspectionResponse, TokenMetadataRepresentation.class);
        Assert.assertFalse((boolean)rep.isActive());
        this.oauth.clientId(clientId);
        OAuthClient.AccessTokenResponse tokenRefreshResponse = this.oauth.doRefreshTokenRequest(tokenResponse.getRefreshToken(), "password");
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)tokenRefreshResponse.getStatusCode());
    }
}

