/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.oauth;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.util.ClientBuilder;
import org.keycloak.testsuite.util.OAuthClient;

public class TokenEndpointCorsTest
extends AbstractKeycloakTest {
    private static final String VALID_CORS_URL = "http://localtest.me:8180";
    private static final String INVALID_CORS_URL = "http://invalid.localtest.me:8180";
    @Rule
    public AssertEvents events = new AssertEvents(this);

    @Override
    public void beforeAbstractKeycloakTest() throws Exception {
        super.beforeAbstractKeycloakTest();
    }

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation realm = AbstractAdminTest.loadJson(this.getClass().getResourceAsStream("/testrealm.json"), RealmRepresentation.class);
        realm.getClients().add(ClientBuilder.create().redirectUris("http://localtest.me:8180/realms/master/app").addWebOrigin(VALID_CORS_URL).clientId("test-app2").publicClient().directAccessGrants().build());
        testRealms.add(realm);
    }

    @Test
    public void preflightRequest() throws Exception {
        CloseableHttpResponse response = this.oauth.doPreflightRequest();
        String[] methods = response.getHeaders("Access-Control-Allow-Methods")[0].getValue().split(", ");
        HashSet<String> allowedMethods = new HashSet<String>(Arrays.asList(methods));
        Assert.assertEquals((long)2L, (long)allowedMethods.size());
        Assert.assertTrue((boolean)allowedMethods.containsAll(Arrays.asList("POST", "OPTIONS")));
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void accessTokenCorsRequest() throws Exception {
        this.oauth.realm("test");
        this.oauth.clientId("test-app2");
        this.oauth.redirectUri("http://localtest.me:8180/realms/master/app");
        this.oauth.doLogin("test-user@localhost", "password");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        this.oauth.origin(VALID_CORS_URL);
        OAuthClient.AccessTokenResponse response = this.oauth.doAccessTokenRequest(code, "password");
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        TokenEndpointCorsTest.assertCors(response);
        response = this.oauth.doRefreshTokenRequest(response.getRefreshToken(), null);
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        TokenEndpointCorsTest.assertCors(response);
        this.oauth.origin(INVALID_CORS_URL);
        response = this.oauth.doRefreshTokenRequest(response.getRefreshToken(), "password");
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        TokenEndpointCorsTest.assertNotCors(response);
        this.oauth.origin(VALID_CORS_URL);
        this.oauth.openLogout();
        response = this.oauth.doRefreshTokenRequest(response.getRefreshToken(), null);
        Assert.assertEquals((long)400L, (long)response.getStatusCode());
        TokenEndpointCorsTest.assertCors(response);
        Assert.assertEquals((Object)"invalid_grant", (Object)response.getError());
        Assert.assertEquals((Object)"Session not active", (Object)response.getErrorDescription());
    }

    @Test
    public void accessTokenResourceOwnerCorsRequest() throws Exception {
        this.oauth.realm("test");
        this.oauth.clientId("test-app2");
        this.oauth.origin(VALID_CORS_URL);
        OAuthClient.AccessTokenResponse response = this.oauth.doGrantAccessTokenRequest("password", "test-user@localhost", "password");
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        TokenEndpointCorsTest.assertCors(response);
        response = this.oauth.doGrantAccessTokenRequest("password", "test-user@localhost", "invalid");
        Assert.assertEquals((long)401L, (long)response.getStatusCode());
        TokenEndpointCorsTest.assertCors(response);
    }

    @Test
    public void accessTokenWithConfidentialClientCorsRequest() throws Exception {
        this.oauth.realm("test");
        this.oauth.clientId("direct-grant");
        this.oauth.origin(VALID_CORS_URL);
        OAuthClient.AccessTokenResponse response = this.oauth.doGrantAccessTokenRequest("password", "test-user@localhost", "password");
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        TokenEndpointCorsTest.assertCors(response);
        response = this.oauth.doGrantAccessTokenRequest("invalid", "test-user@localhost", "password");
        Assert.assertEquals((long)401L, (long)response.getStatusCode());
        TokenEndpointCorsTest.assertCors(response);
        this.oauth.origin(INVALID_CORS_URL);
        response = this.oauth.doGrantAccessTokenRequest("password", "test-user@localhost", "password");
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        TokenEndpointCorsTest.assertNotCors(response);
    }

    private static void assertCors(OAuthClient.AccessTokenResponse response) {
        Assert.assertEquals((Object)"true", response.getHeaders().get("Access-Control-Allow-Credentials"));
        Assert.assertEquals((Object)VALID_CORS_URL, response.getHeaders().get("Access-Control-Allow-Origin"));
        Assert.assertEquals((Object)"Access-Control-Allow-Methods", response.getHeaders().get("Access-Control-Expose-Headers"));
    }

    private static void assertNotCors(OAuthClient.AccessTokenResponse response) {
        Assert.assertNull(response.getHeaders().get("Access-Control-Allow-Credentials"));
        Assert.assertNull(response.getHeaders().get("Access-Control-Allow-Origin"));
        Assert.assertNull(response.getHeaders().get("Access-Control-Expose-Headers"));
    }
}

