/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.oauth;

import java.io.UnsupportedEncodingException;
import java.security.Provider;
import java.security.Security;
import java.util.LinkedList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.jose.jws.JWSHeader;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.TimeBasedOTP;
import org.keycloak.protocol.oidc.OIDCAdvancedConfigWrapper;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.RefreshToken;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.util.ClientBuilder;
import org.keycloak.testsuite.util.ClientManager;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.RealmBuilder;
import org.keycloak.testsuite.util.RealmManager;
import org.keycloak.testsuite.util.TokenSignatureUtil;
import org.keycloak.testsuite.util.UserBuilder;
import org.keycloak.testsuite.util.UserManager;

public class ResourceOwnerPasswordCredentialsGrantTest
extends AbstractKeycloakTest {
    private static String userId;
    private static String userId2;
    private static String userIdMultipleOTPs;
    private final TimeBasedOTP totp = new TimeBasedOTP();
    @Rule
    public AssertEvents events = new AssertEvents(this);

    @Override
    public void beforeAbstractKeycloakTest() throws Exception {
        super.beforeAbstractKeycloakTest();
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmBuilder realm = RealmBuilder.create().name("test").privateKey("MIICXAIBAAKBgQCrVrCuTtArbgaZzL1hvh0xtL5mc7o0NqPVnYXkLvgcwiC3BjLGw1tGEGoJaXDuSaRllobm53JBhjx33UNv+5z/UMG4kytBWxheNVKnL6GgqlNabMaFfPLPCF8kAgKnsi79NMo+n6KnSY8YeUmec/p2vjO2NjsSAVcWEQMVhJ31LwIDAQABAoGAfmO8gVhyBxdqlxmIuglbz8bcjQbhXJLR2EoS8ngTXmN1bo2L90M0mUKSdc7qF10LgETBzqL8jYlQIbt+e6TH8fcEpKCjUlyq0Mf/vVbfZSNaVycY13nTzo27iPyWQHK5NLuJzn1xvxxrUeXI6A2WFpGEBLbHjwpx5WQG9A+2scECQQDvdn9NE75HPTVPxBqsEd2z10TKkl9CZxu10Qby3iQQmWLEJ9LNmy3acvKrE3gMiYNWb6xHPKiIqOR1as7L24aTAkEAtyvQOlCvr5kAjVqrEKXalj0Tzewjweuxc0pskvArTI2Oo070h65GpoIKLc9jf+UA69cRtquwP93aZKtW06U8dQJAF2Y44ks/mK5+eyDqik3koCI08qaC8HYq2wVl7G2QkJ6sbAaILtcvD92ToOvyGyeE0flvmDZxMYlvaZnaQ0lcSQJBAKZU6umJi3/xeEbkJqMfeLclD27XGEFoPeNrmdx0q10Azp4NfJAY+Z8KRyQCR2BEG+oNitBOZ+YXF9KCpH3cdmECQHEigJhYg+ykOvr1aiZUMFT72HU0jnmQe2FVekuG+LJUt2Tm7GtMjTFoGpf0JwrVuZN39fOYAlo+nTixgeW7X8Y=").publicKey("MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCrVrCuTtArbgaZzL1hvh0xtL5mc7o0NqPVnYXkLvgcwiC3BjLGw1tGEGoJaXDuSaRllobm53JBhjx33UNv+5z/UMG4kytBWxheNVKnL6GgqlNabMaFfPLPCF8kAgKnsi79NMo+n6KnSY8YeUmec/p2vjO2NjsSAVcWEQMVhJ31LwIDAQAB").testEventListener();
        ClientRepresentation app = ClientBuilder.create().id(KeycloakModelUtils.generateId()).clientId("resource-owner").directAccessGrants().secret("secret").build();
        realm.client(app);
        ClientRepresentation app2 = ClientBuilder.create().id(KeycloakModelUtils.generateId()).clientId("resource-owner-public").directAccessGrants().publicClient().build();
        realm.client(app2);
        ClientRepresentation app3 = ClientBuilder.create().id(KeycloakModelUtils.generateId()).clientId("resource-owner-refresh").directAccessGrants().secret("secret").build();
        OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)app3).setUseRefreshToken(false);
        realm.client(app3);
        UserBuilder defaultUser = UserBuilder.create().id(KeycloakModelUtils.generateId()).username("test-user@localhost").password("password");
        realm.user(defaultUser);
        userId = KeycloakModelUtils.generateId();
        UserRepresentation user = UserBuilder.create().id(userId).username("direct-login").email("direct-login@localhost").password("password").build();
        realm.user(user);
        userId2 = KeycloakModelUtils.generateId();
        UserRepresentation user2 = UserBuilder.create().id(userId2).username("direct-login-otp").password("password").totpSecret("totpSecret").build();
        realm.user(user2);
        userIdMultipleOTPs = KeycloakModelUtils.generateId();
        UserBuilder userBuilderMultipleOTPs = UserBuilder.create().id(userIdMultipleOTPs).username("direct-login-multiple-otps").password("password").totpSecret("firstOTPIsPreferredCredential");
        for (int i = 2; i <= 10; ++i) {
            userBuilderMultipleOTPs.totpSecret(String.format("%s-th OTP authenticator", i));
        }
        realm.user(userBuilderMultipleOTPs.build());
        testRealms.add(realm.build());
    }

    @Test
    public void grantAccessTokenUsername() throws Exception {
        int authSessionsBefore = this.getAuthenticationSessionsCount();
        this.grantAccessToken("direct-login", "resource-owner");
        Assert.assertEquals((long)authSessionsBefore, (long)this.getAuthenticationSessionsCount());
    }

    @Test
    public void grantAccessTokenEmail() throws Exception {
        this.grantAccessToken("direct-login@localhost", "resource-owner");
    }

    @Test
    public void grantAccessTokenPublic() throws Exception {
        this.grantAccessToken("direct-login", "resource-owner-public");
    }

    @Test
    public void grantAccessTokenWithTotp() throws Exception {
        this.grantAccessToken(userId2, "direct-login-otp", "resource-owner", this.totp.generateTOTP("totpSecret"));
    }

    @Test
    public void grantAccessTokenWithMultipleTotp() throws Exception {
        this.grantAccessToken(userIdMultipleOTPs, "direct-login-multiple-otps", "resource-owner", this.totp.generateTOTP("firstOTPIsPreferredCredential"));
        this.oauth.clientId("resource-owner");
        for (int i = 2; i <= 10; ++i) {
            String otp = this.totp.generateTOTP(String.format("%s-th OTP authenticator", i));
            OAuthClient.AccessTokenResponse response = this.oauth.doGrantAccessTokenRequest("secret", "direct-login-multiple-otps", "password", otp);
            org.junit.Assert.assertEquals((long)401L, (long)response.getStatusCode());
        }
    }

    @Test
    public void grantAccessTokenMissingTotp() throws Exception {
        this.oauth.clientId("resource-owner");
        OAuthClient.AccessTokenResponse response = this.oauth.doGrantAccessTokenRequest("secret", "direct-login-otp", "password");
        org.junit.Assert.assertEquals((long)401L, (long)response.getStatusCode());
        org.junit.Assert.assertEquals((Object)"invalid_grant", (Object)response.getError());
        this.events.expectLogin().client("resource-owner").session((String)null).clearDetails().error("invalid_user_credentials").user(userId2).assertEvent();
    }

    @Test
    public void grantAccessTokenInvalidTotp() throws Exception {
        int authSessionsBefore = this.getAuthenticationSessionsCount();
        this.oauth.clientId("resource-owner");
        OAuthClient.AccessTokenResponse response = this.oauth.doGrantAccessTokenRequest("secret", "direct-login-otp", "password", this.totp.generateTOTP("totpSecret2"));
        org.junit.Assert.assertEquals((long)401L, (long)response.getStatusCode());
        org.junit.Assert.assertEquals((Object)"invalid_grant", (Object)response.getError());
        this.events.expectLogin().client("resource-owner").session((String)null).clearDetails().error("invalid_user_credentials").user(userId2).assertEvent();
        Assert.assertEquals((long)authSessionsBefore, (long)this.getAuthenticationSessionsCount());
    }

    private void grantAccessToken(String login, String clientId) throws Exception {
        this.grantAccessToken(userId, login, clientId, null);
    }

    private void grantAccessToken(String userId, String login, String clientId, String otp) throws Exception {
        this.oauth.clientId(clientId);
        OAuthClient.AccessTokenResponse response = this.oauth.doGrantAccessTokenRequest("secret", login, "password", otp);
        org.junit.Assert.assertEquals((long)200L, (long)response.getStatusCode());
        AccessToken accessToken = this.oauth.verifyToken(response.getAccessToken());
        RefreshToken refreshToken = this.oauth.parseRefreshToken(response.getRefreshToken());
        this.events.expectLogin().client(clientId).user(userId).session(accessToken.getSessionState()).detail("grant_type", "password").detail("token_id", accessToken.getId()).detail("refresh_token_id", refreshToken.getId()).detail("username", login).removeDetail("code_id").removeDetail("redirect_uri").removeDetail("consent").assertEvent();
        Assert.assertTrue((login.equals(accessToken.getPreferredUsername()) || login.equals(accessToken.getEmail()) ? 1 : 0) != 0);
        org.junit.Assert.assertEquals((Object)accessToken.getSessionState(), (Object)refreshToken.getSessionState());
        OAuthClient.AccessTokenResponse refreshedResponse = this.oauth.doRefreshTokenRequest(response.getRefreshToken(), "secret");
        AccessToken refreshedAccessToken = this.oauth.verifyToken(refreshedResponse.getAccessToken());
        RefreshToken refreshedRefreshToken = this.oauth.parseRefreshToken(refreshedResponse.getRefreshToken());
        org.junit.Assert.assertEquals((Object)accessToken.getSessionState(), (Object)refreshedAccessToken.getSessionState());
        org.junit.Assert.assertEquals((Object)accessToken.getSessionState(), (Object)refreshedRefreshToken.getSessionState());
        this.events.expectRefresh(refreshToken.getId(), refreshToken.getSessionState()).user(userId).client(clientId).assertEvent();
    }

    @Test
    public void grantRequest_ClientES256_RealmPS256() throws Exception {
        this.conductGrantRequest("HS256", "ES256", "PS256");
    }

    @Test
    public void grantRequest_ClientPS256_RealmES256() throws Exception {
        this.conductGrantRequest("HS256", "PS256", "ES256");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void conductGrantRequest(String expectedRefreshAlg, String expectedAccessAlg, String realmTokenAlg) throws Exception {
        try {
            TokenSignatureUtil.changeRealmTokenSignatureProvider((Keycloak)this.adminClient, (String)realmTokenAlg);
            TokenSignatureUtil.changeClientAccessTokenSignatureProvider((ClientResource)ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"resource-owner"), (String)expectedAccessAlg);
            this.grantRequest(expectedRefreshAlg, expectedAccessAlg);
        }
        finally {
            TokenSignatureUtil.changeRealmTokenSignatureProvider((Keycloak)this.adminClient, (String)"RS256");
            TokenSignatureUtil.changeClientAccessTokenSignatureProvider((ClientResource)ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"resource-owner"), (String)"RS256");
        }
    }

    private void grantRequest(String expectedRefreshAlg, String expectedAccessAlg) throws Exception {
        String clientId = "resource-owner";
        String login = "direct-login";
        this.oauth.clientId(clientId);
        OAuthClient.AccessTokenResponse response = this.oauth.doGrantAccessTokenRequest("secret", login, "password", null);
        org.junit.Assert.assertEquals((long)200L, (long)response.getStatusCode());
        AccessToken accessToken = this.oauth.verifyToken(response.getAccessToken());
        RefreshToken refreshToken = this.oauth.parseRefreshToken(response.getRefreshToken());
        JWSHeader header = new JWSInput(response.getAccessToken()).getHeader();
        org.junit.Assert.assertEquals((Object)expectedAccessAlg, (Object)header.getAlgorithm().name());
        org.junit.Assert.assertEquals((Object)"JWT", (Object)header.getType());
        org.junit.Assert.assertNull((Object)header.getContentType());
        header = new JWSInput(response.getRefreshToken()).getHeader();
        org.junit.Assert.assertEquals((Object)expectedRefreshAlg, (Object)header.getAlgorithm().name());
        org.junit.Assert.assertEquals((Object)"JWT", (Object)header.getType());
        org.junit.Assert.assertNull((Object)header.getContentType());
        this.events.expectLogin().client(clientId).user(userId).session(accessToken.getSessionState()).detail("grant_type", "password").detail("token_id", accessToken.getId()).detail("refresh_token_id", refreshToken.getId()).detail("username", login).removeDetail("code_id").removeDetail("redirect_uri").removeDetail("consent").assertEvent();
        Assert.assertTrue((login.equals(accessToken.getPreferredUsername()) || login.equals(accessToken.getEmail()) ? 1 : 0) != 0);
        org.junit.Assert.assertEquals((Object)accessToken.getSessionState(), (Object)refreshToken.getSessionState());
        OAuthClient.AccessTokenResponse refreshedResponse = this.oauth.doRefreshTokenRequest(response.getRefreshToken(), "secret");
        AccessToken refreshedAccessToken = this.oauth.verifyToken(refreshedResponse.getAccessToken());
        RefreshToken refreshedRefreshToken = this.oauth.parseRefreshToken(refreshedResponse.getRefreshToken());
        org.junit.Assert.assertEquals((Object)accessToken.getSessionState(), (Object)refreshedAccessToken.getSessionState());
        org.junit.Assert.assertEquals((Object)accessToken.getSessionState(), (Object)refreshedRefreshToken.getSessionState());
        this.events.expectRefresh(refreshToken.getId(), refreshToken.getSessionState()).user(userId).client(clientId).assertEvent();
    }

    @Test
    public void grantAccessTokenLogout() throws Exception {
        this.oauth.clientId("resource-owner");
        OAuthClient.AccessTokenResponse response = this.oauth.doGrantAccessTokenRequest("secret", "test-user@localhost", "password");
        org.junit.Assert.assertEquals((long)200L, (long)response.getStatusCode());
        AccessToken accessToken = this.oauth.verifyToken(response.getAccessToken());
        RefreshToken refreshToken = this.oauth.parseRefreshToken(response.getRefreshToken());
        this.events.expectLogin().client("resource-owner").session(accessToken.getSessionState()).detail("grant_type", "password").detail("token_id", accessToken.getId()).detail("refresh_token_id", refreshToken.getId()).removeDetail("code_id").removeDetail("redirect_uri").removeDetail("consent").detail("client_auth_method", "client-secret").assertEvent();
        CloseableHttpResponse logoutResponse = this.oauth.doLogout(response.getRefreshToken(), "secret");
        org.junit.Assert.assertEquals((long)204L, (long)logoutResponse.getStatusLine().getStatusCode());
        this.events.expectLogout(accessToken.getSessionState()).client("resource-owner").removeDetail("redirect_uri").assertEvent();
        response = this.oauth.doRefreshTokenRequest(response.getRefreshToken(), "secret");
        org.junit.Assert.assertEquals((long)400L, (long)response.getStatusCode());
        org.junit.Assert.assertEquals((Object)"invalid_grant", (Object)response.getError());
        this.events.expectRefresh(refreshToken.getId(), refreshToken.getSessionState()).client("resource-owner").removeDetail("token_id").removeDetail("updated_refresh_token_id").error("invalid_token").assertEvent();
    }

    @Test
    public void grantAccessTokenInvalidClientCredentials() throws Exception {
        this.oauth.clientId("resource-owner");
        OAuthClient.AccessTokenResponse response = this.oauth.doGrantAccessTokenRequest("invalid", "test-user@localhost", "password");
        org.junit.Assert.assertEquals((long)401L, (long)response.getStatusCode());
        org.junit.Assert.assertEquals((Object)"unauthorized_client", (Object)response.getError());
        this.events.expectLogin().client("resource-owner").session((String)null).clearDetails().error("invalid_client_credentials").user((String)null).assertEvent();
    }

    @Test
    public void grantAccessTokenMissingClientCredentials() throws Exception {
        this.oauth.clientId("resource-owner");
        OAuthClient.AccessTokenResponse response = this.oauth.doGrantAccessTokenRequest(null, "test-user@localhost", "password");
        org.junit.Assert.assertEquals((long)401L, (long)response.getStatusCode());
        org.junit.Assert.assertEquals((Object)"unauthorized_client", (Object)response.getError());
        this.events.expectLogin().client("resource-owner").session((String)null).clearDetails().error("invalid_client_credentials").user((String)null).assertEvent();
    }

    @Test
    public void grantAccessTokenClientNotAllowed() throws Exception {
        ClientManager.realm(this.adminClient.realm("test")).clientId("resource-owner").directAccessGrant(false);
        this.oauth.clientId("resource-owner");
        OAuthClient.AccessTokenResponse response = this.oauth.doGrantAccessTokenRequest("secret", "test-user@localhost", "password");
        org.junit.Assert.assertEquals((long)400L, (long)response.getStatusCode());
        org.junit.Assert.assertEquals((Object)"unauthorized_client", (Object)response.getError());
        this.events.expectLogin().client("resource-owner").session((String)null).clearDetails().error("not_allowed").user((String)null).assertEvent();
        ClientManager.realm(this.adminClient.realm("test")).clientId("resource-owner").directAccessGrant(true);
    }

    @Test
    public void grantAccessTokenVerifyEmail() throws Exception {
        int authSessionsBefore = this.getAuthenticationSessionsCount();
        RealmResource realmResource = this.adminClient.realm("test");
        RealmManager.realm(realmResource).verifyEmail(true);
        this.oauth.clientId("resource-owner");
        OAuthClient.AccessTokenResponse response = this.oauth.doGrantAccessTokenRequest("secret", "test-user@localhost", "password");
        org.junit.Assert.assertEquals((long)400L, (long)response.getStatusCode());
        org.junit.Assert.assertEquals((Object)"invalid_grant", (Object)response.getError());
        org.junit.Assert.assertEquals((Object)"Account is not fully set up", (Object)response.getErrorDescription());
        this.events.expectLogin().client("resource-owner").session((String)null).clearDetails().error("resolve_required_actions").user((String)null).assertEvent();
        RealmManager.realm(realmResource).verifyEmail(false);
        UserManager.realm(realmResource).username("test-user@localhost").removeRequiredAction(UserModel.RequiredAction.VERIFY_EMAIL.toString());
        Assert.assertEquals((long)authSessionsBefore, (long)this.getAuthenticationSessionsCount());
    }

    @Test
    public void grantAccessTokenVerifyEmailInvalidPassword() throws Exception {
        RealmResource realmResource = this.adminClient.realm("test");
        RealmManager.realm(realmResource).verifyEmail(true);
        this.oauth.clientId("resource-owner");
        OAuthClient.AccessTokenResponse response = this.oauth.doGrantAccessTokenRequest("secret", "test-user@localhost", "bad-password");
        org.junit.Assert.assertEquals((long)401L, (long)response.getStatusCode());
        org.junit.Assert.assertEquals((Object)"invalid_grant", (Object)response.getError());
        org.junit.Assert.assertEquals((Object)"Invalid user credentials", (Object)response.getErrorDescription());
        this.events.expectLogin().client("resource-owner").session((String)null).detail("grant_type", "password").removeDetail("code_id").removeDetail("redirect_uri").removeDetail("consent").error("invalid_user_credentials").assertEvent();
        RealmManager.realm(realmResource).verifyEmail(false);
        UserManager.realm(realmResource).username("test-user@localhost").removeRequiredAction(UserModel.RequiredAction.VERIFY_EMAIL.toString());
    }

    @Test
    public void grantAccessTokenExpiredPassword() throws Exception {
        RealmResource realmResource = this.adminClient.realm("test");
        RealmManager.realm(realmResource).passwordPolicy("forceExpiredPasswordChange(1)");
        try {
            this.setTimeOffset(172800);
            this.oauth.clientId("resource-owner");
            OAuthClient.AccessTokenResponse response = this.oauth.doGrantAccessTokenRequest("secret", "test-user@localhost", "password");
            org.junit.Assert.assertEquals((long)400L, (long)response.getStatusCode());
            org.junit.Assert.assertEquals((Object)"invalid_grant", (Object)response.getError());
            org.junit.Assert.assertEquals((Object)"Account is not fully set up", (Object)response.getErrorDescription());
            this.setTimeOffset(0);
            this.events.expectLogin().client("resource-owner").session((String)null).clearDetails().error("resolve_required_actions").user((String)null).assertEvent();
        }
        finally {
            RealmManager.realm(realmResource).passwordPolicy("");
            UserManager.realm(realmResource).username("test-user@localhost").removeRequiredAction(UserModel.RequiredAction.UPDATE_PASSWORD.toString());
        }
    }

    @Test
    public void grantAccessTokenExpiredPasswordInvalidPassword() throws Exception {
        RealmResource realmResource = this.adminClient.realm("test");
        RealmManager.realm(realmResource).passwordPolicy("forceExpiredPasswordChange(1)");
        try {
            this.setTimeOffset(172800);
            this.oauth.clientId("resource-owner");
            OAuthClient.AccessTokenResponse response = this.oauth.doGrantAccessTokenRequest("secret", "test-user@localhost", "bad-password");
            org.junit.Assert.assertEquals((long)401L, (long)response.getStatusCode());
            org.junit.Assert.assertEquals((Object)"invalid_grant", (Object)response.getError());
            org.junit.Assert.assertEquals((Object)"Invalid user credentials", (Object)response.getErrorDescription());
            this.events.expectLogin().client("resource-owner").session((String)null).detail("grant_type", "password").removeDetail("code_id").removeDetail("redirect_uri").removeDetail("consent").error("invalid_user_credentials").assertEvent();
        }
        finally {
            RealmManager.realm(realmResource).passwordPolicy("");
            UserManager.realm(realmResource).username("test-user@localhost").removeRequiredAction(UserModel.RequiredAction.UPDATE_PASSWORD.toString());
        }
    }

    @Test
    public void grantAccessTokenInvalidUserCredentials() throws Exception {
        this.oauth.clientId("resource-owner");
        OAuthClient.AccessTokenResponse response = this.oauth.doGrantAccessTokenRequest("secret", "test-user@localhost", "invalid");
        org.junit.Assert.assertEquals((long)401L, (long)response.getStatusCode());
        org.junit.Assert.assertEquals((Object)"invalid_grant", (Object)response.getError());
        org.junit.Assert.assertEquals((Object)"Invalid user credentials", (Object)response.getErrorDescription());
        this.events.expectLogin().client("resource-owner").session((String)null).detail("grant_type", "password").removeDetail("code_id").removeDetail("redirect_uri").removeDetail("consent").error("invalid_user_credentials").assertEvent();
    }

    @Test
    public void grantAccessTokenUserNotFound() throws Exception {
        this.oauth.clientId("resource-owner");
        OAuthClient.AccessTokenResponse response = this.oauth.doGrantAccessTokenRequest("secret", "invalid", "invalid");
        org.junit.Assert.assertEquals((long)401L, (long)response.getStatusCode());
        org.junit.Assert.assertEquals((Object)"invalid_grant", (Object)response.getError());
        this.events.expectLogin().client("resource-owner").user((String)null).session((String)null).detail("grant_type", "password").detail("username", "invalid").removeDetail("code_id").removeDetail("redirect_uri").removeDetail("consent").error("user_not_found").assertEvent();
    }

    @Test
    public void grantAccessTokenMissingGrantType() throws Exception {
        this.oauth.clientId("resource-owner");
        try (CloseableHttpClient client = HttpClientBuilder.create().build();){
            HttpPost post = new HttpPost(this.oauth.getResourceOwnerPasswordCredentialGrantUrl());
            post.addHeader("Content-Type", "application/x-www-form-urlencoded");
            OAuthClient.AccessTokenResponse response = new OAuthClient.AccessTokenResponse(client.execute((HttpUriRequest)post));
            org.junit.Assert.assertEquals((long)400L, (long)response.getStatusCode());
            org.junit.Assert.assertEquals((Object)"invalid_request", (Object)response.getError());
            org.junit.Assert.assertEquals((Object)"Missing form parameter: grant_type", (Object)response.getErrorDescription());
        }
    }

    @Test
    public void grantAccessTokenUnsupportedGrantType() throws Exception {
        this.oauth.clientId("resource-owner");
        try (CloseableHttpClient client = HttpClientBuilder.create().build();){
            UrlEncodedFormEntity formEntity;
            HttpPost post = new HttpPost(this.oauth.getResourceOwnerPasswordCredentialGrantUrl());
            LinkedList<BasicNameValuePair> parameters = new LinkedList<BasicNameValuePair>();
            parameters.add(new BasicNameValuePair("grant_type", "unsupported_grant_type"));
            try {
                formEntity = new UrlEncodedFormEntity(parameters, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            post.setEntity((HttpEntity)formEntity);
            OAuthClient.AccessTokenResponse response = new OAuthClient.AccessTokenResponse(client.execute((HttpUriRequest)post));
            org.junit.Assert.assertEquals((long)400L, (long)response.getStatusCode());
            org.junit.Assert.assertEquals((Object)"unsupported_grant_type", (Object)response.getError());
            org.junit.Assert.assertEquals((Object)"Unsupported grant_type", (Object)response.getErrorDescription());
        }
    }

    @Test
    public void grantAccessTokenNoRefreshToken() throws Exception {
        this.oauth.clientId("resource-owner-refresh");
        OAuthClient.AccessTokenResponse response = this.oauth.doGrantAccessTokenRequest("secret", "direct-login", "password", null);
        org.junit.Assert.assertEquals((long)200L, (long)response.getStatusCode());
        org.junit.Assert.assertNotNull((Object)response.getAccessToken());
        org.junit.Assert.assertNull((Object)response.getRefreshToken());
    }

    private int getAuthenticationSessionsCount() {
        return this.testingClient.testing().cache("authenticationSessions").size();
    }
}

