/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.oauth;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.Serializable;
import java.net.URI;
import java.security.Provider;
import java.security.Security;
import java.util.List;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.graphene.page.Page;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.common.enums.SslRequired;
import org.keycloak.jose.jws.JWSHeader;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.protocol.oidc.OIDCLoginProtocolService;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.representations.RefreshToken;
import org.keycloak.representations.UserInfo;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.EventRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.runonserver.RunOnServer;
import org.keycloak.testsuite.updaters.ClientAttributeUpdater;
import org.keycloak.testsuite.updaters.RealmAttributeUpdater;
import org.keycloak.testsuite.util.AdminClientUtil;
import org.keycloak.testsuite.util.ClientBuilder;
import org.keycloak.testsuite.util.ClientManager;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.RealmBuilder;
import org.keycloak.testsuite.util.RealmManager;
import org.keycloak.testsuite.util.ServerURLs;
import org.keycloak.testsuite.util.TokenSignatureUtil;
import org.keycloak.testsuite.util.UserManager;
import org.keycloak.testsuite.util.WaitUtils;
import org.keycloak.util.BasicAuthHelper;
import org.keycloak.util.JsonSerialization;

public class RefreshTokenTest
extends AbstractKeycloakTest {
    public static final int ALLOWED_CLOCK_SKEW = 3;
    @Page
    protected LoginPage loginPage;
    @Rule
    public AssertEvents events = new AssertEvents(this);

    @Override
    public void beforeAbstractKeycloakTest() throws Exception {
        super.beforeAbstractKeycloakTest();
    }

    @BeforeClass
    public static void addBouncyCastleProvider() {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }

    @Before
    public void clientConfiguration() {
        ClientManager.realm(this.adminClient.realm("test")).clientId("test-app").directAccessGrant(true);
    }

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation realmRepresentation = AbstractAdminTest.loadJson(this.getClass().getResourceAsStream("/testrealm.json"), RealmRepresentation.class);
        realmRepresentation.getClients().add(ClientBuilder.create().clientId("service-account-app").serviceAccount().attribute("client_credentials.use_refresh_token", "true").secret("secret").build());
        RealmBuilder realm = RealmBuilder.edit(realmRepresentation).testEventListener();
        testRealms.add(realm.build());
    }

    @Test
    public void nullRefreshToken() throws Exception {
        ResteasyClient client = AdminClientUtil.createResteasyClient();
        UriBuilder builder = UriBuilder.fromUri((String)OAuthClient.AUTH_SERVER_ROOT);
        URI uri = OIDCLoginProtocolService.tokenUrl((UriBuilder)builder).build(new Object[]{"test"});
        WebTarget target = client.target(uri);
        Object tokenResponse = null;
        String header = BasicAuthHelper.createHeader((String)"test-app", (String)"password");
        Form form = new Form();
        Response response = target.request().header("Authorization", (Object)header).post(Entity.form((Form)form));
        org.junit.Assert.assertEquals((long)400L, (long)response.getStatus());
        response.close();
        this.events.clear();
    }

    @Test
    public void invalidRefreshToken() throws Exception {
        OAuthClient.AccessTokenResponse response = this.oauth.doRefreshTokenRequest("invalid", "password");
        org.junit.Assert.assertEquals((long)400L, (long)response.getStatusCode());
        org.junit.Assert.assertEquals((Object)"invalid_grant", (Object)response.getError());
        this.events.clear();
    }

    @Test
    public void refreshTokenStructure() {
        this.oauth.nonce("123456");
        this.oauth.doLogin("test-user@localhost", "password");
        EventRepresentation loginEvent = this.events.expectLogin().assertEvent();
        String sessionId = loginEvent.getSessionId();
        String codeId = (String)loginEvent.getDetails().get("code_id");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doAccessTokenRequest(code, "password");
        AccessToken token = this.oauth.verifyToken(tokenResponse.getAccessToken());
        org.junit.Assert.assertEquals((Object)"123456", (Object)token.getNonce());
        String refreshTokenString = tokenResponse.getRefreshToken();
        RefreshToken refreshToken = this.oauth.parseRefreshToken(refreshTokenString);
        this.events.expectCodeToToken(codeId, sessionId).assertEvent();
        org.junit.Assert.assertNotNull((Object)refreshTokenString);
        org.junit.Assert.assertEquals((Object)"123456", (Object)refreshToken.getNonce());
        org.junit.Assert.assertNull((String)"RealmAccess should be null for RefreshTokens", (Object)refreshToken.getRealmAccess());
        org.junit.Assert.assertTrue((String)"ResourceAccess should be null for RefreshTokens", (boolean)refreshToken.getResourceAccess().isEmpty());
    }

    @Test
    public void refreshTokenRequest() throws Exception {
        this.oauth.nonce("123456");
        this.oauth.doLogin("test-user@localhost", "password");
        EventRepresentation loginEvent = this.events.expectLogin().assertEvent();
        String sessionId = loginEvent.getSessionId();
        String codeId = (String)loginEvent.getDetails().get("code_id");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doAccessTokenRequest(code, "password");
        AccessToken token = this.oauth.verifyToken(tokenResponse.getAccessToken());
        org.junit.Assert.assertEquals((Object)"123456", (Object)token.getNonce());
        String refreshTokenString = tokenResponse.getRefreshToken();
        RefreshToken refreshToken = this.oauth.parseRefreshToken(refreshTokenString);
        EventRepresentation tokenEvent = this.events.expectCodeToToken(codeId, sessionId).assertEvent();
        org.junit.Assert.assertNotNull((Object)refreshTokenString);
        org.junit.Assert.assertEquals((Object)"Bearer", (Object)tokenResponse.getTokenType());
        org.junit.Assert.assertThat((Object)(token.getExpiration() - this.getCurrentTime()), (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(200)), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(350))));
        int actual = refreshToken.getExpiration() - this.getCurrentTime();
        org.junit.Assert.assertThat((Object)actual, (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1796)), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(1803))));
        org.junit.Assert.assertEquals((Object)sessionId, (Object)refreshToken.getSessionState());
        this.setTimeOffset(2);
        OAuthClient.AccessTokenResponse response = this.oauth.doRefreshTokenRequest(refreshTokenString, "password");
        AccessToken refreshedToken = this.oauth.verifyToken(response.getAccessToken());
        RefreshToken refreshedRefreshToken = this.oauth.parseRefreshToken(response.getRefreshToken());
        org.junit.Assert.assertEquals((long)200L, (long)response.getStatusCode());
        org.junit.Assert.assertEquals((Object)sessionId, (Object)refreshedToken.getSessionState());
        org.junit.Assert.assertEquals((Object)sessionId, (Object)refreshedRefreshToken.getSessionState());
        org.junit.Assert.assertThat((Object)response.getExpiresIn(), (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(250)), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(300))));
        org.junit.Assert.assertThat((Object)(refreshedToken.getExpiration() - this.getCurrentTime()), (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(247)), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(303))));
        org.junit.Assert.assertThat((Object)(refreshedToken.getExpiration() - token.getExpiration()), (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(10))));
        org.junit.Assert.assertThat((Object)(refreshedRefreshToken.getExpiration() - refreshToken.getExpiration()), (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(10))));
        org.junit.Assert.assertEquals((Object)"test-app", (Object)refreshedRefreshToken.getIssuedFor());
        org.junit.Assert.assertFalse((boolean)refreshedRefreshToken.hasAudience("test-app"));
        org.junit.Assert.assertNotEquals((Object)token.getId(), (Object)refreshedToken.getId());
        org.junit.Assert.assertNotEquals((Object)refreshToken.getId(), (Object)refreshedRefreshToken.getId());
        org.junit.Assert.assertEquals((Object)"Bearer", (Object)response.getTokenType());
        org.junit.Assert.assertEquals((Object)ApiUtil.findUserByUsername((RealmResource)this.adminClient.realm("test"), (String)"test-user@localhost").getId(), (Object)refreshedToken.getSubject());
        org.junit.Assert.assertNotEquals((Object)"test-user@localhost", (Object)refreshedToken.getSubject());
        org.junit.Assert.assertTrue((boolean)refreshedToken.getRealmAccess().isUserInRole("user"));
        org.junit.Assert.assertEquals((long)1L, (long)refreshedToken.getResourceAccess(this.oauth.getClientId()).getRoles().size());
        org.junit.Assert.assertTrue((boolean)refreshedToken.getResourceAccess(this.oauth.getClientId()).isUserInRole("customer-user"));
        EventRepresentation refreshEvent = this.events.expectRefresh((String)tokenEvent.getDetails().get("refresh_token_id"), sessionId).assertEvent();
        org.junit.Assert.assertNotEquals(tokenEvent.getDetails().get("token_id"), refreshEvent.getDetails().get("token_id"));
        org.junit.Assert.assertNotEquals(tokenEvent.getDetails().get("refresh_token_id"), refreshEvent.getDetails().get("updated_refresh_token_id"));
        org.junit.Assert.assertEquals((Object)"123456", (Object)refreshedToken.getNonce());
        this.setTimeOffset(0);
    }

    @Test
    public void refreshTokenWithAccessToken() throws Exception {
        this.oauth.doLogin("test-user@localhost", "password");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doAccessTokenRequest(code, "password");
        String accessTokenString = tokenResponse.getAccessToken();
        this.setTimeOffset(2);
        OAuthClient.AccessTokenResponse response = this.oauth.doRefreshTokenRequest(accessTokenString, "password");
        org.junit.Assert.assertNotEquals((long)200L, (long)response.getStatusCode());
        this.setTimeOffset(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void tokenRefreshWithAccessTokenShouldReturnIdTokenWithAccessTokenHash() {
        this.oauth.doLogin("test-user@localhost", "password");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doAccessTokenRequest(code, "password");
        String refreshToken = tokenResponse.getRefreshToken();
        this.setTimeOffset(2);
        try {
            OAuthClient.AccessTokenResponse response = this.oauth.doRefreshTokenRequest(refreshToken, "password");
            org.junit.Assert.assertEquals((long)200L, (long)response.getStatusCode());
            AccessToken idToken = this.oauth.verifyToken(response.getIdToken());
            org.junit.Assert.assertNotNull((String)"AccessTokenHash should not be null after token refresh", (Object)idToken.getAccessTokenHash());
        }
        finally {
            this.setTimeOffset(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void refreshTokenReuseTokenWithoutRefreshTokensRevoked() throws Exception {
        try {
            this.oauth.doLogin("test-user@localhost", "password");
            EventRepresentation loginEvent = this.events.expectLogin().assertEvent();
            String sessionId = loginEvent.getSessionId();
            String codeId = (String)loginEvent.getDetails().get("code_id");
            String code = (String)this.oauth.getCurrentQuery().get("code");
            OAuthClient.AccessTokenResponse response1 = this.oauth.doAccessTokenRequest(code, "password");
            RefreshToken refreshToken1 = this.oauth.parseRefreshToken(response1.getRefreshToken());
            this.events.expectCodeToToken(codeId, sessionId).assertEvent();
            this.setTimeOffset(2);
            OAuthClient.AccessTokenResponse response2 = this.oauth.doRefreshTokenRequest(response1.getRefreshToken(), "password");
            org.junit.Assert.assertEquals((long)200L, (long)response2.getStatusCode());
            this.events.expectRefresh(refreshToken1.getId(), sessionId).assertEvent();
            this.setTimeOffset(4);
            OAuthClient.AccessTokenResponse response3 = this.oauth.doRefreshTokenRequest(response1.getRefreshToken(), "password");
            org.junit.Assert.assertEquals((long)200L, (long)response3.getStatusCode());
            this.events.expectRefresh(refreshToken1.getId(), sessionId).assertEvent();
        }
        finally {
            this.setTimeOffset(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void refreshTokenReuseTokenWithRefreshTokensRevoked() throws Exception {
        try {
            RealmManager.realm(this.adminClient.realm("test")).revokeRefreshToken(true);
            this.oauth.doLogin("test-user@localhost", "password");
            EventRepresentation loginEvent = this.events.expectLogin().assertEvent();
            String sessionId = loginEvent.getSessionId();
            String codeId = (String)loginEvent.getDetails().get("code_id");
            String code = (String)this.oauth.getCurrentQuery().get("code");
            OAuthClient.AccessTokenResponse response1 = this.oauth.doAccessTokenRequest(code, "password");
            RefreshToken refreshToken1 = this.oauth.parseRefreshToken(response1.getRefreshToken());
            this.events.expectCodeToToken(codeId, sessionId).assertEvent();
            this.setTimeOffset(2);
            OAuthClient.AccessTokenResponse response2 = this.oauth.doRefreshTokenRequest(response1.getRefreshToken(), "password");
            RefreshToken refreshToken2 = this.oauth.parseRefreshToken(response2.getRefreshToken());
            org.junit.Assert.assertEquals((long)200L, (long)response2.getStatusCode());
            this.events.expectRefresh(refreshToken1.getId(), sessionId).assertEvent();
            this.setTimeOffset(4);
            OAuthClient.AccessTokenResponse response3 = this.oauth.doRefreshTokenRequest(response1.getRefreshToken(), "password");
            org.junit.Assert.assertEquals((long)400L, (long)response3.getStatusCode());
            this.events.expectRefresh(refreshToken1.getId(), sessionId).removeDetail("token_id").removeDetail("updated_refresh_token_id").error("invalid_token").assertEvent();
            this.setTimeOffset(6);
            OAuthClient.AccessTokenResponse response4 = this.oauth.doRefreshTokenRequest(response2.getRefreshToken(), "password");
            org.junit.Assert.assertEquals((long)400L, (long)response4.getStatusCode());
            this.events.expectRefresh(refreshToken2.getId(), sessionId).removeDetail("token_id").removeDetail("updated_refresh_token_id").error("invalid_token").assertEvent();
        }
        finally {
            this.setTimeOffset(0);
            RealmManager.realm(this.adminClient.realm("test")).revokeRefreshToken(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void refreshTokenReuseTokenWithRefreshTokensRevokedAfterSingleReuse() throws Exception {
        try {
            RealmManager.realm(this.adminClient.realm("test")).revokeRefreshToken(true).refreshTokenMaxReuse(1);
            this.oauth.doLogin("test-user@localhost", "password");
            EventRepresentation loginEvent = this.events.expectLogin().assertEvent();
            String sessionId = loginEvent.getSessionId();
            String codeId = (String)loginEvent.getDetails().get("code_id");
            String code = (String)this.oauth.getCurrentQuery().get("code");
            OAuthClient.AccessTokenResponse initialResponse = this.oauth.doAccessTokenRequest(code, "password");
            RefreshToken initialRefreshToken = this.oauth.parseRefreshToken(initialResponse.getRefreshToken());
            this.events.expectCodeToToken(codeId, sessionId).assertEvent();
            this.setTimeOffset(2);
            OAuthClient.AccessTokenResponse responseFirstUse = this.oauth.doRefreshTokenRequest(initialResponse.getRefreshToken(), "password");
            RefreshToken newTokenFirstUse = this.oauth.parseRefreshToken(responseFirstUse.getRefreshToken());
            org.junit.Assert.assertEquals((long)200L, (long)responseFirstUse.getStatusCode());
            this.events.expectRefresh(initialRefreshToken.getId(), sessionId).assertEvent();
            this.setTimeOffset(4);
            OAuthClient.AccessTokenResponse responseFirstReuse = this.oauth.doRefreshTokenRequest(initialResponse.getRefreshToken(), "password");
            RefreshToken newTokenFirstReuse = this.oauth.parseRefreshToken(responseFirstReuse.getRefreshToken());
            org.junit.Assert.assertEquals((long)200L, (long)responseFirstReuse.getStatusCode());
            this.events.expectRefresh(initialRefreshToken.getId(), sessionId).assertEvent();
            this.setTimeOffset(6);
            OAuthClient.AccessTokenResponse responseSecondReuse = this.oauth.doRefreshTokenRequest(initialResponse.getRefreshToken(), "password");
            org.junit.Assert.assertEquals((long)400L, (long)responseSecondReuse.getStatusCode());
            this.events.expectRefresh(initialRefreshToken.getId(), sessionId).removeDetail("token_id").removeDetail("updated_refresh_token_id").error("invalid_token").assertEvent();
            this.setTimeOffset(8);
            OAuthClient.AccessTokenResponse responseUseOfInvalidatedRefreshToken = this.oauth.doRefreshTokenRequest(responseFirstUse.getRefreshToken(), "password");
            org.junit.Assert.assertEquals((long)400L, (long)responseUseOfInvalidatedRefreshToken.getStatusCode());
            this.events.expectRefresh(newTokenFirstUse.getId(), sessionId).removeDetail("token_id").removeDetail("updated_refresh_token_id").error("invalid_token").assertEvent();
            this.setTimeOffset(10);
            OAuthClient.AccessTokenResponse responseUseOfValidRefreshToken = this.oauth.doRefreshTokenRequest(responseFirstReuse.getRefreshToken(), "password");
            org.junit.Assert.assertEquals((long)400L, (long)responseUseOfValidRefreshToken.getStatusCode());
            this.events.expectRefresh(newTokenFirstReuse.getId(), sessionId).removeDetail("token_id").removeDetail("updated_refresh_token_id").error("invalid_token").assertEvent();
        }
        finally {
            this.setTimeOffset(0);
            RealmManager.realm(this.adminClient.realm("test")).refreshTokenMaxReuse(0).revokeRefreshToken(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void refreshTokenReuseOfExistingTokenAfterEnablingReuseRevokation() throws Exception {
        try {
            this.oauth.doLogin("test-user@localhost", "password");
            EventRepresentation loginEvent = this.events.expectLogin().assertEvent();
            String sessionId = loginEvent.getSessionId();
            String codeId = (String)loginEvent.getDetails().get("code_id");
            String code = (String)this.oauth.getCurrentQuery().get("code");
            OAuthClient.AccessTokenResponse initialResponse = this.oauth.doAccessTokenRequest(code, "password");
            RefreshToken initialRefreshToken = this.oauth.parseRefreshToken(initialResponse.getRefreshToken());
            this.events.expectCodeToToken(codeId, sessionId).assertEvent();
            this.setTimeOffset(2);
            this.processExpectedValidRefresh(sessionId, initialRefreshToken, initialResponse.getRefreshToken());
            this.processExpectedValidRefresh(sessionId, initialRefreshToken, initialResponse.getRefreshToken());
            this.processExpectedValidRefresh(sessionId, initialRefreshToken, initialResponse.getRefreshToken());
            RealmManager.realm(this.adminClient.realm("test")).revokeRefreshToken(true).refreshTokenMaxReuse(1);
            this.processExpectedValidRefresh(sessionId, initialRefreshToken, initialResponse.getRefreshToken());
            this.processExpectedValidRefresh(sessionId, initialRefreshToken, initialResponse.getRefreshToken());
            OAuthClient.AccessTokenResponse responseReuseExceeded = this.oauth.doRefreshTokenRequest(initialResponse.getRefreshToken(), "password");
            org.junit.Assert.assertEquals((long)400L, (long)responseReuseExceeded.getStatusCode());
            this.events.expectRefresh(initialRefreshToken.getId(), sessionId).removeDetail("token_id").removeDetail("updated_refresh_token_id").error("invalid_token").assertEvent();
        }
        finally {
            this.setTimeOffset(0);
            RealmManager.realm(this.adminClient.realm("test")).refreshTokenMaxReuse(0).revokeRefreshToken(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void refreshTokenReuseOfExistingTokenAfterDisablingReuseRevokation() throws Exception {
        try {
            RealmManager.realm(this.adminClient.realm("test")).revokeRefreshToken(true).refreshTokenMaxReuse(1);
            this.oauth.doLogin("test-user@localhost", "password");
            EventRepresentation loginEvent = this.events.expectLogin().assertEvent();
            String sessionId = loginEvent.getSessionId();
            String codeId = (String)loginEvent.getDetails().get("code_id");
            String code = (String)this.oauth.getCurrentQuery().get("code");
            OAuthClient.AccessTokenResponse initialResponse = this.oauth.doAccessTokenRequest(code, "password");
            RefreshToken initialRefreshToken = this.oauth.parseRefreshToken(initialResponse.getRefreshToken());
            this.events.expectCodeToToken(codeId, sessionId).assertEvent();
            this.setTimeOffset(2);
            this.processExpectedValidRefresh(sessionId, initialRefreshToken, initialResponse.getRefreshToken());
            this.processExpectedValidRefresh(sessionId, initialRefreshToken, initialResponse.getRefreshToken());
            OAuthClient.AccessTokenResponse responseReuseExceeded = this.oauth.doRefreshTokenRequest(initialResponse.getRefreshToken(), "password");
            org.junit.Assert.assertEquals((long)400L, (long)responseReuseExceeded.getStatusCode());
            this.events.expectRefresh(initialRefreshToken.getId(), sessionId).removeDetail("token_id").removeDetail("updated_refresh_token_id").error("invalid_token").assertEvent();
            RealmManager.realm(this.adminClient.realm("test")).revokeRefreshToken(false);
            OAuthClient.AccessTokenResponse responseReuseExceeded2 = this.oauth.doRefreshTokenRequest(initialResponse.getRefreshToken(), "password");
            org.junit.Assert.assertEquals((long)400L, (long)responseReuseExceeded2.getStatusCode());
            this.events.expectRefresh(initialRefreshToken.getId(), sessionId).removeDetail("token_id").removeDetail("updated_refresh_token_id").error("invalid_token").assertEvent();
        }
        finally {
            this.setTimeOffset(0);
            RealmManager.realm(this.adminClient.realm("test")).refreshTokenMaxReuse(0).revokeRefreshToken(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void refreshTokenReuseTokenWithRefreshTokensRevokedAndSSOReauthentication() throws Exception {
        try {
            RealmManager.realm(this.adminClient.realm("test")).revokeRefreshToken(true);
            this.oauth.doLogin("test-user@localhost", "password");
            EventRepresentation loginEvent = this.events.expectLogin().assertEvent();
            String sessionId = loginEvent.getSessionId();
            String codeId = (String)loginEvent.getDetails().get("code_id");
            String code = (String)this.oauth.getCurrentQuery().get("code");
            OAuthClient.AccessTokenResponse response1 = this.oauth.doAccessTokenRequest(code, "password");
            RefreshToken refreshToken1 = this.oauth.parseRefreshToken(response1.getRefreshToken());
            this.events.expectCodeToToken(codeId, sessionId).assertEvent();
            this.setTimeOffset(2);
            OAuthClient.AccessTokenResponse response2 = this.oauth.doRefreshTokenRequest(response1.getRefreshToken(), "password");
            RefreshToken refreshToken2 = this.oauth.parseRefreshToken(response2.getRefreshToken());
            org.junit.Assert.assertEquals((long)200L, (long)response2.getStatusCode());
            this.events.expectRefresh(refreshToken1.getId(), sessionId).assertEvent();
            org.junit.Assert.assertTrue((boolean)this.hasClientSessionForTestApp());
            this.setTimeOffset(4);
            OAuthClient.AccessTokenResponse response3 = this.oauth.doRefreshTokenRequest(response1.getRefreshToken(), "password");
            org.junit.Assert.assertEquals((long)400L, (long)response3.getStatusCode());
            this.events.expectRefresh(refreshToken1.getId(), sessionId).removeDetail("token_id").removeDetail("updated_refresh_token_id").error("invalid_token").assertEvent();
            org.junit.Assert.assertFalse((boolean)this.hasClientSessionForTestApp());
            String introspectionResponse = this.oauth.introspectAccessTokenWithClientCredential("test-app", "password", response1.getAccessToken());
            JsonNode jsonNode = JsonSerialization.mapper.readTree(introspectionResponse);
            org.junit.Assert.assertFalse((boolean)jsonNode.get("active").asBoolean());
            this.events.clear();
            this.setTimeOffset(6);
            this.oauth.openLoginForm();
            loginEvent = this.events.expectLogin().assertEvent();
            sessionId = loginEvent.getSessionId();
            codeId = (String)loginEvent.getDetails().get("code_id");
            code = (String)this.oauth.getCurrentQuery().get("code");
            OAuthClient.AccessTokenResponse response4 = this.oauth.doAccessTokenRequest(code, "password");
            RefreshToken refreshToken4 = this.oauth.parseRefreshToken(response4.getRefreshToken());
            this.events.expectCodeToToken(codeId, sessionId).assertEvent();
            org.junit.Assert.assertTrue((boolean)this.hasClientSessionForTestApp());
            introspectionResponse = this.oauth.introspectAccessTokenWithClientCredential("test-app", "password", response1.getAccessToken());
            jsonNode = JsonSerialization.mapper.readTree(introspectionResponse);
            org.junit.Assert.assertFalse((boolean)jsonNode.get("active").asBoolean());
            UserInfo userInfo = this.oauth.doUserInfoRequest(response1.getAccessToken());
            org.junit.Assert.assertNull((Object)userInfo.getSubject());
            org.junit.Assert.assertEquals(userInfo.getOtherClaims().get("error"), (Object)"invalid_token");
            this.events.clear();
            this.setTimeOffset(8);
            OAuthClient.AccessTokenResponse response5 = this.oauth.doRefreshTokenRequest(response2.getRefreshToken(), "password");
            org.junit.Assert.assertEquals((long)400L, (long)response5.getStatusCode());
            this.events.expectRefresh(refreshToken2.getId(), sessionId).removeDetail("token_id").removeDetail("updated_refresh_token_id").error("invalid_token").assertEvent();
        }
        finally {
            this.setTimeOffset(0);
            RealmManager.realm(this.adminClient.realm("test")).revokeRefreshToken(false);
        }
    }

    private boolean hasClientSessionForTestApp() {
        List userSessions = ApiUtil.findUserByUsernameId((RealmResource)this.adminClient.realm("test"), (String)"test-user@localhost").getUserSessions();
        return userSessions.stream().anyMatch(userSession -> userSession.getClients().containsValue("test-app"));
    }

    private void processExpectedValidRefresh(String sessionId, RefreshToken requestToken, String refreshToken) {
        OAuthClient.AccessTokenResponse response2 = this.oauth.doRefreshTokenRequest(refreshToken, "password");
        org.junit.Assert.assertEquals((long)200L, (long)response2.getStatusCode());
        this.events.expectRefresh(requestToken.getId(), sessionId).assertEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void refreshTokenClientDisabled() throws Exception {
        this.oauth.doLogin("test-user@localhost", "password");
        EventRepresentation loginEvent = this.events.expectLogin().assertEvent();
        String sessionId = loginEvent.getSessionId();
        String codeId = (String)loginEvent.getDetails().get("code_id");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse response = this.oauth.doAccessTokenRequest(code, "password");
        String refreshTokenString = response.getRefreshToken();
        RefreshToken refreshToken = this.oauth.parseRefreshToken(refreshTokenString);
        this.events.expectCodeToToken(codeId, sessionId).assertEvent();
        try {
            ClientManager.realm(this.adminClient.realm("test")).clientId(this.oauth.getClientId()).enabled(false);
            this.setTimeOffset(2);
            response = this.oauth.doRefreshTokenRequest(refreshTokenString, "password");
            org.junit.Assert.assertEquals((long)400L, (long)response.getStatusCode());
            org.junit.Assert.assertEquals((Object)"unauthorized_client", (Object)response.getError());
            this.events.expectRefresh(refreshToken.getId(), sessionId).user((String)null).session((String)null).clearDetails().error("client_disabled").assertEvent();
        }
        finally {
            ClientManager.realm(this.adminClient.realm("test")).clientId(this.oauth.getClientId()).enabled(true);
        }
    }

    @Test
    public void refreshTokenUserSessionExpired() {
        this.oauth.doLogin("test-user@localhost", "password");
        EventRepresentation loginEvent = this.events.expectLogin().assertEvent();
        String sessionId = loginEvent.getSessionId();
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doAccessTokenRequest(code, "password");
        this.events.poll();
        String refreshId = this.oauth.parseRefreshToken(tokenResponse.getRefreshToken()).getId();
        this.testingClient.testing().removeUserSession("test", sessionId);
        this.setTimeOffset(2);
        tokenResponse = this.oauth.doRefreshTokenRequest(tokenResponse.getRefreshToken(), "password");
        org.junit.Assert.assertEquals((long)400L, (long)tokenResponse.getStatusCode());
        org.junit.Assert.assertNull((Object)tokenResponse.getAccessToken());
        org.junit.Assert.assertNull((Object)tokenResponse.getRefreshToken());
        this.events.expectRefresh(refreshId, sessionId).error("invalid_token");
        this.events.clear();
    }

    @Test
    public void refreshTokenAfterUserLogoutAndLoginAgain() {
        String refreshToken1 = this.loginAndForceNewLoginPage();
        this.oauth.doLogout(refreshToken1, "password");
        this.events.clear();
        this.setTimeOffset(2);
        this.oauth.fillLoginForm("test-user@localhost", "password");
        org.junit.Assert.assertFalse((boolean)this.loginPage.isCurrent());
        OAuthClient.AccessTokenResponse tokenResponse2 = null;
        String code = (String)this.oauth.getCurrentQuery().get("code");
        tokenResponse2 = this.oauth.doAccessTokenRequest(code, "password");
        this.setTimeOffset(4);
        OAuthClient.AccessTokenResponse responseReuseExceeded = this.oauth.doRefreshTokenRequest(refreshToken1, "password");
        org.junit.Assert.assertEquals((long)400L, (long)responseReuseExceeded.getStatusCode());
        this.setTimeOffset(6);
        responseReuseExceeded = this.oauth.doRefreshTokenRequest(tokenResponse2.getRefreshToken(), "password");
        org.junit.Assert.assertEquals((long)200L, (long)responseReuseExceeded.getStatusCode());
    }

    @Test
    public void refreshTokenAfterAdminLogoutAllAndLoginAgain() {
        String refreshToken1 = this.loginAndForceNewLoginPage();
        this.adminClient.realm("test").logoutAll();
        WaitUtils.pause((long)500L);
        this.events.clear();
        this.setTimeOffset(2);
        this.oauth.fillLoginForm("test-user@localhost", "password");
        org.junit.Assert.assertFalse((boolean)this.loginPage.isCurrent());
        OAuthClient.AccessTokenResponse tokenResponse2 = null;
        String code = (String)this.oauth.getCurrentQuery().get("code");
        tokenResponse2 = this.oauth.doAccessTokenRequest(code, "password");
        this.setTimeOffset(4);
        OAuthClient.AccessTokenResponse responseReuseExceeded = this.oauth.doRefreshTokenRequest(refreshToken1, "password");
        org.junit.Assert.assertEquals((long)400L, (long)responseReuseExceeded.getStatusCode());
        this.setTimeOffset(6);
        responseReuseExceeded = this.oauth.doRefreshTokenRequest(tokenResponse2.getRefreshToken(), "password");
        org.junit.Assert.assertEquals((long)200L, (long)responseReuseExceeded.getStatusCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void refreshTokenAfterUserAdminLogoutEndpointAndLoginAgain() {
        try {
            String refreshToken1 = this.loginAndForceNewLoginPage();
            RefreshToken refreshTokenParsed1 = this.oauth.parseRefreshToken(refreshToken1);
            String userId = refreshTokenParsed1.getSubject();
            UserResource user = this.adminClient.realm("test").users().get(userId);
            user.logout();
            this.setTimeOffset(2);
            this.oauth.fillLoginForm("test-user@localhost", "password");
            org.junit.Assert.assertFalse((boolean)this.loginPage.isCurrent());
            OAuthClient.AccessTokenResponse tokenResponse2 = null;
            String code = (String)this.oauth.getCurrentQuery().get("code");
            tokenResponse2 = this.oauth.doAccessTokenRequest(code, "password");
            this.setTimeOffset(4);
            OAuthClient.AccessTokenResponse responseReuseExceeded = this.oauth.doRefreshTokenRequest(refreshToken1, "password");
            org.junit.Assert.assertEquals((long)400L, (long)responseReuseExceeded.getStatusCode());
            this.setTimeOffset(6);
            responseReuseExceeded = this.oauth.doRefreshTokenRequest(tokenResponse2.getRefreshToken(), "password");
            org.junit.Assert.assertEquals((long)200L, (long)responseReuseExceeded.getStatusCode());
        }
        finally {
            this.testingClient.server().run((RunOnServer & Serializable)session -> {
                RealmModel realm = session.realms().getRealmByName("test");
                UserModel user = session.users().getUserByUsername(realm, "test-user@localhost");
                session.users().setNotBeforeForUser(realm, user, 0);
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUserSessionRefreshAndIdle() throws Exception {
        this.oauth.doLogin("test-user@localhost", "password");
        EventRepresentation loginEvent = this.events.expectLogin().assertEvent();
        String sessionId = loginEvent.getSessionId();
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doAccessTokenRequest(code, "password");
        this.events.poll();
        String refreshId = this.oauth.parseRefreshToken(tokenResponse.getRefreshToken()).getId();
        int last = this.testingClient.testing().getLastSessionRefresh("test", sessionId, false);
        this.setTimeOffset(2);
        tokenResponse = this.oauth.doRefreshTokenRequest(tokenResponse.getRefreshToken(), "password");
        AccessToken refreshedToken = this.oauth.verifyToken(tokenResponse.getAccessToken());
        RefreshToken refreshedRefreshToken = this.oauth.parseRefreshToken(tokenResponse.getRefreshToken());
        org.junit.Assert.assertEquals((long)200L, (long)tokenResponse.getStatusCode());
        int next = this.testingClient.testing().getLastSessionRefresh("test", sessionId, false);
        org.junit.Assert.assertNotEquals((long)last, (long)next);
        RealmResource realmResource = this.adminClient.realm("test");
        int lastAccessTokenLifespan = realmResource.toRepresentation().getAccessTokenLifespan();
        int originalIdle = realmResource.toRepresentation().getSsoSessionIdleTimeout();
        try {
            RealmManager.realm(realmResource).accessTokenLifespan(100000);
            this.setTimeOffset(4);
            tokenResponse = this.oauth.doRefreshTokenRequest(tokenResponse.getRefreshToken(), "password");
            next = this.testingClient.testing().getLastSessionRefresh("test", sessionId, false);
            org.junit.Assert.assertThat((Object)next, (Matcher)Matchers.allOf((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(last)), (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(last + 50))));
            RealmManager.realm(realmResource).ssoSessionIdleTimeout(1);
            this.events.clear();
            this.setTimeOffset(126);
            tokenResponse = this.oauth.doRefreshTokenRequest(tokenResponse.getRefreshToken(), "password");
            org.junit.Assert.assertEquals((long)400L, (long)tokenResponse.getStatusCode());
            org.junit.Assert.assertNull((Object)tokenResponse.getAccessToken());
            org.junit.Assert.assertNull((Object)tokenResponse.getRefreshToken());
            this.events.expectRefresh(refreshId, sessionId).error("invalid_token");
        }
        finally {
            RealmManager.realm(realmResource).ssoSessionIdleTimeout(originalIdle).accessTokenLifespan(lastAccessTokenLifespan);
            this.events.clear();
            this.setTimeOffset(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUserSessionRefreshAndIdleRememberMe() throws Exception {
        RealmResource testRealm = this.adminClient.realm("test");
        RealmRepresentation testRealmRep = testRealm.toRepresentation();
        Boolean previousRememberMe = testRealmRep.isRememberMe();
        int originalIdleRememberMe = testRealmRep.getSsoSessionIdleTimeoutRememberMe();
        try {
            testRealmRep.setRememberMe(Boolean.valueOf(true));
            testRealm.update(testRealmRep);
            this.oauth.doRememberMeLogin("test-user@localhost", "password");
            EventRepresentation loginEvent = this.events.expectLogin().assertEvent();
            String sessionId = loginEvent.getSessionId();
            String code = (String)this.oauth.getCurrentQuery().get("code");
            OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doAccessTokenRequest(code, "password");
            this.events.poll();
            String refreshId = this.oauth.parseRefreshToken(tokenResponse.getRefreshToken()).getId();
            int last = this.testingClient.testing().getLastSessionRefresh("test", sessionId, false);
            this.setTimeOffset(2);
            tokenResponse = this.oauth.doRefreshTokenRequest(tokenResponse.getRefreshToken(), "password");
            this.oauth.verifyToken(tokenResponse.getAccessToken());
            this.oauth.parseRefreshToken(tokenResponse.getRefreshToken());
            org.junit.Assert.assertEquals((long)200L, (long)tokenResponse.getStatusCode());
            int next = this.testingClient.testing().getLastSessionRefresh("test", sessionId, false);
            org.junit.Assert.assertNotEquals((long)last, (long)next);
            testRealmRep.setSsoSessionIdleTimeoutRememberMe(Integer.valueOf(1));
            testRealm.update(testRealmRep);
            this.events.clear();
            this.setTimeOffset(126);
            tokenResponse = this.oauth.doRefreshTokenRequest(tokenResponse.getRefreshToken(), "password");
            org.junit.Assert.assertEquals((long)400L, (long)tokenResponse.getStatusCode());
            org.junit.Assert.assertNull((Object)tokenResponse.getAccessToken());
            org.junit.Assert.assertNull((Object)tokenResponse.getRefreshToken());
            this.events.expectRefresh(refreshId, sessionId).error("invalid_token");
            this.events.clear();
        }
        finally {
            testRealmRep.setSsoSessionIdleTimeoutRememberMe(Integer.valueOf(originalIdleRememberMe));
            testRealmRep.setRememberMe(previousRememberMe);
            testRealm.update(testRealmRep);
            this.setTimeOffset(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void refreshTokenUserSessionMaxLifespan() throws Exception {
        this.oauth.doLogin("test-user@localhost", "password");
        EventRepresentation loginEvent = this.events.expectLogin().assertEvent();
        String sessionId = loginEvent.getSessionId();
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doAccessTokenRequest(code, "password");
        this.events.poll();
        String refreshId = this.oauth.parseRefreshToken(tokenResponse.getRefreshToken()).getId();
        RealmResource realmResource = this.adminClient.realm("test");
        Integer maxLifespan = realmResource.toRepresentation().getSsoSessionMaxLifespan();
        try {
            RealmManager.realm(realmResource).ssoSessionMaxLifespan(1);
            this.setTimeOffset(2);
            tokenResponse = this.oauth.doRefreshTokenRequest(tokenResponse.getRefreshToken(), "password");
            org.junit.Assert.assertEquals((long)400L, (long)tokenResponse.getStatusCode());
            org.junit.Assert.assertNull((Object)tokenResponse.getAccessToken());
            org.junit.Assert.assertNull((Object)tokenResponse.getRefreshToken());
            this.events.expectRefresh(refreshId, sessionId).error("invalid_token");
        }
        finally {
            RealmManager.realm(realmResource).ssoSessionMaxLifespan(maxLifespan);
            this.events.clear();
            this.resetTimeOffset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void refreshTokenUserSessionMaxLifespanWithRememberMe() throws Exception {
        RealmResource testRealm = this.adminClient.realm("test");
        RealmRepresentation testRealmRep = testRealm.toRepresentation();
        Boolean previousRememberMe = testRealmRep.isRememberMe();
        int previousSsoMaxLifespanRememberMe = testRealmRep.getSsoSessionMaxLifespanRememberMe();
        try {
            testRealmRep.setRememberMe(Boolean.valueOf(true));
            testRealm.update(testRealmRep);
            this.oauth.doRememberMeLogin("test-user@localhost", "password");
            EventRepresentation loginEvent = this.events.expectLogin().assertEvent();
            String sessionId = loginEvent.getSessionId();
            String code = (String)this.oauth.getCurrentQuery().get("code");
            OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doAccessTokenRequest(code, "password");
            this.events.poll();
            String refreshId = this.oauth.parseRefreshToken(tokenResponse.getRefreshToken()).getId();
            testRealmRep.setSsoSessionMaxLifespanRememberMe(Integer.valueOf(1));
            testRealm.update(testRealmRep);
            this.setTimeOffset(2);
            tokenResponse = this.oauth.doRefreshTokenRequest(tokenResponse.getRefreshToken(), "password");
            org.junit.Assert.assertEquals((long)400L, (long)tokenResponse.getStatusCode());
            org.junit.Assert.assertNull((Object)tokenResponse.getAccessToken());
            org.junit.Assert.assertNull((Object)tokenResponse.getRefreshToken());
            this.events.expectRefresh(refreshId, sessionId).error("invalid_token");
            this.events.clear();
        }
        finally {
            testRealmRep.setSsoSessionMaxLifespanRememberMe(Integer.valueOf(previousSsoMaxLifespanRememberMe));
            testRealmRep.setRememberMe(previousRememberMe);
            testRealm.update(testRealmRep);
            this.setTimeOffset(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCheckSsl() throws Exception {
        ResteasyClient client = AdminClientUtil.createResteasyClient();
        try {
            UriBuilder builder = UriBuilder.fromUri((String)OAuthClient.AUTH_SERVER_ROOT);
            URI grantUri = OIDCLoginProtocolService.tokenUrl((UriBuilder)builder).build(new Object[]{"test"});
            WebTarget grantTarget = client.target(grantUri);
            builder = UriBuilder.fromUri((String)OAuthClient.AUTH_SERVER_ROOT);
            URI uri = OIDCLoginProtocolService.tokenUrl((UriBuilder)builder).build(new Object[]{"test"});
            WebTarget refreshTarget = client.target(uri);
            String refreshToken = null;
            Response response = this.executeGrantAccessTokenRequest(grantTarget);
            org.junit.Assert.assertEquals((long)200L, (long)response.getStatus());
            AccessTokenResponse tokenResponse = (AccessTokenResponse)response.readEntity(AccessTokenResponse.class);
            refreshToken = tokenResponse.getRefreshToken();
            response.close();
            response = this.executeRefreshToken(refreshTarget, refreshToken);
            org.junit.Assert.assertEquals((long)200L, (long)response.getStatus());
            tokenResponse = (AccessTokenResponse)response.readEntity(AccessTokenResponse.class);
            refreshToken = tokenResponse.getRefreshToken();
            response.close();
            if (!ServerURLs.AUTH_SERVER_SSL_REQUIRED) {
                RealmResource realmResource = this.adminClient.realm("test");
                RealmManager.realm(realmResource).sslRequired(SslRequired.ALL.toString());
                Response response2 = this.executeRefreshToken(refreshTarget, refreshToken);
                org.junit.Assert.assertEquals((long)403L, (long)response2.getStatus());
                response2.close();
                RealmManager.realm(realmResource).sslRequired(SslRequired.EXTERNAL.toString());
            }
            response = this.executeRefreshToken(refreshTarget, refreshToken);
            org.junit.Assert.assertEquals((long)200L, (long)response.getStatus());
            tokenResponse = (AccessTokenResponse)response.readEntity(AccessTokenResponse.class);
            refreshToken = tokenResponse.getRefreshToken();
            response.close();
        }
        finally {
            client.close();
            this.resetTimeOffset();
            this.events.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void refreshTokenUserDisabled() throws Exception {
        this.oauth.doLogin("test-user@localhost", "password");
        EventRepresentation loginEvent = this.events.expectLogin().assertEvent();
        String sessionId = loginEvent.getSessionId();
        String codeId = (String)loginEvent.getDetails().get("code_id");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse response = this.oauth.doAccessTokenRequest(code, "password");
        String refreshTokenString = response.getRefreshToken();
        RefreshToken refreshToken = this.oauth.parseRefreshToken(refreshTokenString);
        this.events.expectCodeToToken(codeId, sessionId).assertEvent();
        try {
            UserManager.realm(this.adminClient.realm("test")).username("test-user@localhost").enabled(false);
            this.setTimeOffset(2);
            response = this.oauth.doRefreshTokenRequest(refreshTokenString, "password");
            org.junit.Assert.assertEquals((long)400L, (long)response.getStatusCode());
            org.junit.Assert.assertEquals((Object)"invalid_grant", (Object)response.getError());
            this.events.expectRefresh(refreshToken.getId(), sessionId).clearDetails().error("invalid_token").assertEvent();
        }
        finally {
            UserManager.realm(this.adminClient.realm("test")).username("test-user@localhost").enabled(true);
        }
    }

    @Test
    public void refreshTokenUserDeleted() throws Exception {
        String userId = this.createUser("test", "temp-user@localhost", "password", new String[0]);
        this.oauth.doLogin("temp-user@localhost", "password");
        EventRepresentation loginEvent = this.events.expectLogin().user(userId).assertEvent();
        String sessionId = loginEvent.getSessionId();
        String codeId = (String)loginEvent.getDetails().get("code_id");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse response = this.oauth.doAccessTokenRequest(code, "password");
        String refreshTokenString = response.getRefreshToken();
        RefreshToken refreshToken = this.oauth.parseRefreshToken(refreshTokenString);
        this.events.expectCodeToToken(codeId, sessionId).user(userId).assertEvent();
        this.adminClient.realm("test").users().delete(userId);
        this.setTimeOffset(2);
        response = this.oauth.doRefreshTokenRequest(refreshTokenString, "password");
        org.junit.Assert.assertEquals((long)400L, (long)response.getStatusCode());
        org.junit.Assert.assertEquals((Object)"invalid_grant", (Object)response.getError());
        this.events.expectRefresh(refreshToken.getId(), sessionId).user(userId).clearDetails().error("invalid_token").assertEvent();
    }

    @Test
    public void refreshTokenServiceAccount() throws Exception {
        OAuthClient.AccessTokenResponse response = this.oauth.clientId("service-account-app").doClientCredentialsGrantAccessTokenRequest("secret");
        org.junit.Assert.assertNotNull((Object)response.getRefreshToken());
        response = this.oauth.doRefreshTokenRequest(response.getRefreshToken(), "secret");
        org.junit.Assert.assertNotNull((Object)response.getRefreshToken());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClientSessionMaxLifespan() throws Exception {
        ClientResource client = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app");
        ClientRepresentation clientRepresentation = client.toRepresentation();
        RealmResource realm = this.adminClient.realm("test");
        RealmRepresentation rep = realm.toRepresentation();
        Integer originalSsoSessionMaxLifespan = rep.getSsoSessionMaxLifespan();
        int ssoSessionMaxLifespan = rep.getSsoSessionIdleTimeout() - 100;
        Integer originalClientSessionMaxLifespan = rep.getClientSessionMaxLifespan();
        try {
            rep.setSsoSessionMaxLifespan(Integer.valueOf(ssoSessionMaxLifespan));
            realm.update(rep);
            this.oauth.doLogin("test-user@localhost", "password");
            String code = (String)this.oauth.getCurrentQuery().get("code");
            OAuthClient.AccessTokenResponse response = this.oauth.doAccessTokenRequest(code, "password");
            org.junit.Assert.assertEquals((long)200L, (long)response.getStatusCode());
            Assert.assertExpiration(response.getRefreshExpiresIn(), ssoSessionMaxLifespan);
            rep.setClientSessionMaxLifespan(Integer.valueOf(ssoSessionMaxLifespan - 100));
            realm.update(rep);
            String refreshToken = response.getRefreshToken();
            response = this.oauth.doRefreshTokenRequest(refreshToken, "password");
            org.junit.Assert.assertEquals((long)200L, (long)response.getStatusCode());
            Assert.assertExpiration(response.getRefreshExpiresIn(), ssoSessionMaxLifespan - 100);
            clientRepresentation.getAttributes().put("client.session.max.lifespan", Integer.toString(ssoSessionMaxLifespan - 200));
            client.update(clientRepresentation);
            refreshToken = response.getRefreshToken();
            response = this.oauth.doRefreshTokenRequest(refreshToken, "password");
            org.junit.Assert.assertEquals((long)200L, (long)response.getStatusCode());
            Assert.assertExpiration(response.getRefreshExpiresIn(), ssoSessionMaxLifespan - 200);
        }
        finally {
            rep.setSsoSessionMaxLifespan(originalSsoSessionMaxLifespan);
            rep.setClientSessionMaxLifespan(originalClientSessionMaxLifespan);
            realm.update(rep);
            clientRepresentation.getAttributes().put("client.session.max.lifespan", null);
            client.update(clientRepresentation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClientSessionIdleTimeout() throws Exception {
        ClientResource client = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app");
        ClientRepresentation clientRepresentation = client.toRepresentation();
        RealmResource realm = this.adminClient.realm("test");
        RealmRepresentation rep = realm.toRepresentation();
        int ssoSessionIdleTimeout = rep.getSsoSessionIdleTimeout();
        Integer originalClientSessionIdleTimeout = rep.getClientSessionIdleTimeout();
        try {
            this.oauth.doLogin("test-user@localhost", "password");
            String code = (String)this.oauth.getCurrentQuery().get("code");
            OAuthClient.AccessTokenResponse response = this.oauth.doAccessTokenRequest(code, "password");
            org.junit.Assert.assertEquals((long)200L, (long)response.getStatusCode());
            Assert.assertExpiration(response.getRefreshExpiresIn(), ssoSessionIdleTimeout);
            rep.setClientSessionIdleTimeout(Integer.valueOf(ssoSessionIdleTimeout - 100));
            realm.update(rep);
            String refreshToken = response.getRefreshToken();
            response = this.oauth.doRefreshTokenRequest(refreshToken, "password");
            org.junit.Assert.assertEquals((long)200L, (long)response.getStatusCode());
            Assert.assertExpiration(response.getRefreshExpiresIn(), ssoSessionIdleTimeout - 100);
            clientRepresentation.getAttributes().put("client.session.idle.timeout", Integer.toString(ssoSessionIdleTimeout - 200));
            client.update(clientRepresentation);
            refreshToken = response.getRefreshToken();
            response = this.oauth.doRefreshTokenRequest(refreshToken, "password");
            org.junit.Assert.assertEquals((long)200L, (long)response.getStatusCode());
            Assert.assertExpiration(response.getRefreshExpiresIn(), ssoSessionIdleTimeout - 200);
        }
        finally {
            rep.setClientSessionIdleTimeout(originalClientSessionIdleTimeout);
            realm.update(rep);
            clientRepresentation.getAttributes().put("client.session.idle.timeout", null);
            client.update(clientRepresentation);
        }
    }

    @Test
    public void testRefreshTokenWhenClientSessionTimeoutPassedButRealmDidNot() {
        this.getCleanup().addCleanup((AutoCloseable)new RealmAttributeUpdater(this.adminClient.realm("test")).setSsoSessionIdleTimeout(Integer.valueOf(2592000)).setSsoSessionMaxLifespan(Integer.valueOf(86313600)).update()).addCleanup((AutoCloseable)ClientAttributeUpdater.forClient((Keycloak)this.adminClient, (String)"test", (String)"test-app").setAttribute("client.session.idle.timeout", "60").setAttribute("client.session.max.lifespan", "65").update());
        this.oauth.doLogin("test-user@localhost", "password");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse response = this.oauth.doAccessTokenRequest(code, "password");
        org.junit.Assert.assertEquals((long)200L, (long)response.getStatusCode());
        Assert.assertExpiration(response.getExpiresIn(), 65);
        this.setTimeOffset(70);
        this.oauth.openLoginForm();
        code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse response2 = this.oauth.doAccessTokenRequest(code, "password");
        Assert.assertExpiration(response2.getExpiresIn(), 65);
    }

    @Test
    public void refreshTokenRequestNoRefreshToken() {
        ClientResource client = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app");
        ClientRepresentation clientRepresentation = client.toRepresentation();
        this.oauth.doLogin("test-user@localhost", "password");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doAccessTokenRequest(code, "password");
        String refreshTokenString = tokenResponse.getRefreshToken();
        this.setTimeOffset(2);
        clientRepresentation.getAttributes().put("use.refresh.tokens", "false");
        client.update(clientRepresentation);
        OAuthClient.AccessTokenResponse response = this.oauth.doRefreshTokenRequest(refreshTokenString, "password");
        org.junit.Assert.assertNotNull((Object)response.getAccessToken());
        org.junit.Assert.assertNull((Object)response.getRefreshToken());
        clientRepresentation.getAttributes().put("use.refresh.tokens", "true");
        client.update(clientRepresentation);
    }

    @Test
    public void tokenRefreshRequest_ClientRS384_RealmRS384() throws Exception {
        this.conductTokenRefreshRequest("HS256", "RS384", "RS384");
    }

    @Test
    public void tokenRefreshRequest_ClientRS512_RealmRS256() throws Exception {
        this.conductTokenRefreshRequest("HS256", "RS512", "RS256");
    }

    @Test
    public void tokenRefreshRequest_ClientES256_RealmRS256() throws Exception {
        this.conductTokenRefreshRequest("HS256", "ES256", "RS256");
    }

    @Test
    public void tokenRefreshRequest_ClientES384_RealmES384() throws Exception {
        this.conductTokenRefreshRequest("HS256", "ES384", "ES384");
    }

    @Test
    public void tokenRefreshRequest_ClientES512_RealmRS256() throws Exception {
        this.conductTokenRefreshRequest("HS256", "ES512", "RS256");
    }

    @Test
    public void tokenRefreshRequest_ClientPS256_RealmRS256() throws Exception {
        this.conductTokenRefreshRequest("HS256", "PS256", "RS256");
    }

    @Test
    public void tokenRefreshRequest_ClientPS384_RealmES384() throws Exception {
        this.conductTokenRefreshRequest("HS256", "PS384", "ES384");
    }

    @Test
    public void tokenRefreshRequest_ClientPS512_RealmPS256() throws Exception {
        this.conductTokenRefreshRequest("HS256", "PS512", "PS256");
    }

    protected Response executeRefreshToken(WebTarget refreshTarget, String refreshToken) {
        String header = BasicAuthHelper.createHeader((String)"test-app", (String)"password");
        Form form = new Form();
        form.param("grant_type", "refresh_token");
        form.param("refresh_token", refreshToken);
        return refreshTarget.request().header("Authorization", (Object)header).post(Entity.form((Form)form));
    }

    protected Response executeGrantAccessTokenRequest(WebTarget grantTarget) {
        String header = BasicAuthHelper.createHeader((String)"test-app", (String)"password");
        Form form = new Form();
        form.param("grant_type", "password").param("username", "test-user@localhost").param("password", "password");
        return grantTarget.request().header("Authorization", (Object)header).post(Entity.form((Form)form));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void conductTokenRefreshRequest(String expectedRefreshAlg, String expectedAccessAlg, String expectedIdTokenAlg) throws Exception {
        try {
            TokenSignatureUtil.changeRealmTokenSignatureProvider((Keycloak)this.adminClient, (String)expectedIdTokenAlg);
            TokenSignatureUtil.changeClientAccessTokenSignatureProvider((ClientResource)ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app"), (String)expectedAccessAlg);
            this.refreshToken(expectedRefreshAlg, expectedAccessAlg, expectedIdTokenAlg);
        }
        finally {
            TokenSignatureUtil.changeRealmTokenSignatureProvider((Keycloak)this.adminClient, (String)"RS256");
            TokenSignatureUtil.changeClientAccessTokenSignatureProvider((ClientResource)ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app"), (String)"RS256");
        }
    }

    private void refreshToken(String expectedRefreshAlg, String expectedAccessAlg, String expectedIdTokenAlg) throws Exception {
        this.oauth.doLogin("test-user@localhost", "password");
        EventRepresentation loginEvent = this.events.expectLogin().assertEvent();
        String sessionId = loginEvent.getSessionId();
        String codeId = (String)loginEvent.getDetails().get("code_id");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doAccessTokenRequest(code, "password");
        JWSHeader header = new JWSInput(tokenResponse.getAccessToken()).getHeader();
        org.junit.Assert.assertEquals((Object)expectedAccessAlg, (Object)header.getAlgorithm().name());
        org.junit.Assert.assertEquals((Object)"JWT", (Object)header.getType());
        org.junit.Assert.assertNull((Object)header.getContentType());
        header = new JWSInput(tokenResponse.getIdToken()).getHeader();
        org.junit.Assert.assertEquals((Object)expectedIdTokenAlg, (Object)header.getAlgorithm().name());
        org.junit.Assert.assertEquals((Object)"JWT", (Object)header.getType());
        org.junit.Assert.assertNull((Object)header.getContentType());
        header = new JWSInput(tokenResponse.getRefreshToken()).getHeader();
        org.junit.Assert.assertEquals((Object)expectedRefreshAlg, (Object)header.getAlgorithm().name());
        org.junit.Assert.assertEquals((Object)"JWT", (Object)header.getType());
        org.junit.Assert.assertNull((Object)header.getContentType());
        AccessToken token = this.oauth.verifyToken(tokenResponse.getAccessToken());
        String refreshTokenString = tokenResponse.getRefreshToken();
        RefreshToken refreshToken = this.oauth.parseRefreshToken(refreshTokenString);
        EventRepresentation tokenEvent = this.events.expectCodeToToken(codeId, sessionId).assertEvent();
        org.junit.Assert.assertNotNull((Object)refreshTokenString);
        org.junit.Assert.assertEquals((Object)"Bearer", (Object)tokenResponse.getTokenType());
        org.junit.Assert.assertEquals((Object)sessionId, (Object)refreshToken.getSessionState());
        this.setTimeOffset(2);
        OAuthClient.AccessTokenResponse response = this.oauth.doRefreshTokenRequest(refreshTokenString, "password");
        if (response.getError() != null || response.getErrorDescription() != null) {
            this.log.debugf("Refresh token error: %s, error description: %s", (Object)response.getError(), (Object)response.getErrorDescription());
        }
        AccessToken refreshedToken = this.oauth.verifyToken(response.getAccessToken());
        RefreshToken refreshedRefreshToken = this.oauth.parseRefreshToken(response.getRefreshToken());
        org.junit.Assert.assertEquals((long)200L, (long)response.getStatusCode());
        org.junit.Assert.assertEquals((Object)sessionId, (Object)refreshedToken.getSessionState());
        org.junit.Assert.assertEquals((Object)sessionId, (Object)refreshedRefreshToken.getSessionState());
        org.junit.Assert.assertNotEquals((Object)token.getId(), (Object)refreshedToken.getId());
        org.junit.Assert.assertNotEquals((Object)refreshToken.getId(), (Object)refreshedRefreshToken.getId());
        org.junit.Assert.assertEquals((Object)"Bearer", (Object)response.getTokenType());
        org.junit.Assert.assertEquals((Object)ApiUtil.findUserByUsername((RealmResource)this.adminClient.realm("test"), (String)"test-user@localhost").getId(), (Object)refreshedToken.getSubject());
        org.junit.Assert.assertNotEquals((Object)"test-user@localhost", (Object)refreshedToken.getSubject());
        EventRepresentation refreshEvent = this.events.expectRefresh((String)tokenEvent.getDetails().get("refresh_token_id"), sessionId).assertEvent();
        org.junit.Assert.assertNotEquals(tokenEvent.getDetails().get("token_id"), refreshEvent.getDetails().get("token_id"));
        org.junit.Assert.assertNotEquals(tokenEvent.getDetails().get("refresh_token_id"), refreshEvent.getDetails().get("updated_refresh_token_id"));
        this.setTimeOffset(0);
    }

    private String loginAndForceNewLoginPage() {
        this.oauth.doLogin("test-user@localhost", "password");
        EventRepresentation loginEvent = this.events.expectLogin().assertEvent();
        String sessionId = loginEvent.getSessionId();
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doAccessTokenRequest(code, "password");
        this.events.poll();
        String refreshToken = tokenResponse.getRefreshToken();
        RefreshToken refreshTokenParsed1 = this.oauth.parseRefreshToken(tokenResponse.getRefreshToken());
        this.processExpectedValidRefresh(sessionId, refreshTokenParsed1, refreshToken);
        this.setTimeOffset(1);
        String loginFormUri = UriBuilder.fromUri((String)this.oauth.getLoginFormUrl()).queryParam("prompt", new Object[]{"login"}).build(new Object[0]).toString();
        this.driver.navigate().to(loginFormUri);
        this.loginPage.assertCurrent();
        return refreshToken;
    }
}

