/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.oauth;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.ws.rs.NotFoundException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.RoleResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.common.Profile;
import org.keycloak.jose.jws.JWSHeader;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.models.AdminRoles;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.RefreshToken;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ClientScopeRepresentation;
import org.keycloak.representations.idm.EventRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.arquillian.annotation.DisableFeature;
import org.keycloak.testsuite.pages.AccountApplicationsPage;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.runonserver.FetchOnServer;
import org.keycloak.testsuite.util.ClientBuilder;
import org.keycloak.testsuite.util.ClientManager;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.RealmBuilder;
import org.keycloak.testsuite.util.RealmManager;
import org.keycloak.testsuite.util.RoleBuilder;
import org.keycloak.testsuite.util.ServerURLs;
import org.keycloak.testsuite.util.TokenSignatureUtil;
import org.keycloak.testsuite.util.UserBuilder;
import org.keycloak.testsuite.utils.tls.TLSUtils;

public class OfflineTokenTest
extends AbstractKeycloakTest {
    private static String userId;
    private static String offlineClientAppUri;
    private static String serviceAccountUserId;
    @Page
    protected LoginPage loginPage;
    @Page
    protected AccountApplicationsPage applicationsPage;
    @Rule
    public AssertEvents events = new AssertEvents(this);

    @Override
    public void beforeAbstractKeycloakTest() throws Exception {
        super.beforeAbstractKeycloakTest();
    }

    @Before
    public void clientConfiguration() {
        userId = ApiUtil.findUserByUsername((RealmResource)this.adminClient.realm("test"), (String)"test-user@localhost").getId();
        this.oauth.clientId("test-app");
    }

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation realmRepresentation = AbstractAdminTest.loadJson(this.getClass().getResourceAsStream("/testrealm.json"), RealmRepresentation.class);
        RealmBuilder realm = RealmBuilder.edit(realmRepresentation).accessTokenLifespan(10).ssoSessionIdleTimeout(30).testEventListener();
        offlineClientAppUri = OAuthClient.APP_ROOT + "/offline-client";
        ClientRepresentation app = ClientBuilder.create().clientId("offline-client").id(KeycloakModelUtils.generateId()).adminUrl(offlineClientAppUri).redirectUris(offlineClientAppUri).directAccessGrants().serviceAccountsEnabled(true).attribute("client_credentials.use_refresh_token", "true").secret("secret1").build();
        realm.client(app);
        serviceAccountUserId = KeycloakModelUtils.generateId();
        UserRepresentation serviceAccountUser = UserBuilder.create().id(serviceAccountUserId).addRoles("user", "offline_access").role("test-app", "customer-user").username("service-account-" + app.getClientId()).serviceAccountId(app.getClientId()).build();
        realm.user(serviceAccountUser);
        testRealms.add(realm.build());
    }

    @Test
    public void offlineTokenDisabledForClient() throws Exception {
        ClientScopeRepresentation offlineScope = this.adminClient.realm("test").clientScopes().findAll().stream().filter(clientScope -> "offline_access".equals(clientScope.getName())).findFirst().get();
        ClientManager.realm(this.adminClient.realm("test")).clientId("offline-client").fullScopeAllowed(false).removeClientScope(offlineScope.getId(), false);
        this.oauth.scope("offline_access");
        this.oauth.clientId("offline-client");
        this.oauth.redirectUri(offlineClientAppUri);
        this.oauth.openLoginForm();
        org.junit.Assert.assertTrue((boolean)this.driver.getCurrentUrl().contains("error_description=Invalid+scopes"));
        ClientManager.realm(this.adminClient.realm("test")).clientId("offline-client").fullScopeAllowed(true).addClientScope(offlineScope.getId(), false);
    }

    @Test
    public void offlineTokenUserNotAllowed() throws Exception {
        String userId = ApiUtil.findUserByUsername((RealmResource)this.adminClient.realm("test"), (String)"keycloak-user@localhost").getId();
        this.oauth.scope("offline_access");
        this.oauth.clientId("offline-client");
        this.oauth.redirectUri(offlineClientAppUri);
        this.oauth.doLogin("keycloak-user@localhost", "password");
        EventRepresentation loginEvent = this.events.expectLogin().client("offline-client").user(userId).detail("redirect_uri", offlineClientAppUri).assertEvent();
        String sessionId = loginEvent.getSessionId();
        String codeId = (String)loginEvent.getDetails().get("code_id");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doAccessTokenRequest(code, "secret1");
        org.junit.Assert.assertEquals((long)400L, (long)tokenResponse.getStatusCode());
        org.junit.Assert.assertEquals((Object)"not_allowed", (Object)tokenResponse.getError());
        this.events.expectCodeToToken(codeId, sessionId).client("offline-client").user(userId).error("not_allowed").clearDetails().assertEvent();
    }

    @Test
    public void offlineTokenBrowserFlow() throws Exception {
        this.oauth.scope("offline_access");
        this.oauth.clientId("offline-client");
        this.oauth.redirectUri(offlineClientAppUri);
        this.oauth.doLogin("test-user@localhost", "password");
        EventRepresentation loginEvent = this.events.expectLogin().client("offline-client").detail("redirect_uri", offlineClientAppUri).assertEvent();
        String sessionId = loginEvent.getSessionId();
        String codeId = (String)loginEvent.getDetails().get("code_id");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doAccessTokenRequest(code, "secret1");
        AccessToken token = this.oauth.verifyToken(tokenResponse.getAccessToken());
        String offlineTokenString = tokenResponse.getRefreshToken();
        RefreshToken offlineToken = this.oauth.parseRefreshToken(offlineTokenString);
        this.events.expectCodeToToken(codeId, sessionId).client("offline-client").detail("refresh_token_type", "Offline").assertEvent();
        org.junit.Assert.assertEquals((Object)"Offline", (Object)offlineToken.getType());
        org.junit.Assert.assertEquals((long)0L, (long)offlineToken.getExpiration());
        org.junit.Assert.assertTrue((boolean)tokenResponse.getScope().contains("offline_access"));
        String newRefreshTokenString = this.testRefreshWithOfflineToken(token, offlineToken, offlineTokenString, sessionId, userId);
        this.setTimeOffset(3000000);
        OAuthClient.AccessTokenResponse response = this.oauth.doRefreshTokenRequest(newRefreshTokenString, "secret1");
        RefreshToken newRefreshToken = this.oauth.parseRefreshToken(newRefreshTokenString);
        org.junit.Assert.assertEquals((long)400L, (long)response.getStatusCode());
        org.junit.Assert.assertEquals((Object)"invalid_grant", (Object)response.getError());
        this.events.expectRefresh(offlineToken.getId(), newRefreshToken.getSessionState()).client("offline-client").error("invalid_token").user(userId).clearDetails().assertEvent();
        this.setTimeOffset(0);
    }

    private String testRefreshWithOfflineToken(AccessToken oldToken, RefreshToken offlineToken, String offlineTokenString, String sessionId, String userId) {
        this.setTimeOffset(99999);
        org.junit.Assert.assertFalse((boolean)oldToken.isActive());
        org.junit.Assert.assertTrue((boolean)offlineToken.isActive());
        this.testingClient.testing().removeExpired("test");
        try {
            this.testingClient.testing().removeUserSession("test", sessionId);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        OAuthClient.AccessTokenResponse response = this.oauth.doRefreshTokenRequest(offlineTokenString, "secret1");
        AccessToken refreshedToken = this.oauth.verifyToken(response.getAccessToken());
        org.junit.Assert.assertEquals((long)200L, (long)response.getStatusCode());
        String newRefreshToken = response.getRefreshToken();
        org.junit.Assert.assertNotNull((Object)newRefreshToken);
        org.junit.Assert.assertNotEquals((Object)oldToken.getId(), (Object)refreshedToken.getId());
        org.junit.Assert.assertTrue((boolean)response.getScope().contains("offline_access"));
        org.junit.Assert.assertEquals((Object)userId, (Object)refreshedToken.getSubject());
        org.junit.Assert.assertTrue((boolean)refreshedToken.getRealmAccess().isUserInRole("user"));
        org.junit.Assert.assertTrue((boolean)refreshedToken.getRealmAccess().isUserInRole("offline_access"));
        org.junit.Assert.assertEquals((long)1L, (long)refreshedToken.getResourceAccess("test-app").getRoles().size());
        org.junit.Assert.assertTrue((boolean)refreshedToken.getResourceAccess("test-app").isUserInRole("customer-user"));
        EventRepresentation refreshEvent = this.events.expectRefresh(offlineToken.getId(), sessionId).client("offline-client").user(userId).removeDetail("updated_refresh_token_id").detail("refresh_token_type", "Offline").assertEvent();
        org.junit.Assert.assertNotEquals((Object)oldToken.getId(), refreshEvent.getDetails().get("token_id"));
        this.setTimeOffset(0);
        return newRefreshToken;
    }

    @Test
    public void offlineTokenDirectGrantFlow() throws Exception {
        this.oauth.scope("offline_access");
        this.oauth.clientId("offline-client");
        OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doGrantAccessTokenRequest("secret1", "test-user@localhost", "password");
        org.junit.Assert.assertNull((Object)tokenResponse.getErrorDescription());
        AccessToken token = this.oauth.verifyToken(tokenResponse.getAccessToken());
        String offlineTokenString = tokenResponse.getRefreshToken();
        RefreshToken offlineToken = this.oauth.parseRefreshToken(offlineTokenString);
        this.events.expectLogin().client("offline-client").user(userId).session(token.getSessionState()).detail("grant_type", "password").detail("token_id", token.getId()).detail("refresh_token_id", offlineToken.getId()).detail("refresh_token_type", "Offline").detail("username", "test-user@localhost").removeDetail("code_id").removeDetail("redirect_uri").removeDetail("consent").assertEvent();
        org.junit.Assert.assertEquals((Object)"Offline", (Object)offlineToken.getType());
        org.junit.Assert.assertEquals((long)0L, (long)offlineToken.getExpiration());
        this.testRefreshWithOfflineToken(token, offlineToken, offlineTokenString, token.getSessionState(), userId);
        this.testRefreshWithOfflineToken(token, offlineToken, offlineTokenString, token.getSessionState(), userId);
    }

    @Test
    public void offlineTokenDirectGrantFlowWithRefreshTokensRevoked() throws Exception {
        RealmManager.realm(this.adminClient.realm("test")).revokeRefreshToken(true);
        this.oauth.scope("offline_access");
        this.oauth.clientId("offline-client");
        OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doGrantAccessTokenRequest("secret1", "test-user@localhost", "password");
        AccessToken token = this.oauth.verifyToken(tokenResponse.getAccessToken());
        String offlineTokenString = tokenResponse.getRefreshToken();
        RefreshToken offlineToken = this.oauth.parseRefreshToken(offlineTokenString);
        this.events.expectLogin().client("offline-client").user(userId).session(token.getSessionState()).detail("grant_type", "password").detail("token_id", token.getId()).detail("refresh_token_id", offlineToken.getId()).detail("refresh_token_type", "Offline").detail("username", "test-user@localhost").removeDetail("code_id").removeDetail("redirect_uri").removeDetail("consent").assertEvent();
        org.junit.Assert.assertEquals((Object)"Offline", (Object)offlineToken.getType());
        org.junit.Assert.assertEquals((long)0L, (long)offlineToken.getExpiration());
        String offlineTokenString2 = this.testRefreshWithOfflineToken(token, offlineToken, offlineTokenString, token.getSessionState(), userId);
        RefreshToken offlineToken2 = this.oauth.parseRefreshToken(offlineTokenString2);
        OAuthClient.AccessTokenResponse response = this.oauth.doRefreshTokenRequest(offlineTokenString, "secret1");
        org.junit.Assert.assertEquals((long)400L, (long)response.getStatusCode());
        this.events.expectRefresh(offlineToken.getId(), token.getSessionState()).client("offline-client").error("invalid_token").user(userId).clearDetails().assertEvent();
        OAuthClient.AccessTokenResponse response2 = this.oauth.doRefreshTokenRequest(offlineTokenString2, "secret1");
        org.junit.Assert.assertEquals((long)400L, (long)response2.getStatusCode());
        this.events.expectRefresh(offlineToken2.getId(), offlineToken2.getSessionState()).client("offline-client").error("invalid_token").user(userId).clearDetails().assertEvent();
        RealmManager.realm(this.adminClient.realm("test")).revokeRefreshToken(false);
    }

    @Test
    public void offlineTokenServiceAccountFlow() throws Exception {
        this.oauth.scope("offline_access");
        this.oauth.clientId("offline-client");
        OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doClientCredentialsGrantAccessTokenRequest("secret1");
        AccessToken token = this.oauth.verifyToken(tokenResponse.getAccessToken());
        String offlineTokenString = tokenResponse.getRefreshToken();
        RefreshToken offlineToken = this.oauth.parseRefreshToken(offlineTokenString);
        this.events.expectClientLogin().client("offline-client").user(serviceAccountUserId).session(token.getSessionState()).detail("token_id", token.getId()).detail("refresh_token_id", offlineToken.getId()).detail("refresh_token_type", "Offline").detail("username", "service-account-offline-client").assertEvent();
        org.junit.Assert.assertEquals((Object)"Offline", (Object)offlineToken.getType());
        org.junit.Assert.assertEquals((long)0L, (long)offlineToken.getExpiration());
        this.testRefreshWithOfflineToken(token, offlineToken, offlineTokenString, token.getSessionState(), serviceAccountUserId);
        tokenResponse = this.oauth.doClientCredentialsGrantAccessTokenRequest("secret1");
        AccessToken token2 = this.oauth.verifyToken(tokenResponse.getAccessToken());
        String offlineTokenString2 = tokenResponse.getRefreshToken();
        RefreshToken offlineToken2 = this.oauth.parseRefreshToken(offlineTokenString2);
        this.events.expectClientLogin().client("offline-client").user(serviceAccountUserId).session(token2.getSessionState()).detail("token_id", token2.getId()).detail("refresh_token_id", offlineToken2.getId()).detail("refresh_token_type", "Offline").detail("username", "service-account-offline-client").assertEvent();
        this.testRefreshWithOfflineToken(token, offlineToken, offlineTokenString, token.getSessionState(), serviceAccountUserId);
        this.testRefreshWithOfflineToken(token2, offlineToken2, offlineTokenString2, token2.getSessionState(), serviceAccountUserId);
    }

    @Test
    public void offlineTokenAllowedWithCompositeRole() throws Exception {
        RealmResource appRealm = this.adminClient.realm("test");
        UserResource testUser = ApiUtil.findUserByUsernameId((RealmResource)appRealm, (String)"test-user@localhost");
        RoleRepresentation offlineAccess = ApiUtil.findRealmRoleByName((RealmResource)this.adminClient.realm("test"), (String)"offline_access").toRepresentation();
        appRealm.roles().create(RoleBuilder.create().name("composite").build());
        RoleResource roleResource = appRealm.roles().get("composite");
        roleResource.addComposites(Collections.singletonList(offlineAccess));
        testUser.roles().realmLevel().remove(Collections.singletonList(offlineAccess));
        testUser.roles().realmLevel().add(Collections.singletonList(roleResource.toRepresentation()));
        this.offlineTokenDirectGrantFlow();
        testUser.roles().realmLevel().remove(Collections.singletonList(appRealm.roles().get("composite").toRepresentation()));
        appRealm.roles().get("composite").remove();
        testUser.roles().realmLevel().add(Collections.singletonList(offlineAccess));
    }

    @Test
    public void offlineTokenAdminRESTAccess() throws Exception {
        RealmResource appRealm = this.adminClient.realm("test");
        ClientResource realmMgmt = ApiUtil.findClientByClientId((RealmResource)appRealm, (String)"realm-management");
        String realmMgmtUuid = realmMgmt.toRepresentation().getId();
        RoleRepresentation roleRep = realmMgmt.roles().get(AdminRoles.VIEW_REALM).toRepresentation();
        UserResource testUser = ApiUtil.findUserByUsernameId((RealmResource)appRealm, (String)"test-user@localhost");
        testUser.roles().clientLevel(realmMgmtUuid).add(Collections.singletonList(roleRep));
        this.oauth.scope("offline_access");
        this.oauth.clientId("offline-client");
        OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doGrantAccessTokenRequest("secret1", "test-user@localhost", "password");
        this.events.clear();
        this.setTimeOffset(86400);
        this.testingClient.testing().removeUserSessions(appRealm.toRepresentation().getId());
        tokenResponse = this.oauth.doRefreshTokenRequest(tokenResponse.getRefreshToken(), "secret1");
        try (Keycloak offlineTokenAdmin = Keycloak.getInstance((String)(ServerURLs.getAuthServerContextRoot() + "/auth"), (String)"master", (String)"admin-cli", (String)tokenResponse.getAccessToken(), (SSLContext)TLSUtils.initializeTLS());){
            RealmRepresentation testRealm = offlineTokenAdmin.realm("test").toRepresentation();
            org.junit.Assert.assertNotNull((Object)testRealm);
        }
    }

    @Test
    @DisableFeature(value=Profile.Feature.ACCOUNT2, skipRestart=true)
    public void offlineTokenRemoveClientWithTokens() throws Exception {
        RealmResource appRealm = this.adminClient.realm("test");
        ClientRepresentation clientRep = ClientBuilder.create().clientId("offline-client-2").id(KeycloakModelUtils.generateId()).directAccessGrants().secret("secret1").build();
        appRealm.clients().create(clientRep);
        this.oauth.scope("offline_access");
        this.oauth.clientId("offline-client-2");
        OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doGrantAccessTokenRequest("secret1", "test-user@localhost", "password");
        org.junit.Assert.assertNull((Object)tokenResponse.getErrorDescription());
        AccessToken token = this.oauth.verifyToken(tokenResponse.getAccessToken());
        String offlineTokenString = tokenResponse.getRefreshToken();
        RefreshToken offlineToken = this.oauth.parseRefreshToken(offlineTokenString);
        this.events.expectLogin().client("offline-client-2").user(userId).session(token.getSessionState()).detail("grant_type", "password").detail("token_id", token.getId()).detail("refresh_token_id", offlineToken.getId()).detail("refresh_token_type", "Offline").detail("username", "test-user@localhost").removeDetail("code_id").removeDetail("redirect_uri").removeDetail("consent").assertEvent();
        this.applicationsPage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.events.expectLogin().client("account").detail("redirect_uri", this.getAccountRedirectUrl() + "?path=applications").assertEvent();
        org.junit.Assert.assertTrue((boolean)this.applicationsPage.isCurrent());
        Map apps = this.applicationsPage.getApplications();
        org.junit.Assert.assertTrue((boolean)apps.containsKey("offline-client-2"));
        org.junit.Assert.assertEquals((Object)"Offline Token", ((AccountApplicationsPage.AppEntry)apps.get("offline-client-2")).getAdditionalGrants().get(0));
        ClientResource offlineTokenClient2 = ApiUtil.findClientByClientId((RealmResource)appRealm, (String)"offline-client-2");
        offlineTokenClient2.remove();
        this.applicationsPage.open();
        apps = this.applicationsPage.getApplications();
        org.junit.Assert.assertFalse((boolean)apps.containsKey("offline-client-2"));
        UserResource user = ApiUtil.findUserByUsernameId((RealmResource)appRealm, (String)"test-user@localhost");
        List consents = user.getConsents();
        for (Map consent : consents) {
            org.junit.Assert.assertNotEquals(consent.get("clientId"), (Object)"offline-client-2");
        }
    }

    @Test
    public void offlineTokenLogout() throws Exception {
        this.oauth.scope("offline_access");
        this.oauth.clientId("offline-client");
        OAuthClient.AccessTokenResponse response = this.oauth.doGrantAccessTokenRequest("secret1", "test-user@localhost", "password");
        org.junit.Assert.assertEquals((long)200L, (long)response.getStatusCode());
        response = this.oauth.doRefreshTokenRequest(response.getRefreshToken(), "secret1");
        org.junit.Assert.assertEquals((long)200L, (long)response.getStatusCode());
        CloseableHttpResponse logoutResponse = this.oauth.doLogout(response.getRefreshToken(), "secret1");
        org.junit.Assert.assertEquals((long)204L, (long)logoutResponse.getStatusLine().getStatusCode());
        response = this.oauth.doRefreshTokenRequest(response.getRefreshToken(), "secret1");
        org.junit.Assert.assertEquals((long)400L, (long)response.getStatusCode());
    }

    @Test
    public void onlineOfflineTokenLogout() throws Exception {
        this.oauth.clientId("offline-client");
        OAuthClient.AccessTokenResponse response = this.oauth.doGrantAccessTokenRequest("secret1", "test-user@localhost", "password");
        org.junit.Assert.assertEquals((long)200L, (long)response.getStatusCode());
        response = this.oauth.doRefreshTokenRequest(response.getRefreshToken(), "secret1");
        org.junit.Assert.assertEquals((long)200L, (long)response.getStatusCode());
        this.oauth.scope("offline_access");
        OAuthClient.AccessTokenResponse offlineResponse = this.oauth.doGrantAccessTokenRequest("secret1", "test-user@localhost", "password");
        org.junit.Assert.assertEquals((long)200L, (long)offlineResponse.getStatusCode());
        OAuthClient.AccessTokenResponse offlineRefresh = this.oauth.doRefreshTokenRequest(offlineResponse.getRefreshToken(), "secret1");
        org.junit.Assert.assertEquals((long)200L, (long)offlineRefresh.getStatusCode());
        CloseableHttpResponse logoutResponse = this.oauth.scope("").doLogout(response.getRefreshToken(), "secret1");
        org.junit.Assert.assertEquals((long)204L, (long)logoutResponse.getStatusLine().getStatusCode());
        response = this.oauth.doRefreshTokenRequest(response.getRefreshToken(), "secret1");
        org.junit.Assert.assertEquals((long)400L, (long)response.getStatusCode());
        offlineRefresh = this.oauth.doRefreshTokenRequest(offlineResponse.getRefreshToken(), "secret1");
        org.junit.Assert.assertEquals((long)200L, (long)offlineRefresh.getStatusCode());
    }

    @Test
    public void browserOfflineTokenLogoutFollowedByLoginSameSession() throws Exception {
        this.oauth.scope("offline_access");
        this.oauth.clientId("offline-client");
        this.oauth.redirectUri(offlineClientAppUri);
        this.oauth.doLogin("test-user@localhost", "password");
        EventRepresentation loginEvent = this.events.expectLogin().client("offline-client").detail("redirect_uri", offlineClientAppUri).assertEvent();
        String sessionId = loginEvent.getSessionId();
        String codeId = (String)loginEvent.getDetails().get("code_id");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doAccessTokenRequest(code, "secret1");
        this.oauth.verifyToken(tokenResponse.getAccessToken());
        String offlineTokenString = tokenResponse.getRefreshToken();
        RefreshToken offlineToken = this.oauth.parseRefreshToken(offlineTokenString);
        this.events.expectCodeToToken(codeId, sessionId).client("offline-client").detail("refresh_token_type", "Offline").assertEvent();
        org.junit.Assert.assertEquals((Object)"Offline", (Object)offlineToken.getType());
        org.junit.Assert.assertEquals((long)0L, (long)offlineToken.getExpiration());
        String offlineUserSessionId = (String)this.testingClient.server().fetch((FetchOnServer & Serializable)session -> session.sessions().getOfflineUserSession(session.realms().getRealmByName("test"), offlineToken.getSessionState()).getId(), String.class);
        try (CloseableHttpResponse logoutResponse = this.oauth.doLogout(offlineTokenString, "secret1");){
            org.junit.Assert.assertEquals((long)204L, (long)logoutResponse.getStatusLine().getStatusCode());
        }
        this.events.expectLogout(offlineUserSessionId).client("offline-client").removeDetail("redirect_uri").assertEvent();
        this.oauth.doLogin("test-user@localhost", "password");
        String code2 = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse tokenResponse2 = this.oauth.doAccessTokenRequest(code2, "secret1");
        org.junit.Assert.assertEquals((long)200L, (long)tokenResponse2.getStatusCode());
        this.oauth.verifyToken(tokenResponse2.getAccessToken());
        String offlineTokenString2 = tokenResponse2.getRefreshToken();
        RefreshToken offlineToken2 = this.oauth.parseRefreshToken(offlineTokenString2);
        loginEvent = this.events.expectLogin().client("offline-client").detail("redirect_uri", offlineClientAppUri).assertEvent();
        codeId = (String)loginEvent.getDetails().get("code_id");
        this.events.expectCodeToToken(codeId, offlineToken2.getSessionState()).client("offline-client").detail("refresh_token_type", "Offline").assertEvent();
        org.junit.Assert.assertEquals((Object)"Offline", (Object)offlineToken2.getType());
        org.junit.Assert.assertEquals((long)0L, (long)offlineToken2.getExpiration());
        org.junit.Assert.assertNotEquals((Object)offlineToken.getSessionState(), (Object)offlineToken2.getSessionState());
    }

    private int[] changeOfflineSessionSettings(boolean isEnabled, int sessionMax, int sessionIdle) {
        int[] prev = new int[2];
        RealmRepresentation rep = this.adminClient.realm("test").toRepresentation();
        prev[0] = rep.getOfflineSessionMaxLifespan();
        prev[1] = rep.getOfflineSessionIdleTimeout();
        RealmBuilder realmBuilder = RealmBuilder.create();
        realmBuilder.offlineSessionMaxLifespanEnabled(isEnabled).offlineSessionMaxLifespan(sessionMax).offlineSessionIdleTimeout(sessionIdle);
        this.adminClient.realm("test").update(realmBuilder.build());
        return prev;
    }

    private int[] changeSessionSettings(int ssoSessionIdle, int accessTokenLifespan) {
        int[] prev = new int[2];
        RealmRepresentation rep = this.adminClient.realm("test").toRepresentation();
        prev[0] = rep.getOfflineSessionMaxLifespan();
        prev[1] = rep.getOfflineSessionIdleTimeout();
        RealmBuilder realmBuilder = RealmBuilder.create();
        realmBuilder.ssoSessionIdleTimeout(ssoSessionIdle).accessTokenLifespan(accessTokenLifespan);
        this.adminClient.realm("test").update(realmBuilder.build());
        return prev;
    }

    @Test
    public void offlineTokenBrowserFlowMaxLifespanExpired() throws Exception {
        int MAX_LIFESPAN = 3600;
        int IDLE_LIFESPAN = 6000;
        this.testOfflineSessionExpiration(6000, 3600, 3660);
    }

    @Test
    public void offlineTokenBrowserFlowIdleTimeExpired() throws Exception {
        int MAX_LIFESPAN = 3000;
        int IDLE_LIFESPAN = 600;
        this.testOfflineSessionExpiration(600, 3000, 780);
    }

    @Test
    public void offlineTokenRequest_ClientES256_RealmPS256() throws Exception {
        this.conductOfflineTokenRequest("HS256", "ES256", "PS256");
    }

    @Test
    public void offlineTokenRequest_ClientPS256_RealmES256() throws Exception {
        this.conductOfflineTokenRequest("HS256", "PS256", "ES256");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void conductOfflineTokenRequest(String expectedRefreshAlg, String expectedAccessAlg, String expectedIdTokenAlg) throws Exception {
        try {
            TokenSignatureUtil.changeRealmTokenSignatureProvider((Keycloak)this.adminClient, (String)expectedIdTokenAlg);
            TokenSignatureUtil.changeClientAccessTokenSignatureProvider((ClientResource)ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"offline-client"), (String)expectedAccessAlg);
            this.offlineTokenRequest(expectedRefreshAlg, expectedAccessAlg, expectedIdTokenAlg);
        }
        finally {
            TokenSignatureUtil.changeRealmTokenSignatureProvider((Keycloak)this.adminClient, (String)"RS256");
            TokenSignatureUtil.changeClientAccessTokenSignatureProvider((ClientResource)ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"offline-client"), (String)"RS256");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testOfflineSessionExpiration(int idleTime, int maxLifespan, int offset) {
        int[] prev = null;
        try {
            prev = this.changeOfflineSessionSettings(true, maxLifespan, idleTime);
            this.oauth.scope("offline_access");
            this.oauth.clientId("offline-client");
            this.oauth.redirectUri(offlineClientAppUri);
            this.oauth.doLogin("test-user@localhost", "password");
            EventRepresentation loginEvent = this.events.expectLogin().client("offline-client").detail("redirect_uri", offlineClientAppUri).assertEvent();
            String sessionId = loginEvent.getSessionId();
            String code = (String)this.oauth.getCurrentQuery().get("code");
            OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doAccessTokenRequest(code, "secret1");
            String offlineTokenString = tokenResponse.getRefreshToken();
            RefreshToken offlineToken = this.oauth.parseRefreshToken(offlineTokenString);
            org.junit.Assert.assertEquals((Object)"Offline", (Object)offlineToken.getType());
            tokenResponse = this.oauth.doRefreshTokenRequest(offlineTokenString, "secret1");
            AccessToken refreshedToken = this.oauth.verifyToken(tokenResponse.getAccessToken());
            offlineTokenString = tokenResponse.getRefreshToken();
            offlineToken = this.oauth.parseRefreshToken(offlineTokenString);
            org.junit.Assert.assertEquals((long)200L, (long)tokenResponse.getStatusCode());
            this.setTimeOffset(offset);
            tokenResponse = this.oauth.doRefreshTokenRequest(offlineTokenString, "secret1");
            org.junit.Assert.assertEquals((long)400L, (long)tokenResponse.getStatusCode());
            org.junit.Assert.assertEquals((Object)"invalid_grant", (Object)tokenResponse.getError());
            this.testingClient.testing().removeExpired("test");
            try {
                this.testingClient.testing().removeUserSession("test", sessionId);
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
            this.setTimeOffset(0);
        }
        finally {
            this.changeOfflineSessionSettings(false, prev[0], prev[1]);
        }
    }

    private void offlineTokenRequest(String expectedRefreshAlg, String expectedAccessAlg, String expectedIdTokenAlg) throws Exception {
        this.oauth.scope("offline_access");
        this.oauth.clientId("offline-client");
        OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doClientCredentialsGrantAccessTokenRequest("secret1");
        JWSHeader header = null;
        String idToken = tokenResponse.getIdToken();
        String accessToken = tokenResponse.getAccessToken();
        String refreshToken = tokenResponse.getRefreshToken();
        if (idToken != null) {
            header = new JWSInput(idToken).getHeader();
            org.junit.Assert.assertEquals((Object)expectedIdTokenAlg, (Object)header.getAlgorithm().name());
            org.junit.Assert.assertEquals((Object)"JWT", (Object)header.getType());
            org.junit.Assert.assertNull((Object)header.getContentType());
        }
        if (accessToken != null) {
            header = new JWSInput(accessToken).getHeader();
            org.junit.Assert.assertEquals((Object)expectedAccessAlg, (Object)header.getAlgorithm().name());
            org.junit.Assert.assertEquals((Object)"JWT", (Object)header.getType());
            org.junit.Assert.assertNull((Object)header.getContentType());
        }
        if (refreshToken != null) {
            header = new JWSInput(refreshToken).getHeader();
            org.junit.Assert.assertEquals((Object)expectedRefreshAlg, (Object)header.getAlgorithm().name());
            org.junit.Assert.assertEquals((Object)"JWT", (Object)header.getType());
            org.junit.Assert.assertNull((Object)header.getContentType());
        }
        AccessToken token = this.oauth.verifyToken(tokenResponse.getAccessToken());
        String offlineTokenString = tokenResponse.getRefreshToken();
        RefreshToken offlineToken = this.oauth.parseRefreshToken(offlineTokenString);
        this.events.expectClientLogin().client("offline-client").user(serviceAccountUserId).session(token.getSessionState()).detail("token_id", token.getId()).detail("refresh_token_id", offlineToken.getId()).detail("refresh_token_type", "Offline").detail("username", "service-account-offline-client").assertEvent();
        org.junit.Assert.assertEquals((Object)"Offline", (Object)offlineToken.getType());
        org.junit.Assert.assertEquals((long)0L, (long)offlineToken.getExpiration());
        this.testRefreshWithOfflineToken(token, offlineToken, offlineTokenString, token.getSessionState(), serviceAccountUserId);
        tokenResponse = this.oauth.doClientCredentialsGrantAccessTokenRequest("secret1");
        AccessToken token2 = this.oauth.verifyToken(tokenResponse.getAccessToken());
        String offlineTokenString2 = tokenResponse.getRefreshToken();
        RefreshToken offlineToken2 = this.oauth.parseRefreshToken(offlineTokenString2);
        this.events.expectClientLogin().client("offline-client").user(serviceAccountUserId).session(token2.getSessionState()).detail("token_id", token2.getId()).detail("refresh_token_id", offlineToken2.getId()).detail("refresh_token_type", "Offline").detail("username", "service-account-offline-client").assertEvent();
        this.testRefreshWithOfflineToken(token, offlineToken, offlineTokenString, token.getSessionState(), serviceAccountUserId);
        this.testRefreshWithOfflineToken(token2, offlineToken2, offlineTokenString2, token2.getSessionState(), serviceAccountUserId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testShortOfflineSessionMax() throws Exception {
        int[] prevOfflineSession = null;
        int[] prevSession = null;
        try {
            prevOfflineSession = this.changeOfflineSessionSettings(true, 60, 30);
            prevSession = this.changeSessionSettings(1800, 300);
            this.oauth.scope("offline_access");
            this.oauth.clientId("offline-client");
            this.oauth.redirectUri(offlineClientAppUri);
            this.oauth.doLogin("test-user@localhost", "password");
            this.events.expectLogin().client("offline-client").detail("redirect_uri", offlineClientAppUri).assertEvent();
            String code = (String)this.oauth.getCurrentQuery().get("code");
            OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doAccessTokenRequest(code, "secret1");
            String offlineTokenString = tokenResponse.getRefreshToken();
            RefreshToken offlineToken = this.oauth.parseRefreshToken(offlineTokenString);
            org.junit.Assert.assertThat((Object)tokenResponse.getExpiresIn(), (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(59)), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(60))));
            org.junit.Assert.assertThat((Object)tokenResponse.getRefreshExpiresIn(), (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(29)), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(30))));
            org.junit.Assert.assertEquals((Object)"Offline", (Object)offlineToken.getType());
            String introspectionResponse = this.oauth.introspectAccessTokenWithClientCredential("test-app", "password", tokenResponse.getAccessToken());
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode jsonNode = objectMapper.readTree(introspectionResponse);
            org.junit.Assert.assertEquals((Object)true, (Object)jsonNode.get("active").asBoolean());
            org.junit.Assert.assertEquals((Object)"test-user@localhost", (Object)jsonNode.get("email").asText());
            org.junit.Assert.assertThat((Object)(jsonNode.get("exp").asInt() - this.getCurrentTime()), (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(59)), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(60))));
        }
        finally {
            this.changeOfflineSessionSettings(false, prevOfflineSession[0], prevOfflineSession[1]);
            this.changeSessionSettings(prevSession[0], prevSession[1]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClientOfflineSessionMaxLifespan() throws Exception {
        ClientResource client = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"offline-client");
        ClientRepresentation clientRepresentation = client.toRepresentation();
        RealmResource realm = this.adminClient.realm("test");
        RealmRepresentation rep = realm.toRepresentation();
        Boolean originalOfflineSessionMaxLifespanEnabled = rep.getOfflineSessionMaxLifespanEnabled();
        Integer originalOfflineSessionMaxLifespan = rep.getOfflineSessionMaxLifespan();
        int offlineSessionMaxLifespan = rep.getOfflineSessionIdleTimeout() - 100;
        Integer originalClientOfflineSessionMaxLifespan = rep.getClientOfflineSessionMaxLifespan();
        try {
            rep.setOfflineSessionMaxLifespanEnabled(Boolean.valueOf(true));
            rep.setOfflineSessionMaxLifespan(Integer.valueOf(offlineSessionMaxLifespan));
            realm.update(rep);
            this.oauth.scope("offline_access");
            this.oauth.clientId("offline-client");
            this.oauth.redirectUri(offlineClientAppUri);
            this.oauth.doLogin("test-user@localhost", "password");
            String code = (String)this.oauth.getCurrentQuery().get("code");
            OAuthClient.AccessTokenResponse response = this.oauth.doAccessTokenRequest(code, "secret1");
            org.junit.Assert.assertEquals((long)200L, (long)response.getStatusCode());
            Assert.assertExpiration(response.getRefreshExpiresIn(), offlineSessionMaxLifespan);
            rep.setClientOfflineSessionMaxLifespan(Integer.valueOf(offlineSessionMaxLifespan - 100));
            realm.update(rep);
            String refreshToken = response.getRefreshToken();
            response = this.oauth.doRefreshTokenRequest(refreshToken, "secret1");
            org.junit.Assert.assertEquals((long)200L, (long)response.getStatusCode());
            Assert.assertExpiration(response.getRefreshExpiresIn(), offlineSessionMaxLifespan - 100);
            clientRepresentation.getAttributes().put("client.offline.session.max.lifespan", Integer.toString(offlineSessionMaxLifespan - 200));
            client.update(clientRepresentation);
            refreshToken = response.getRefreshToken();
            response = this.oauth.doRefreshTokenRequest(refreshToken, "secret1");
            org.junit.Assert.assertEquals((long)200L, (long)response.getStatusCode());
            Assert.assertExpiration(response.getRefreshExpiresIn(), offlineSessionMaxLifespan - 200);
        }
        finally {
            rep.setOfflineSessionMaxLifespanEnabled(originalOfflineSessionMaxLifespanEnabled);
            rep.setOfflineSessionMaxLifespan(originalOfflineSessionMaxLifespan);
            rep.setClientOfflineSessionMaxLifespan(originalClientOfflineSessionMaxLifespan);
            realm.update(rep);
            clientRepresentation.getAttributes().put("client.offline.session.max.lifespan", null);
            client.update(clientRepresentation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClientOfflineSessionIdleTimeout() throws Exception {
        ClientResource client = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"offline-client");
        ClientRepresentation clientRepresentation = client.toRepresentation();
        RealmResource realm = this.adminClient.realm("test");
        RealmRepresentation rep = realm.toRepresentation();
        Boolean originalOfflineSessionMaxLifespanEnabled = rep.getOfflineSessionMaxLifespanEnabled();
        int offlineSessionIdleTimeout = rep.getOfflineSessionIdleTimeout();
        Integer originalClientOfflineSessionIdleTimeout = rep.getClientOfflineSessionIdleTimeout();
        try {
            rep.setOfflineSessionMaxLifespanEnabled(Boolean.valueOf(true));
            realm.update(rep);
            this.oauth.scope("offline_access");
            this.oauth.clientId("offline-client");
            this.oauth.redirectUri(offlineClientAppUri);
            this.oauth.doLogin("test-user@localhost", "password");
            String code = (String)this.oauth.getCurrentQuery().get("code");
            OAuthClient.AccessTokenResponse response = this.oauth.doAccessTokenRequest(code, "secret1");
            org.junit.Assert.assertEquals((long)200L, (long)response.getStatusCode());
            Assert.assertExpiration(response.getRefreshExpiresIn(), offlineSessionIdleTimeout);
            rep.setClientOfflineSessionIdleTimeout(Integer.valueOf(offlineSessionIdleTimeout - 100));
            realm.update(rep);
            String refreshToken = response.getRefreshToken();
            response = this.oauth.doRefreshTokenRequest(refreshToken, "secret1");
            org.junit.Assert.assertEquals((long)200L, (long)response.getStatusCode());
            Assert.assertExpiration(response.getRefreshExpiresIn(), offlineSessionIdleTimeout - 100);
            clientRepresentation.getAttributes().put("client.offline.session.idle.timeout", Integer.toString(offlineSessionIdleTimeout - 200));
            client.update(clientRepresentation);
            refreshToken = response.getRefreshToken();
            response = this.oauth.doRefreshTokenRequest(refreshToken, "secret1");
            org.junit.Assert.assertEquals((long)200L, (long)response.getStatusCode());
            Assert.assertExpiration(response.getRefreshExpiresIn(), offlineSessionIdleTimeout - 200);
        }
        finally {
            rep.setOfflineSessionMaxLifespanEnabled(originalOfflineSessionMaxLifespanEnabled);
            rep.setClientOfflineSessionIdleTimeout(originalClientOfflineSessionIdleTimeout);
            realm.update(rep);
            clientRepresentation.getAttributes().put("client.offline.session.idle.timeout", null);
            client.update(clientRepresentation);
        }
    }
}

