/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.oauth;

import java.net.URL;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.core.Response;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.ClientsResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.common.util.UriUtils;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ClientScopeRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.util.OAuthClient;

public class OAuthScopeInTokenResponseTest
extends AbstractKeycloakTest {
    @Override
    public void beforeAbstractKeycloakTest() throws Exception {
        super.beforeAbstractKeycloakTest();
    }

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation realm = AbstractAdminTest.loadJson(this.getClass().getResourceAsStream("/testrealm.json"), RealmRepresentation.class);
        testRealms.add(realm);
    }

    @Test
    public void specifyNoScopeTest() throws Exception {
        String loginUser = "john-doh@localhost";
        String loginPassword = "password";
        String clientSecret = "password";
        String expectedScope = "openid profile email";
        this.oauth.doLogin(loginUser, loginPassword);
        String code = (String)this.oauth.getCurrentQuery().get("code");
        this.expectSuccessfulResponseFromTokenEndpoint(code, expectedScope, clientSecret);
    }

    @Test
    public void specifyEmptyScopeTest() throws Exception {
        String loginUser = "john-doh@localhost";
        String loginPassword = "password";
        String clientSecret = "password";
        String requestedScope = "";
        String expectedScope = "openid profile email";
        this.oauth.scope(requestedScope);
        this.oauth.doLogin(loginUser, loginPassword);
        String code = (String)this.oauth.getCurrentQuery().get("code");
        this.expectSuccessfulResponseFromTokenEndpoint(code, expectedScope, clientSecret);
    }

    @Test
    public void failCodeNotExistingScope() throws Exception {
        String loginUser = "john-doh@localhost";
        String loginPassword = "password";
        String clientSecret = "password";
        ClientsResource clients = this.realmsResouce().realm("test").clients();
        ClientRepresentation clientRep = (ClientRepresentation)clients.findByClientId(this.oauth.getClientId()).get(0);
        ClientResource client = clients.get(clientRep.getId());
        List scopes = client.getDefaultClientScopes();
        for (ClientScopeRepresentation scope : scopes) {
            client.removeDefaultClientScope(scope.getId());
        }
        this.oauth.openid(false);
        this.oauth.scope("user openid phone");
        this.oauth.openLoginForm();
        MultivaluedHashMap queryParams = UriUtils.decodeQueryString((String)new URL(this.driver.getCurrentUrl()).getQuery());
        Assert.assertEquals((Object)"invalid_scope", (Object)queryParams.getFirst((Object)"error"));
        Assert.assertTrue((boolean)((String)queryParams.getFirst((Object)"error_description")).startsWith("Invalid scopes"));
        this.oauth.scope("user");
        this.oauth.openLoginForm();
        queryParams = UriUtils.decodeQueryString((String)new URL(this.driver.getCurrentUrl()).getQuery());
        Assert.assertEquals((Object)"invalid_scope", (Object)queryParams.getFirst((Object)"error"));
        Assert.assertTrue((boolean)((String)queryParams.getFirst((Object)"error_description")).startsWith("Invalid scopes"));
        this.oauth.scope("phone");
        this.oauth.doLogin(loginUser, loginPassword);
        String code = (String)this.oauth.getCurrentQuery().get("code");
        this.expectSuccessfulResponseFromTokenEndpoint(code, "phone", clientSecret);
        this.oauth.openLogout();
        this.oauth.scope(null);
        this.oauth.doLogin(loginUser, loginPassword);
        code = (String)this.oauth.getCurrentQuery().get("code");
        this.expectSuccessfulResponseFromTokenEndpoint(code, "", clientSecret);
        for (ClientScopeRepresentation scope : scopes) {
            client.addDefaultClientScope(scope.getId());
        }
    }

    @Test
    public void failTokenNotExistingScope() throws Exception {
        String loginUser = "john-doh@localhost";
        String loginPassword = "password";
        String clientSecret = "password";
        ClientsResource clients = this.realmsResouce().realm("test").clients();
        ClientRepresentation clientRep = (ClientRepresentation)clients.findByClientId(this.oauth.getClientId()).get(0);
        clientRep.setDirectAccessGrantsEnabled(Boolean.valueOf(true));
        ClientResource client = clients.get(clientRep.getId());
        client.update(clientRep);
        List scopes = client.getDefaultClientScopes();
        for (ClientScopeRepresentation scope : scopes) {
            client.removeDefaultClientScope(scope.getId());
        }
        this.oauth.openid(false);
        this.oauth.scope("user phone");
        OAuthClient.AccessTokenResponse response = this.oauth.doGrantAccessTokenRequest(clientSecret, loginUser, loginPassword);
        Assert.assertNotNull((Object)response.getError());
        Assert.assertEquals((Object)"invalid_scope", (Object)response.getError());
        this.oauth.scope("user");
        response = this.oauth.doGrantAccessTokenRequest(clientSecret, loginUser, loginPassword);
        Assert.assertNotNull((Object)response.getError());
        Assert.assertEquals((Object)"invalid_scope", (Object)response.getError());
        this.oauth.scope(null);
        response = this.oauth.doGrantAccessTokenRequest(clientSecret, loginUser, loginPassword);
        Assert.assertNotNull((Object)response.getAccessToken());
        for (ClientScopeRepresentation scope : scopes) {
            client.addDefaultClientScope(scope.getId());
        }
    }

    @Test
    public void specifyMultipleScopeTest() throws Exception {
        String loginUser = "rich.roles@redhat.com";
        String loginPassword = "password";
        String clientSecret = "password";
        String requestedScope = "address";
        String expectedScope = "openid profile email address";
        this.oauth.scope(requestedScope);
        this.oauth.doLogin(loginUser, loginPassword);
        String code = (String)this.oauth.getCurrentQuery().get("code");
        this.expectSuccessfulResponseFromTokenEndpoint(code, expectedScope, clientSecret);
    }

    @Test
    public void specifyMultipleExistingScopesTest() throws Exception {
        ClientScopeRepresentation userScope = new ClientScopeRepresentation();
        userScope.setName("user");
        userScope.setProtocol("openid-connect");
        Response response = this.realmsResouce().realm("test").clientScopes().create(userScope);
        String userScopeId = ApiUtil.getCreatedId((Response)response);
        this.getCleanup().addClientScopeId(userScopeId);
        ApiUtil.findClientResourceByClientId((RealmResource)this.realmsResouce().realm("test"), (String)"test-app").addOptionalClientScope(userScopeId);
        String loginUser = "john-doh@localhost";
        String loginPassword = "password";
        String clientSecret = "password";
        String requestedScope = "address phone";
        String expectedScope = "openid profile email address phone";
        this.oauth.scope(requestedScope);
        this.oauth.doLogin(loginUser, loginPassword);
        String code = (String)this.oauth.getCurrentQuery().get("code");
        this.expectSuccessfulResponseFromTokenEndpoint(code, expectedScope, clientSecret);
        requestedScope = "user address phone";
        expectedScope = "openid profile email user address phone";
        this.oauth.scope(requestedScope);
        this.oauth.doLogin(loginUser, loginPassword);
        code = (String)this.oauth.getCurrentQuery().get("code");
        this.expectSuccessfulResponseFromTokenEndpoint(code, expectedScope, clientSecret);
        ApiUtil.findClientResourceByClientId((RealmResource)this.realmsResouce().realm("test"), (String)"test-app").removeOptionalClientScope(userScopeId);
    }

    private void expectSuccessfulResponseFromTokenEndpoint(String code, String expectedScope, String clientSecret) throws Exception {
        OAuthClient.AccessTokenResponse response = this.oauth.doAccessTokenRequest(code, clientSecret);
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        this.log.info((Object)("expectedScopes = " + expectedScope));
        this.log.info((Object)("receivedScopes = " + response.getScope()));
        List<String> expectedScopes = Arrays.asList(expectedScope.split(" "));
        List<String> receivedScopes = Arrays.asList(response.getScope().split(" "));
        Assert.assertTrue((expectedScopes.containsAll(receivedScopes) && receivedScopes.containsAll(expectedScopes) ? 1 : 0) != 0);
        this.oauth.doLogout(response.getRefreshToken(), clientSecret);
    }
}

