/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.oauth;

import java.net.MalformedURLException;
import java.net.URL;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.AbstractTestRealmKeycloakTest;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.util.OAuthClient;

public class OAuthRedirectUriStateTest
extends AbstractTestRealmKeycloakTest {
    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
    }

    @Before
    public void clientConfiguration() {
        this.oauth.clientId("test-app");
        this.oauth.responseType("code");
        this.oauth.stateParamRandom();
    }

    void assertStateReflected(String state) {
        URL url;
        this.oauth.stateParamHardcoded(state);
        OAuthClient.AuthorizationEndpointResponse response = this.oauth.doLogin("test-user@localhost", "password");
        Assert.assertNotNull((Object)response.getCode());
        try {
            url = new URL(this.driver.getCurrentUrl());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        Assert.assertTrue((boolean)url.getQuery().contains("state=" + state));
    }

    @Test
    public void testSimpleStateParameter() {
        this.assertStateReflected("VeryLittleGravitasIndeed");
    }

    @Test
    public void testJsonStateParameter() {
        this.assertStateReflected("%7B%22csrf_token%22%3A%2B%22hlvZNIsWyqdkEhbjlQIia0ty2YY4TXat%22%2C%2B%22destination%22%3A%2B%22eyJhbGciOiJIUzI1NiJ9.Imh0dHA6Ly9sb2NhbGhvc3Q6NTAwMC9wcml2YXRlIg.T18WeIV29komDl8jav-3bSnUZDlMD8VOfIrd2ikP5zE%22%7D");
    }
}

