/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.oauth;

import java.security.MessageDigest;
import java.util.List;
import javax.ws.rs.core.UriBuilder;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.common.util.Base64Url;
import org.keycloak.jose.jws.JWSHeader;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.protocol.oidc.OIDCAdvancedConfigWrapper;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.RefreshToken;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.EventRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.util.ClientManager;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.UserBuilder;

public class OAuthProofKeyForCodeExchangeTest
extends AbstractKeycloakTest {
    @Rule
    public AssertEvents events = new AssertEvents(this);

    @Override
    public void beforeAbstractKeycloakTest() throws Exception {
        super.beforeAbstractKeycloakTest();
    }

    @Before
    public void clientConfiguration() {
        ClientManager.realm(this.adminClient.realm("test")).clientId("test-app").directAccessGrant(true);
        this.oauth.clientId("test-app");
    }

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation realm = AbstractAdminTest.loadJson(this.getClass().getResourceAsStream("/testrealm.json"), RealmRepresentation.class);
        UserBuilder user = UserBuilder.create().id(KeycloakModelUtils.generateId()).username("no-permissions").addRoles("user").password("password");
        realm.getUsers().add(user.build());
        testRealms.add(realm);
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void accessTokenRequestWithoutPKCE() throws Exception {
        this.oauth.doLogin("test-user@localhost", "password");
        EventRepresentation loginEvent = this.events.expectLogin().assertEvent();
        String sessionId = loginEvent.getSessionId();
        String codeId = (String)loginEvent.getDetails().get("code_id");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        this.expectSuccessfulResponseFromTokenEndpoint(codeId, sessionId, code);
    }

    @Test
    public void accessTokenRequestInPKCEValidS256CodeChallengeMethod() throws Exception {
        String codeVerifier = "1234567890123456789012345678901234567890123";
        String codeChallenge = this.generateS256CodeChallenge(codeVerifier);
        this.oauth.codeChallenge(codeChallenge);
        this.oauth.codeChallengeMethod("S256");
        this.oauth.doLogin("test-user@localhost", "password");
        EventRepresentation loginEvent = this.events.expectLogin().assertEvent();
        String sessionId = loginEvent.getSessionId();
        String codeId = (String)loginEvent.getDetails().get("code_id");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        this.oauth.codeVerifier(codeVerifier);
        this.expectSuccessfulResponseFromTokenEndpoint(codeId, sessionId, code);
    }

    @Test
    public void accessTokenRequestInPKCEUnmatchedCodeVerifierWithS256CodeChallengeMethod() throws Exception {
        String codeVerifier;
        String codeChallenge = codeVerifier = "1234567890123456789012345678901234567890123";
        this.oauth.codeChallenge(codeChallenge);
        this.oauth.codeChallengeMethod("S256");
        this.oauth.doLogin("test-user@localhost", "password");
        EventRepresentation loginEvent = this.events.expectLogin().assertEvent();
        String sessionId = loginEvent.getSessionId();
        String codeId = (String)loginEvent.getDetails().get("code_id");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        this.oauth.codeVerifier(codeVerifier);
        OAuthClient.AccessTokenResponse response = this.oauth.doAccessTokenRequest(code, "password");
        Assert.assertEquals((long)400L, (long)response.getStatusCode());
        Assert.assertEquals((Object)"invalid_grant", (Object)response.getError());
        Assert.assertEquals((Object)"PKCE verification failed", (Object)response.getErrorDescription());
        this.events.expectCodeToToken(codeId, sessionId).error("pkce_verification_failed").clearDetails().assertEvent();
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void accessTokenRequestInPKCEValidPlainCodeChallengeMethod() throws Exception {
        this.oauth.codeChallenge(".234567890-234567890~234567890_234567890123");
        this.oauth.codeChallengeMethod("plain");
        this.oauth.doLogin("test-user@localhost", "password");
        EventRepresentation loginEvent = this.events.expectLogin().assertEvent();
        String sessionId = loginEvent.getSessionId();
        String codeId = (String)loginEvent.getDetails().get("code_id");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        this.oauth.codeVerifier(".234567890-234567890~234567890_234567890123");
        this.expectSuccessfulResponseFromTokenEndpoint(codeId, sessionId, code);
    }

    @Test
    public void accessTokenRequestInPKCEUnmachedCodeVerifierWithPlainCodeChallengeMethod() throws Exception {
        this.oauth.codeChallenge("1234567890123456789012345678901234567890123");
        this.oauth.codeChallengeMethod("plain");
        this.oauth.doLogin("test-user@localhost", "password");
        EventRepresentation loginEvent = this.events.expectLogin().assertEvent();
        String sessionId = loginEvent.getSessionId();
        String codeId = (String)loginEvent.getDetails().get("code_id");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        this.oauth.codeVerifier("aZ_-.~1234567890123456789012345678901234567890123Za");
        OAuthClient.AccessTokenResponse response = this.oauth.doAccessTokenRequest(code, "password");
        Assert.assertEquals((long)400L, (long)response.getStatusCode());
        Assert.assertEquals((Object)"invalid_grant", (Object)response.getError());
        Assert.assertEquals((Object)"PKCE verification failed", (Object)response.getErrorDescription());
        this.events.expectCodeToToken(codeId, sessionId).error("pkce_verification_failed").clearDetails().assertEvent();
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void accessTokenRequestInPKCEValidDefaultCodeChallengeMethod() throws Exception {
        this.oauth.codeChallenge("1234567890123456789012345678901234567890123");
        this.oauth.doLogin("test-user@localhost", "password");
        EventRepresentation loginEvent = this.events.expectLogin().assertEvent();
        String sessionId = loginEvent.getSessionId();
        String codeId = (String)loginEvent.getDetails().get("code_id");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        this.oauth.codeVerifier("1234567890123456789012345678901234567890123");
        this.expectSuccessfulResponseFromTokenEndpoint(codeId, sessionId, code);
    }

    @Test
    public void accessTokenRequestInPKCEWithoutCodeChallengeWithValidCodeChallengeMethod() throws Exception {
        this.oauth.codeChallengeMethod("plain");
        UriBuilder b = UriBuilder.fromUri((String)this.oauth.getLoginFormUrl());
        this.driver.navigate().to(b.build(new Object[0]).toURL());
        OAuthClient.AuthorizationEndpointResponse errorResponse = new OAuthClient.AuthorizationEndpointResponse(this.oauth);
        Assert.assertTrue((boolean)errorResponse.isRedirected());
        Assert.assertEquals((Object)errorResponse.getError(), (Object)"invalid_request");
        Assert.assertEquals((Object)errorResponse.getErrorDescription(), (Object)"Missing parameter: code_challenge");
        this.events.expectLogin().error("invalid_request").user((String)null).session((String)null).clearDetails().assertEvent();
    }

    @Test
    public void accessTokenRequestInPKCEInvalidUnderCodeChallengeWithS256CodeChallengeMethod() throws Exception {
        this.oauth.codeChallengeMethod("S256");
        this.oauth.codeChallenge("ABCDEFGabcdefg1234567ABCDEFGabcdefg1234567");
        UriBuilder b = UriBuilder.fromUri((String)this.oauth.getLoginFormUrl());
        this.driver.navigate().to(b.build(new Object[0]).toURL());
        OAuthClient.AuthorizationEndpointResponse errorResponse = new OAuthClient.AuthorizationEndpointResponse(this.oauth);
        Assert.assertTrue((boolean)errorResponse.isRedirected());
        Assert.assertEquals((Object)errorResponse.getError(), (Object)"invalid_request");
        Assert.assertEquals((Object)errorResponse.getErrorDescription(), (Object)"Invalid parameter: code_challenge");
        this.events.expectLogin().error("invalid_request").user((String)null).session((String)null).clearDetails().assertEvent();
    }

    @Test
    public void accessTokenRequestInPKCEInvalidOverCodeChallengeWithPlainCodeChallengeMethod() throws Exception {
        this.oauth.codeChallengeMethod("plain");
        this.oauth.codeChallenge("3fRc92kac_keic8c7al-3ncbdoaie.DDeizlck3~3fRc92kac_keic8c7al-3ncbdoaie.DDeizlck3~3fRc92kac_keic8c7al-3ncbdoaie.DDeizlck3~123456789");
        UriBuilder b = UriBuilder.fromUri((String)this.oauth.getLoginFormUrl());
        this.driver.navigate().to(b.build(new Object[0]).toURL());
        OAuthClient.AuthorizationEndpointResponse errorResponse = new OAuthClient.AuthorizationEndpointResponse(this.oauth);
        Assert.assertTrue((boolean)errorResponse.isRedirected());
        Assert.assertEquals((Object)errorResponse.getError(), (Object)"invalid_request");
        Assert.assertEquals((Object)errorResponse.getErrorDescription(), (Object)"Invalid parameter: code_challenge");
        this.events.expectLogin().error("invalid_request").user((String)null).session((String)null).clearDetails().assertEvent();
    }

    @Test
    public void accessTokenRequestInPKCEInvalidUnderCodeVerifierWithS256CodeChallengeMethod() throws Exception {
        String codeVerifier = "ABCDEFGabcdefg1234567ABCDEFGabcdefg1234567";
        String codeChallenge = this.generateS256CodeChallenge(codeVerifier);
        this.oauth.codeChallenge(codeChallenge);
        this.oauth.codeChallengeMethod("S256");
        this.oauth.doLogin("test-user@localhost", "password");
        EventRepresentation loginEvent = this.events.expectLogin().assertEvent();
        String sessionId = loginEvent.getSessionId();
        String codeId = (String)loginEvent.getDetails().get("code_id");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        this.oauth.codeVerifier(codeVerifier);
        OAuthClient.AccessTokenResponse response = this.oauth.doAccessTokenRequest(code, "password");
        Assert.assertEquals((long)400L, (long)response.getStatusCode());
        Assert.assertEquals((Object)"invalid_grant", (Object)response.getError());
        Assert.assertEquals((Object)"PKCE invalid code verifier", (Object)response.getErrorDescription());
        this.events.expectCodeToToken(codeId, sessionId).error("invalid_code_verifier").clearDetails().assertEvent();
    }

    @Test
    public void accessTokenRequestInPKCEInvalidOverCodeVerifierWithS256CodeChallengeMethod() throws Exception {
        String codeVerifier = "3fRc92kac_keic8c7al-3ncbdoaie.DDeizlck3~3fRc92kac_keic8c7al-3ncbdoaie.DDeizlck3~3fRc92kac_keic8c7al-3ncbdoaie.DDeizlck3~123456789";
        String codeChallenge = this.generateS256CodeChallenge(codeVerifier);
        this.oauth.codeChallenge(codeChallenge);
        this.oauth.codeChallengeMethod("S256");
        this.oauth.doLogin("test-user@localhost", "password");
        EventRepresentation loginEvent = this.events.expectLogin().assertEvent();
        String sessionId = loginEvent.getSessionId();
        String codeId = (String)loginEvent.getDetails().get("code_id");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        this.oauth.codeVerifier(codeVerifier);
        OAuthClient.AccessTokenResponse response = this.oauth.doAccessTokenRequest(code, "password");
        Assert.assertEquals((long)400L, (long)response.getStatusCode());
        Assert.assertEquals((Object)"invalid_grant", (Object)response.getError());
        Assert.assertEquals((Object)"PKCE invalid code verifier", (Object)response.getErrorDescription());
        this.events.expectCodeToToken(codeId, sessionId).error("invalid_code_verifier").clearDetails().assertEvent();
    }

    @Test
    public void accessTokenRequestInPKCEWIthoutCodeVerifierWithS256CodeChallengeMethod() throws Exception {
        String codeVerifier;
        String codeChallenge = codeVerifier = "1234567890123456789012345678901234567890123";
        this.oauth.codeChallenge(codeChallenge);
        this.oauth.codeChallengeMethod("S256");
        this.oauth.doLogin("test-user@localhost", "password");
        EventRepresentation loginEvent = this.events.expectLogin().assertEvent();
        String sessionId = loginEvent.getSessionId();
        String codeId = (String)loginEvent.getDetails().get("code_id");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse response = this.oauth.doAccessTokenRequest(code, "password");
        Assert.assertEquals((long)400L, (long)response.getStatusCode());
        Assert.assertEquals((Object)"invalid_grant", (Object)response.getError());
        Assert.assertEquals((Object)"PKCE code verifier not specified", (Object)response.getErrorDescription());
        this.events.expectCodeToToken(codeId, sessionId).error("code_verifier_missing").clearDetails().assertEvent();
    }

    @Test
    public void accessTokenRequestInPKCEInvalidCodeChallengeWithS256CodeChallengeMethod() throws Exception {
        String codeVerifier;
        String codeChallenge = codeVerifier = "1234567890123456789=12345678901234567890123";
        this.oauth.codeChallenge(codeChallenge);
        this.oauth.codeChallengeMethod("S256");
        UriBuilder b = UriBuilder.fromUri((String)this.oauth.getLoginFormUrl());
        this.driver.navigate().to(b.build(new Object[0]).toURL());
        OAuthClient.AuthorizationEndpointResponse errorResponse = new OAuthClient.AuthorizationEndpointResponse(this.oauth);
        Assert.assertTrue((boolean)errorResponse.isRedirected());
        Assert.assertEquals((Object)errorResponse.getError(), (Object)"invalid_request");
        Assert.assertEquals((Object)errorResponse.getErrorDescription(), (Object)"Invalid parameter: code_challenge");
        this.events.expectLogin().error("invalid_request").user((String)null).session((String)null).clearDetails().assertEvent();
    }

    @Test
    public void accessTokenRequestInPKCEInvalidCodeVerifierWithS256CodeChallengeMethod() throws Exception {
        String codeVerifier = "123456789.123456789-123456789~1234$6789_123";
        String codeChallenge = this.generateS256CodeChallenge(codeVerifier);
        this.oauth.codeChallenge(codeChallenge);
        this.oauth.codeChallengeMethod("S256");
        this.oauth.doLogin("test-user@localhost", "password");
        EventRepresentation loginEvent = this.events.expectLogin().assertEvent();
        String sessionId = loginEvent.getSessionId();
        String codeId = (String)loginEvent.getDetails().get("code_id");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        this.oauth.codeVerifier(codeVerifier);
        OAuthClient.AccessTokenResponse response = this.oauth.doAccessTokenRequest(code, "password");
        Assert.assertEquals((long)400L, (long)response.getStatusCode());
        Assert.assertEquals((Object)"invalid_grant", (Object)response.getError());
        Assert.assertEquals((Object)"PKCE invalid code verifier", (Object)response.getErrorDescription());
        this.events.expectCodeToToken(codeId, sessionId).error("invalid_code_verifier").clearDetails().assertEvent();
    }

    private String generateS256CodeChallenge(String codeVerifier) throws Exception {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        md.update(codeVerifier.getBytes("ISO_8859_1"));
        byte[] digestBytes = md.digest();
        String codeChallenge = Base64Url.encode((byte[])digestBytes);
        return codeChallenge;
    }

    private void expectSuccessfulResponseFromTokenEndpoint(String codeId, String sessionId, String code) throws Exception {
        OAuthClient.AccessTokenResponse response = this.oauth.doAccessTokenRequest(code, "password");
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        Assert.assertThat((Object)response.getExpiresIn(), (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(250)), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(300))));
        Assert.assertThat((Object)response.getRefreshExpiresIn(), (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1750)), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(1800))));
        Assert.assertEquals((Object)"Bearer", (Object)response.getTokenType());
        String expectedKid = this.oauth.doCertsRequest("test").getKeys()[0].getKeyId();
        JWSHeader header = new JWSInput(response.getAccessToken()).getHeader();
        Assert.assertEquals((Object)"RS256", (Object)header.getAlgorithm().name());
        Assert.assertEquals((Object)"JWT", (Object)header.getType());
        Assert.assertEquals((Object)expectedKid, (Object)header.getKeyId());
        Assert.assertNull((Object)header.getContentType());
        header = new JWSInput(response.getIdToken()).getHeader();
        Assert.assertEquals((Object)"RS256", (Object)header.getAlgorithm().name());
        Assert.assertEquals((Object)"JWT", (Object)header.getType());
        Assert.assertEquals((Object)expectedKid, (Object)header.getKeyId());
        Assert.assertNull((Object)header.getContentType());
        header = new JWSInput(response.getRefreshToken()).getHeader();
        Assert.assertEquals((Object)"HS256", (Object)header.getAlgorithm().name());
        Assert.assertEquals((Object)"JWT", (Object)header.getType());
        Assert.assertNull((Object)header.getContentType());
        AccessToken token = this.oauth.verifyToken(response.getAccessToken());
        Assert.assertEquals((Object)ApiUtil.findUserByUsername((RealmResource)this.adminClient.realm("test"), (String)"test-user@localhost").getId(), (Object)token.getSubject());
        Assert.assertNotEquals((Object)"test-user@localhost", (Object)token.getSubject());
        Assert.assertEquals((Object)sessionId, (Object)token.getSessionState());
        Assert.assertEquals((long)2L, (long)token.getRealmAccess().getRoles().size());
        Assert.assertTrue((boolean)token.getRealmAccess().isUserInRole("user"));
        Assert.assertEquals((long)1L, (long)token.getResourceAccess(this.oauth.getClientId()).getRoles().size());
        Assert.assertTrue((boolean)token.getResourceAccess(this.oauth.getClientId()).isUserInRole("customer-user"));
        EventRepresentation event = this.events.expectCodeToToken(codeId, sessionId).assertEvent();
        Assert.assertEquals((Object)token.getId(), event.getDetails().get("token_id"));
        Assert.assertEquals((Object)this.oauth.parseRefreshToken(response.getRefreshToken()).getId(), event.getDetails().get("refresh_token_id"));
        Assert.assertEquals((Object)sessionId, (Object)token.getSessionState());
        String refreshTokenString = response.getRefreshToken();
        RefreshToken refreshToken = this.oauth.parseRefreshToken(refreshTokenString);
        Assert.assertNotNull((Object)refreshTokenString);
        Assert.assertThat((Object)(token.getExpiration() - this.getCurrentTime()), (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(200)), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(350))));
        int actual = refreshToken.getExpiration() - this.getCurrentTime();
        Assert.assertThat((Object)actual, (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1796)), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(1803))));
        Assert.assertEquals((Object)sessionId, (Object)refreshToken.getSessionState());
        this.setTimeOffset(2);
        OAuthClient.AccessTokenResponse refreshResponse = this.oauth.doRefreshTokenRequest(refreshTokenString, "password");
        AccessToken refreshedToken = this.oauth.verifyToken(refreshResponse.getAccessToken());
        RefreshToken refreshedRefreshToken = this.oauth.parseRefreshToken(refreshResponse.getRefreshToken());
        Assert.assertEquals((long)200L, (long)refreshResponse.getStatusCode());
        Assert.assertEquals((Object)sessionId, (Object)refreshedToken.getSessionState());
        Assert.assertEquals((Object)sessionId, (Object)refreshedRefreshToken.getSessionState());
        Assert.assertThat((Object)refreshResponse.getExpiresIn(), (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(250)), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(300))));
        Assert.assertThat((Object)(refreshedToken.getExpiration() - this.getCurrentTime()), (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(247)), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(303))));
        Assert.assertThat((Object)(refreshedToken.getExpiration() - token.getExpiration()), (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(10))));
        Assert.assertThat((Object)(refreshedRefreshToken.getExpiration() - refreshToken.getExpiration()), (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(10))));
        Assert.assertNotEquals((Object)token.getId(), (Object)refreshedToken.getId());
        Assert.assertNotEquals((Object)refreshToken.getId(), (Object)refreshedRefreshToken.getId());
        Assert.assertEquals((Object)"Bearer", (Object)refreshResponse.getTokenType());
        Assert.assertEquals((Object)ApiUtil.findUserByUsername((RealmResource)this.adminClient.realm("test"), (String)"test-user@localhost").getId(), (Object)refreshedToken.getSubject());
        Assert.assertNotEquals((Object)"test-user@localhost", (Object)refreshedToken.getSubject());
        Assert.assertEquals((long)2L, (long)refreshedToken.getRealmAccess().getRoles().size());
        Assert.assertTrue((boolean)refreshedToken.getRealmAccess().isUserInRole("user"));
        Assert.assertEquals((long)1L, (long)refreshedToken.getResourceAccess(this.oauth.getClientId()).getRoles().size());
        Assert.assertTrue((boolean)refreshedToken.getResourceAccess(this.oauth.getClientId()).isUserInRole("customer-user"));
        EventRepresentation refreshEvent = this.events.expectRefresh((String)event.getDetails().get("refresh_token_id"), sessionId).assertEvent();
        Assert.assertNotEquals(event.getDetails().get("token_id"), refreshEvent.getDetails().get("token_id"));
        Assert.assertNotEquals(event.getDetails().get("refresh_token_id"), refreshEvent.getDetails().get("updated_refresh_token_id"));
        this.setTimeOffset(0);
    }

    private void setPkceActivationSettings(String clientId, String codeChallengeMethodName) {
        ClientResource clientResource = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)clientId);
        ClientRepresentation clientRep = clientResource.toRepresentation();
        OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).setPkceCodeChallengeMethod(codeChallengeMethodName);
        clientResource.update(clientRep);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void accessTokenRequestValidS256CodeChallengeMethodPkceEnforced() throws Exception {
        try {
            this.setPkceActivationSettings("test-app", "S256");
            String codeVerifier = "1a345A7890123456r8901c3456789012b45K7890l23";
            String codeChallenge = this.generateS256CodeChallenge(codeVerifier);
            this.oauth.codeChallenge(codeChallenge);
            this.oauth.codeChallengeMethod("S256");
            this.oauth.doLogin("test-user@localhost", "password");
            EventRepresentation loginEvent = this.events.expectLogin().assertEvent();
            String sessionId = loginEvent.getSessionId();
            String codeId = (String)loginEvent.getDetails().get("code_id");
            String code = (String)this.oauth.getCurrentQuery().get("code");
            this.oauth.codeVerifier(codeVerifier);
            this.expectSuccessfulResponseFromTokenEndpoint(codeId, sessionId, code);
        }
        finally {
            this.setPkceActivationSettings("test-app", null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void accessTokenRequestValidPlainCodeChallengeMethodPkceEnforced() throws Exception {
        try {
            String codeVerifier;
            this.setPkceActivationSettings("test-app", "plain");
            String codeChallenge = codeVerifier = "12E45r78901d3456789G12y45G78901234B67v901u3";
            this.oauth.codeChallenge(codeChallenge);
            this.oauth.codeChallengeMethod("plain");
            this.oauth.doLogin("test-user@localhost", "password");
            EventRepresentation loginEvent = this.events.expectLogin().assertEvent();
            String sessionId = loginEvent.getSessionId();
            String codeId = (String)loginEvent.getDetails().get("code_id");
            String code = (String)this.oauth.getCurrentQuery().get("code");
            this.oauth.codeVerifier(codeVerifier);
            this.expectSuccessfulResponseFromTokenEndpoint(codeId, sessionId, code);
        }
        finally {
            this.setPkceActivationSettings("test-app", null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void accessTokenRequestCodeChallengeMethodMismatchPkceEnforced() throws Exception {
        try {
            this.setPkceActivationSettings("test-app", "S256");
            String codeVerifier = "12345678e01234567890g2345678h012a4567j90123";
            String codeChallenge = this.generateS256CodeChallenge(codeVerifier);
            this.oauth.codeChallenge(codeChallenge);
            this.oauth.codeChallengeMethod("plain");
            UriBuilder b = UriBuilder.fromUri((String)this.oauth.getLoginFormUrl());
            this.driver.navigate().to(b.build(new Object[0]).toURL());
            OAuthClient.AuthorizationEndpointResponse errorResponse = new OAuthClient.AuthorizationEndpointResponse(this.oauth);
            Assert.assertTrue((boolean)errorResponse.isRedirected());
            Assert.assertEquals((Object)errorResponse.getError(), (Object)"invalid_request");
            Assert.assertEquals((Object)errorResponse.getErrorDescription(), (Object)"Invalid parameter: code challenge method is not configured one");
            this.events.expectLogin().error("invalid_request").user((String)null).session((String)null).clearDetails().assertEvent();
        }
        finally {
            this.setPkceActivationSettings("test-app", null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void accessTokenRequestCodeChallengeMethodMissingPkceEnforced() throws Exception {
        try {
            this.setPkceActivationSettings("test-app", "S256");
            String codeVerifier = "1234567890123456789012345678901234567890123";
            String codeChallenge = this.generateS256CodeChallenge(codeVerifier);
            this.oauth.codeChallenge(codeChallenge);
            UriBuilder b = UriBuilder.fromUri((String)this.oauth.getLoginFormUrl());
            this.driver.navigate().to(b.build(new Object[0]).toURL());
            OAuthClient.AuthorizationEndpointResponse errorResponse = new OAuthClient.AuthorizationEndpointResponse(this.oauth);
            Assert.assertTrue((boolean)errorResponse.isRedirected());
            Assert.assertEquals((Object)errorResponse.getError(), (Object)"invalid_request");
            Assert.assertEquals((Object)errorResponse.getErrorDescription(), (Object)"Missing parameter: code_challenge_method");
            this.events.expectLogin().error("invalid_request").user((String)null).session((String)null).clearDetails().assertEvent();
        }
        finally {
            this.setPkceActivationSettings("test-app", null);
        }
    }

    @Test
    public void accessTokenRequestCodeChallengeMissingPkceEnforced() throws Exception {
        try {
            this.setPkceActivationSettings("test-app", "S256");
            this.oauth.codeChallengeMethod("S256");
            UriBuilder b = UriBuilder.fromUri((String)this.oauth.getLoginFormUrl());
            this.driver.navigate().to(b.build(new Object[0]).toURL());
            OAuthClient.AuthorizationEndpointResponse errorResponse = new OAuthClient.AuthorizationEndpointResponse(this.oauth);
            Assert.assertTrue((boolean)errorResponse.isRedirected());
            Assert.assertEquals((Object)errorResponse.getError(), (Object)"invalid_request");
            Assert.assertEquals((Object)errorResponse.getErrorDescription(), (Object)"Missing parameter: code_challenge");
            this.events.expectLogin().error("invalid_request").user((String)null).session((String)null).clearDetails().assertEvent();
        }
        finally {
            this.setPkceActivationSettings("test-app", null);
        }
    }

    @Test
    public void accessTokenRequestInvalidCodeChallengePkceEnforced() throws Exception {
        try {
            this.setPkceActivationSettings("test-app", "S256");
            this.oauth.codeChallenge("invalid");
            this.oauth.codeChallengeMethod("S256");
            UriBuilder b = UriBuilder.fromUri((String)this.oauth.getLoginFormUrl());
            this.driver.navigate().to(b.build(new Object[0]).toURL());
            OAuthClient.AuthorizationEndpointResponse errorResponse = new OAuthClient.AuthorizationEndpointResponse(this.oauth);
            Assert.assertTrue((boolean)errorResponse.isRedirected());
            Assert.assertEquals((Object)errorResponse.getError(), (Object)"invalid_request");
            Assert.assertEquals((Object)errorResponse.getErrorDescription(), (Object)"Invalid parameter: code_challenge");
            this.events.expectLogin().error("invalid_request").user((String)null).session((String)null).clearDetails().assertEvent();
        }
        finally {
            this.setPkceActivationSettings("test-app", null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void accessTokenRequestWithoutCodeVerifierPkceEnforced() throws Exception {
        try {
            this.setPkceActivationSettings("test-app", "S256");
            String codeVerifier = "1234567890123456789012345678901234567890123";
            String codeChallenge = this.generateS256CodeChallenge(codeVerifier);
            this.oauth.codeChallenge(codeChallenge);
            this.oauth.codeChallengeMethod("S256");
            this.oauth.doLogin("test-user@localhost", "password");
            EventRepresentation loginEvent = this.events.expectLogin().assertEvent();
            String sessionId = loginEvent.getSessionId();
            String codeId = (String)loginEvent.getDetails().get("code_id");
            String code = (String)this.oauth.getCurrentQuery().get("code");
            OAuthClient.AccessTokenResponse response = this.oauth.doAccessTokenRequest(code, "password");
            Assert.assertEquals((long)400L, (long)response.getStatusCode());
            Assert.assertEquals((Object)"invalid_grant", (Object)response.getError());
            Assert.assertEquals((Object)"PKCE code verifier not specified", (Object)response.getErrorDescription());
            this.events.expectCodeToToken(codeId, sessionId).error("code_verifier_missing").clearDetails().assertEvent();
        }
        finally {
            this.setPkceActivationSettings("test-app", null);
        }
    }
}

