/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.oauth;

import java.util.Arrays;
import java.util.Collections;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.EventRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.AbstractTestRealmKeycloakTest;
import org.keycloak.testsuite.ActionURIUtils;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.pages.AccountUpdateProfilePage;
import org.keycloak.testsuite.pages.AppPage;
import org.keycloak.testsuite.pages.ErrorPage;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.pages.OAuthGrantPage;
import org.keycloak.testsuite.util.ClientManager;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.ServerURLs;

public class OAuth2OnlyTest
extends AbstractTestRealmKeycloakTest {
    @Rule
    public AssertEvents events = new AssertEvents(this);
    @Page
    protected AppPage appPage;
    @Page
    protected LoginPage loginPage;
    @Page
    protected AccountUpdateProfilePage profilePage;
    @Page
    protected OAuthGrantPage grantPage;
    @Page
    protected ErrorPage errorPage;

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
        ClientRepresentation client = new ClientRepresentation();
        client.setClientId("more-uris-client");
        client.setEnabled(Boolean.valueOf(true));
        client.setRedirectUris(Arrays.asList("http://localhost:8180/auth/realms/master/app/auth", "http://localhost:8180/foo", "https://localhost:8543/auth/realms/master/app/auth", "https://localhost:8543/foo"));
        client.setBaseUrl("http://localhost:8180/auth/realms/master/app/auth");
        testRealm.getClients().add(client);
        ClientRepresentation testApp = testRealm.getClients().stream().filter(cl -> cl.getClientId().equals("test-app")).findFirst().get();
        testApp.setImplicitFlowEnabled(Boolean.valueOf(true));
        this.trimRedirectUris(testApp);
    }

    private final void trimRedirectUris(ClientRepresentation testApp) {
        String redirectUri = testApp.getRedirectUris().stream().filter(uri -> ServerURLs.AUTH_SERVER_SSL_REQUIRED ? uri.startsWith("https://") : uri.startsWith("http://")).findFirst().get();
        testApp.setRedirectUris(Collections.singletonList(redirectUri));
    }

    @Before
    public void clientConfiguration() {
        ClientManager.realm(this.adminClient.realm("test")).clientId("test-app").directAccessGrant(true);
        this.oauth.init(this.driver);
    }

    @Test
    public void testMissingIDToken() {
        String loginFormUrl = this.oauth.getLoginFormUrl();
        loginFormUrl = ActionURIUtils.removeQueryParamFromURI((String)loginFormUrl, (String)"scope");
        this.driver.navigate().to(loginFormUrl);
        this.oauth.fillLoginForm("test-user@localhost", "password");
        EventRepresentation loginEvent = this.events.expectLogin().assertEvent();
        String code = new OAuthClient.AuthorizationEndpointResponse(this.oauth).getCode();
        OAuthClient.AccessTokenResponse response = this.oauth.doAccessTokenRequest(code, "password");
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        Assert.assertNull((Object)response.getIdToken());
        Assert.assertNotNull((Object)response.getRefreshToken());
        AccessToken token = this.oauth.verifyToken(response.getAccessToken());
        Assert.assertEquals((Object)token.getSubject(), (Object)loginEvent.getUserId());
        response = this.oauth.doRefreshTokenRequest(response.getRefreshToken(), "password");
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        Assert.assertNull((Object)response.getIdToken());
        token = this.oauth.verifyToken(response.getAccessToken());
        Assert.assertEquals((Object)token.getSubject(), (Object)loginEvent.getUserId());
    }

    @Test
    public void testMissingScopeOpenidInResourceOwnerPasswordCredentialRequest() throws Exception {
        OAuthClient.AccessTokenResponse response = this.oauth.doGrantAccessTokenRequest("password", "test-user@localhost", "password");
        org.junit.Assert.assertEquals((long)200L, (long)response.getStatusCode());
        Assert.assertNull((Object)response.getIdToken());
        Assert.assertNotNull((Object)response.getRefreshToken());
        AccessToken accessToken = this.oauth.verifyToken(response.getAccessToken());
        Assert.assertEquals((Object)accessToken.getPreferredUsername(), (Object)"test-user@localhost");
    }

    @Test
    public void testMissingRedirectUri() throws Exception {
        String loginFormUrl = this.oauth.getLoginFormUrl();
        loginFormUrl = ActionURIUtils.removeQueryParamFromURI((String)loginFormUrl, (String)"scope");
        loginFormUrl = ActionURIUtils.removeQueryParamFromURI((String)loginFormUrl, (String)"redirect_uri");
        this.driver.navigate().to(loginFormUrl);
        this.loginPage.assertCurrent();
        this.oauth.fillLoginForm("test-user@localhost", "password");
        this.events.expectLogin().assertEvent();
        this.oauth.clientId("more-uris-client");
        loginFormUrl = this.oauth.getLoginFormUrl();
        loginFormUrl = ActionURIUtils.removeQueryParamFromURI((String)loginFormUrl, (String)"scope");
        loginFormUrl = ActionURIUtils.removeQueryParamFromURI((String)loginFormUrl, (String)"redirect_uri");
        this.driver.navigate().to(loginFormUrl);
        this.errorPage.assertCurrent();
        Assert.assertEquals((Object)"Invalid parameter: redirect_uri", (Object)this.errorPage.getError());
        this.events.expectLogin().error("invalid_redirect_uri").client("more-uris-client").user((Matcher<String>)Matchers.nullValue(String.class)).session((Matcher<String>)Matchers.nullValue(String.class)).removeDetail("redirect_uri").removeDetail("code_id").removeDetail("consent").assertEvent();
    }

    @Test
    public void testMissingNonceInOAuth2ImplicitFlow() throws Exception {
        this.oauth.responseType("token");
        this.oauth.nonce(null);
        String loginFormUrl = this.oauth.getLoginFormUrl();
        loginFormUrl = ActionURIUtils.removeQueryParamFromURI((String)loginFormUrl, (String)"scope");
        this.driver.navigate().to(loginFormUrl);
        this.loginPage.assertCurrent();
        this.oauth.fillLoginForm("test-user@localhost", "password");
        this.events.expectLogin().assertEvent();
        OAuthClient.AuthorizationEndpointResponse response = new OAuthClient.AuthorizationEndpointResponse(this.oauth);
        Assert.assertNull((Object)response.getError());
        Assert.assertNull((Object)response.getCode());
        Assert.assertNull((Object)response.getIdToken());
        Assert.assertNotNull((Object)response.getAccessToken());
    }
}

