/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.oauth;

import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.TokenVerifier;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.common.Profile;
import org.keycloak.credential.CredentialInput;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ImpersonationConstants;
import org.keycloak.models.ImpersonationSessionNote;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionNoteDescriptor;
import org.keycloak.protocol.oidc.mappers.UserSessionNoteMapper;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.authorization.AbstractPolicyRepresentation;
import org.keycloak.representations.idm.authorization.ClientPolicyRepresentation;
import org.keycloak.representations.idm.authorization.DecisionStrategy;
import org.keycloak.services.resources.admin.permissions.AdminPermissionManagement;
import org.keycloak.services.resources.admin.permissions.AdminPermissions;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.ProfileAssume;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.arquillian.annotation.DisableFeature;
import org.keycloak.testsuite.arquillian.annotation.EnableFeature;
import org.keycloak.testsuite.arquillian.annotation.UncaughtServerErrorExpected;
import org.keycloak.testsuite.util.AdminClientUtil;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.util.BasicAuthHelper;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
@EnableFeature(value=Profile.Feature.TOKEN_EXCHANGE, skipRestart=true)
public class ClientTokenExchangeTest
extends AbstractKeycloakTest {
    @Rule
    public AssertEvents events = new AssertEvents(this);

    @BeforeClass
    public static void enabled() {
        ProfileAssume.assumeFeatureEnabled((Profile.Feature)Profile.Feature.AUTHORIZATION);
    }

    @Test
    @UncaughtServerErrorExpected
    @DisableFeature(value=Profile.Feature.TOKEN_EXCHANGE, skipRestart=true)
    public void checkFeatureDisabled() {
        this.testingClient.server().run(ClientTokenExchangeTest::addDirectExchanger);
        Assert.assertEquals((long)501L, (long)this.checkTokenExchange().getStatus());
        this.testingClient.server().run(ClientTokenExchangeTest::removeDirectExchanger);
    }

    @Test
    public void checkFeatureEnabled() {
        this.testingClient.server().run(ClientTokenExchangeTest::addDirectExchanger);
        Assert.assertEquals((long)200L, (long)this.checkTokenExchange().getStatus());
        this.testingClient.server().run(ClientTokenExchangeTest::removeDirectExchanger);
    }

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation testRealmRep = new RealmRepresentation();
        testRealmRep.setId("test");
        testRealmRep.setRealm("test");
        testRealmRep.setEnabled(Boolean.valueOf(true));
        testRealms.add(testRealmRep);
    }

    public static void setupRealm(KeycloakSession session) {
        ClientTokenExchangeTest.addDirectExchanger(session);
        RealmModel realm = session.realms().getRealmByName("test");
        RoleModel exampleRole = realm.getRole("example");
        AdminPermissionManagement management = AdminPermissions.management((KeycloakSession)session, (RealmModel)realm);
        ClientModel target = realm.getClientByClientId("target");
        org.junit.Assert.assertNotNull((Object)target);
        RoleModel impersonateRole = management.getRealmManagementClient().getRole(ImpersonationConstants.IMPERSONATION_ROLE);
        ClientModel clientExchanger = realm.addClient("client-exchanger");
        clientExchanger.setClientId("client-exchanger");
        clientExchanger.setPublicClient(false);
        clientExchanger.setDirectAccessGrantsEnabled(true);
        clientExchanger.setEnabled(true);
        clientExchanger.setSecret("secret");
        clientExchanger.setProtocol("openid-connect");
        clientExchanger.setFullScopeAllowed(false);
        clientExchanger.addScopeMapping(impersonateRole);
        clientExchanger.addProtocolMapper(UserSessionNoteMapper.createUserSessionNoteMapper((UserSessionNoteDescriptor)ImpersonationSessionNote.IMPERSONATOR_ID));
        clientExchanger.addProtocolMapper(UserSessionNoteMapper.createUserSessionNoteMapper((UserSessionNoteDescriptor)ImpersonationSessionNote.IMPERSONATOR_USERNAME));
        ClientModel illegal = realm.addClient("illegal");
        illegal.setClientId("illegal");
        illegal.setPublicClient(false);
        illegal.setDirectAccessGrantsEnabled(true);
        illegal.setEnabled(true);
        illegal.setSecret("secret");
        illegal.setProtocol("openid-connect");
        illegal.setFullScopeAllowed(false);
        ClientModel legal = realm.addClient("legal");
        legal.setClientId("legal");
        legal.setPublicClient(false);
        legal.setDirectAccessGrantsEnabled(true);
        legal.setEnabled(true);
        legal.setSecret("secret");
        legal.setProtocol("openid-connect");
        legal.setFullScopeAllowed(false);
        ClientModel directLegal = realm.addClient("direct-legal");
        directLegal.setClientId("direct-legal");
        directLegal.setPublicClient(false);
        directLegal.setDirectAccessGrantsEnabled(true);
        directLegal.setEnabled(true);
        directLegal.setSecret("secret");
        directLegal.setProtocol("openid-connect");
        directLegal.setFullScopeAllowed(false);
        ClientModel directPublic = realm.addClient("direct-public");
        directPublic.setClientId("direct-public");
        directPublic.setPublicClient(true);
        directPublic.setDirectAccessGrantsEnabled(true);
        directPublic.setEnabled(true);
        directPublic.setProtocol("openid-connect");
        directPublic.setFullScopeAllowed(false);
        ClientModel directNoSecret = realm.addClient("direct-no-secret");
        directNoSecret.setClientId("direct-no-secret");
        directNoSecret.setPublicClient(false);
        directNoSecret.setDirectAccessGrantsEnabled(true);
        directNoSecret.setEnabled(true);
        directNoSecret.setProtocol("openid-connect");
        directNoSecret.setFullScopeAllowed(false);
        ClientModel noRefreshToken = realm.addClient("no-refresh-token");
        noRefreshToken.setClientId("no-refresh-token");
        noRefreshToken.setPublicClient(false);
        noRefreshToken.setDirectAccessGrantsEnabled(true);
        noRefreshToken.setEnabled(true);
        noRefreshToken.setSecret("secret");
        noRefreshToken.setProtocol("openid-connect");
        noRefreshToken.setFullScopeAllowed(false);
        noRefreshToken.getAttributes().put("use.refresh.tokens", "false");
        ClientPolicyRepresentation clientRep = new ClientPolicyRepresentation();
        clientRep.setName("to");
        clientRep.addClient(new String[]{clientExchanger.getId()});
        clientRep.addClient(new String[]{legal.getId()});
        clientRep.addClient(new String[]{directLegal.getId()});
        clientRep.addClient(new String[]{noRefreshToken.getId()});
        ResourceServer server = management.realmResourceServer();
        Policy clientPolicy = management.authz().getStoreFactory().getPolicyStore().create((AbstractPolicyRepresentation)clientRep, server);
        management.clients().exchangeToPermission(target).addAssociatedPolicy(clientPolicy);
        ClientPolicyRepresentation clientImpersonateRep = new ClientPolicyRepresentation();
        clientImpersonateRep.setName("clientImpersonators");
        clientImpersonateRep.addClient(new String[]{directLegal.getId()});
        clientImpersonateRep.addClient(new String[]{directPublic.getId()});
        clientImpersonateRep.addClient(new String[]{directNoSecret.getId()});
        server = management.realmResourceServer();
        Policy clientImpersonatePolicy = management.authz().getStoreFactory().getPolicyStore().create((AbstractPolicyRepresentation)clientImpersonateRep, server);
        management.users().setPermissionsEnabled(true);
        management.users().adminImpersonatingPermission().addAssociatedPolicy(clientImpersonatePolicy);
        management.users().adminImpersonatingPermission().setDecisionStrategy(DecisionStrategy.AFFIRMATIVE);
        UserModel user = session.users().addUser(realm, "user");
        user.setEnabled(true);
        session.userCredentialManager().updateCredential(realm, user, (CredentialInput)UserCredentialModel.password((String)"password"));
        user.grantRole(exampleRole);
        user.grantRole(impersonateRole);
        UserModel bad = session.users().addUser(realm, "bad-impersonator");
        bad.setEnabled(true);
        session.userCredentialManager().updateCredential(realm, bad, (CredentialInput)UserCredentialModel.password((String)"password"));
    }

    @Override
    protected boolean isImportAfterEachMethod() {
        return true;
    }

    @Test
    @UncaughtServerErrorExpected
    public void testExchange() throws Exception {
        this.testingClient.server().run(ClientTokenExchangeTest::setupRealm);
        this.oauth.realm("test");
        this.oauth.clientId("client-exchanger");
        OAuthClient.AccessTokenResponse response = this.oauth.doGrantAccessTokenRequest("secret", "user", "password");
        String accessToken = response.getAccessToken();
        TokenVerifier accessTokenVerifier = TokenVerifier.create((String)accessToken, AccessToken.class);
        AccessToken token = (AccessToken)accessTokenVerifier.parse().getToken();
        Assert.assertEquals((Object)token.getPreferredUsername(), (Object)"user");
        Assert.assertTrue((token.getRealmAccess() == null || !token.getRealmAccess().isUserInRole("example") ? 1 : 0) != 0);
        response = this.oauth.doTokenExchange("test", accessToken, "target", "client-exchanger", "secret");
        String exchangedTokenString = response.getAccessToken();
        TokenVerifier verifier = TokenVerifier.create((String)exchangedTokenString, AccessToken.class);
        AccessToken exchangedToken = (AccessToken)verifier.parse().getToken();
        Assert.assertEquals((Object)"client-exchanger", (Object)exchangedToken.getIssuedFor());
        Assert.assertEquals((Object)"target", (Object)exchangedToken.getAudience()[0]);
        Assert.assertEquals((Object)exchangedToken.getPreferredUsername(), (Object)"user");
        Assert.assertTrue((boolean)exchangedToken.getRealmAccess().isUserInRole("example"));
        response = this.oauth.doTokenExchange("test", accessToken, "target", "legal", "secret");
        exchangedTokenString = response.getAccessToken();
        verifier = TokenVerifier.create((String)exchangedTokenString, AccessToken.class);
        exchangedToken = (AccessToken)verifier.parse().getToken();
        Assert.assertEquals((Object)"legal", (Object)exchangedToken.getIssuedFor());
        Assert.assertEquals((Object)"target", (Object)exchangedToken.getAudience()[0]);
        Assert.assertEquals((Object)exchangedToken.getPreferredUsername(), (Object)"user");
        Assert.assertTrue((boolean)exchangedToken.getRealmAccess().isUserInRole("example"));
        response = this.oauth.doTokenExchange("test", accessToken, "target", "illegal", "secret");
        Assert.assertEquals((long)403L, (long)response.getStatusCode());
    }

    @Test
    @UncaughtServerErrorExpected
    public void testImpersonation() throws Exception {
        this.testingClient.server().run(ClientTokenExchangeTest::setupRealm);
        this.oauth.realm("test");
        this.oauth.clientId("client-exchanger");
        ResteasyClient httpClient = AdminClientUtil.createResteasyClient();
        WebTarget exchangeUrl = httpClient.target(OAuthClient.AUTH_SERVER_ROOT).path("/realms").path("test").path("protocol/openid-connect/token");
        System.out.println("Exchange url: " + exchangeUrl.getUri().toString());
        OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doGrantAccessTokenRequest("secret", "user", "password");
        String accessToken = tokenResponse.getAccessToken();
        TokenVerifier accessTokenVerifier = TokenVerifier.create((String)accessToken, AccessToken.class);
        AccessToken token = (AccessToken)accessTokenVerifier.parse().getToken();
        Assert.assertEquals((Object)token.getPreferredUsername(), (Object)"user");
        Assert.assertTrue((token.getRealmAccess() == null || !token.getRealmAccess().isUserInRole("example") ? 1 : 0) != 0);
        Response response = exchangeUrl.request().header("Authorization", (Object)BasicAuthHelper.createHeader((String)"client-exchanger", (String)"secret")).post(Entity.form((Form)new Form().param("grant_type", "urn:ietf:params:oauth:grant-type:token-exchange").param("subject_token", accessToken).param("subject_token_type", "urn:ietf:params:oauth:token-type:access_token").param("requested_subject", "impersonated-user")));
        org.junit.Assert.assertEquals((long)200L, (long)response.getStatus());
        AccessTokenResponse accessTokenResponse = (AccessTokenResponse)response.readEntity(AccessTokenResponse.class);
        response.close();
        String exchangedTokenString = accessTokenResponse.getToken();
        TokenVerifier verifier = TokenVerifier.create((String)exchangedTokenString, AccessToken.class);
        AccessToken exchangedToken = (AccessToken)verifier.parse().getToken();
        Assert.assertEquals((Object)"client-exchanger", (Object)exchangedToken.getIssuedFor());
        Assert.assertNull((Object)exchangedToken.getAudience());
        Assert.assertEquals((Object)"impersonated-user", (Object)exchangedToken.getPreferredUsername());
        Assert.assertNull((Object)exchangedToken.getRealmAccess());
        Object impersonatorRaw = exchangedToken.getOtherClaims().get("impersonator");
        Assert.assertThat(impersonatorRaw, (Matcher)Matchers.instanceOf(Map.class));
        Map impersonatorClaim = (Map)impersonatorRaw;
        Assert.assertEquals((Object)token.getSubject(), impersonatorClaim.get("id"));
        Assert.assertEquals((Object)"user", impersonatorClaim.get("username"));
        response = exchangeUrl.request().header("Authorization", (Object)BasicAuthHelper.createHeader((String)"client-exchanger", (String)"secret")).post(Entity.form((Form)new Form().param("grant_type", "urn:ietf:params:oauth:grant-type:token-exchange").param("subject_token", accessToken).param("subject_token_type", "urn:ietf:params:oauth:token-type:access_token").param("requested_subject", "impersonated-user").param("audience", "target")));
        org.junit.Assert.assertEquals((long)200L, (long)response.getStatus());
        accessTokenResponse = (AccessTokenResponse)response.readEntity(AccessTokenResponse.class);
        response.close();
        exchangedTokenString = accessTokenResponse.getToken();
        verifier = TokenVerifier.create((String)exchangedTokenString, AccessToken.class);
        exchangedToken = (AccessToken)verifier.parse().getToken();
        Assert.assertEquals((Object)"client-exchanger", (Object)exchangedToken.getIssuedFor());
        Assert.assertEquals((Object)"target", (Object)exchangedToken.getAudience()[0]);
        Assert.assertEquals((Object)exchangedToken.getPreferredUsername(), (Object)"impersonated-user");
        Assert.assertTrue((boolean)exchangedToken.getRealmAccess().isUserInRole("example"));
    }

    @Test
    @UncaughtServerErrorExpected
    public void testBadImpersonator() throws Exception {
        this.testingClient.server().run(ClientTokenExchangeTest::setupRealm);
        this.oauth.realm("test");
        this.oauth.clientId("client-exchanger");
        ResteasyClient httpClient = AdminClientUtil.createResteasyClient();
        WebTarget exchangeUrl = httpClient.target(OAuthClient.AUTH_SERVER_ROOT).path("/realms").path("test").path("protocol/openid-connect/token");
        System.out.println("Exchange url: " + exchangeUrl.getUri().toString());
        OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doGrantAccessTokenRequest("secret", "bad-impersonator", "password");
        String accessToken = tokenResponse.getAccessToken();
        TokenVerifier accessTokenVerifier = TokenVerifier.create((String)accessToken, AccessToken.class);
        AccessToken token = (AccessToken)accessTokenVerifier.parse().getToken();
        Assert.assertEquals((Object)token.getPreferredUsername(), (Object)"bad-impersonator");
        Assert.assertTrue((token.getRealmAccess() == null || !token.getRealmAccess().isUserInRole("example") ? 1 : 0) != 0);
        Response response = exchangeUrl.request().header("Authorization", (Object)BasicAuthHelper.createHeader((String)"client-exchanger", (String)"secret")).post(Entity.form((Form)new Form().param("grant_type", "urn:ietf:params:oauth:grant-type:token-exchange").param("subject_token", accessToken).param("subject_token_type", "urn:ietf:params:oauth:token-type:access_token").param("requested_subject", "impersonated-user")));
        org.junit.Assert.assertEquals((long)403L, (long)response.getStatus());
        response.close();
    }

    @Test
    @UncaughtServerErrorExpected
    public void testDirectImpersonation() throws Exception {
        this.testingClient.server().run(ClientTokenExchangeTest::setupRealm);
        ResteasyClient httpClient = AdminClientUtil.createResteasyClient();
        WebTarget exchangeUrl = httpClient.target(OAuthClient.AUTH_SERVER_ROOT).path("/realms").path("test").path("protocol/openid-connect/token");
        System.out.println("Exchange url: " + exchangeUrl.getUri().toString());
        Response response = exchangeUrl.request().header("Authorization", (Object)BasicAuthHelper.createHeader((String)"direct-exchanger", (String)"secret")).post(Entity.form((Form)new Form().param("grant_type", "urn:ietf:params:oauth:grant-type:token-exchange").param("requested_subject", "impersonated-user")));
        Assert.assertEquals((long)200L, (long)response.getStatus());
        AccessTokenResponse accessTokenResponse = (AccessTokenResponse)response.readEntity(AccessTokenResponse.class);
        response.close();
        String exchangedTokenString = accessTokenResponse.getToken();
        TokenVerifier verifier = TokenVerifier.create((String)exchangedTokenString, AccessToken.class);
        AccessToken exchangedToken = (AccessToken)verifier.parse().getToken();
        Assert.assertEquals((Object)"direct-exchanger", (Object)exchangedToken.getIssuedFor());
        Assert.assertNull((Object)exchangedToken.getAudience());
        Assert.assertEquals((Object)exchangedToken.getPreferredUsername(), (Object)"impersonated-user");
        Assert.assertNull((Object)exchangedToken.getRealmAccess());
        response = exchangeUrl.request().header("Authorization", (Object)BasicAuthHelper.createHeader((String)"direct-legal", (String)"secret")).post(Entity.form((Form)new Form().param("grant_type", "urn:ietf:params:oauth:grant-type:token-exchange").param("requested_subject", "impersonated-user").param("audience", "target")));
        Assert.assertEquals((long)200L, (long)response.getStatus());
        accessTokenResponse = (AccessTokenResponse)response.readEntity(AccessTokenResponse.class);
        response.close();
        exchangedTokenString = accessTokenResponse.getToken();
        verifier = TokenVerifier.create((String)exchangedTokenString, AccessToken.class);
        exchangedToken = (AccessToken)verifier.parse().getToken();
        Assert.assertEquals((Object)"direct-legal", (Object)exchangedToken.getIssuedFor());
        Assert.assertEquals((Object)"target", (Object)exchangedToken.getAudience()[0]);
        Assert.assertEquals((Object)exchangedToken.getPreferredUsername(), (Object)"impersonated-user");
        Assert.assertTrue((boolean)exchangedToken.getRealmAccess().isUserInRole("example"));
        response = exchangeUrl.request().header("Authorization", (Object)BasicAuthHelper.createHeader((String)"direct-public", (String)"secret")).post(Entity.form((Form)new Form().param("grant_type", "urn:ietf:params:oauth:grant-type:token-exchange").param("requested_subject", "impersonated-user").param("audience", "target")));
        Assert.assertEquals((long)403L, (long)response.getStatus());
        response.close();
        response = exchangeUrl.request().header("Authorization", (Object)BasicAuthHelper.createHeader((String)"direct-no-secret", (String)"secret")).post(Entity.form((Form)new Form().param("grant_type", "urn:ietf:params:oauth:grant-type:token-exchange").param("requested_subject", "impersonated-user").param("audience", "target")));
        Assert.assertTrue((response.getStatus() >= 400 ? 1 : 0) != 0);
        response.close();
    }

    @Test
    @UncaughtServerErrorExpected
    public void testExchangeNoRefreshToken() throws Exception {
        this.testingClient.server().run(ClientTokenExchangeTest::setupRealm);
        this.oauth.realm("test");
        this.oauth.clientId("client-exchanger");
        ClientResource client = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"no-refresh-token");
        ClientRepresentation clientRepresentation = client.toRepresentation();
        clientRepresentation.getAttributes().put("use.refresh.tokens", "false");
        client.update(clientRepresentation);
        OAuthClient.AccessTokenResponse response = this.oauth.doGrantAccessTokenRequest("secret", "user", "password");
        String accessToken = response.getAccessToken();
        response = this.oauth.doTokenExchange("test", accessToken, "target", "client-exchanger", "secret");
        String exchangedTokenString = response.getAccessToken();
        String refreshTokenString = response.getRefreshToken();
        org.junit.Assert.assertNotNull((Object)exchangedTokenString);
        org.junit.Assert.assertNotNull((Object)refreshTokenString);
        response = this.oauth.doTokenExchange("test", accessToken, "target", "no-refresh-token", "secret");
        exchangedTokenString = response.getAccessToken();
        refreshTokenString = response.getRefreshToken();
        org.junit.Assert.assertNotNull((Object)exchangedTokenString);
        org.junit.Assert.assertNull((Object)refreshTokenString);
        clientRepresentation.getAttributes().put("use.refresh.tokens", "true");
        client.update(clientRepresentation);
    }

    private static void addDirectExchanger(KeycloakSession session) {
        RealmModel realm = session.realms().getRealmByName("test");
        RoleModel exampleRole = realm.addRole("example");
        AdminPermissionManagement management = AdminPermissions.management((KeycloakSession)session, (RealmModel)realm);
        ClientModel target = realm.addClient("target");
        target.setName("target");
        target.setClientId("target");
        target.setDirectAccessGrantsEnabled(true);
        target.setEnabled(true);
        target.setSecret("secret");
        target.setProtocol("openid-connect");
        target.setFullScopeAllowed(false);
        target.addScopeMapping(exampleRole);
        ClientModel directExchanger = realm.addClient("direct-exchanger");
        directExchanger.setName("direct-exchanger");
        directExchanger.setClientId("direct-exchanger");
        directExchanger.setPublicClient(false);
        directExchanger.setDirectAccessGrantsEnabled(true);
        directExchanger.setEnabled(true);
        directExchanger.setSecret("secret");
        directExchanger.setProtocol("openid-connect");
        directExchanger.setFullScopeAllowed(false);
        management.clients().setPermissionsEnabled(target, true);
        ClientPolicyRepresentation clientImpersonateRep = new ClientPolicyRepresentation();
        clientImpersonateRep.setName("clientImpersonatorsDirect");
        clientImpersonateRep.addClient(new String[]{directExchanger.getId()});
        ResourceServer server = management.realmResourceServer();
        Policy clientImpersonatePolicy = management.authz().getStoreFactory().getPolicyStore().create((AbstractPolicyRepresentation)clientImpersonateRep, server);
        management.users().setPermissionsEnabled(true);
        management.users().adminImpersonatingPermission().addAssociatedPolicy(clientImpersonatePolicy);
        management.users().adminImpersonatingPermission().setDecisionStrategy(DecisionStrategy.AFFIRMATIVE);
        UserModel impersonatedUser = session.users().addUser(realm, "impersonated-user");
        impersonatedUser.setEnabled(true);
        session.userCredentialManager().updateCredential(realm, impersonatedUser, (CredentialInput)UserCredentialModel.password((String)"password"));
        impersonatedUser.grantRole(exampleRole);
    }

    private static void removeDirectExchanger(KeycloakSession session) {
        RealmModel realm = session.realms().getRealmByName("test");
        realm.removeClient(realm.getClientByClientId("direct-exchanger").getId());
        realm.removeClient(realm.getClientByClientId("target").getId());
        realm.removeRole(realm.getRole("example"));
        session.users().removeUser(realm, session.users().getUserByUsername(realm, "impersonated-user"));
    }

    private Response checkTokenExchange() {
        ResteasyClient httpClient = AdminClientUtil.createResteasyClient();
        WebTarget exchangeUrl = httpClient.target(OAuthClient.AUTH_SERVER_ROOT).path("/realms").path("test").path("protocol/openid-connect/token");
        Response response = exchangeUrl.request().header("Authorization", (Object)BasicAuthHelper.createHeader((String)"direct-exchanger", (String)"secret")).post(Entity.form((Form)new Form().param("grant_type", "urn:ietf:params:oauth:grant-type:token-exchange").param("requested_subject", "impersonated-user")));
        return response;
    }
}

