/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.oauth;

import java.net.URI;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.TokenVerifier;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.common.Profile;
import org.keycloak.common.util.Base64Url;
import org.keycloak.credential.CredentialInput;
import org.keycloak.dom.saml.v2.assertion.AssertionType;
import org.keycloak.dom.saml.v2.assertion.AudienceRestrictionType;
import org.keycloak.dom.saml.v2.assertion.NameIDType;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ImpersonationConstants;
import org.keycloak.models.ImpersonationSessionNote;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionNoteDescriptor;
import org.keycloak.protocol.oidc.mappers.UserSessionNoteMapper;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.authorization.AbstractPolicyRepresentation;
import org.keycloak.representations.idm.authorization.ClientPolicyRepresentation;
import org.keycloak.representations.idm.authorization.DecisionStrategy;
import org.keycloak.saml.common.util.DocumentUtil;
import org.keycloak.saml.processing.core.parsers.saml.SAMLParser;
import org.keycloak.saml.processing.core.saml.v2.util.AssertionUtil;
import org.keycloak.saml.processing.core.util.XMLEncryptionUtil;
import org.keycloak.services.resources.admin.permissions.AdminPermissionManagement;
import org.keycloak.services.resources.admin.permissions.AdminPermissions;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.ProfileAssume;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.arquillian.annotation.EnableFeature;
import org.keycloak.testsuite.arquillian.annotation.UncaughtServerErrorExpected;
import org.keycloak.testsuite.util.AdminClientUtil;
import org.keycloak.testsuite.util.KeyUtils;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.util.BasicAuthHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
@EnableFeature(value=Profile.Feature.TOKEN_EXCHANGE, skipRestart=true)
public class ClientTokenExchangeSAML2Test
extends AbstractKeycloakTest {
    private static final String SAML_SIGNED_TARGET = "http://localhost:8080/saml-signed-assertion/";
    private static final String SAML_ENCRYPTED_TARGET = "http://localhost:8080/saml-encrypted-assertion/";
    private static final String SAML_SIGNED_AND_ENCRYPTED_TARGET = "http://localhost:8080/saml-signed-and-encrypted-assertion/";
    private static final String SAML_UNSIGNED_AND_UNENCRYPTED_TARGET = "http://localhost:8080/saml-unsigned-and-unencrypted-assertion/";
    private static final String REALM_PRIVATE_KEY = "MIICXAIBAAKBgQCrVrCuTtArbgaZzL1hvh0xtL5mc7o0NqPVnYXkLvgcwiC3BjLGw1tGEGoJaXDuSaRllobm53JBhjx33UNv+5z/UMG4kytBWxheNVKnL6GgqlNabMaFfPLPCF8kAgKnsi79NMo+n6KnSY8YeUmec/p2vjO2NjsSAVcWEQMVhJ31LwIDAQABAoGAfmO8gVhyBxdqlxmIuglbz8bcjQbhXJLR2EoS8ngTXmN1bo2L90M0mUKSdc7qF10LgETBzqL8jYlQIbt+e6TH8fcEpKCjUlyq0Mf/vVbfZSNaVycY13nTzo27iPyWQHK5NLuJzn1xvxxrUeXI6A2WFpGEBLbHjwpx5WQG9A+2scECQQDvdn9NE75HPTVPxBqsEd2z10TKkl9CZxu10Qby3iQQmWLEJ9LNmy3acvKrE3gMiYNWb6xHPKiIqOR1as7L24aTAkEAtyvQOlCvr5kAjVqrEKXalj0Tzewjweuxc0pskvArTI2Oo070h65GpoIKLc9jf+UA69cRtquwP93aZKtW06U8dQJAF2Y44ks/mK5+eyDqik3koCI08qaC8HYq2wVl7G2QkJ6sbAaILtcvD92ToOvyGyeE0flvmDZxMYlvaZnaQ0lcSQJBAKZU6umJi3/xeEbkJqMfeLclD27XGEFoPeNrmdx0q10Azp4NfJAY+Z8KRyQCR2BEG+oNitBOZ+YXF9KCpH3cdmECQHEigJhYg+ykOvr1aiZUMFT72HU0jnmQe2FVekuG+LJUt2Tm7GtMjTFoGpf0JwrVuZN39fOYAlo+nTixgeW7X8Y=";
    private static final String REALM_PUBLIC_KEY = "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCrVrCuTtArbgaZzL1hvh0xtL5mc7o0NqPVnYXkLvgcwiC3BjLGw1tGEGoJaXDuSaRllobm53JBhjx33UNv+5z/UMG4kytBWxheNVKnL6GgqlNabMaFfPLPCF8kAgKnsi79NMo+n6KnSY8YeUmec/p2vjO2NjsSAVcWEQMVhJ31LwIDAQAB";
    private static final String ENCRYPTION_CERTIFICATE = "MIIB1DCCAT0CBgFJGVacCDANBgkqhkiG9w0BAQsFADAwMS4wLAYDVQQDEyVodHRwOi8vbG9jYWxob3N0OjgwODAvc2FsZXMtcG9zdC1lbmMvMB4XDTE0MTAxNjE0MjA0NloXDTI0MTAxNjE0MjIyNlowMDEuMCwGA1UEAxMlaHR0cDovL2xvY2FsaG9zdDo4MDgwL3NhbGVzLXBvc3QtZW5jLzCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEA2+5MCT5BnVN+IYnKZcH6ev1pjXGi4feE0nOycq/VJ3aeaZMi4G9AxOxCBPupErOC7Kgm/Bw5AdJyw+Q12wSRXfJ9FhqCrLXpb7YOhbVSTJ8De5O8mW35DxAlh/cxe9FXjqPb286wKTUZ3LfGYR+X235UQeCTAPS/Ufi21EXaEikCAwEAATANBgkqhkiG9w0BAQsFAAOBgQBMrfGD9QFfx5v7ld/OAto5rjkTe3R1Qei8XRXfcs83vLaqEzjEtTuLGrJEi55kXuJgBpVmQpnwCCkkjSy0JxbqLDdVi9arfWUxEGmOr01ZHycELhDNaQcFqVMPr5kRHIHgktT8hK2IgCvd3Fy9/JCgUgCPxKfhwecyEOKxUc857g==";
    private static final String ENCRYPTION_PRIVATE_KEY = "MIICXQIBAAKBgQDb7kwJPkGdU34hicplwfp6/WmNcaLh94TSc7Jyr9Undp5pkyLgb0DE7EIE+6kSs4LsqCb8HDkB0nLD5DXbBJFd8n0WGoKstelvtg6FtVJMnwN7k7yZbfkPECWH9zF70VeOo9vbzrApNRnct8ZhH5fbflRB4JMA9L9R+LbURdoSKQIDAQABAoGBANtbZG9bruoSGp2s5zhzLzd4hczT6Jfk3o9hYjzNb5Z60ymN3Z1omXtQAdEiiNHkRdNxK+EM7TcKBfmoJqcaeTkW8cksVEAW23ip8W9/XsLqmbU2mRrJiKa+KQNDSHqJi1VGyimi4DDApcaqRZcaKDFXg2KDr/Qt5JFD/o9IIIPZAkEA+ZENdBIlpbUfkJh6Ln+bUTss/FZ1FsrcPZWu13rChRMrsmXsfzu9kZUWdUeQ2Dj5AoW2Q7L/cqdGXS7Mm5XhcwJBAOGZq9axJY5YhKrsksvYRLhQbStmGu5LG75suF+rc/44sFq+aQM7+oeRr4VY88Mvz7mk4esdfnk7ae+cCazqJvMCQQCx1L1cZw3yfRSn6S6u8XjQMjWE/WpjulujeoRiwPPY9WcesOgLZZtYIH8nRL6ehEJTnMnahbLmlPFbttxPRUanAkA11MtSIVcKzkhp2KV2ipZrPJWwI18NuVJXb+3WtjypTrGWFZVNNkSjkLnHIeCYlJIGhDd8OL9zAiBXEm6kmgLNAkBWAg0tK2hCjvzsaA505gWQb4X56uKWdb0IzN+fOLB3Qt7+fLqbVQNQoNGzqey6B4MoS1fUKAStqdGTFYPG/+9t";
    @Rule
    public AssertEvents events = new AssertEvents(this);

    @BeforeClass
    public static void enabled() {
        ProfileAssume.assumeFeatureEnabled((Profile.Feature)Profile.Feature.AUTHORIZATION);
    }

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation testRealmRep = new RealmRepresentation();
        testRealmRep.setId("test");
        testRealmRep.setRealm("test");
        testRealmRep.setEnabled(Boolean.valueOf(true));
        testRealmRep.setPrivateKey(REALM_PRIVATE_KEY);
        testRealmRep.setPublicKey(REALM_PUBLIC_KEY);
        testRealmRep.setAccessCodeLifespan(Integer.valueOf(60));
        testRealms.add(testRealmRep);
    }

    public static void setupRealm(KeycloakSession session) {
        ClientTokenExchangeSAML2Test.addTargetClients(session);
        ClientTokenExchangeSAML2Test.addDirectExchanger(session);
        RealmModel realm = session.realms().getRealmByName("test");
        RoleModel exampleRole = realm.getRole("example");
        AdminPermissionManagement management = AdminPermissions.management((KeycloakSession)session, (RealmModel)realm);
        RoleModel impersonateRole = management.getRealmManagementClient().getRole(ImpersonationConstants.IMPERSONATION_ROLE);
        ClientModel clientExchanger = realm.addClient("client-exchanger");
        clientExchanger.setClientId("client-exchanger");
        clientExchanger.setPublicClient(false);
        clientExchanger.setDirectAccessGrantsEnabled(true);
        clientExchanger.setEnabled(true);
        clientExchanger.setSecret("secret");
        clientExchanger.setProtocol("openid-connect");
        clientExchanger.setFullScopeAllowed(false);
        clientExchanger.addScopeMapping(impersonateRole);
        clientExchanger.addProtocolMapper(UserSessionNoteMapper.createUserSessionNoteMapper((UserSessionNoteDescriptor)ImpersonationSessionNote.IMPERSONATOR_ID));
        clientExchanger.addProtocolMapper(UserSessionNoteMapper.createUserSessionNoteMapper((UserSessionNoteDescriptor)ImpersonationSessionNote.IMPERSONATOR_USERNAME));
        ClientModel illegal = realm.addClient("illegal");
        illegal.setClientId("illegal");
        illegal.setPublicClient(false);
        illegal.setDirectAccessGrantsEnabled(true);
        illegal.setEnabled(true);
        illegal.setSecret("secret");
        illegal.setProtocol("openid-connect");
        illegal.setFullScopeAllowed(false);
        ClientModel legal = realm.addClient("legal");
        legal.setClientId("legal");
        legal.setPublicClient(false);
        legal.setDirectAccessGrantsEnabled(true);
        legal.setEnabled(true);
        legal.setSecret("secret");
        legal.setProtocol("openid-connect");
        legal.setFullScopeAllowed(false);
        ClientModel directLegal = realm.addClient("direct-legal");
        directLegal.setClientId("direct-legal");
        directLegal.setPublicClient(false);
        directLegal.setDirectAccessGrantsEnabled(true);
        directLegal.setEnabled(true);
        directLegal.setSecret("secret");
        directLegal.setProtocol("openid-connect");
        directLegal.setFullScopeAllowed(false);
        ClientModel directPublic = realm.addClient("direct-public");
        directPublic.setClientId("direct-public");
        directPublic.setPublicClient(true);
        directPublic.setDirectAccessGrantsEnabled(true);
        directPublic.setEnabled(true);
        directPublic.setProtocol("openid-connect");
        directPublic.setFullScopeAllowed(false);
        ClientModel directNoSecret = realm.addClient("direct-no-secret");
        directNoSecret.setClientId("direct-no-secret");
        directNoSecret.setPublicClient(false);
        directNoSecret.setDirectAccessGrantsEnabled(true);
        directNoSecret.setEnabled(true);
        directNoSecret.setProtocol("openid-connect");
        directNoSecret.setFullScopeAllowed(false);
        ClientPolicyRepresentation clientRep = new ClientPolicyRepresentation();
        clientRep.setName("to");
        clientRep.addClient(new String[]{clientExchanger.getId()});
        clientRep.addClient(new String[]{legal.getId()});
        clientRep.addClient(new String[]{directLegal.getId()});
        ClientModel samlSignedTarget = realm.getClientByClientId(SAML_SIGNED_TARGET);
        ClientModel samlEncryptedTarget = realm.getClientByClientId(SAML_ENCRYPTED_TARGET);
        ClientModel samlSignedAndEncryptedTarget = realm.getClientByClientId(SAML_SIGNED_AND_ENCRYPTED_TARGET);
        ClientModel samlUnsignedAndUnencryptedTarget = realm.getClientByClientId(SAML_UNSIGNED_AND_UNENCRYPTED_TARGET);
        org.junit.Assert.assertNotNull((Object)samlSignedTarget);
        org.junit.Assert.assertNotNull((Object)samlEncryptedTarget);
        org.junit.Assert.assertNotNull((Object)samlSignedAndEncryptedTarget);
        org.junit.Assert.assertNotNull((Object)samlUnsignedAndUnencryptedTarget);
        ResourceServer server = management.realmResourceServer();
        Policy clientPolicy = management.authz().getStoreFactory().getPolicyStore().create((AbstractPolicyRepresentation)clientRep, server);
        management.clients().exchangeToPermission(samlSignedTarget).addAssociatedPolicy(clientPolicy);
        management.clients().exchangeToPermission(samlEncryptedTarget).addAssociatedPolicy(clientPolicy);
        management.clients().exchangeToPermission(samlSignedAndEncryptedTarget).addAssociatedPolicy(clientPolicy);
        management.clients().exchangeToPermission(samlUnsignedAndUnencryptedTarget).addAssociatedPolicy(clientPolicy);
        ClientPolicyRepresentation clientImpersonateRep = new ClientPolicyRepresentation();
        clientImpersonateRep.setName("clientImpersonators");
        clientImpersonateRep.addClient(new String[]{directLegal.getId()});
        clientImpersonateRep.addClient(new String[]{directPublic.getId()});
        clientImpersonateRep.addClient(new String[]{directNoSecret.getId()});
        server = management.realmResourceServer();
        Policy clientImpersonatePolicy = management.authz().getStoreFactory().getPolicyStore().create((AbstractPolicyRepresentation)clientImpersonateRep, server);
        management.users().setPermissionsEnabled(true);
        management.users().adminImpersonatingPermission().addAssociatedPolicy(clientImpersonatePolicy);
        management.users().adminImpersonatingPermission().setDecisionStrategy(DecisionStrategy.AFFIRMATIVE);
        UserModel user = session.users().addUser(realm, "user");
        user.setEnabled(true);
        session.userCredentialManager().updateCredential(realm, user, (CredentialInput)UserCredentialModel.password((String)"password"));
        user.grantRole(exampleRole);
        user.grantRole(impersonateRole);
        UserModel bad = session.users().addUser(realm, "bad-impersonator");
        bad.setEnabled(true);
        session.userCredentialManager().updateCredential(realm, bad, (CredentialInput)UserCredentialModel.password((String)"password"));
    }

    @Override
    protected boolean isImportAfterEachMethod() {
        return true;
    }

    @Test
    @UncaughtServerErrorExpected
    public void testExchangeToSAML2SignedAssertion() throws Exception {
        this.testingClient.server().run(ClientTokenExchangeSAML2Test::setupRealm);
        this.oauth.realm("test");
        this.oauth.clientId("client-exchanger");
        OAuthClient.AccessTokenResponse response = this.oauth.doGrantAccessTokenRequest("secret", "user", "password");
        String accessToken = response.getAccessToken();
        TokenVerifier accessTokenVerifier = TokenVerifier.create((String)accessToken, AccessToken.class);
        AccessToken token = (AccessToken)accessTokenVerifier.parse().getToken();
        Assert.assertEquals((Object)token.getPreferredUsername(), (Object)"user");
        Assert.assertTrue((token.getRealmAccess() == null || !token.getRealmAccess().isUserInRole("example") ? 1 : 0) != 0);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("requested_token_type", "urn:ietf:params:oauth:token-type:saml2");
        response = this.oauth.doTokenExchange("test", accessToken, SAML_SIGNED_TARGET, "client-exchanger", "secret", params);
        String exchangedTokenString = response.getAccessToken();
        String assertionXML = new String(Base64Url.decode((String)exchangedTokenString), "UTF-8");
        Assert.assertEquals((Object)"urn:ietf:params:oauth:token-type:saml2", (Object)response.getIssuedTokenType());
        Element assertionElement = DocumentUtil.getDocument((String)assertionXML).getDocumentElement();
        Assert.assertTrue((boolean)AssertionUtil.isSignedElement((Element)assertionElement));
        AssertionType assertion = (AssertionType)SAMLParser.getInstance().parse((Node)assertionElement);
        Assert.assertTrue((boolean)AssertionUtil.isSignatureValid((Element)assertionElement, (PublicKey)this.publicKeyFromString(REALM_PUBLIC_KEY)));
        Assert.assertEquals((long)60L, (long)response.getExpiresIn());
        AudienceRestrictionType aud = (AudienceRestrictionType)assertion.getConditions().getConditions().get(0);
        Assert.assertEquals((Object)SAML_SIGNED_TARGET, (Object)((URI)aud.getAudience().get(0)).toString());
        Assert.assertEquals((Object)"user", (Object)((NameIDType)assertion.getSubject().getSubType().getBaseID()).getValue());
        List roles = AssertionUtil.getRoles((AssertionType)assertion, null);
        Assert.assertTrue((boolean)roles.contains("example"));
        response = this.oauth.doTokenExchange("test", accessToken, SAML_SIGNED_TARGET, "legal", "secret", params);
        exchangedTokenString = response.getAccessToken();
        assertionXML = new String(Base64Url.decode((String)exchangedTokenString), "UTF-8");
        Assert.assertEquals((Object)"urn:ietf:params:oauth:token-type:saml2", (Object)response.getIssuedTokenType());
        assertionElement = DocumentUtil.getDocument((String)assertionXML).getDocumentElement();
        Assert.assertTrue((boolean)AssertionUtil.isSignedElement((Element)assertionElement));
        assertion = (AssertionType)SAMLParser.getInstance().parse((Node)assertionElement);
        Assert.assertTrue((boolean)AssertionUtil.isSignatureValid((Element)assertionElement, (PublicKey)this.publicKeyFromString(REALM_PUBLIC_KEY)));
        aud = (AudienceRestrictionType)assertion.getConditions().getConditions().get(0);
        Assert.assertEquals((Object)SAML_SIGNED_TARGET, (Object)((URI)aud.getAudience().get(0)).toString());
        Assert.assertEquals((Object)"user", (Object)((NameIDType)assertion.getSubject().getSubType().getBaseID()).getValue());
        roles = AssertionUtil.getRoles((AssertionType)assertion, null);
        Assert.assertTrue((boolean)roles.contains("example"));
        response = this.oauth.doTokenExchange("test", accessToken, SAML_SIGNED_TARGET, "illegal", "secret", params);
        Assert.assertEquals((long)403L, (long)response.getStatusCode());
    }

    @Test
    @UncaughtServerErrorExpected
    public void testExchangeToSAML2EncryptedAssertion() throws Exception {
        this.testingClient.server().run(ClientTokenExchangeSAML2Test::setupRealm);
        this.oauth.realm("test");
        this.oauth.clientId("client-exchanger");
        OAuthClient.AccessTokenResponse response = this.oauth.doGrantAccessTokenRequest("secret", "user", "password");
        String accessToken = response.getAccessToken();
        TokenVerifier accessTokenVerifier = TokenVerifier.create((String)accessToken, AccessToken.class);
        AccessToken token = (AccessToken)accessTokenVerifier.parse().getToken();
        Assert.assertEquals((Object)token.getPreferredUsername(), (Object)"user");
        Assert.assertTrue((token.getRealmAccess() == null || !token.getRealmAccess().isUserInRole("example") ? 1 : 0) != 0);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("requested_token_type", "urn:ietf:params:oauth:token-type:saml2");
        response = this.oauth.doTokenExchange("test", accessToken, SAML_ENCRYPTED_TARGET, "client-exchanger", "secret", params);
        String exchangedTokenString = response.getAccessToken();
        String assertionXML = new String(Base64Url.decode((String)exchangedTokenString), "UTF-8");
        Assert.assertEquals((Object)"urn:ietf:params:oauth:token-type:saml2", (Object)response.getIssuedTokenType());
        Document assertionDoc = DocumentUtil.getDocument((String)assertionXML);
        Element assertionElement = XMLEncryptionUtil.decryptElementInDocument((Document)assertionDoc, (PrivateKey)this.privateKeyFromString(ENCRYPTION_PRIVATE_KEY));
        Assert.assertFalse((boolean)AssertionUtil.isSignedElement((Element)assertionElement));
        AssertionType assertion = (AssertionType)SAMLParser.getInstance().parse((Node)assertionElement);
        Assert.assertEquals((long)30L, (long)response.getExpiresIn());
        AudienceRestrictionType aud = (AudienceRestrictionType)assertion.getConditions().getConditions().get(0);
        Assert.assertEquals((Object)SAML_ENCRYPTED_TARGET, (Object)((URI)aud.getAudience().get(0)).toString());
        Assert.assertEquals((Object)"user", (Object)((NameIDType)assertion.getSubject().getSubType().getBaseID()).getValue());
        List roles = AssertionUtil.getRoles((AssertionType)assertion, null);
        Assert.assertTrue((boolean)roles.contains("example"));
    }

    @Test
    @UncaughtServerErrorExpected
    public void testExchangeToSAML2SignedAndEncryptedAssertion() throws Exception {
        this.testingClient.server().run(ClientTokenExchangeSAML2Test::setupRealm);
        this.oauth.realm("test");
        this.oauth.clientId("client-exchanger");
        OAuthClient.AccessTokenResponse response = this.oauth.doGrantAccessTokenRequest("secret", "user", "password");
        String accessToken = response.getAccessToken();
        TokenVerifier accessTokenVerifier = TokenVerifier.create((String)accessToken, AccessToken.class);
        AccessToken token = (AccessToken)accessTokenVerifier.parse().getToken();
        Assert.assertEquals((Object)token.getPreferredUsername(), (Object)"user");
        Assert.assertTrue((token.getRealmAccess() == null || !token.getRealmAccess().isUserInRole("example") ? 1 : 0) != 0);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("requested_token_type", "urn:ietf:params:oauth:token-type:saml2");
        response = this.oauth.doTokenExchange("test", accessToken, SAML_SIGNED_AND_ENCRYPTED_TARGET, "client-exchanger", "secret", params);
        String exchangedTokenString = response.getAccessToken();
        String assertionXML = new String(Base64Url.decode((String)exchangedTokenString), "UTF-8");
        Assert.assertEquals((Object)"urn:ietf:params:oauth:token-type:saml2", (Object)response.getIssuedTokenType());
        Document assertionDoc = DocumentUtil.getDocument((String)assertionXML);
        Element assertionElement = XMLEncryptionUtil.decryptElementInDocument((Document)assertionDoc, (PrivateKey)this.privateKeyFromString(ENCRYPTION_PRIVATE_KEY));
        Assert.assertTrue((boolean)AssertionUtil.isSignedElement((Element)assertionElement));
        AssertionType assertion = (AssertionType)SAMLParser.getInstance().parse((Node)assertionElement);
        Assert.assertTrue((boolean)AssertionUtil.isSignatureValid((Element)assertionElement, (PublicKey)this.publicKeyFromString(REALM_PUBLIC_KEY)));
        AudienceRestrictionType aud = (AudienceRestrictionType)assertion.getConditions().getConditions().get(0);
        Assert.assertEquals((Object)SAML_SIGNED_AND_ENCRYPTED_TARGET, (Object)((URI)aud.getAudience().get(0)).toString());
        Assert.assertEquals((Object)"user", (Object)((NameIDType)assertion.getSubject().getSubType().getBaseID()).getValue());
        List roles = AssertionUtil.getRoles((AssertionType)assertion, null);
        Assert.assertTrue((boolean)roles.contains("example"));
    }

    @Test
    @UncaughtServerErrorExpected
    public void testExchangeToSAML2UnsignedAndUnencryptedAssertion() throws Exception {
        this.testingClient.server().run(ClientTokenExchangeSAML2Test::setupRealm);
        this.oauth.realm("test");
        this.oauth.clientId("client-exchanger");
        OAuthClient.AccessTokenResponse response = this.oauth.doGrantAccessTokenRequest("secret", "user", "password");
        String accessToken = response.getAccessToken();
        TokenVerifier accessTokenVerifier = TokenVerifier.create((String)accessToken, AccessToken.class);
        AccessToken token = (AccessToken)accessTokenVerifier.parse().getToken();
        Assert.assertEquals((Object)token.getPreferredUsername(), (Object)"user");
        Assert.assertTrue((token.getRealmAccess() == null || !token.getRealmAccess().isUserInRole("example") ? 1 : 0) != 0);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("requested_token_type", "urn:ietf:params:oauth:token-type:saml2");
        response = this.oauth.doTokenExchange("test", accessToken, SAML_UNSIGNED_AND_UNENCRYPTED_TARGET, "client-exchanger", "secret", params);
        String exchangedTokenString = response.getAccessToken();
        String assertionXML = new String(Base64Url.decode((String)exchangedTokenString), "UTF-8");
        Assert.assertEquals((Object)"urn:ietf:params:oauth:token-type:saml2", (Object)response.getIssuedTokenType());
        Document assertionDoc = DocumentUtil.getDocument((String)assertionXML);
        Assert.assertFalse((boolean)AssertionUtil.isSignedElement((Element)assertionDoc.getDocumentElement()));
        AssertionType assertion = (AssertionType)SAMLParser.getInstance().parse((Node)assertionDoc);
        AudienceRestrictionType aud = (AudienceRestrictionType)assertion.getConditions().getConditions().get(0);
        Assert.assertEquals((Object)SAML_UNSIGNED_AND_UNENCRYPTED_TARGET, (Object)((URI)aud.getAudience().get(0)).toString());
        Assert.assertEquals((Object)"user", (Object)((NameIDType)assertion.getSubject().getSubType().getBaseID()).getValue());
        List roles = AssertionUtil.getRoles((AssertionType)assertion, null);
        Assert.assertTrue((boolean)roles.contains("example"));
    }

    @Test
    @UncaughtServerErrorExpected
    public void testImpersonation() throws Exception {
        this.testingClient.server().run(ClientTokenExchangeSAML2Test::setupRealm);
        this.oauth.realm("test");
        this.oauth.clientId("client-exchanger");
        OAuthClient.AccessTokenResponse response = this.oauth.doGrantAccessTokenRequest("secret", "user", "password");
        String accessToken = response.getAccessToken();
        TokenVerifier accessTokenVerifier = TokenVerifier.create((String)accessToken, AccessToken.class);
        AccessToken token = (AccessToken)accessTokenVerifier.parse().getToken();
        Assert.assertEquals((Object)token.getPreferredUsername(), (Object)"user");
        Assert.assertTrue((token.getRealmAccess() == null || !token.getRealmAccess().isUserInRole("example") ? 1 : 0) != 0);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("requested_token_type", "urn:ietf:params:oauth:token-type:saml2");
        params.put("requested_subject", "impersonated-user");
        response = this.oauth.doTokenExchange("test", accessToken, SAML_SIGNED_TARGET, "client-exchanger", "secret", params);
        String exchangedTokenString = response.getAccessToken();
        String assertionXML = new String(Base64Url.decode((String)exchangedTokenString), "UTF-8");
        Assert.assertEquals((Object)"urn:ietf:params:oauth:token-type:saml2", (Object)response.getIssuedTokenType());
        Element assertionElement = DocumentUtil.getDocument((String)assertionXML).getDocumentElement();
        Assert.assertTrue((boolean)AssertionUtil.isSignedElement((Element)assertionElement));
        AssertionType assertion = (AssertionType)SAMLParser.getInstance().parse((Node)assertionElement);
        Assert.assertTrue((boolean)AssertionUtil.isSignatureValid((Element)assertionElement, (PublicKey)this.publicKeyFromString(REALM_PUBLIC_KEY)));
        AudienceRestrictionType aud = (AudienceRestrictionType)assertion.getConditions().getConditions().get(0);
        Assert.assertEquals((Object)SAML_SIGNED_TARGET, (Object)((URI)aud.getAudience().get(0)).toString());
        Assert.assertEquals((Object)"impersonated-user", (Object)((NameIDType)assertion.getSubject().getSubType().getBaseID()).getValue());
        List roles = AssertionUtil.getRoles((AssertionType)assertion, null);
        Assert.assertTrue((boolean)roles.contains("example"));
    }

    @Test
    @UncaughtServerErrorExpected
    public void testBadImpersonator() throws Exception {
        this.testingClient.server().run(ClientTokenExchangeSAML2Test::setupRealm);
        this.oauth.realm("test");
        this.oauth.clientId("client-exchanger");
        OAuthClient.AccessTokenResponse response = this.oauth.doGrantAccessTokenRequest("secret", "bad-impersonator", "password");
        String accessToken = response.getAccessToken();
        TokenVerifier accessTokenVerifier = TokenVerifier.create((String)accessToken, AccessToken.class);
        AccessToken token = (AccessToken)accessTokenVerifier.parse().getToken();
        Assert.assertEquals((Object)token.getPreferredUsername(), (Object)"bad-impersonator");
        Assert.assertTrue((token.getRealmAccess() == null || !token.getRealmAccess().isUserInRole("example") ? 1 : 0) != 0);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("requested_token_type", "urn:ietf:params:oauth:token-type:saml2");
        params.put("requested_subject", "impersonated-user");
        response = this.oauth.doTokenExchange("test", accessToken, SAML_SIGNED_TARGET, "client-exchanger", "secret", params);
        Assert.assertEquals((long)403L, (long)response.getStatusCode());
    }

    @Test
    @UncaughtServerErrorExpected
    public void testDirectImpersonation() throws Exception {
        this.testingClient.server().run(ClientTokenExchangeSAML2Test::setupRealm);
        ResteasyClient httpClient = AdminClientUtil.createResteasyClient();
        WebTarget exchangeUrl = httpClient.target(OAuthClient.AUTH_SERVER_ROOT).path("/realms").path("test").path("protocol/openid-connect/token");
        System.out.println("Exchange url: " + exchangeUrl.getUri().toString());
        Response response = exchangeUrl.request().header("Authorization", (Object)BasicAuthHelper.createHeader((String)"direct-legal", (String)"secret")).post(Entity.form((Form)new Form().param("grant_type", "urn:ietf:params:oauth:grant-type:token-exchange").param("requested_token_type", "urn:ietf:params:oauth:token-type:saml2").param("requested_subject", "impersonated-user").param("audience", SAML_SIGNED_TARGET)));
        Assert.assertEquals((long)200L, (long)response.getStatus());
        AccessTokenResponse accessTokenResponse = (AccessTokenResponse)response.readEntity(AccessTokenResponse.class);
        response.close();
        String exchangedTokenString = accessTokenResponse.getToken();
        String assertionXML = new String(Base64Url.decode((String)exchangedTokenString), "UTF-8");
        Assert.assertEquals((Object)"urn:ietf:params:oauth:token-type:saml2", accessTokenResponse.getOtherClaims().get("issued_token_type"));
        Element assertionElement = DocumentUtil.getDocument((String)assertionXML).getDocumentElement();
        Assert.assertTrue((boolean)AssertionUtil.isSignedElement((Element)assertionElement));
        AssertionType assertion = (AssertionType)SAMLParser.getInstance().parse((Node)assertionElement);
        Assert.assertTrue((boolean)AssertionUtil.isSignatureValid((Element)assertionElement, (PublicKey)this.publicKeyFromString(REALM_PUBLIC_KEY)));
        AudienceRestrictionType aud = (AudienceRestrictionType)assertion.getConditions().getConditions().get(0);
        Assert.assertEquals((Object)SAML_SIGNED_TARGET, (Object)((URI)aud.getAudience().get(0)).toString());
        Assert.assertEquals((Object)"impersonated-user", (Object)((NameIDType)assertion.getSubject().getSubType().getBaseID()).getValue());
        List roles = AssertionUtil.getRoles((AssertionType)assertion, null);
        Assert.assertTrue((boolean)roles.contains("example"));
        response = exchangeUrl.request().header("Authorization", (Object)BasicAuthHelper.createHeader((String)"direct-public", (String)"secret")).post(Entity.form((Form)new Form().param("grant_type", "urn:ietf:params:oauth:grant-type:token-exchange").param("requested_token_type", "urn:ietf:params:oauth:token-type:saml2").param("requested_subject", "impersonated-user").param("audience", SAML_SIGNED_TARGET)));
        Assert.assertEquals((long)403L, (long)response.getStatus());
        response.close();
        response = exchangeUrl.request().header("Authorization", (Object)BasicAuthHelper.createHeader((String)"direct-no-secret", (String)"secret")).post(Entity.form((Form)new Form().param("grant_type", "urn:ietf:params:oauth:grant-type:token-exchange").param("requested_token_type", "urn:ietf:params:oauth:token-type:saml2").param("requested_subject", "impersonated-user").param("audience", SAML_SIGNED_TARGET)));
        Assert.assertTrue((response.getStatus() >= 400 ? 1 : 0) != 0);
        response.close();
    }

    private static void addTargetClients(KeycloakSession session) {
        RealmModel realm = session.realms().getRealmByName("test");
        ClientModel samlSignedTarget = realm.addClient(SAML_SIGNED_TARGET);
        samlSignedTarget.setClientId(SAML_SIGNED_TARGET);
        samlSignedTarget.setEnabled(true);
        samlSignedTarget.setProtocol("saml");
        samlSignedTarget.setFullScopeAllowed(true);
        samlSignedTarget.setAttribute("saml.authnstatement", "true");
        samlSignedTarget.setAttribute("saml_assertion_consumer_url_post", "http://localhost:8080/saml-signed-assertion/endpoint");
        samlSignedTarget.setAttribute("saml_name_id_format", "username");
        samlSignedTarget.setAttribute("saml.assertion.signature", "true");
        samlSignedTarget.setAttribute("saml.server.signature", "true");
        samlSignedTarget.setAttribute("saml.encrypt", "false");
        ClientModel samlEncryptedTarget = realm.addClient(SAML_ENCRYPTED_TARGET);
        samlEncryptedTarget.setClientId(SAML_ENCRYPTED_TARGET);
        samlEncryptedTarget.setEnabled(true);
        samlEncryptedTarget.setProtocol("saml");
        samlEncryptedTarget.setFullScopeAllowed(true);
        samlEncryptedTarget.setAttribute("saml.authnstatement", "true");
        samlEncryptedTarget.setAttribute("saml_assertion_consumer_url_post", "http://localhost:8080/saml-encrypted-assertion/endpoint");
        samlEncryptedTarget.setAttribute("saml_name_id_format", "username");
        samlEncryptedTarget.setAttribute("saml.assertion.signature", "false");
        samlEncryptedTarget.setAttribute("saml.server.signature", "true");
        samlEncryptedTarget.setAttribute("saml.encrypt", "true");
        samlEncryptedTarget.setAttribute("saml.encryption.certificate", ENCRYPTION_CERTIFICATE);
        samlEncryptedTarget.setAttribute("saml.assertion.lifespan", "30");
        ClientModel samlSignedAndEncryptedTarget = realm.addClient(SAML_SIGNED_AND_ENCRYPTED_TARGET);
        samlSignedAndEncryptedTarget.setClientId(SAML_SIGNED_AND_ENCRYPTED_TARGET);
        samlSignedAndEncryptedTarget.setEnabled(true);
        samlSignedAndEncryptedTarget.setProtocol("saml");
        samlSignedAndEncryptedTarget.setFullScopeAllowed(true);
        samlSignedAndEncryptedTarget.setAttribute("saml.authnstatement", "true");
        samlSignedAndEncryptedTarget.setAttribute("saml_assertion_consumer_url_post", "http://localhost:8080/saml-signed-and-encrypted-assertion/endpoint");
        samlSignedAndEncryptedTarget.setAttribute("saml_name_id_format", "username");
        samlSignedAndEncryptedTarget.setAttribute("saml.assertion.signature", "true");
        samlSignedAndEncryptedTarget.setAttribute("saml.server.signature", "true");
        samlSignedAndEncryptedTarget.setAttribute("saml.encrypt", "true");
        samlSignedAndEncryptedTarget.setAttribute("saml.encryption.certificate", ENCRYPTION_CERTIFICATE);
        ClientModel samlUnsignedAndUnencryptedTarget = realm.addClient(SAML_UNSIGNED_AND_UNENCRYPTED_TARGET);
        samlUnsignedAndUnencryptedTarget.setClientId(SAML_UNSIGNED_AND_UNENCRYPTED_TARGET);
        samlUnsignedAndUnencryptedTarget.setEnabled(true);
        samlUnsignedAndUnencryptedTarget.setProtocol("saml");
        samlUnsignedAndUnencryptedTarget.setFullScopeAllowed(true);
        samlUnsignedAndUnencryptedTarget.setAttribute("saml.authnstatement", "true");
        samlUnsignedAndUnencryptedTarget.setAttribute("saml_assertion_consumer_url_post", "http://localhost:8080/saml-unsigned-and-unencrypted-assertion/endpoint");
        samlUnsignedAndUnencryptedTarget.setAttribute("saml_name_id_format", "username");
        samlUnsignedAndUnencryptedTarget.setAttribute("saml.assertion.signature", "false");
        samlUnsignedAndUnencryptedTarget.setAttribute("saml.server.signature", "true");
        samlUnsignedAndUnencryptedTarget.setAttribute("saml.encrypt", "false");
    }

    private static void addDirectExchanger(KeycloakSession session) {
        RealmModel realm = session.realms().getRealmByName("test");
        RoleModel exampleRole = realm.addRole("example");
        AdminPermissionManagement management = AdminPermissions.management((KeycloakSession)session, (RealmModel)realm);
        ClientModel directExchanger = realm.addClient("direct-exchanger");
        directExchanger.setName("direct-exchanger");
        directExchanger.setClientId("direct-exchanger");
        directExchanger.setPublicClient(false);
        directExchanger.setDirectAccessGrantsEnabled(true);
        directExchanger.setEnabled(true);
        directExchanger.setSecret("secret");
        directExchanger.setProtocol("openid-connect");
        directExchanger.setFullScopeAllowed(false);
        management.clients().setPermissionsEnabled(realm.getClientByClientId(SAML_SIGNED_TARGET), true);
        management.clients().setPermissionsEnabled(realm.getClientByClientId(SAML_ENCRYPTED_TARGET), true);
        management.clients().setPermissionsEnabled(realm.getClientByClientId(SAML_SIGNED_AND_ENCRYPTED_TARGET), true);
        management.clients().setPermissionsEnabled(realm.getClientByClientId(SAML_UNSIGNED_AND_UNENCRYPTED_TARGET), true);
        ClientPolicyRepresentation clientImpersonateRep = new ClientPolicyRepresentation();
        clientImpersonateRep.setName("clientImpersonatorsDirect");
        clientImpersonateRep.addClient(new String[]{directExchanger.getId()});
        ResourceServer server = management.realmResourceServer();
        Policy clientImpersonatePolicy = management.authz().getStoreFactory().getPolicyStore().create((AbstractPolicyRepresentation)clientImpersonateRep, server);
        management.users().setPermissionsEnabled(true);
        management.users().adminImpersonatingPermission().addAssociatedPolicy(clientImpersonatePolicy);
        management.users().adminImpersonatingPermission().setDecisionStrategy(DecisionStrategy.AFFIRMATIVE);
        UserModel impersonatedUser = session.users().addUser(realm, "impersonated-user");
        impersonatedUser.setEnabled(true);
        session.userCredentialManager().updateCredential(realm, impersonatedUser, (CredentialInput)UserCredentialModel.password((String)"password"));
        impersonatedUser.grantRole(exampleRole);
    }

    private PublicKey publicKeyFromString(String publicKey) {
        return KeyUtils.publicKeyFromString((String)publicKey);
    }

    private PrivateKey privateKeyFromString(String privateKey) {
        return KeyUtils.privateKeyFromString((String)privateKey);
    }
}

