/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.oauth;

import java.io.IOException;
import java.security.KeyPair;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.ClientsResource;
import org.keycloak.admin.client.resource.IdentityProviderResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.common.util.Base64Url;
import org.keycloak.common.util.KeyUtils;
import org.keycloak.events.EventType;
import org.keycloak.protocol.oidc.LogoutTokenValidationCode;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.EventRepresentation;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.idm.UserSessionRepresentation;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.broker.AbstractNestedBrokerTest;
import org.keycloak.testsuite.broker.BrokerTestTools;
import org.keycloak.testsuite.broker.NestedBrokerConfiguration;
import org.keycloak.testsuite.broker.OidcBackchannelLogoutBrokerConfiguration;
import org.keycloak.testsuite.util.CredentialBuilder;
import org.keycloak.testsuite.util.LogoutTokenUtil;
import org.keycloak.testsuite.util.Matchers;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.RealmManager;
import org.keycloak.testsuite.util.SecondBrowser;
import org.keycloak.util.JsonSerialization;
import org.openqa.selenium.WebDriver;

public class BackchannelLogoutTest
extends AbstractNestedBrokerTest {
    public static final String ACCOUNT_CLIENT_NAME = "account";
    public static final String BROKER_CLIENT_ID = "brokerapp";
    public static final String USER_PASSWORD_CONSUMER_REALM = "password";
    private static final KeyPair KEY_PAIR = KeyUtils.generateRsaKeyPair((int)2048);
    private String userIdProviderRealm;
    private String realmIdConsumerRealm;
    private String accountClientIdConsumerRealm;
    private String accountClientIdSubConsumerRealm;
    private String providerId;
    private RealmManager providerRealmManager;
    @Rule
    public AssertEvents events = new AssertEvents(this);
    @Drone
    @SecondBrowser
    WebDriver driver2;

    @Override
    protected NestedBrokerConfiguration getNestedBrokerConfiguration() {
        return OidcBackchannelLogoutBrokerConfiguration.INSTANCE;
    }

    @Before
    public void createProviderRealmUser() {
        this.log.debug((Object)("creating user for realm " + this.nbc.providerRealmName()));
        UserRepresentation userProviderRealm = new UserRepresentation();
        userProviderRealm.setUsername(this.nbc.getUserLogin());
        userProviderRealm.setEmail(this.nbc.getUserEmail());
        userProviderRealm.setEmailVerified(Boolean.valueOf(true));
        userProviderRealm.setEnabled(Boolean.valueOf(true));
        RealmResource realmResource = this.adminClient.realm(this.nbc.providerRealmName());
        this.userIdProviderRealm = ApiUtil.createUserWithAdminClient((RealmResource)realmResource, (UserRepresentation)userProviderRealm);
        ApiUtil.resetUserPassword((UserResource)realmResource.users().get(this.userIdProviderRealm), (String)this.nbc.getUserPassword(), (boolean)false);
    }

    @Before
    public void addIdentityProviders() {
        this.log.debug((Object)("adding identity provider to realm " + this.nbc.consumerRealmName()));
        RealmResource realm = this.adminClient.realm(this.nbc.consumerRealmName());
        realm.identityProviders().create(this.nbc.setUpIdentityProvider()).close();
        this.log.debug((Object)("adding identity provider to realm " + this.nbc.subConsumerRealmName()));
        realm = this.adminClient.realm(this.nbc.subConsumerRealmName());
        realm.identityProviders().create(this.nbc.setUpConsumerIdentityProvider()).close();
    }

    @Before
    public void addClients() {
        this.addClientsToProviderAndConsumer();
    }

    @Before
    public void fetchConsumerRealmDetails() {
        RealmResource realmResourceConsumerRealm = this.adminClient.realm(this.nbc.consumerRealmName());
        this.realmIdConsumerRealm = realmResourceConsumerRealm.toRepresentation().getId();
        this.accountClientIdConsumerRealm = ((ClientRepresentation)this.adminClient.realm(this.nbc.consumerRealmName()).clients().findByClientId(ACCOUNT_CLIENT_NAME).get(0)).getId();
        RealmResource realmResourceSubConsumerRealm = this.adminClient.realm(this.nbc.subConsumerRealmName());
        this.accountClientIdSubConsumerRealm = ((ClientRepresentation)this.adminClient.realm(this.nbc.subConsumerRealmName()).clients().findByClientId(ACCOUNT_CLIENT_NAME).get(0)).getId();
    }

    @Before
    public void createNewRsaKeyForProviderRealm() {
        this.providerRealmManager = RealmManager.realm(this.adminClient.realm(this.nbc.providerRealmName()));
        this.providerId = this.providerRealmManager.generateNewRsaKey(KEY_PAIR, "rsa-test-2");
    }

    @Test
    public void postBackchannelLogoutWithSessionId() throws Exception {
        String brokerClientIdProviderRealm = this.getClientId(this.nbc.providerRealmName(), BROKER_CLIENT_ID);
        this.logInAsUserInIDPForFirstTime();
        String userIdConsumerRealm = this.getUserIdConsumerRealm();
        String sessionIdProviderRealm = this.assertProviderLoginEventIdpClient(this.userIdProviderRealm);
        String sessionIdConsumerRealm = this.assertConsumerLoginEventAccountManagement(userIdConsumerRealm);
        this.assertActiveSessionInClient(this.nbc.consumerRealmName(), this.accountClientIdConsumerRealm, userIdConsumerRealm, sessionIdConsumerRealm);
        String logoutTokenEncoded = this.getLogoutTokenEncodedAndSigned(this.userIdProviderRealm, sessionIdProviderRealm);
        this.oauth.realm(this.nbc.consumerRealmName());
        try (CloseableHttpResponse response = this.oauth.doBackchannelLogout(logoutTokenEncoded);){
            Assert.assertThat((Object)response, (Matcher)Matchers.statusCodeIsHC((Response.Status)Response.Status.OK));
        }
        this.assertConsumerLogoutEvent(sessionIdConsumerRealm, userIdConsumerRealm);
        this.assertNoSessionsInClient(this.nbc.consumerRealmName(), this.accountClientIdConsumerRealm, userIdConsumerRealm, sessionIdConsumerRealm);
        this.assertActiveSessionInClient(this.nbc.providerRealmName(), brokerClientIdProviderRealm, this.userIdProviderRealm, sessionIdProviderRealm);
    }

    @Test
    public void postBackchannelLogoutWithoutSessionId() throws Exception {
        String brokerClientIdProviderRealm = this.getClientId(this.nbc.providerRealmName(), BROKER_CLIENT_ID);
        this.logInAsUserInIDPForFirstTime();
        String userIdConsumerRealm = this.getUserIdConsumerRealm();
        String sessionIdProviderRealm = this.assertProviderLoginEventIdpClient(this.userIdProviderRealm);
        String sessionIdConsumerRealm = this.assertConsumerLoginEventAccountManagement(userIdConsumerRealm);
        this.assertActiveSessionInClient(this.nbc.consumerRealmName(), this.accountClientIdConsumerRealm, userIdConsumerRealm, sessionIdConsumerRealm);
        String logoutTokenEncoded = this.getLogoutTokenEncodedAndSigned(this.userIdProviderRealm);
        this.oauth.realm(this.nbc.consumerRealmName());
        try (CloseableHttpResponse response = this.oauth.doBackchannelLogout(logoutTokenEncoded);){
            Assert.assertThat((Object)response, (Matcher)Matchers.statusCodeIsHC((Response.Status)Response.Status.OK));
        }
        this.assertConsumerLogoutEvent(sessionIdConsumerRealm, userIdConsumerRealm);
        this.assertNoSessionsInClient(this.nbc.consumerRealmName(), this.accountClientIdConsumerRealm, userIdConsumerRealm, sessionIdConsumerRealm);
        this.assertActiveSessionInClient(this.nbc.providerRealmName(), brokerClientIdProviderRealm, this.userIdProviderRealm, sessionIdProviderRealm);
    }

    @Test
    public void postBackchannelLogoutWithoutLogoutToken() throws Exception {
        this.oauth.realm(this.nbc.consumerRealmName());
        try (CloseableHttpResponse response = this.oauth.doBackchannelLogout(null);){
            Assert.assertThat((Object)response, (Matcher)Matchers.statusCodeIsHC((Response.Status)Response.Status.BAD_REQUEST));
            Assert.assertThat((Object)response, (Matcher)Matchers.bodyHC((Matcher)CoreMatchers.containsString((String)"No logout token")));
        }
        this.events.expectLogoutError("invalid_token").realm(this.realmIdConsumerRealm).assertEvent();
    }

    @Test
    public void postBackchannelLogoutWithInvalidLogoutToken() throws Exception {
        String logoutTokenMissingContent = Base64Url.encode((byte[])JsonSerialization.writeValueAsBytes((Object)JsonSerialization.createObjectNode()));
        this.oauth.realm(this.nbc.consumerRealmName());
        try (CloseableHttpResponse response = this.oauth.doBackchannelLogout(logoutTokenMissingContent);){
            Assert.assertThat((Object)response, (Matcher)Matchers.statusCodeIsHC((Response.Status)Response.Status.BAD_REQUEST));
            Assert.assertThat((Object)response, (Matcher)Matchers.bodyHC((Matcher)CoreMatchers.containsString((String)LogoutTokenValidationCode.DECODE_TOKEN_FAILED.getErrorMessage())));
        }
        this.events.expectLogoutError("invalid_token").realm(this.realmIdConsumerRealm).assertEvent();
    }

    @Test
    public void postBackchannelLogoutWithSessionIdUserNotLoggedIn() throws Exception {
        String logoutTokenEncoded = this.getLogoutTokenEncodedAndSigned(this.userIdProviderRealm, UUID.randomUUID().toString());
        this.oauth.realm(this.nbc.consumerRealmName());
        try (CloseableHttpResponse response = this.oauth.doBackchannelLogout(logoutTokenEncoded);){
            Assert.assertThat((Object)response, (Matcher)Matchers.statusCodeIsHC((Response.Status)Response.Status.OK));
        }
    }

    @Test
    public void postBackchannelLogoutWithoutSessionIdUserNotLoggedIn() throws Exception {
        String logoutTokenEncoded = this.getLogoutTokenEncodedAndSigned(this.userIdProviderRealm);
        this.oauth.realm(this.nbc.consumerRealmName());
        try (CloseableHttpResponse response = this.oauth.doBackchannelLogout(logoutTokenEncoded);){
            Assert.assertThat((Object)response, (Matcher)Matchers.statusCodeIsHC((Response.Status)Response.Status.OK));
        }
    }

    @Test
    public void postBackchannelLogoutWithoutSessionIdUserDoesntExist() throws Exception {
        String logoutTokenEncoded = this.getLogoutTokenEncodedAndSigned(UUID.randomUUID().toString());
        this.oauth.realm(this.nbc.consumerRealmName());
        try (CloseableHttpResponse response = this.oauth.doBackchannelLogout(logoutTokenEncoded);){
            Assert.assertThat((Object)response, (Matcher)Matchers.statusCodeIsHC((Response.Status)Response.Status.OK));
        }
    }

    @Test
    public void postBackchannelLogoutWithSessionIdMultipleOpenSession() throws Exception {
        this.logInAsUserInIDPForFirstTime();
        String userIdConsumerRealm = this.getUserIdConsumerRealm();
        String brokerClientIdProviderRealm = this.getClientId(this.nbc.providerRealmName(), BROKER_CLIENT_ID);
        String sessionId1ProviderRealm = this.assertProviderLoginEventIdpClient(this.userIdProviderRealm);
        String sessionId1ConsumerRealm = this.assertConsumerLoginEventAccountManagement(userIdConsumerRealm);
        this.assertActiveSessionInClient(this.nbc.consumerRealmName(), this.accountClientIdConsumerRealm, userIdConsumerRealm, sessionId1ConsumerRealm);
        OAuthClient oauth2 = new OAuthClient();
        oauth2.init(this.driver2);
        oauth2.realm(this.nbc.consumerRealmName()).clientId(ACCOUNT_CLIENT_NAME).redirectUri(this.getAuthServerRoot() + "realms/" + this.nbc.consumerRealmName() + "/account").doLoginSocial(this.nbc.getIDPAlias(), this.nbc.getUserLogin(), this.nbc.getUserPassword());
        String sessionId2ProviderRealm = this.assertProviderLoginEventIdpClient(this.userIdProviderRealm);
        String sessionId2ConsumerRealm = this.assertConsumerLoginEventAccountManagement(userIdConsumerRealm);
        this.assertActiveSessionInClient(this.nbc.consumerRealmName(), this.accountClientIdConsumerRealm, userIdConsumerRealm, sessionId2ConsumerRealm);
        String logoutTokenEncoded = this.getLogoutTokenEncodedAndSigned(this.userIdProviderRealm, sessionId1ProviderRealm);
        this.oauth.realm(this.nbc.consumerRealmName());
        try (CloseableHttpResponse response = this.oauth.doBackchannelLogout(logoutTokenEncoded);){
            Assert.assertThat((Object)response, (Matcher)Matchers.statusCodeIsHC((Response.Status)Response.Status.OK));
        }
        this.assertConsumerLogoutEvent(sessionId1ConsumerRealm, userIdConsumerRealm);
        this.assertNoSessionsInClient(this.nbc.consumerRealmName(), this.accountClientIdConsumerRealm, userIdConsumerRealm, sessionId1ConsumerRealm);
        this.assertActiveSessionInClient(this.nbc.consumerRealmName(), this.accountClientIdConsumerRealm, userIdConsumerRealm, sessionId2ConsumerRealm);
        this.assertActiveSessionInClient(this.nbc.providerRealmName(), brokerClientIdProviderRealm, this.userIdProviderRealm, sessionId1ProviderRealm);
        this.assertActiveSessionInClient(this.nbc.providerRealmName(), brokerClientIdProviderRealm, this.userIdProviderRealm, sessionId2ProviderRealm);
    }

    @Test
    public void postBackchannelLogoutWithoutSessionIdMultipleOpenSession() throws Exception {
        this.logInAsUserInIDPForFirstTime();
        String userIdConsumerRealm = this.getUserIdConsumerRealm();
        String brokerClientIdProviderRealm = this.getClientId(this.nbc.providerRealmName(), BROKER_CLIENT_ID);
        String sessionId1ProviderRealm = this.assertProviderLoginEventIdpClient(this.userIdProviderRealm);
        String sessionId1ConsumerRealm = this.assertConsumerLoginEventAccountManagement(userIdConsumerRealm);
        this.assertActiveSessionInClient(this.nbc.consumerRealmName(), this.accountClientIdConsumerRealm, userIdConsumerRealm, sessionId1ConsumerRealm);
        this.loginWithSecondBrowser(this.nbc.getIDPAlias());
        String sessionId2ProviderRealm = this.assertProviderLoginEventIdpClient(this.userIdProviderRealm);
        String sessionId2ConsumerRealm = this.assertConsumerLoginEventAccountManagement(userIdConsumerRealm);
        this.assertActiveSessionInClient(this.nbc.consumerRealmName(), this.accountClientIdConsumerRealm, userIdConsumerRealm, sessionId2ConsumerRealm);
        String logoutTokenEncoded = this.getLogoutTokenEncodedAndSigned(this.userIdProviderRealm);
        this.oauth.realm(this.nbc.consumerRealmName());
        try (CloseableHttpResponse response = this.oauth.doBackchannelLogout(logoutTokenEncoded);){
            Assert.assertThat((Object)response, (Matcher)Matchers.statusCodeIsHC((Response.Status)Response.Status.OK));
        }
        List<String> expectedSessionIdsInLogoutEvents = Arrays.asList(sessionId1ConsumerRealm, sessionId2ConsumerRealm);
        this.assertConsumerLogoutEvents(expectedSessionIdsInLogoutEvents, userIdConsumerRealm);
        this.assertNoSessionsInClient(this.nbc.consumerRealmName(), this.accountClientIdConsumerRealm, userIdConsumerRealm, sessionId1ConsumerRealm);
        this.assertNoSessionsInClient(this.nbc.consumerRealmName(), this.accountClientIdConsumerRealm, userIdConsumerRealm, sessionId2ConsumerRealm);
        this.assertActiveSessionInClient(this.nbc.providerRealmName(), brokerClientIdProviderRealm, this.userIdProviderRealm, sessionId1ProviderRealm);
        this.assertActiveSessionInClient(this.nbc.providerRealmName(), brokerClientIdProviderRealm, this.userIdProviderRealm, sessionId2ProviderRealm);
    }

    @Test
    public void postBackchannelLogoutWithSessionIdMultipleOpenSessionDifferentIdentityProvider() throws Exception {
        IdentityProviderRepresentation identityProvider2 = this.addSecondIdentityProviderToConsumerRealm();
        String brokerClientIdProviderRealm = this.getClientId(this.nbc.providerRealmName(), BROKER_CLIENT_ID);
        this.logInAsUserInIDPForFirstTime();
        String userIdConsumerRealm = this.getUserIdConsumerRealm();
        this.adminClient.realm(this.nbc.consumerRealmName()).users().get(userIdConsumerRealm).resetPassword(CredentialBuilder.create().password(USER_PASSWORD_CONSUMER_REALM).build());
        String sessionId1ProviderRealm = this.assertProviderLoginEventIdpClient(this.userIdProviderRealm);
        String sessionId1ConsumerRealm = this.assertConsumerLoginEventAccountManagement(userIdConsumerRealm);
        this.assertActiveSessionInClient(this.nbc.consumerRealmName(), this.accountClientIdConsumerRealm, userIdConsumerRealm, sessionId1ConsumerRealm);
        OAuthClient oauth2 = this.loginWithSecondBrowser(identityProvider2.getDisplayName());
        this.linkUsers(oauth2);
        String sessionId2ProviderRealm = this.assertProviderLoginEventIdpClient(this.userIdProviderRealm);
        String sessionId2ConsumerRealm = this.assertConsumerLoginEventAccountManagement(userIdConsumerRealm);
        this.assertActiveSessionInClient(this.nbc.consumerRealmName(), this.accountClientIdConsumerRealm, userIdConsumerRealm, sessionId2ConsumerRealm);
        String logoutTokenEncoded = this.getLogoutTokenEncodedAndSigned(this.userIdProviderRealm, sessionId1ProviderRealm);
        this.oauth.realm(this.nbc.consumerRealmName());
        try (CloseableHttpResponse response = this.oauth.doBackchannelLogout(logoutTokenEncoded);){
            Assert.assertThat((Object)response, (Matcher)Matchers.statusCodeIsHC((Response.Status)Response.Status.OK));
        }
        this.assertConsumerLogoutEvent(sessionId1ConsumerRealm, userIdConsumerRealm);
        this.assertNoSessionsInClient(this.nbc.consumerRealmName(), this.accountClientIdConsumerRealm, userIdConsumerRealm, sessionId1ConsumerRealm);
        this.assertActiveSessionInClient(this.nbc.consumerRealmName(), this.accountClientIdConsumerRealm, userIdConsumerRealm, sessionId2ConsumerRealm);
        this.assertActiveSessionInClient(this.nbc.providerRealmName(), brokerClientIdProviderRealm, this.userIdProviderRealm, sessionId1ProviderRealm);
        this.assertActiveSessionInClient(this.nbc.providerRealmName(), brokerClientIdProviderRealm, this.userIdProviderRealm, sessionId2ProviderRealm);
    }

    @Test
    public void postBackchannelLogoutWithoutSessionIdMultipleOpenSessionDifferentIdentityProvider() throws Exception {
        IdentityProviderRepresentation identityProvider2 = this.addSecondIdentityProviderToConsumerRealm();
        String brokerClientIdProviderRealm = this.getClientId(this.nbc.providerRealmName(), BROKER_CLIENT_ID);
        this.logInAsUserInIDPForFirstTime();
        String userIdConsumerRealm = this.getUserIdConsumerRealm();
        this.adminClient.realm(this.nbc.consumerRealmName()).users().get(userIdConsumerRealm).resetPassword(CredentialBuilder.create().password(USER_PASSWORD_CONSUMER_REALM).build());
        String sessionId1ProviderRealm = this.assertProviderLoginEventIdpClient(this.userIdProviderRealm);
        String sessionId1ConsumerRealm = this.assertConsumerLoginEventAccountManagement(userIdConsumerRealm);
        this.assertActiveSessionInClient(this.nbc.consumerRealmName(), this.accountClientIdConsumerRealm, userIdConsumerRealm, sessionId1ConsumerRealm);
        OAuthClient oauth2 = this.loginWithSecondBrowser(identityProvider2.getDisplayName());
        this.linkUsers(oauth2);
        String sessionId2ProviderRealm = this.assertProviderLoginEventIdpClient(this.userIdProviderRealm);
        String sessionId2ConsumerRealm = this.assertConsumerLoginEventAccountManagement(userIdConsumerRealm);
        this.assertActiveSessionInClient(this.nbc.consumerRealmName(), this.accountClientIdConsumerRealm, userIdConsumerRealm, sessionId2ConsumerRealm);
        String logoutTokenEncoded = this.getLogoutTokenEncodedAndSigned(this.userIdProviderRealm);
        this.oauth.realm(this.nbc.consumerRealmName());
        try (CloseableHttpResponse response = this.oauth.doBackchannelLogout(logoutTokenEncoded);){
            Assert.assertThat((Object)response, (Matcher)Matchers.statusCodeIsHC((Response.Status)Response.Status.OK));
        }
        List<String> expectedSessionIdsInLogoutEvents = Arrays.asList(sessionId1ConsumerRealm, sessionId2ConsumerRealm);
        this.assertConsumerLogoutEvents(expectedSessionIdsInLogoutEvents, userIdConsumerRealm);
        this.assertNoSessionsInClient(this.nbc.consumerRealmName(), this.accountClientIdConsumerRealm, userIdConsumerRealm, sessionId1ConsumerRealm);
        this.assertNoSessionsInClient(this.nbc.consumerRealmName(), this.accountClientIdConsumerRealm, userIdConsumerRealm, sessionId2ConsumerRealm);
        this.assertActiveSessionInClient(this.nbc.providerRealmName(), brokerClientIdProviderRealm, this.userIdProviderRealm, sessionId1ProviderRealm);
        this.assertActiveSessionInClient(this.nbc.providerRealmName(), brokerClientIdProviderRealm, this.userIdProviderRealm, sessionId2ProviderRealm);
    }

    @Test
    public void postBackchannelLogoutOnDisabledClientReturnsNotImplemented() throws Exception {
        this.logInAsUserInIDPForFirstTime();
        String userIdConsumerRealm = this.getUserIdConsumerRealm();
        String sessionIdProviderRealm = this.assertProviderLoginEventIdpClient(this.userIdProviderRealm);
        String sessionIdConsumerRealm = this.assertConsumerLoginEventAccountManagement(userIdConsumerRealm);
        this.assertActiveSessionInClient(this.nbc.consumerRealmName(), this.accountClientIdConsumerRealm, userIdConsumerRealm, sessionIdConsumerRealm);
        String logoutTokenEncoded = this.getLogoutTokenEncodedAndSigned(this.userIdProviderRealm, sessionIdProviderRealm);
        this.disableClient(this.nbc.consumerRealmName(), this.accountClientIdConsumerRealm);
        this.oauth.realm(this.nbc.consumerRealmName());
        try (CloseableHttpResponse response = this.oauth.doBackchannelLogout(logoutTokenEncoded);){
            Assert.assertThat((Object)response, (Matcher)Matchers.statusCodeIsHC((Response.Status)Response.Status.NOT_IMPLEMENTED));
            Assert.assertThat((Object)response, (Matcher)Matchers.bodyHC((Matcher)CoreMatchers.containsString((String)"There was an error in the local logout")));
        }
        this.assertLogoutErrorEvent(this.nbc.consumerRealmName());
    }

    @Test
    public void postBackchannelLogoutNestedBrokering() throws Exception {
        String consumerClientId = this.getClientId(this.nbc.consumerRealmName(), "consumer-brokerapp");
        String brokerClientIdProviderRealm = this.getClientId(this.nbc.providerRealmName(), BROKER_CLIENT_ID);
        this.logInAsUserInNestedIDPForFirstTime();
        String userIdConsumerRealm = this.getUserIdConsumerRealm();
        String userIdSubConsumerRealm = this.getUserIdSubConsumerRealm();
        String sessionIdProviderRealm = this.assertProviderLoginEventIdpClient(this.userIdProviderRealm);
        String sessionIdConsumerRealm = this.assertConsumerLoginEvent(userIdConsumerRealm, "consumer-brokerapp");
        this.assertActiveSessionInClient(this.nbc.consumerRealmName(), consumerClientId, userIdConsumerRealm, sessionIdConsumerRealm);
        String sessionIdSubConsumerRealm = this.assertLoginEvent(userIdSubConsumerRealm, ACCOUNT_CLIENT_NAME, this.nbc.subConsumerRealmName());
        this.assertActiveSessionInClient(this.nbc.subConsumerRealmName(), this.accountClientIdSubConsumerRealm, userIdSubConsumerRealm, sessionIdSubConsumerRealm);
        String logoutTokenEncoded = this.getLogoutTokenEncodedAndSigned(this.userIdProviderRealm, sessionIdProviderRealm);
        this.oauth.realm(this.nbc.consumerRealmName());
        try (CloseableHttpResponse response = this.oauth.doBackchannelLogout(logoutTokenEncoded);){
            Assert.assertThat((Object)response, (Matcher)Matchers.statusCodeIsHC((Response.Status)Response.Status.OK));
        }
        this.assertConsumerLogoutEvent(sessionIdConsumerRealm, userIdConsumerRealm);
        this.assertLogoutEvent(sessionIdSubConsumerRealm, userIdSubConsumerRealm, this.nbc.subConsumerRealmName());
        this.assertNoSessionsInClient(this.nbc.consumerRealmName(), consumerClientId, userIdConsumerRealm, sessionIdConsumerRealm);
        this.assertNoSessionsInClient(this.nbc.subConsumerRealmName(), this.accountClientIdSubConsumerRealm, userIdSubConsumerRealm, sessionIdSubConsumerRealm);
        this.assertActiveSessionInClient(this.nbc.providerRealmName(), brokerClientIdProviderRealm, this.userIdProviderRealm, sessionIdProviderRealm);
    }

    @Test
    public void postBackchannelLogoutNestedBrokeringDownstreamLogoutOfSubConsumerFails() throws Exception {
        String consumerClientId = this.getClientId(this.nbc.consumerRealmName(), "consumer-brokerapp");
        this.logInAsUserInNestedIDPForFirstTime();
        String userIdConsumerRealm = this.getUserIdConsumerRealm();
        String userIdSubConsumerRealm = this.getUserIdSubConsumerRealm();
        String sessionIdProviderRealm = this.assertProviderLoginEventIdpClient(this.userIdProviderRealm);
        String sessionIdConsumerRealm = this.assertConsumerLoginEvent(userIdConsumerRealm, "consumer-brokerapp");
        this.assertActiveSessionInClient(this.nbc.consumerRealmName(), consumerClientId, userIdConsumerRealm, sessionIdConsumerRealm);
        String sessionIdSubConsumerRealm = this.assertLoginEvent(userIdSubConsumerRealm, ACCOUNT_CLIENT_NAME, this.nbc.subConsumerRealmName());
        this.assertActiveSessionInClient(this.nbc.subConsumerRealmName(), this.accountClientIdSubConsumerRealm, userIdSubConsumerRealm, sessionIdSubConsumerRealm);
        this.disableClient(this.nbc.subConsumerRealmName(), this.accountClientIdSubConsumerRealm);
        String logoutTokenEncoded = this.getLogoutTokenEncodedAndSigned(this.userIdProviderRealm, sessionIdProviderRealm);
        this.oauth.realm(this.nbc.consumerRealmName());
        try (CloseableHttpResponse response = this.oauth.doBackchannelLogout(logoutTokenEncoded);){
            Assert.assertThat((Object)response, (Matcher)Matchers.statusCodeIsHC((Response.Status)Response.Status.GATEWAY_TIMEOUT));
        }
        this.assertLogoutErrorEvent(this.nbc.subConsumerRealmName());
        this.assertConsumerLogoutEvent(sessionIdConsumerRealm, userIdConsumerRealm);
        this.assertNoSessionsInClient(this.nbc.consumerRealmName(), consumerClientId, userIdConsumerRealm, sessionIdConsumerRealm);
    }

    @Test
    public void postBackchannelLogoutNestedBrokeringRevokeOfflineSessions() throws Exception {
        String consumerClientId = this.getClientId(this.nbc.consumerRealmName(), "consumer-brokerapp");
        String brokerClientIdProviderRealm = this.getClientId(this.nbc.providerRealmName(), BROKER_CLIENT_ID);
        this.subConsumerIdpRequestsOfflineSessions();
        this.logInAsUserInNestedIDPForFirstTime();
        String userIdConsumerRealm = this.getUserIdConsumerRealm();
        String userIdSubConsumerRealm = this.getUserIdSubConsumerRealm();
        String sessionIdProviderRealm = this.assertProviderLoginEventIdpClient(this.userIdProviderRealm);
        String sessionIdConsumerRealm = this.assertConsumerLoginEvent(userIdConsumerRealm, "consumer-brokerapp");
        this.assertActiveSessionInClient(this.nbc.consumerRealmName(), consumerClientId, userIdConsumerRealm, sessionIdConsumerRealm);
        String sessionIdSubConsumerRealm = this.assertLoginEvent(userIdSubConsumerRealm, ACCOUNT_CLIENT_NAME, this.nbc.subConsumerRealmName());
        this.assertActiveSessionInClient(this.nbc.subConsumerRealmName(), this.accountClientIdSubConsumerRealm, userIdSubConsumerRealm, sessionIdSubConsumerRealm);
        String logoutTokenEncoded = this.getLogoutTokenEncodedAndSigned(this.userIdProviderRealm, sessionIdProviderRealm, true);
        this.oauth.realm(this.nbc.consumerRealmName());
        try (CloseableHttpResponse response = this.oauth.doBackchannelLogout(logoutTokenEncoded);){
            Assert.assertThat((Object)response, (Matcher)Matchers.statusCodeIsHC((Response.Status)Response.Status.OK));
        }
        this.assertConsumerLogoutEvent(sessionIdConsumerRealm, userIdConsumerRealm);
        this.assertLogoutEvent(sessionIdSubConsumerRealm, userIdSubConsumerRealm, this.nbc.subConsumerRealmName());
        this.assertNoSessionsInClient(this.nbc.consumerRealmName(), consumerClientId, userIdConsumerRealm, sessionIdConsumerRealm);
        this.assertNoOfflineSessionsInClient(this.nbc.consumerRealmName(), consumerClientId, userIdConsumerRealm);
        this.assertNoSessionsInClient(this.nbc.subConsumerRealmName(), this.accountClientIdSubConsumerRealm, userIdSubConsumerRealm, sessionIdSubConsumerRealm);
        this.assertActiveSessionInClient(this.nbc.providerRealmName(), brokerClientIdProviderRealm, this.userIdProviderRealm, sessionIdProviderRealm);
    }

    @Test
    public void postBackchannelLogoutNestedBrokeringDoNotRevokeOfflineSessions() throws Exception {
        String consumerClientId = this.getClientId(this.nbc.consumerRealmName(), "consumer-brokerapp");
        String brokerClientIdProviderRealm = this.getClientId(this.nbc.providerRealmName(), BROKER_CLIENT_ID);
        this.subConsumerIdpRequestsOfflineSessions();
        this.logInAsUserInNestedIDPForFirstTime();
        String userIdConsumerRealm = this.getUserIdConsumerRealm();
        String userIdSubConsumerRealm = this.getUserIdSubConsumerRealm();
        String sessionIdProviderRealm = this.assertProviderLoginEventIdpClient(this.userIdProviderRealm);
        String sessionIdConsumerRealm = this.assertConsumerLoginEvent(userIdConsumerRealm, "consumer-brokerapp");
        this.assertActiveSessionInClient(this.nbc.consumerRealmName(), consumerClientId, userIdConsumerRealm, sessionIdConsumerRealm);
        String sessionIdSubConsumerRealm = this.assertLoginEvent(userIdSubConsumerRealm, ACCOUNT_CLIENT_NAME, this.nbc.subConsumerRealmName());
        this.assertActiveSessionInClient(this.nbc.subConsumerRealmName(), this.accountClientIdSubConsumerRealm, userIdSubConsumerRealm, sessionIdSubConsumerRealm);
        String logoutTokenEncoded = this.getLogoutTokenEncodedAndSigned(this.userIdProviderRealm, sessionIdProviderRealm, false);
        this.oauth.realm(this.nbc.consumerRealmName());
        try (CloseableHttpResponse response = this.oauth.doBackchannelLogout(logoutTokenEncoded);){
            Assert.assertThat((Object)response, (Matcher)Matchers.statusCodeIsHC((Response.Status)Response.Status.OK));
        }
        this.assertConsumerLogoutEvent(sessionIdConsumerRealm, userIdConsumerRealm);
        this.assertLogoutEvent(sessionIdSubConsumerRealm, userIdSubConsumerRealm, this.nbc.subConsumerRealmName());
        this.assertNoSessionsInClient(this.nbc.consumerRealmName(), consumerClientId, userIdConsumerRealm, sessionIdConsumerRealm);
        this.assertActiveOfflineSessionInClient(this.nbc.consumerRealmName(), consumerClientId, userIdConsumerRealm);
        this.assertNoSessionsInClient(this.nbc.subConsumerRealmName(), this.accountClientIdSubConsumerRealm, userIdSubConsumerRealm, sessionIdSubConsumerRealm);
        this.assertActiveSessionInClient(this.nbc.providerRealmName(), brokerClientIdProviderRealm, this.userIdProviderRealm, sessionIdProviderRealm);
    }

    @Test
    public void postBackchannelLogoutNestedBrokeringRevokeOfflineSessionsWithoutActiveUserSession() throws Exception {
        String consumerClientId = this.getClientId(this.nbc.consumerRealmName(), "consumer-brokerapp");
        this.subConsumerIdpRequestsOfflineSessions();
        this.logInAsUserInNestedIDPForFirstTime();
        String userIdConsumerRealm = this.getUserIdConsumerRealm();
        String sessionIdProviderRealm = this.assertProviderLoginEventIdpClient(this.userIdProviderRealm);
        String sessionIdConsumerRealm = this.assertConsumerLoginEvent(userIdConsumerRealm, "consumer-brokerapp");
        this.assertActiveSessionInClient(this.nbc.consumerRealmName(), consumerClientId, userIdConsumerRealm, sessionIdConsumerRealm);
        this.logoutFromRealm(BrokerTestTools.getConsumerRoot(), this.nbc.consumerRealmName());
        this.assertNoSessionsInClient(this.nbc.consumerRealmName(), consumerClientId, userIdConsumerRealm, sessionIdConsumerRealm);
        this.assertActiveOfflineSessionInClient(this.nbc.consumerRealmName(), consumerClientId, userIdConsumerRealm);
        String logoutTokenEncoded = this.getLogoutTokenEncodedAndSigned(this.userIdProviderRealm, sessionIdProviderRealm, true);
        this.oauth.realm(this.nbc.consumerRealmName());
        try (CloseableHttpResponse response = this.oauth.doBackchannelLogout(logoutTokenEncoded);){
            Assert.assertThat((Object)response, (Matcher)Matchers.statusCodeIsHC((Response.Status)Response.Status.OK));
        }
        this.assertNoOfflineSessionsInClient(this.nbc.consumerRealmName(), consumerClientId, userIdConsumerRealm);
    }

    private void subConsumerIdpRequestsOfflineSessions() {
        IdentityProviderResource subConsumerIDPResource = this.adminClient.realm(this.nbc.subConsumerRealmName()).identityProviders().get(this.nbc.getSubConsumerIDPDisplayName());
        IdentityProviderRepresentation subConsumerIDP = subConsumerIDPResource.toRepresentation();
        Map config = subConsumerIDP.getConfig();
        config.put("defaultScope", (String)config.get("defaultScope") + " " + "offline_access");
        subConsumerIDPResource.update(subConsumerIDP);
    }

    private String getLogoutTokenEncodedAndSigned(String userId) throws IOException {
        return this.getLogoutTokenEncodedAndSigned(userId, null);
    }

    private String getLogoutTokenEncodedAndSigned(String userId, String sessionId) throws IOException {
        return this.getLogoutTokenEncodedAndSigned(userId, sessionId, false);
    }

    private String getLogoutTokenEncodedAndSigned(String userId, String sessionId, boolean revokeOfflineSessions) throws IOException {
        String keyId = this.adminClient.realm(this.nbc.providerRealmName()).keys().getKeyMetadata().getKeys().stream().filter(key -> this.providerId.equals(key.getProviderId())).findFirst().get().getKid();
        return LogoutTokenUtil.generateSignedLogoutToken(KEY_PAIR.getPrivate(), keyId, BrokerTestTools.getConsumerRoot() + "/auth/realms/" + this.nbc.providerRealmName(), this.nbc.getIDPClientIdInProviderRealm(), userId, sessionId, revokeOfflineSessions);
    }

    private String assertConsumerLoginEventAccountManagement(String userIdConsumerRealm) {
        return this.assertConsumerLoginEvent(userIdConsumerRealm, ACCOUNT_CLIENT_NAME);
    }

    private String assertConsumerLoginEvent(String userIdConsumerRealm, String clientId) {
        return this.assertLoginEvent(userIdConsumerRealm, clientId, this.nbc.consumerRealmName());
    }

    private String assertLoginEvent(String userId, String clientId, String realmName) {
        String sessionId = null;
        String realmId = this.adminClient.realm(realmName).toRepresentation().getId();
        List eventList = this.adminClient.realm(realmName).getEvents();
        Optional<EventRepresentation> loginEventOptional = eventList.stream().filter(event -> userId.equals(event.getUserId())).filter(event -> event.getType().equals(EventType.LOGIN.name())).findAny();
        if (loginEventOptional.isPresent()) {
            EventRepresentation loginEvent = loginEventOptional.get();
            this.events.expectLogin().realm(realmId).client(clientId).user(userId).removeDetail("code_id").removeDetail("redirect_uri").removeDetail("consent").assertEvent(loginEvent);
            sessionId = loginEvent.getSessionId();
        } else {
            Assert.fail((String)("No Login event found for user " + userId));
        }
        return sessionId;
    }

    private String assertProviderLoginEventIdpClient(String userIdProviderRealm) {
        return this.assertLoginEvent(userIdProviderRealm, BROKER_CLIENT_ID, this.nbc.providerRealmName());
    }

    private void assertConsumerLogoutEvent(String sessionIdConsumerRealm, String userIdConsumerRealm) {
        this.assertLogoutEvent(sessionIdConsumerRealm, userIdConsumerRealm, this.nbc.consumerRealmName());
    }

    private void assertLogoutEvent(String sessionId, String userId, String realmName) {
        String realmId = this.adminClient.realm(realmName).toRepresentation().getId();
        List eventList = this.adminClient.realm(realmName).getEvents();
        Optional<EventRepresentation> logoutEventOptional = eventList.stream().filter(event -> sessionId.equals(event.getSessionId())).findAny();
        if (logoutEventOptional.isPresent()) {
            EventRepresentation logoutEvent = logoutEventOptional.get();
            this.events.expectLogout(sessionId).realm(realmId).user(userId).removeDetail("redirect_uri").assertEvent(logoutEvent);
        } else {
            Assert.fail((String)("No Logout event found for session " + sessionId));
        }
    }

    private void assertLogoutErrorEvent(String realmName) {
        String realmId = this.adminClient.realm(realmName).toRepresentation().getId();
        List eventList = this.adminClient.realm(realmName).getEvents();
        Optional<EventRepresentation> logoutErrorEventOptional = eventList.stream().filter(event -> event.getError().equals("logout_failed")).findAny();
        if (logoutErrorEventOptional.isPresent()) {
            EventRepresentation logoutEvent = logoutErrorEventOptional.get();
            this.events.expectLogoutError("logout_failed").realm(realmId).assertEvent(logoutEvent);
        } else {
            Assert.fail((String)("No Logout error event found in realm " + realmName));
        }
    }

    private void assertConsumerLogoutEvents(List<String> sessionIdsConsumerRealm, String userIdConsumerRealm) {
        List consumerRealmEvents = this.adminClient.realm(this.nbc.consumerRealmName()).getEvents();
        for (String sessionId : sessionIdsConsumerRealm) {
            Optional<EventRepresentation> logoutEventOptional = consumerRealmEvents.stream().filter(event -> sessionId.equals(event.getSessionId())).findAny();
            if (logoutEventOptional.isPresent()) {
                EventRepresentation logoutEvent = logoutEventOptional.get();
                this.events.expectLogout(sessionId).realm(this.realmIdConsumerRealm).user(userIdConsumerRealm).removeDetail("redirect_uri").assertEvent(logoutEvent);
                continue;
            }
            Assert.fail((String)("No Logout event found for session " + sessionId));
        }
    }

    private String getUserIdConsumerRealm() {
        return this.getUserId(this.nbc.consumerRealmName());
    }

    private String getUserIdSubConsumerRealm() {
        return this.getUserId(this.nbc.subConsumerRealmName());
    }

    private String getUserId(String realmName) {
        RealmResource realmResourceConsumerRealm = this.adminClient.realm(realmName);
        return ((UserRepresentation)realmResourceConsumerRealm.users().list().get(0)).getId();
    }

    private void assertActiveSessionInClient(String realmName, String clientId, String userId, String sessionId) {
        List<UserSessionRepresentation> sessions = this.getClientSessions(realmName, clientId, userId, sessionId);
        Assert.assertThat((Object)sessions.size(), (Matcher)CoreMatchers.is((Object)1));
    }

    private void assertNoSessionsInClient(String realmName, String clientId, String userId, String sessionId) {
        List<UserSessionRepresentation> sessions = this.getClientSessions(realmName, clientId, userId, sessionId);
        Assert.assertThat((Object)sessions.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    private List<UserSessionRepresentation> getClientSessions(String realmName, String clientUuid, String userId, String sessionId) {
        return this.adminClient.realm(realmName).clients().get(clientUuid).getUserSessions(Integer.valueOf(0), Integer.valueOf(5)).stream().filter(s -> s.getUserId().equals(userId) && s.getId().equals(sessionId)).collect(Collectors.toList());
    }

    private void assertActiveOfflineSessionInClient(String realmName, String clientId, String userId) {
        List<UserSessionRepresentation> sessions = this.getOfflineClientSessions(realmName, clientId, userId);
        Assert.assertThat((Object)sessions.size(), (Matcher)CoreMatchers.is((Object)1));
    }

    private void assertNoOfflineSessionsInClient(String realmName, String clientId, String userId) {
        List<UserSessionRepresentation> sessions = this.getOfflineClientSessions(realmName, clientId, userId);
        Assert.assertThat((Object)sessions.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    private List<UserSessionRepresentation> getOfflineClientSessions(String realmName, String clientUuid, String userId) {
        return this.adminClient.realm(realmName).clients().get(clientUuid).getOfflineUserSessions(Integer.valueOf(0), Integer.valueOf(5)).stream().filter(s -> s.getUserId().equals(userId)).collect(Collectors.toList());
    }

    private IdentityProviderRepresentation addSecondIdentityProviderToConsumerRealm() {
        this.log.debug((Object)("adding second identity provider to realm " + this.nbc.consumerRealmName()));
        IdentityProviderRepresentation identityProvider2 = this.nbc.setUpIdentityProvider();
        identityProvider2.setAlias(identityProvider2.getAlias() + "2");
        identityProvider2.setDisplayName(identityProvider2.getDisplayName() + "2");
        Map config = identityProvider2.getConfig();
        config.put("clientId", BROKER_CLIENT_ID);
        this.adminClient.realm(this.nbc.consumerRealmName()).identityProviders().create(identityProvider2).close();
        ClientResource ipdClientResource = this.getByClientId(this.nbc.providerRealmName(), this.nbc.getIDPClientIdInProviderRealm());
        ClientRepresentation clientRepresentation = ipdClientResource.toRepresentation();
        clientRepresentation.getRedirectUris().add(BrokerTestTools.getConsumerRoot() + "/auth/realms/" + this.nbc.consumerRealmName() + "/broker/" + identityProvider2.getAlias() + "/endpoint/*");
        ipdClientResource.update(clientRepresentation);
        return identityProvider2;
    }

    private ClientResource getByClientId(String realmName, String clientId) {
        ClientsResource c = this.adminClient.realm(realmName).clients();
        ClientResource ipdClientResource = c.findByClientId(clientId).stream().findAny().map(rep -> c.get(rep.getId())).orElseThrow(IllegalArgumentException::new);
        return ipdClientResource;
    }

    private void disableClient(String realmName, String clientUuid) {
        ClientResource accountClient = this.adminClient.realm(realmName).clients().get(clientUuid);
        ClientRepresentation clientRepresentation = accountClient.toRepresentation();
        clientRepresentation.setEnabled(Boolean.valueOf(false));
        accountClient.update(clientRepresentation);
    }

    private OAuthClient loginWithSecondBrowser(String identityProviderDisplayName) {
        OAuthClient oauth2 = new OAuthClient();
        oauth2.init(this.driver2);
        oauth2.realm(this.nbc.consumerRealmName()).clientId(ACCOUNT_CLIENT_NAME).redirectUri(this.getAuthServerRoot() + "realms/" + this.nbc.consumerRealmName() + "/account").doLoginSocial(identityProviderDisplayName, this.nbc.getUserLogin(), this.nbc.getUserPassword());
        return oauth2;
    }

    private void linkUsers(OAuthClient oauth) {
        oauth.updateAccountInformation(this.nbc.getUserLogin(), this.nbc.getUserEmail());
        oauth.linkUsers(this.nbc.getUserLogin(), USER_PASSWORD_CONSUMER_REALM);
    }

    private String getClientId(String realm, String clientId) {
        return this.adminClient.realm(realm).clients().findByClientId(clientId).stream().findAny().map(ClientRepresentation::getId).orElse(null);
    }
}

