/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.oauth;

import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.UriBuilder;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.protocol.oidc.utils.OIDCResponseMode;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.pages.ErrorPage;
import org.keycloak.testsuite.pages.PageUtils;
import org.keycloak.testsuite.util.ClientManager;
import org.keycloak.testsuite.util.OAuthClient;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;

public class AuthorizationCodeTest
extends AbstractKeycloakTest {
    @Rule
    public AssertEvents events = new AssertEvents(this);
    @Page
    private ErrorPage errorPage;

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation realmRepresentation = AbstractAdminTest.loadJson(this.getClass().getResourceAsStream("/testrealm.json"), RealmRepresentation.class);
        testRealms.add(realmRepresentation);
    }

    @Before
    public void clientConfiguration() {
        this.oauth.responseType("code");
        this.oauth.responseMode(null);
        this.oauth.stateParamRandom();
    }

    @Test
    public void authorizationRequest() throws IOException {
        this.oauth.stateParamHardcoded("OpenIdConnect.AuthenticationProperties=2302984sdlk");
        OAuthClient.AuthorizationEndpointResponse response = this.oauth.doLogin("test-user@localhost", "password");
        Assert.assertTrue((boolean)response.isRedirected());
        Assert.assertNotNull((Object)response.getCode());
        Assert.assertEquals((Object)"OpenIdConnect.AuthenticationProperties=2302984sdlk", (Object)response.getState());
        Assert.assertNull((Object)response.getError());
        String codeId = (String)this.events.expectLogin().assertEvent().getDetails().get("code_id");
    }

    @Test
    public void authorizationRequestInstalledApp() throws IOException {
        ClientManager.realm(this.adminClient.realm("test")).clientId("test-app").addRedirectUris("urn:ietf:wg:oauth:2.0:oob");
        this.oauth.redirectUri("urn:ietf:wg:oauth:2.0:oob");
        this.oauth.doLogin("test-user@localhost", "password");
        String title = PageUtils.getPageTitle((WebDriver)this.driver);
        Assert.assertEquals((Object)"Success code", (Object)title);
        this.driver.findElement(By.id((String)"code")).getAttribute("value");
        this.events.expectLogin().detail("redirect_uri", OAuthClient.AUTH_SERVER_ROOT + "/realms/test/protocol/openid-connect/oauth/oob").assertEvent().getDetails().get("code_id");
        ClientManager.realm(this.adminClient.realm("test")).clientId("test-app").removeRedirectUris("urn:ietf:wg:oauth:2.0:oob");
    }

    @Test
    public void authorizationValidRedirectUri() throws IOException {
        ClientManager.realm(this.adminClient.realm("test")).clientId("test-app").addRedirectUris(this.oauth.getRedirectUri());
        OAuthClient.AuthorizationEndpointResponse response = this.oauth.doLogin("test-user@localhost", "password");
        Assert.assertTrue((boolean)response.isRedirected());
        Assert.assertNotNull((Object)response.getCode());
        String codeId = (String)this.events.expectLogin().assertEvent().getDetails().get("code_id");
    }

    @Test
    public void testInvalidRedirectUri() {
        ClientManager.realm(this.adminClient.realm("test")).clientId("test-app").addRedirectUris(this.oauth.getRedirectUri());
        this.oauth.redirectUri(this.oauth.getRedirectUri() + "%20test");
        this.oauth.openLoginForm();
        Assert.assertTrue((boolean)this.errorPage.isCurrent());
        Assert.assertEquals((Object)"Invalid parameter: redirect_uri", (Object)this.errorPage.getError());
        this.oauth.redirectUri("ZAP%25n%25s%25n%25s%25n%25s%25n%25s%25n%25s%25n%25s%25n%25s%25n%25s%25n%25s%25n%25s%25n%25s%25n%25s%25n%25s%25n%25s%25n%25s%25n%25s%25n%25s%25n%25s%25n%25s%25n%25s%0A");
        this.oauth.openLoginForm();
        Assert.assertTrue((boolean)this.errorPage.isCurrent());
        Assert.assertEquals((Object)"Invalid parameter: redirect_uri", (Object)this.errorPage.getError());
    }

    @Test
    public void authorizationRequestNoState() throws IOException {
        this.oauth.stateParamHardcoded(null);
        OAuthClient.AuthorizationEndpointResponse response = this.oauth.doLogin("test-user@localhost", "password");
        Assert.assertTrue((boolean)response.isRedirected());
        Assert.assertNotNull((Object)response.getCode());
        Assert.assertNull((Object)response.getState());
        Assert.assertNull((Object)response.getError());
        String codeId = (String)this.events.expectLogin().assertEvent().getDetails().get("code_id");
    }

    @Test
    public void authorizationRequestInvalidResponseType() throws IOException {
        this.oauth.responseType("tokenn");
        UriBuilder b = UriBuilder.fromUri((String)this.oauth.getLoginFormUrl());
        this.driver.navigate().to(b.build(new Object[0]).toURL());
        OAuthClient.AuthorizationEndpointResponse errorResponse = new OAuthClient.AuthorizationEndpointResponse(this.oauth);
        Assert.assertTrue((boolean)errorResponse.isRedirected());
        Assert.assertEquals((Object)errorResponse.getError(), (Object)"unsupported_response_type");
        this.events.expectLogin().error("invalid_request").user((String)null).session((String)null).clearDetails().detail("response_type", "tokenn").assertEvent();
    }

    @Test
    public void authorizationRequestFormPostResponseMode() throws IOException {
        this.oauth.responseMode(OIDCResponseMode.FORM_POST.value());
        this.oauth.stateParamHardcoded("OpenIdConnect.AuthenticationProperties=2302984sdlk");
        this.oauth.doLoginGrant("test-user@localhost", "password");
        String sources = this.driver.getPageSource();
        System.out.println(sources);
        String code = this.driver.findElement(By.id((String)"code")).getText();
        String state = this.driver.findElement(By.id((String)"state")).getText();
        Assert.assertEquals((Object)"OpenIdConnect.AuthenticationProperties=2302984sdlk", (Object)state);
        String codeId = (String)this.events.expectLogin().assertEvent().getDetails().get("code_id");
    }

    @Test
    public void authorizationRequestFormPostResponseModeWithCustomState() throws IOException {
        this.oauth.responseMode(OIDCResponseMode.FORM_POST.value());
        this.oauth.stateParamHardcoded("\"><foo>bar_baz(2)far</foo>");
        this.oauth.doLoginGrant("test-user@localhost", "password");
        String sources = this.driver.getPageSource();
        System.out.println(sources);
        String code = this.driver.findElement(By.id((String)"code")).getText();
        String state = this.driver.findElement(By.id((String)"state")).getText();
        Assert.assertEquals((Object)"\"><foo>bar_baz(2)far</foo>", (Object)state);
        String codeId = (String)this.events.expectLogin().assertEvent().getDetails().get("code_id");
    }

    @Test
    public void authorizationRequestFragmentResponseModeNotKept() throws Exception {
        this.oauth.responseMode(OIDCResponseMode.FRAGMENT.value());
        OAuthClient.AuthorizationEndpointResponse response = this.oauth.doLogin("test-user@localhost", "password");
        Assert.assertNotNull((Object)response.getCode());
        Assert.assertNotNull((Object)response.getState());
        URI currentUri = new URI(this.driver.getCurrentUrl());
        Assert.assertNull((Object)currentUri.getRawQuery());
        Assert.assertNotNull((Object)currentUri.getRawFragment());
        this.oauth.responseMode(null);
        this.oauth.openLoginForm();
        response = new OAuthClient.AuthorizationEndpointResponse(this.oauth);
        Assert.assertNotNull((Object)response.getCode());
        Assert.assertNotNull((Object)response.getState());
        currentUri = new URI(this.driver.getCurrentUrl());
        Assert.assertNotNull((Object)currentUri.getRawQuery());
        Assert.assertNull((Object)currentUri.getRawFragment());
    }

    @Test
    public void authorizationRequestParamsMoreThanOnce() throws IOException {
        this.oauth.stateParamHardcoded("OpenIdConnect.AuthenticationProperties=2302984sdlk");
        HashMap extraParams = new HashMap();
        this.oauth.addCustomParameter("scope", "read_write").addCustomParameter("state", "abcdefg").addCustomParameter("scope", "pop push");
        this.oauth.openLoginForm();
        Assert.assertEquals((Object)"invalid_request", this.oauth.getCurrentQuery().get("error"));
        Assert.assertEquals((Object)"duplicated parameter", this.oauth.getCurrentQuery().get("error_description"));
        this.events.expectLogin().error("invalid_request").user((String)null).session((String)null).clearDetails().assertEvent();
    }

    @Test
    public void authorizationRequestClientParamsMoreThanOnce() throws IOException {
        this.oauth.stateParamHardcoded("OpenIdConnect.AuthenticationProperties=2302984sdlk");
        this.oauth.addCustomParameter("scope", "read_write").addCustomParameter("client_id", "client2client").addCustomParameter("redirect_uri", "https://www.example.com").addCustomParameter("state", "abcdefg").addCustomParameter("scope", "pop push");
        this.oauth.openLoginForm();
        Assert.assertTrue((boolean)this.errorPage.isCurrent());
        Assert.assertEquals((Object)"Invalid Request", (Object)this.errorPage.getError());
        this.events.expectLogin().error("invalid_request").user((String)null).session((String)null).client((String)null).clearDetails().assertEvent();
    }
}

