/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.oauth;

import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.util.OAuthClient;
import org.openqa.selenium.By;

public class AccessTokenDuplicateEmailsNotCleanedUpTest
extends AbstractKeycloakTest {
    @Rule
    public AssertEvents events = new AssertEvents(this);

    @Override
    public void beforeAbstractKeycloakTest() throws Exception {
        super.beforeAbstractKeycloakTest();
    }

    @Before
    public void clientConfiguration() {
        this.oauth.clientId("test-app");
        this.oauth.realm("test-duplicate-emails");
        RealmRepresentation realmRep = new RealmRepresentation();
        realmRep.setLoginWithEmailAllowed(Boolean.valueOf(true));
        this.adminClient.realm("test-duplicate-emails").update(realmRep);
    }

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation realm = AbstractAdminTest.loadJson(this.getClass().getResourceAsStream("/testrealm-duplicate-emails.json"), RealmRepresentation.class);
        testRealms.add(realm);
    }

    @Test
    public void loginWithNonDuplicateEmail() throws Exception {
        this.oauth.doLogin("non-duplicate-email-user@localhost", "password");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse response = this.oauth.doAccessTokenRequest(code, "password");
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        AccessToken token = this.oauth.verifyToken(response.getAccessToken());
        Assert.assertEquals((Object)ApiUtil.findUserByUsername((RealmResource)this.adminClient.realm("test-duplicate-emails"), (String)"non-duplicate-email-user").getId(), (Object)token.getSubject());
    }

    @Test
    public void loginWithDuplicateEmail() throws Exception {
        this.oauth.doLogin("duplicate-email-user@localhost", "password");
        Assert.assertEquals((Object)"Username already exists.", (Object)this.driver.findElement(By.className((String)"kc-feedback-text")).getText());
    }

    @Test
    public void loginWithUserHavingDuplicateEmailByUsername() throws Exception {
        this.oauth.doLogin("duplicate-email-user1", "password");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse response = this.oauth.doAccessTokenRequest(code, "password");
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        AccessToken token = this.oauth.verifyToken(response.getAccessToken());
        Assert.assertEquals((Object)ApiUtil.findUserByUsername((RealmResource)this.adminClient.realm("test-duplicate-emails"), (String)"duplicate-email-user1").getId(), (Object)token.getSubject());
        Assert.assertEquals((Object)"duplicate-email-user@localhost", (Object)token.getEmail());
    }
}

