/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.common.util.Time;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserLoginFailureModel;
import org.keycloak.models.UserManager;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.ResetTimeOffsetEvent;
import org.keycloak.provider.ProviderEvent;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.sessions.CommonClientSessionModel;
import org.keycloak.testsuite.AbstractTestRealmKeycloakTest;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.arquillian.annotation.ModelTest;
import org.keycloak.testsuite.runonserver.RunOnServer;
import org.keycloak.testsuite.util.InfinispanTestTimeServiceRule;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class UserSessionProviderTest
extends AbstractTestRealmKeycloakTest {
    @Rule
    public InfinispanTestTimeServiceRule ispnTestTimeService = new InfinispanTestTimeServiceRule(this);

    public static void setupRealm(KeycloakSession session) {
        RealmModel realm = session.realms().getRealmByName("test");
        UserModel user1 = session.users().addUser(realm, "user1");
        user1.setEmail("user1@localhost");
        UserModel user2 = session.users().addUser(realm, "user2");
        user2.setEmail("user2@localhost");
    }

    @Before
    public void before() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel realm = session.realms().getRealmByName("test");
            realm = session.realms().getRealm("test");
            session.users().addUser(realm, "user1").setEmail("user1@localhost");
            session.users().addUser(realm, "user2").setEmail("user2@localhost");
        });
    }

    @After
    public void after() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel realm = session.realms().getRealmByName("test");
            session.sessions().removeUserSessions(realm);
            UserModel user1 = session.users().getUserByUsername(realm, "user1");
            UserModel user2 = session.users().getUserByUsername(realm, "user2");
            UserManager um = new UserManager(session);
            if (user1 != null) {
                um.removeUser(realm, user1);
            }
            if (user2 != null) {
                um.removeUser(realm, user2);
            }
        });
    }

    @Test
    @ModelTest
    public void testCreateSessions(KeycloakSession session) {
        int started = Time.currentTime();
        RealmModel realm = session.realms().getRealmByName("test");
        UserSessionModel[] sessions = UserSessionProviderTest.createSessions(session);
        UserSessionProviderTest.assertSession(session.sessions().getUserSession(realm, sessions[0].getId()), session.users().getUserByUsername(realm, "user1"), "127.0.0.1", started, started, "test-app", "third-party");
        UserSessionProviderTest.assertSession(session.sessions().getUserSession(realm, sessions[1].getId()), session.users().getUserByUsername(realm, "user1"), "127.0.0.2", started, started, "test-app");
        UserSessionProviderTest.assertSession(session.sessions().getUserSession(realm, sessions[2].getId()), session.users().getUserByUsername(realm, "user2"), "127.0.0.3", started, started, "test-app");
    }

    @Test
    @ModelTest
    public void testUpdateSession(KeycloakSession session) {
        RealmModel realm = session.realms().getRealmByName("test");
        UserSessionModel[] sessions = UserSessionProviderTest.createSessions(session);
        int lastRefresh = Time.currentTime();
        session.sessions().getUserSession(realm, sessions[0].getId()).setLastSessionRefresh(lastRefresh);
        Assert.assertEquals((long)lastRefresh, (long)session.sessions().getUserSession(realm, sessions[0].getId()).getLastSessionRefresh());
    }

    @Test
    @ModelTest
    public void testUpdateSessionInSameTransaction(KeycloakSession session) {
        RealmModel realm = session.realms().getRealmByName("test");
        UserSessionModel[] sessions = UserSessionProviderTest.createSessions(session);
        int lastRefresh = Time.currentTime();
        session.sessions().getUserSession(realm, sessions[0].getId()).setLastSessionRefresh(lastRefresh);
        Assert.assertEquals((long)lastRefresh, (long)session.sessions().getUserSession(realm, sessions[0].getId()).getLastSessionRefresh());
    }

    @Test
    @ModelTest
    public void testRestartSession(KeycloakSession session) {
        RealmModel realm = session.realms().getRealmByName("test");
        int started = Time.currentTime();
        UserSessionModel[] sessions = UserSessionProviderTest.createSessions(session);
        Time.setOffset((int)100);
        UserSessionModel userSession = session.sessions().getUserSession(realm, sessions[0].getId());
        UserSessionProviderTest.assertSession(userSession, session.users().getUserByUsername(realm, "user1"), "127.0.0.1", started, started, "test-app", "third-party");
        userSession.restartSession(realm, session.users().getUserByUsername(realm, "user2"), "user2", "127.0.0.6", "form", true, null, null);
        userSession = session.sessions().getUserSession(realm, sessions[0].getId());
        UserSessionProviderTest.assertSession(userSession, session.users().getUserByUsername(realm, "user2"), "127.0.0.6", started + 100, started + 100, new String[0]);
        Time.setOffset((int)0);
    }

    @Test
    @ModelTest
    public void testCreateClientSession(KeycloakSession session) {
        RealmModel realm = session.realms().getRealmByName("test");
        UserSessionModel[] sessions = UserSessionProviderTest.createSessions(session);
        Map clientSessions = session.sessions().getUserSession(realm, sessions[0].getId()).getAuthenticatedClientSessions();
        Assert.assertEquals((long)2L, (long)clientSessions.size());
        String clientUUID = realm.getClientByClientId("test-app").getId();
        AuthenticatedClientSessionModel session1 = (AuthenticatedClientSessionModel)clientSessions.get(clientUUID);
        Assert.assertNull((Object)session1.getAction());
        Assert.assertEquals((Object)realm.getClientByClientId("test-app").getClientId(), (Object)session1.getClient().getClientId());
        Assert.assertEquals((Object)sessions[0].getId(), (Object)session1.getUserSession().getId());
        Assert.assertEquals((Object)"http://redirect", (Object)session1.getRedirectUri());
        Assert.assertEquals((Object)"state", (Object)session1.getNote("state"));
    }

    @Test
    @ModelTest
    public void testUpdateClientSession(KeycloakSession session) {
        RealmModel realm = session.realms().getRealmByName("test");
        UserSessionModel[] sessions = UserSessionProviderTest.createSessions(session);
        String userSessionId = sessions[0].getId();
        String clientUUID = realm.getClientByClientId("test-app").getId();
        UserSessionModel userSession = session.sessions().getUserSession(realm, userSessionId);
        AuthenticatedClientSessionModel clientSession = (AuthenticatedClientSessionModel)userSession.getAuthenticatedClientSessions().get(clientUUID);
        int time = clientSession.getTimestamp();
        Assert.assertNull((Object)clientSession.getAction());
        clientSession.setAction(CommonClientSessionModel.Action.LOGGED_OUT.name());
        clientSession.setTimestamp(time + 10);
        AuthenticatedClientSessionModel updated = (AuthenticatedClientSessionModel)session.sessions().getUserSession(realm, userSessionId).getAuthenticatedClientSessions().get(clientUUID);
        Assert.assertEquals((Object)CommonClientSessionModel.Action.LOGGED_OUT.name(), (Object)updated.getAction());
        Assert.assertEquals((long)(time + 10), (long)updated.getTimestamp());
    }

    @Test
    @ModelTest
    public void testUpdateClientSessionWithGetByClientId(KeycloakSession session) {
        RealmModel realm = session.realms().getRealmByName("test");
        UserSessionModel[] sessions = UserSessionProviderTest.createSessions(session);
        String userSessionId = sessions[0].getId();
        String clientUUID = realm.getClientByClientId("test-app").getId();
        UserSessionModel userSession = session.sessions().getUserSession(realm, userSessionId);
        AuthenticatedClientSessionModel clientSession = userSession.getAuthenticatedClientSessionByClient(clientUUID);
        int time = clientSession.getTimestamp();
        Assert.assertNull((Object)clientSession.getAction());
        clientSession.setAction(CommonClientSessionModel.Action.LOGGED_OUT.name());
        clientSession.setTimestamp(time + 10);
        AuthenticatedClientSessionModel updated = session.sessions().getUserSession(realm, userSessionId).getAuthenticatedClientSessionByClient(clientUUID);
        Assert.assertEquals((Object)CommonClientSessionModel.Action.LOGGED_OUT.name(), (Object)updated.getAction());
        Assert.assertEquals((long)(time + 10), (long)updated.getTimestamp());
    }

    @Test
    @ModelTest
    public void testUpdateClientSessionInSameTransaction(KeycloakSession session) {
        RealmModel realm = session.realms().getRealmByName("test");
        UserSessionModel[] sessions = UserSessionProviderTest.createSessions(session);
        String userSessionId = sessions[0].getId();
        String clientUUID = realm.getClientByClientId("test-app").getId();
        UserSessionModel userSession = session.sessions().getUserSession(realm, userSessionId);
        AuthenticatedClientSessionModel clientSession = userSession.getAuthenticatedClientSessionByClient(clientUUID);
        clientSession.setAction(CommonClientSessionModel.Action.LOGGED_OUT.name());
        clientSession.setNote("foo", "bar");
        AuthenticatedClientSessionModel updated = session.sessions().getUserSession(realm, userSessionId).getAuthenticatedClientSessionByClient(clientUUID);
        Assert.assertEquals((Object)CommonClientSessionModel.Action.LOGGED_OUT.name(), (Object)updated.getAction());
        Assert.assertEquals((Object)"bar", (Object)updated.getNote("foo"));
    }

    @Test
    @ModelTest
    public void testGetUserSessions(KeycloakSession session) {
        RealmModel realm = session.realms().getRealmByName("test");
        UserSessionModel[] sessions = UserSessionProviderTest.createSessions(session);
        UserSessionProviderTest.assertSessions(session.sessions().getUserSessionsStream(realm, session.users().getUserByUsername(realm, "user1")).collect(Collectors.toList()), sessions[0], sessions[1]);
        UserSessionProviderTest.assertSessions(session.sessions().getUserSessionsStream(realm, session.users().getUserByUsername(realm, "user2")).collect(Collectors.toList()), sessions[2]);
    }

    @Test
    @ModelTest
    public void testRemoveUserSessionsByUser(KeycloakSession session) {
        RealmModel realm = session.realms().getRealmByName("test");
        UserSessionProviderTest.createSessions(session);
        Map<String, Integer> clientSessionsKept = session.sessions().getUserSessionsStream(realm, session.users().getUserByUsername(realm, "user2")).collect(Collectors.toMap(model -> model.getId(), model -> model.getAuthenticatedClientSessions().keySet().size()));
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), kcSession -> kcSession.sessions().removeUserSessions(realm, kcSession.users().getUserByUsername(realm, "user1")));
        Assert.assertEquals((long)0L, (long)session.sessions().getUserSessionsStream(realm, session.users().getUserByUsername(realm, "user1")).count());
        List userSessions = session.sessions().getUserSessionsStream(realm, session.users().getUserByUsername(realm, "user2")).collect(Collectors.toList());
        Assert.assertSame((Object)userSessions.size(), (Object)1);
        for (UserSessionModel userSession : userSessions) {
            Assert.assertEquals((long)clientSessionsKept.get(userSession.getId()).intValue(), (long)userSession.getAuthenticatedClientSessions().size());
        }
    }

    @Test
    @ModelTest
    public void testRemoveUserSession(KeycloakSession session) {
        RealmModel realm = session.realms().getRealmByName("test");
        UserSessionModel userSession = UserSessionProviderTest.createSessions(session)[0];
        session.sessions().removeUserSession(realm, userSession);
        Assert.assertNull((Object)session.sessions().getUserSession(realm, userSession.getId()));
    }

    @Test
    @ModelTest
    public void testRemoveUserSessionsByRealm(KeycloakSession session) {
        RealmModel realm = session.realms().getRealmByName("test");
        UserSessionProviderTest.createSessions(session);
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), kcSession -> kcSession.sessions().removeUserSessions(realm));
        Assert.assertEquals((long)0L, (long)session.sessions().getUserSessionsStream(realm, session.users().getUserByUsername(realm, "user1")).count());
        Assert.assertEquals((long)0L, (long)session.sessions().getUserSessionsStream(realm, session.users().getUserByUsername(realm, "user2")).count());
    }

    @Test
    @ModelTest
    public void testOnClientRemoved(KeycloakSession session) {
        Set clientUUIDS;
        RealmModel realm = session.realms().getRealmByName("test");
        UserSessionModel[] sessions = UserSessionProviderTest.createSessions(session);
        String thirdPartyClientUUID = realm.getClientByClientId("third-party").getId();
        HashMap clientSessionsKept = new HashMap();
        for (UserSessionModel s : sessions) {
            clientUUIDS = new HashSet(s.getAuthenticatedClientSessions().keySet());
            clientUUIDS.remove(thirdPartyClientUUID);
            clientSessionsKept.put(s.getId(), clientUUIDS);
        }
        realm.removeClient(thirdPartyClientUUID);
        for (UserSessionModel s : sessions) {
            s = session.sessions().getUserSession(realm, s.getId());
            clientUUIDS = s.getAuthenticatedClientSessions().keySet();
            Assert.assertEquals(clientUUIDS, clientSessionsKept.get(s.getId()));
        }
        realm.addClient("third-party");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @ModelTest
    public void testRemoveUserSessionsByExpired(KeycloakSession session) {
        try {
            RealmModel realm = session.realms().getRealmByName("test");
            ClientModel client = realm.getClientByClientId("test-app");
            HashSet validUserSessions = new HashSet();
            HashSet validClientSessions = new HashSet();
            HashSet expiredUserSessions = new HashSet();
            KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), session1 -> {
                Time.setOffset((int)(-(realm.getSsoSessionMaxLifespan() + 1)));
                UserSessionModel userSession = session1.sessions().createUserSession(realm, session1.users().getUserByUsername(realm, "user1"), "user1", "127.0.0.1", "form", false, null, null);
                expiredUserSessions.add(userSession.getId());
                AuthenticatedClientSessionModel clientSession = session1.sessions().createClientSession(realm, client, userSession);
                Assert.assertEquals((Object)userSession, (Object)clientSession.getUserSession());
            });
            KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), session1 -> {
                Time.setOffset((int)(-(realm.getSsoSessionIdleTimeout() + 180 + 1)));
                UserSessionModel s = session1.sessions().createUserSession(realm, session1.users().getUserByUsername(realm, "user2"), "user2", "127.0.0.1", "form", false, null, null);
                expiredUserSessions.add(s.getId());
            });
            Time.setOffset((int)0);
            KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), session1 -> {
                UserSessionModel userSession = session1.sessions().createUserSession(realm, session1.users().getUserByUsername(realm, "user1"), "user1", "127.0.0.1", "form", false, null, null);
                validUserSessions.add(userSession.getId());
                validClientSessions.add(session1.sessions().createClientSession(realm, client, userSession).getId());
            });
            KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), session1 -> session1.sessions().removeExpired(realm));
            for (String e : expiredUserSessions) {
                Assert.assertNull((Object)session.sessions().getUserSession(realm, e));
            }
            for (String v : validUserSessions) {
                UserSessionModel userSessionLoaded = session.sessions().getUserSession(realm, v);
                Assert.assertNotNull((Object)userSessionLoaded);
                AuthenticatedClientSessionModel clientSessionModel = (AuthenticatedClientSessionModel)userSessionLoaded.getAuthenticatedClientSessions().get(client.getId());
                Assert.assertNotNull((Object)clientSessionModel);
                Assert.assertTrue((boolean)validClientSessions.contains(clientSessionModel.getId()));
            }
        }
        finally {
            Time.setOffset((int)0);
            session.getKeycloakSessionFactory().publish((ProviderEvent)new ResetTimeOffsetEvent());
        }
    }

    @Test
    @ModelTest
    public void testTransientUserSession(KeycloakSession session) {
        RealmModel realm = session.realms().getRealmByName("test");
        ClientModel client = realm.getClientByClientId("test-app");
        String userSessionId = UUID.randomUUID().toString();
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), session1 -> {
            long sessionsBefore = session1.sessions().getActiveUserSessions(realm, client);
            UserSessionModel userSession = session1.sessions().createUserSession(userSessionId, realm, session1.users().getUserByUsername(realm, "user1"), "user1", "127.0.0.1", "form", true, null, null, UserSessionModel.SessionPersistenceState.TRANSIENT);
            AuthenticatedClientSessionModel clientSession = session1.sessions().createClientSession(realm, client, userSession);
            Assert.assertEquals((Object)userSession, (Object)clientSession.getUserSession());
            UserSessionProviderTest.assertSession(userSession, session.users().getUserByUsername(realm, "user1"), "127.0.0.1", userSession.getStarted(), userSession.getStarted(), "test-app");
            UserSessionModel foundSession = session1.sessions().getUserSession(realm, userSessionId);
            Assert.assertEquals((Object)userSession, (Object)foundSession);
            Assert.assertEquals((long)sessionsBefore, (long)session1.sessions().getActiveUserSessions(realm, client));
        });
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), session1 -> {
            UserSessionModel userSession = session1.sessions().getUserSession(realm, userSessionId);
            Assert.assertNull((Object)userSession);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @ModelTest
    public void testRemoveUserSessionsByExpiredRememberMe(KeycloakSession session) {
        RealmModel testRealm = session.realms().getRealmByName("test");
        int previousMaxLifespan = testRealm.getSsoSessionMaxLifespanRememberMe();
        int previousMaxIdle = testRealm.getSsoSessionIdleTimeoutRememberMe();
        try {
            ClientModel client = testRealm.getClientByClientId("test-app");
            HashSet validUserSessions = new HashSet();
            HashSet validClientSessions = new HashSet();
            HashSet expiredUserSessions = new HashSet();
            KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), kcSession -> {
                RealmModel r = kcSession.realms().getRealmByName("test");
                r.setSsoSessionMaxLifespanRememberMe(r.getSsoSessionMaxLifespan() * 4);
                r.setSsoSessionIdleTimeoutRememberMe(r.getSsoSessionIdleTimeout() * 4);
            });
            RealmModel realm = session.realms().getRealmByName("test");
            KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), kcSession -> {
                Time.setOffset((int)(-(realm.getSsoSessionMaxLifespan() * 2)));
                UserSessionModel userSession = kcSession.sessions().createUserSession(realm, kcSession.users().getUserByUsername(realm, "user1"), "user1", "127.0.0.1", "form", true, null, null);
                AuthenticatedClientSessionModel clientSession = kcSession.sessions().createClientSession(realm, client, userSession);
                Assert.assertEquals((Object)userSession, (Object)clientSession.getUserSession());
                Time.setOffset((int)(-(realm.getSsoSessionIdleTimeout() * 2)));
                userSession.setLastSessionRefresh(Time.currentTime());
                clientSession.setTimestamp(Time.currentTime());
                validUserSessions.add(userSession.getId());
                validClientSessions.add(clientSession.getId());
            });
            KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), kcSession -> {
                Time.setOffset((int)(-(realm.getSsoSessionMaxLifespanRememberMe() + 1)));
                UserSessionModel userSession = kcSession.sessions().createUserSession(realm, kcSession.users().getUserByUsername(realm, "user1"), "user1", "127.0.0.1", "form", true, null, null);
                expiredUserSessions.add(userSession.getId());
            });
            KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), kcSession -> {
                Time.setOffset((int)(-(realm.getSsoSessionIdleTimeoutRememberMe() + 180 + 1)));
                UserSessionModel userSession = kcSession.sessions().createUserSession(realm, kcSession.users().getUserByUsername(realm, "user2"), "user2", "127.0.0.1", "form", true, null, null);
                expiredUserSessions.add(userSession.getId());
            });
            Time.setOffset((int)0);
            KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), kcSession -> kcSession.sessions().removeExpired(realm));
            for (String sessionId : expiredUserSessions) {
                Assert.assertNull((Object)session.sessions().getUserSession(realm, sessionId));
            }
            for (String sessionId : validUserSessions) {
                UserSessionModel userSessionLoaded = session.sessions().getUserSession(realm, sessionId);
                Assert.assertNotNull((Object)userSessionLoaded);
                AuthenticatedClientSessionModel clientSessionModel = (AuthenticatedClientSessionModel)userSessionLoaded.getAuthenticatedClientSessions().get(client.getId());
                Assert.assertNotNull((Object)clientSessionModel);
                Assert.assertTrue((boolean)validClientSessions.contains(clientSessionModel.getId()));
            }
        }
        finally {
            Time.setOffset((int)0);
            session.getKeycloakSessionFactory().publish((ProviderEvent)new ResetTimeOffsetEvent());
            KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), kcSession -> {
                RealmModel r = kcSession.realms().getRealmByName("test");
                r.setSsoSessionMaxLifespanRememberMe(previousMaxLifespan);
                r.setSsoSessionIdleTimeoutRememberMe(previousMaxIdle);
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @ModelTest
    public void testRemovingExpiredSession(KeycloakSession session) {
        UserSessionModel[] sessions = UserSessionProviderTest.createSessions(session);
        try {
            Time.setOffset((int)3600000);
            UserSessionModel userSession = sessions[0];
            RealmModel realm = userSession.getRealm();
            session.sessions().removeExpired(realm);
            session.sessions().removeUserSession(realm, userSession);
        }
        finally {
            Time.setOffset((int)0);
            session.getKeycloakSessionFactory().publish((ProviderEvent)new ResetTimeOffsetEvent());
        }
    }

    @Test
    @ModelTest
    public void testGetByClient(KeycloakSession session) {
        RealmModel realm = session.realms().getRealmByName("test");
        UserSessionModel[] sessions = UserSessionProviderTest.createSessions(session);
        UserSessionProviderTest.assertSessions(session.sessions().getUserSessionsStream(realm, realm.getClientByClientId("test-app")).collect(Collectors.toList()), sessions[0], sessions[1], sessions[2]);
        UserSessionProviderTest.assertSessions(session.sessions().getUserSessionsStream(realm, realm.getClientByClientId("third-party")).collect(Collectors.toList()), sessions[0]);
    }

    @Test
    @ModelTest
    public void testGetByClientPaginated(KeycloakSession session) {
        RealmModel realm = session.realms().getRealmByName("test");
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), kcSession -> {
            try {
                for (int i = 0; i < 25; ++i) {
                    Time.setOffset((int)i);
                    UserSessionModel userSession = kcSession.sessions().createUserSession(realm, kcSession.users().getUserByUsername(realm, "user1"), "user1", "127.0.0." + i, "form", false, null, null);
                    AuthenticatedClientSessionModel clientSession = kcSession.sessions().createClientSession(realm, realm.getClientByClientId("test-app"), userSession);
                    Assert.assertNotNull((Object)clientSession);
                    clientSession.setRedirectUri("http://redirect");
                    clientSession.setNote("state", "state");
                    clientSession.setTimestamp(userSession.getStarted());
                    userSession.setLastSessionRefresh(userSession.getStarted());
                }
            }
            finally {
                Time.setOffset((int)0);
            }
        });
        UserSessionProviderTest.assertPaginatedSession(session, realm, realm.getClientByClientId("test-app"), 0, 1, 1);
        UserSessionProviderTest.assertPaginatedSession(session, realm, realm.getClientByClientId("test-app"), 0, 10, 10);
        UserSessionProviderTest.assertPaginatedSession(session, realm, realm.getClientByClientId("test-app"), 10, 10, 10);
        UserSessionProviderTest.assertPaginatedSession(session, realm, realm.getClientByClientId("test-app"), 20, 10, 5);
        UserSessionProviderTest.assertPaginatedSession(session, realm, realm.getClientByClientId("test-app"), 30, 10, 0);
    }

    @Test
    @ModelTest
    public void testCreateAndGetInSameTransaction(KeycloakSession session) {
        RealmModel realm = session.realms().getRealmByName("test");
        ClientModel client = realm.getClientByClientId("test-app");
        UserSessionModel userSession = session.sessions().createUserSession(realm, session.users().getUserByUsername(realm, "user1"), "user1", "127.0.0.2", "form", true, null, null);
        AuthenticatedClientSessionModel clientSession = UserSessionProviderTest.createClientSession(session, client, userSession, "http://redirect", "state");
        UserSessionModel userSessionLoaded = session.sessions().getUserSession(realm, userSession.getId());
        AuthenticatedClientSessionModel clientSessionLoaded = (AuthenticatedClientSessionModel)userSessionLoaded.getAuthenticatedClientSessions().get(client.getId());
        Assert.assertNotNull((Object)userSessionLoaded);
        Assert.assertNotNull((Object)clientSessionLoaded);
        Assert.assertEquals((Object)userSession.getId(), (Object)clientSessionLoaded.getUserSession().getId());
        Assert.assertEquals((long)1L, (long)userSessionLoaded.getAuthenticatedClientSessions().size());
    }

    @Test
    @ModelTest
    public void testAuthenticatedClientSessions(KeycloakSession session) {
        RealmModel realm = session.realms().getRealmByName("test");
        realm.setSsoSessionIdleTimeout(1800);
        realm.setSsoSessionMaxLifespan(36000);
        UserSessionModel userSession = session.sessions().createUserSession(realm, session.users().getUserByUsername(realm, "user1"), "user1", "127.0.0.2", "form", true, null, null);
        ClientModel client1 = realm.getClientByClientId("test-app");
        ClientModel client2 = realm.getClientByClientId("third-party");
        AuthenticatedClientSessionModel clientSession1 = session.sessions().createClientSession(realm, client1, userSession);
        clientSession1.setAction("foo1");
        int currentTime1 = Time.currentTime();
        clientSession1.setTimestamp(currentTime1);
        AuthenticatedClientSessionModel clientSession2 = session.sessions().createClientSession(realm, client2, userSession);
        clientSession2.setAction("foo2");
        int currentTime2 = Time.currentTime();
        clientSession2.setTimestamp(currentTime2);
        userSession = session.sessions().getUserSession(realm, userSession.getId());
        Map clientSessions = userSession.getAuthenticatedClientSessions();
        Assert.assertEquals((long)2L, (long)clientSessions.size());
        UserSessionProviderTest.testAuthenticatedClientSession((AuthenticatedClientSessionModel)clientSessions.get(client1.getId()), "test-app", userSession.getId(), "foo1", currentTime1);
        UserSessionProviderTest.testAuthenticatedClientSession((AuthenticatedClientSessionModel)clientSessions.get(client2.getId()), "third-party", userSession.getId(), "foo2", currentTime2);
        ((AuthenticatedClientSessionModel)clientSessions.get(client1.getId())).setAction("foo1-updated");
        userSession = session.sessions().getUserSession(realm, userSession.getId());
        clientSessions = userSession.getAuthenticatedClientSessions();
        UserSessionProviderTest.testAuthenticatedClientSession((AuthenticatedClientSessionModel)clientSessions.get(client1.getId()), "test-app", userSession.getId(), "foo1-updated", currentTime1);
        clientSession2 = session.sessions().createClientSession(realm, client2, userSession);
        clientSession2.setAction("foo2-rewrited");
        int currentTime3 = Time.currentTime();
        clientSession2.setTimestamp(currentTime3);
        userSession = session.sessions().getUserSession(realm, userSession.getId());
        clientSessions = userSession.getAuthenticatedClientSessions();
        Assert.assertEquals((long)2L, (long)clientSessions.size());
        UserSessionProviderTest.testAuthenticatedClientSession((AuthenticatedClientSessionModel)clientSessions.get(client1.getId()), "test-app", userSession.getId(), "foo1-updated", currentTime1);
        UserSessionProviderTest.testAuthenticatedClientSession((AuthenticatedClientSessionModel)clientSessions.get(client2.getId()), "third-party", userSession.getId(), "foo2-rewrited", currentTime3);
        clientSession1 = (AuthenticatedClientSessionModel)userSession.getAuthenticatedClientSessions().get(client1.getId());
        clientSession1.detachFromUserSession();
        userSession = session.sessions().getUserSession(realm, userSession.getId());
        clientSessions = userSession.getAuthenticatedClientSessions();
        Assert.assertEquals((long)1L, (long)clientSessions.size());
        Assert.assertNull(clientSessions.get(client1.getId()));
    }

    private static void testAuthenticatedClientSession(AuthenticatedClientSessionModel clientSession, String expectedClientId, String expectedUserSessionId, String expectedAction, int expectedTimestamp) {
        Assert.assertEquals((Object)expectedClientId, (Object)clientSession.getClient().getClientId());
        Assert.assertEquals((Object)expectedUserSessionId, (Object)clientSession.getUserSession().getId());
        Assert.assertEquals((Object)expectedAction, (Object)clientSession.getAction());
        Assert.assertEquals((long)expectedTimestamp, (long)clientSession.getTimestamp());
    }

    private static void assertPaginatedSession(KeycloakSession session, RealmModel realm, ClientModel client, int start, int max, int expectedSize) {
        Assert.assertEquals((long)expectedSize, (long)session.sessions().getUserSessionsStream(realm, client, Integer.valueOf(start), Integer.valueOf(max)).count());
    }

    @Test
    public void testGetCountByClient() {
        this.testingClient.server().run(UserSessionProviderTest::testGetCountByClient);
    }

    public static void testGetCountByClient(KeycloakSession session) {
        RealmModel realm = session.realms().getRealmByName("test");
        UserSessionProviderTest.createSessions(session);
        Assert.assertEquals((long)3L, (long)session.sessions().getActiveUserSessions(realm, realm.getClientByClientId("test-app")));
        Assert.assertEquals((long)1L, (long)session.sessions().getActiveUserSessions(realm, realm.getClientByClientId("third-party")));
    }

    @Test
    public void loginFailures() {
        this.testingClient.server().run((RunOnServer & Serializable)kcSession -> {
            RealmModel realm = kcSession.realms().getRealmByName("test");
            UserLoginFailureModel failure1 = kcSession.loginFailures().addUserLoginFailure(realm, "user1");
            failure1.incrementFailures();
            UserLoginFailureModel failure2 = kcSession.loginFailures().addUserLoginFailure(realm, "user2");
            failure2.incrementFailures();
            failure2.incrementFailures();
        });
        this.testingClient.server().run((RunOnServer & Serializable)kcSession -> {
            RealmModel realm = kcSession.realms().getRealmByName("test");
            UserLoginFailureModel failure1 = kcSession.loginFailures().getUserLoginFailure(realm, "user1");
            Assert.assertEquals((long)1L, (long)failure1.getNumFailures());
            UserLoginFailureModel failure2 = kcSession.loginFailures().getUserLoginFailure(realm, "user2");
            Assert.assertEquals((long)2L, (long)failure2.getNumFailures());
            failure1.incrementFailures();
            Assert.assertEquals((long)2L, (long)failure1.getNumFailures());
            failure1 = kcSession.loginFailures().getUserLoginFailure(realm, "user1");
            failure1.clearFailures();
            failure1 = kcSession.loginFailures().getUserLoginFailure(realm, "user1");
            Assert.assertEquals((long)0L, (long)failure1.getNumFailures());
        });
        this.testingClient.server().run((RunOnServer & Serializable)kcSession -> {
            RealmModel realm = kcSession.realms().getRealmByName("test");
            kcSession.loginFailures().removeUserLoginFailure(realm, "user1");
        });
        this.testingClient.server().run((RunOnServer & Serializable)kcSession -> {
            RealmModel realm = kcSession.realms().getRealmByName("test");
            Assert.assertNull((Object)kcSession.loginFailures().getUserLoginFailure(realm, "user1"));
            kcSession.loginFailures().removeAllUserLoginFailures(realm);
        });
        this.testingClient.server().run((RunOnServer & Serializable)kcSession -> {
            RealmModel realm = kcSession.realms().getRealmByName("test");
            Assert.assertNull((Object)kcSession.loginFailures().getUserLoginFailure(realm, "user1"));
            Assert.assertNull((Object)kcSession.loginFailures().getUserLoginFailure(realm, "user2"));
        });
    }

    @Test
    public void testOnUserRemoved() {
        this.testingClient.server().run(UserSessionProviderTest::testOnUserRemoved);
    }

    public static void testOnUserRemoved(KeycloakSession session) {
        RealmModel realm = session.realms().getRealmByName("test");
        UserModel user1 = session.users().getUserByUsername(realm, "user1");
        UserModel user2 = session.users().getUserByUsername(realm, "user2");
        UserSessionProviderTest.createSessions(session);
        Assert.assertEquals((long)2L, (long)session.sessions().getUserSessionsStream(realm, user1).count());
        Assert.assertEquals((long)1L, (long)session.sessions().getUserSessionsStream(realm, user2).count());
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), kcSession -> new UserManager(kcSession).removeUser(realm, user1));
        Assert.assertEquals((long)0L, (long)session.sessions().getUserSessionsStream(realm, user1).count());
        Assert.assertEquals((long)1L, (long)session.sessions().getUserSessionsStream(realm, user2).count());
    }

    private static AuthenticatedClientSessionModel createClientSession(KeycloakSession session, ClientModel client, UserSessionModel userSession, String redirect, String state) {
        RealmModel realm = session.realms().getRealmByName("test");
        AuthenticatedClientSessionModel clientSession = session.sessions().createClientSession(realm, client, userSession);
        clientSession.setRedirectUri(redirect);
        if (state != null) {
            clientSession.setNote("state", state);
        }
        return clientSession;
    }

    private static UserSessionModel[] createSessions(KeycloakSession session) {
        UserSessionModel[] sessions = new UserSessionModel[3];
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), kcSession -> {
            RealmModel realm = kcSession.realms().getRealmByName("test");
            sessions[0] = kcSession.sessions().createUserSession(realm, kcSession.users().getUserByUsername(realm, "user1"), "user1", "127.0.0.1", "form", true, null, null);
            UserSessionProviderTest.createClientSession(kcSession, realm.getClientByClientId("test-app"), sessions[0], "http://redirect", "state");
            UserSessionProviderTest.createClientSession(kcSession, realm.getClientByClientId("third-party"), sessions[0], "http://redirect", "state");
            sessions[1] = kcSession.sessions().createUserSession(realm, kcSession.users().getUserByUsername(realm, "user1"), "user1", "127.0.0.2", "form", true, null, null);
            UserSessionProviderTest.createClientSession(kcSession, realm.getClientByClientId("test-app"), sessions[1], "http://redirect", "state");
            sessions[2] = kcSession.sessions().createUserSession(realm, kcSession.users().getUserByUsername(realm, "user2"), "user2", "127.0.0.3", "form", true, null, null);
            UserSessionProviderTest.createClientSession(kcSession, realm.getClientByClientId("test-app"), sessions[2], "http://redirect", "state");
        });
        return sessions;
    }

    public static void assertSessions(List<UserSessionModel> actualSessions, UserSessionModel ... expectedSessions) {
        Object[] expected = new String[expectedSessions.length];
        for (int i = 0; i < expected.length; ++i) {
            expected[i] = expectedSessions[i].getId();
        }
        Object[] actual = new String[actualSessions.size()];
        for (int i = 0; i < actual.length; ++i) {
            actual[i] = actualSessions.get(i).getId();
        }
        Arrays.sort(expected);
        Arrays.sort(actual);
        Assert.assertArrayEquals((Object[])expected, (Object[])actual);
    }

    public static void assertSession(UserSessionModel session, UserModel user, String ipAddress, int started, int lastRefresh, String ... clients) {
        Assert.assertEquals((Object)user.getId(), (Object)session.getUser().getId());
        Assert.assertEquals((Object)ipAddress, (Object)session.getIpAddress());
        Assert.assertEquals((Object)user.getUsername(), (Object)session.getLoginUsername());
        Assert.assertEquals((Object)"form", (Object)session.getAuthMethod());
        Assert.assertTrue((boolean)session.isRememberMe());
        Assert.assertTrue((session.getStarted() >= started - 1 && session.getStarted() <= started + 1 ? 1 : 0) != 0);
        Assert.assertTrue((session.getLastSessionRefresh() >= lastRefresh - 1 && session.getLastSessionRefresh() <= lastRefresh + 1 ? 1 : 0) != 0);
        Object[] actualClients = new String[session.getAuthenticatedClientSessions().size()];
        int i = 0;
        for (Map.Entry entry : session.getAuthenticatedClientSessions().entrySet()) {
            String clientUUID = (String)entry.getKey();
            AuthenticatedClientSessionModel clientSession = (AuthenticatedClientSessionModel)entry.getValue();
            Assert.assertEquals((Object)clientUUID, (Object)clientSession.getClient().getId());
            actualClients[i] = clientSession.getClient().getClientId();
            ++i;
        }
        Arrays.sort(clients);
        Arrays.sort(actualClients);
        Assert.assertArrayEquals((Object[])clients, (Object[])actualClients);
    }

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
    }
}

