/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.common.util.Time;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserManager;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.services.managers.ClientManager;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.services.managers.UserSessionManager;
import org.keycloak.testsuite.AbstractTestRealmKeycloakTest;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.arquillian.annotation.ModelTest;
import org.keycloak.testsuite.runonserver.RunOnServer;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class UserSessionProviderOfflineTest
extends AbstractTestRealmKeycloakTest {
    private static KeycloakSession currentSession;
    private static RealmModel realm;
    private static UserSessionManager sessionManager;

    @Before
    public void before() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sessionBefore -> UserSessionProviderOfflineTest.reloadState(sessionBefore, true)));
    }

    @After
    public void after() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel realm = session.realms().getRealmByName("test");
            session.sessions().removeUserSessions(realm);
            UserModel user1 = session.users().getUserByUsername(realm, "user1");
            UserModel user2 = session.users().getUserByUsername(realm, "user2");
            UserManager um = new UserManager(session);
            if (user1 != null) {
                um.removeUser(realm, user1);
            }
            if (user2 != null) {
                um.removeUser(realm, user2);
            }
        });
    }

    @Test
    @ModelTest
    public void testOfflineSessionsCrud(KeycloakSession session) {
        HashMap offlineSessions = new HashMap();
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sessionCrud -> {
            UserSessionProviderOfflineTest.reloadState(sessionCrud);
            UserSessionProviderOfflineTest.createSessions(sessionCrud);
        });
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sessionCrud2 -> {
            currentSession = sessionCrud2;
            realm = currentSession.realms().getRealm("test");
            sessionManager = new UserSessionManager(currentSession);
            ClientModel testApp = realm.getClientByClientId("test-app");
            currentSession.sessions().getUserSessionsStream(realm, testApp).collect(Collectors.toList()).forEach(userSession -> offlineSessions.put(userSession.getId(), UserSessionProviderOfflineTest.createOfflineSessionIncludeClientSessions(currentSession, userSession)));
        });
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sessionCrud3 -> {
            currentSession = sessionCrud3;
            realm = currentSession.realms().getRealm("test");
            sessionManager = new UserSessionManager(currentSession);
            for (Map.Entry entry : offlineSessions.entrySet()) {
                UserSessionModel offlineSession = sessionManager.findOfflineUserSession(realm, (String)entry.getKey());
                Assert.assertNotNull((Object)offlineSession);
                Assert.assertEquals(offlineSession.getAuthenticatedClientSessions().keySet(), entry.getValue());
            }
            UserModel user1 = currentSession.users().getUserByUsername(realm, "user1");
            Set clients = sessionManager.findClientsWithOfflineToken(realm, user1);
            Assert.assertEquals((long)clients.size(), (long)2L);
            for (ClientModel client : clients) {
                Assert.assertTrue((client.getClientId().equals("test-app") || client.getClientId().equals("third-party") ? 1 : 0) != 0);
            }
            UserModel user2 = currentSession.users().getUserByUsername(realm, "user2");
            clients = sessionManager.findClientsWithOfflineToken(realm, user2);
            Assert.assertEquals((long)clients.size(), (long)1L);
            Assert.assertEquals((Object)"test-app", (Object)((ClientModel)clients.iterator().next()).getClientId());
            ClientModel testApp = realm.getClientByClientId("test-app");
            ClientModel thirdparty = realm.getClientByClientId("third-party");
            Assert.assertEquals((long)3L, (long)currentSession.sessions().getOfflineSessionsCount(realm, testApp));
            Assert.assertEquals((long)1L, (long)currentSession.sessions().getOfflineSessionsCount(realm, thirdparty));
            sessionManager.revokeOfflineToken(user1, testApp);
        });
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sessionCrud4 -> {
            currentSession = sessionCrud4;
            realm = currentSession.realms().getRealm("test");
            sessionManager = new UserSessionManager(currentSession);
            ClientModel thirdparty = realm.getClientByClientId("third-party");
            List thirdpartySessions = currentSession.sessions().getOfflineUserSessionsStream(realm, thirdparty, Integer.valueOf(0), Integer.valueOf(10)).collect(Collectors.toList());
            Assert.assertEquals((long)1L, (long)thirdpartySessions.size());
            Assert.assertEquals((Object)"127.0.0.1", (Object)((UserSessionModel)thirdpartySessions.get(0)).getIpAddress());
            Assert.assertEquals((Object)"user1", (Object)((UserSessionModel)thirdpartySessions.get(0)).getUser().getUsername());
            UserModel user1 = currentSession.users().getUserByUsername(realm, "user1");
            UserModel user2 = currentSession.users().getUserByUsername(realm, "user2");
            Set clients = sessionManager.findClientsWithOfflineToken(realm, user1);
            Assert.assertEquals((long)1L, (long)clients.size());
            Assert.assertEquals((Object)"third-party", (Object)((ClientModel)clients.iterator().next()).getClientId());
            clients = sessionManager.findClientsWithOfflineToken(realm, user2);
            Assert.assertEquals((long)1L, (long)clients.size());
            Assert.assertEquals((Object)"test-app", (Object)((ClientModel)clients.iterator().next()).getClientId());
            sessionManager.revokeOfflineToken(user1, thirdparty);
        });
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sessionCrud5 -> {
            currentSession = sessionCrud5;
            realm = currentSession.realms().getRealm("test");
            sessionManager = new UserSessionManager(currentSession);
            ClientModel testApp = realm.getClientByClientId("test-app");
            ClientModel thirdparty = realm.getClientByClientId("third-party");
            Assert.assertEquals((long)1L, (long)currentSession.sessions().getOfflineSessionsCount(realm, testApp));
            Assert.assertEquals((long)0L, (long)currentSession.sessions().getOfflineSessionsCount(realm, thirdparty));
            List testAppSessions = currentSession.sessions().getOfflineUserSessionsStream(realm, testApp, Integer.valueOf(0), Integer.valueOf(10)).collect(Collectors.toList());
            Assert.assertEquals((long)1L, (long)testAppSessions.size());
            Assert.assertEquals((Object)"127.0.0.3", (Object)((UserSessionModel)testAppSessions.get(0)).getIpAddress());
            Assert.assertEquals((Object)"user2", (Object)((UserSessionModel)testAppSessions.get(0)).getUser().getUsername());
            UserModel user1 = currentSession.users().getUserByUsername(realm, "user1");
            Set clients = sessionManager.findClientsWithOfflineToken(realm, user1);
            Assert.assertEquals((long)0L, (long)clients.size());
        });
    }

    @Test
    @ModelTest
    public void testOnRealmRemoved(KeycloakSession session) {
        AtomicReference userSessionID = new AtomicReference();
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sessionRR1 -> {
            currentSession = sessionRR1;
            RealmModel fooRealm = currentSession.realms().createRealm("foo", "foo");
            fooRealm.setDefaultRole(currentSession.roles().addRealmRole(fooRealm, "default-roles-" + fooRealm.getName()));
            fooRealm.setSsoSessionIdleTimeout(1800);
            fooRealm.setSsoSessionMaxLifespan(36000);
            fooRealm.setOfflineSessionIdleTimeout(2592000);
            fooRealm.setOfflineSessionMaxLifespan(5184000);
            fooRealm.addClient("foo-app");
            currentSession.users().addUser(fooRealm, "user3");
            UserSessionModel userSession = currentSession.sessions().createUserSession(fooRealm, currentSession.users().getUserByUsername(fooRealm, "user3"), "user3", "127.0.0.1", "form", true, null, null);
            userSessionID.set(userSession.getId());
            UserSessionProviderOfflineTest.createClientSession(currentSession, fooRealm.getClientByClientId("foo-app"), userSession, "http://redirect", "state");
        });
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sessionRR2 -> {
            currentSession = sessionRR2;
            sessionManager = new UserSessionManager(currentSession);
            RealmModel fooRealm = currentSession.realms().getRealm("foo");
            UserSessionModel userSession = currentSession.sessions().getUserSession(fooRealm, (String)userSessionID.get());
            UserSessionProviderOfflineTest.createOfflineSessionIncludeClientSessions(currentSession, userSession);
            UserSessionModel offlineUserSession = sessionManager.findOfflineUserSession(fooRealm, userSession.getId());
            Assert.assertEquals((long)offlineUserSession.getAuthenticatedClientSessions().size(), (long)1L);
            AuthenticatedClientSessionModel offlineClientSession = (AuthenticatedClientSessionModel)offlineUserSession.getAuthenticatedClientSessions().values().iterator().next();
            Assert.assertEquals((Object)"foo-app", (Object)offlineClientSession.getClient().getClientId());
            Assert.assertEquals((Object)"user3", (Object)offlineClientSession.getUserSession().getUser().getUsername());
            RealmManager realmMgr = new RealmManager(currentSession);
            realmMgr.removeRealm(realmMgr.getRealm("foo"));
        });
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sessionRR3 -> {
            currentSession = sessionRR3;
            RealmModel fooRealm = currentSession.realms().createRealm("foo", "foo");
            fooRealm.setDefaultRole(currentSession.roles().addRealmRole(fooRealm, "default-roles-" + fooRealm.getName()));
            fooRealm.addClient("foo-app");
            currentSession.users().addUser(fooRealm, "user3");
        });
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sessionRR4 -> {
            currentSession = sessionRR4;
            RealmModel fooRealm = currentSession.realms().getRealm("foo");
            Assert.assertEquals((long)0L, (long)currentSession.sessions().getOfflineSessionsCount(fooRealm, fooRealm.getClientByClientId("foo-app")));
            RealmManager realmMgr = new RealmManager(currentSession);
            realmMgr.removeRealm(realmMgr.getRealm("foo"));
        });
    }

    @Test
    @ModelTest
    public void testOnClientRemoved(KeycloakSession session) {
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sessionCR -> {
            try {
                int started = Time.currentTime();
                AtomicReference userSessionID = new AtomicReference();
                KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sessionCR1 -> {
                    currentSession = sessionCR1;
                    sessionManager = new UserSessionManager(currentSession);
                    RealmModel fooRealm = currentSession.realms().createRealm("foo", "foo");
                    fooRealm.setDefaultRole(currentSession.roles().addRealmRole(fooRealm, "default-roles-" + fooRealm.getName()));
                    fooRealm.setSsoSessionIdleTimeout(1800);
                    fooRealm.setSsoSessionMaxLifespan(36000);
                    fooRealm.setOfflineSessionIdleTimeout(2592000);
                    fooRealm.setOfflineSessionMaxLifespan(5184000);
                    fooRealm.addClient("foo-app");
                    fooRealm.addClient("bar-app");
                    currentSession.users().addUser(fooRealm, "user3");
                    UserSessionModel userSession = currentSession.sessions().createUserSession(fooRealm, currentSession.users().getUserByUsername(fooRealm, "user3"), "user3", "127.0.0.1", "form", true, null, null);
                    userSessionID.set(userSession.getId());
                    UserSessionProviderOfflineTest.createClientSession(currentSession, fooRealm.getClientByClientId("foo-app"), userSession, "http://redirect", "state");
                    UserSessionProviderOfflineTest.createClientSession(currentSession, fooRealm.getClientByClientId("bar-app"), userSession, "http://redirect", "state");
                });
                KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sessionCR2 -> {
                    currentSession = sessionCR2;
                    RealmModel fooRealm = currentSession.realms().getRealm("foo");
                    UserSessionModel userSession = currentSession.sessions().getUserSession(fooRealm, (String)userSessionID.get());
                    UserSessionProviderOfflineTest.createOfflineSessionIncludeClientSessions(currentSession, userSession);
                });
                KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sessionCR3 -> {
                    currentSession = sessionCR3;
                    RealmManager realmMgr = new RealmManager(currentSession);
                    ClientManager clientMgr = new ClientManager(realmMgr);
                    RealmModel fooRealm = realmMgr.getRealm("foo");
                    UserSessionModel offlineSession = currentSession.sessions().getOfflineUserSession(fooRealm, (String)userSessionID.get());
                    UserSessionProviderOfflineTest.assertSession(offlineSession, currentSession.users().getUserByUsername(fooRealm, "user3"), "127.0.0.1", started, started, "foo-app", "bar-app");
                    ClientModel client = fooRealm.getClientByClientId("foo-app");
                    clientMgr.removeClient(fooRealm, client);
                });
                KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sessionCR4 -> {
                    currentSession = sessionCR4;
                    RealmManager realmMgr = new RealmManager(currentSession);
                    ClientManager clientMgr = new ClientManager(realmMgr);
                    RealmModel fooRealm = realmMgr.getRealm("foo");
                    UserSessionModel offlineSession = currentSession.sessions().getOfflineUserSession(fooRealm, (String)userSessionID.get());
                    Assert.assertEquals((long)1L, (long)offlineSession.getAuthenticatedClientSessions().size());
                    Assert.assertEquals((Object)"bar-app", (Object)((AuthenticatedClientSessionModel)offlineSession.getAuthenticatedClientSessions().values().iterator().next()).getClient().getClientId());
                    ClientModel client = fooRealm.getClientByClientId("bar-app");
                    clientMgr.removeClient(fooRealm, client);
                });
                KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sessionCR5 -> {
                    currentSession = sessionCR5;
                    RealmManager realmMgr = new RealmManager(currentSession);
                    RealmModel fooRealm = realmMgr.getRealm("foo");
                    UserSessionModel offlineSession = currentSession.sessions().getOfflineUserSession(fooRealm, (String)userSessionID.get());
                    Assert.assertEquals((long)0L, (long)offlineSession.getAuthenticatedClientSessions().size());
                });
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sessionTearDown -> {
                    currentSession = sessionTearDown;
                    RealmManager realmMgr = new RealmManager(currentSession);
                    RealmModel fooRealm = realmMgr.getRealm("foo");
                    UserModel user3 = currentSession.users().getUserByUsername(fooRealm, "user3");
                    new UserManager(currentSession).removeUser(fooRealm, user3);
                    realmMgr = new RealmManager(currentSession);
                    realmMgr.removeRealm(realmMgr.getRealm("foo"));
                });
            }
        });
    }

    @Test
    @ModelTest
    public void testOnUserRemoved(KeycloakSession session) {
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sessionUR -> {
            try {
                int started = Time.currentTime();
                AtomicReference userSessionID = new AtomicReference();
                KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sessionUR1 -> {
                    currentSession = sessionUR1;
                    RealmModel fooRealm = currentSession.realms().createRealm("foo", "foo");
                    fooRealm.setDefaultRole(currentSession.roles().addRealmRole(fooRealm, "default-roles-" + fooRealm.getName()));
                    fooRealm.setSsoSessionIdleTimeout(1800);
                    fooRealm.setSsoSessionMaxLifespan(36000);
                    fooRealm.setOfflineSessionIdleTimeout(2592000);
                    fooRealm.setOfflineSessionMaxLifespan(5184000);
                    fooRealm.addClient("foo-app");
                    currentSession.users().addUser(fooRealm, "user3");
                    UserSessionModel userSession = currentSession.sessions().createUserSession(fooRealm, currentSession.users().getUserByUsername(fooRealm, "user3"), "user3", "127.0.0.1", "form", true, null, null);
                    userSessionID.set(userSession.getId());
                    UserSessionProviderOfflineTest.createClientSession(currentSession, fooRealm.getClientByClientId("foo-app"), userSession, "http://redirect", "state");
                });
                KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sessionUR2 -> {
                    currentSession = sessionUR2;
                    RealmModel fooRealm = currentSession.realms().getRealm("foo");
                    UserSessionModel userSession = currentSession.sessions().getUserSession(fooRealm, (String)userSessionID.get());
                    UserSessionProviderOfflineTest.createOfflineSessionIncludeClientSessions(currentSession, userSession);
                });
                KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sessionUR3 -> {
                    currentSession = sessionUR3;
                    RealmManager realmMgr = new RealmManager(currentSession);
                    RealmModel fooRealm = realmMgr.getRealm("foo");
                    UserModel user3 = currentSession.users().getUserByUsername(fooRealm, "user3");
                    UserSessionModel offlineSession = currentSession.sessions().getOfflineUserSession(fooRealm, (String)userSessionID.get());
                    UserSessionProviderOfflineTest.assertSession(offlineSession, user3, "127.0.0.1", started, started, "foo-app");
                });
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sessionTearDown -> {
                    currentSession = sessionTearDown;
                    RealmManager realmMgr = new RealmManager(currentSession);
                    RealmModel fooRealm = realmMgr.getRealm("foo");
                    UserModel user3 = currentSession.users().getUserByUsername(fooRealm, "user3");
                    new UserManager(currentSession).removeUser(fooRealm, user3);
                    realmMgr = new RealmManager(currentSession);
                    realmMgr.removeRealm(realmMgr.getRealm("foo"));
                });
            }
        });
    }

    private static Set<String> createOfflineSessionIncludeClientSessions(KeycloakSession session, UserSessionModel userSession) {
        HashSet<String> offlineSessions = new HashSet<String>();
        UserSessionManager localManager = new UserSessionManager(session);
        for (AuthenticatedClientSessionModel clientSession : userSession.getAuthenticatedClientSessions().values()) {
            localManager.createOrUpdateOfflineSession(clientSession, userSession);
            offlineSessions.add(clientSession.getClient().getId());
        }
        return offlineSessions;
    }

    public static void assertSession(UserSessionModel session, UserModel user, String ipAddress, int started, int lastRefresh, String ... clients) {
        Assert.assertEquals((Object)user.getId(), (Object)session.getUser().getId());
        Assert.assertEquals((Object)ipAddress, (Object)session.getIpAddress());
        Assert.assertEquals((Object)user.getUsername(), (Object)session.getLoginUsername());
        Assert.assertEquals((Object)"form", (Object)session.getAuthMethod());
        Assert.assertTrue((boolean)session.isRememberMe());
        Assert.assertTrue((session.getStarted() >= started - 1 && session.getStarted() <= started + 1 ? 1 : 0) != 0);
        Assert.assertTrue((session.getLastSessionRefresh() >= lastRefresh - 1 && session.getLastSessionRefresh() <= lastRefresh + 1 ? 1 : 0) != 0);
        String[] actualClients = new String[session.getAuthenticatedClientSessions().size()];
        int i = 0;
        for (Map.Entry entry : session.getAuthenticatedClientSessions().entrySet()) {
            String clientUUID = (String)entry.getKey();
            AuthenticatedClientSessionModel clientSession = (AuthenticatedClientSessionModel)entry.getValue();
            Assert.assertEquals((Object)clientUUID, (Object)clientSession.getClient().getId());
            actualClients[i] = clientSession.getClient().getClientId();
            ++i;
        }
    }

    private static AuthenticatedClientSessionModel createClientSession(KeycloakSession sessionParam, ClientModel client, UserSessionModel userSession, String redirect, String state) {
        AuthenticatedClientSessionModel clientSession = sessionParam.sessions().createClientSession(client.getRealm(), client, userSession);
        clientSession.setRedirectUri(redirect);
        if (state != null) {
            clientSession.setNote("state", state);
        }
        return clientSession;
    }

    private static UserSessionModel[] createSessions(KeycloakSession session) {
        UserSessionModel[] sessions = new UserSessionModel[3];
        sessions[0] = session.sessions().createUserSession(realm, currentSession.users().getUserByUsername(realm, "user1"), "user1", "127.0.0.1", "form", true, null, null);
        HashSet<String> roles = new HashSet<String>();
        roles.add("one");
        roles.add("two");
        HashSet<String> protocolMappers = new HashSet<String>();
        protocolMappers.add("mapper-one");
        protocolMappers.add("mapper-two");
        UserSessionProviderOfflineTest.createClientSession(session, realm.getClientByClientId("test-app"), sessions[0], "http://redirect", "state");
        UserSessionProviderOfflineTest.createClientSession(session, realm.getClientByClientId("third-party"), sessions[0], "http://redirect", "state");
        sessions[1] = session.sessions().createUserSession(realm, session.users().getUserByUsername(realm, "user1"), "user1", "127.0.0.2", "form", true, null, null);
        UserSessionProviderOfflineTest.createClientSession(session, realm.getClientByClientId("test-app"), sessions[1], "http://redirect", "state");
        sessions[2] = session.sessions().createUserSession(realm, session.users().getUserByUsername(realm, "user2"), "user2", "127.0.0.3", "form", true, null, null);
        UserSessionProviderOfflineTest.createClientSession(session, realm.getClientByClientId("test-app"), sessions[2], "http://redirect", "state");
        return sessions;
    }

    public static void reloadState(KeycloakSession session) {
        UserSessionProviderOfflineTest.reloadState(session, false);
    }

    public static void reloadState(KeycloakSession session, Boolean initialConfig) {
        currentSession = session;
        realm = currentSession.realms().getRealm("test");
        if (initialConfig.booleanValue()) {
            currentSession.users().addUser(realm, "user1").setEmail("user1@localhost");
            currentSession.users().addUser(realm, "user2").setEmail("user2@localhost");
        }
        sessionManager = new UserSessionManager(currentSession);
    }

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
    }
}

