/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.model;

import java.io.Serializable;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.ModelException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserConsentModel;
import org.keycloak.models.UserManager;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.storage.UserStorageProviderModel;
import org.keycloak.storage.client.ClientStorageProviderModel;
import org.keycloak.testsuite.AbstractTestRealmKeycloakTest;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.arquillian.annotation.ModelTest;
import org.keycloak.testsuite.runonserver.RunOnServer;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class UserConsentWithUserStorageModelTest
extends AbstractTestRealmKeycloakTest {
    private static ComponentModel clientStorageComponent;

    @Before
    public void before() {
        this.testingClient.server().run(UserConsentWithUserStorageModelTest::setupEnv);
    }

    @After
    public void after() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmManager realmManager = new RealmManager(session);
            RealmModel realm = realmManager.getRealmByName("original");
            if (realm != null) {
                session.sessions().removeUserSessions(realm);
                UserModel user = session.users().getUserByUsername(realm, "user");
                UserModel user1 = session.users().getUserByUsername(realm, "user1");
                UserModel user2 = session.users().getUserByUsername(realm, "user2");
                UserModel user3 = session.users().getUserByUsername(realm, "user3");
                UserManager um = new UserManager(session);
                if (user != null) {
                    um.removeUser(realm, user);
                }
                if (user1 != null) {
                    um.removeUser(realm, user1);
                }
                if (user2 != null) {
                    um.removeUser(realm, user2);
                }
                if (user3 != null) {
                    um.removeUser(realm, user3);
                }
                realmManager.removeRealm(realm);
            }
        });
    }

    public static void setupEnv(KeycloakSession session) {
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sessionSetUpEnv -> {
            KeycloakSession currentSession = sessionSetUpEnv;
            RealmManager realmManager = new RealmManager(currentSession);
            RealmModel realm = realmManager.createRealm("original");
            UserStorageProviderModel model = new UserStorageProviderModel();
            model.setName("memory");
            model.setPriority(0);
            model.setProviderId("user-password-map-arq");
            model.setParentId(realm.getId());
            model.getConfig().putSingle((Object)"importEnabled", (Object)Boolean.toString(false));
            realm.addComponentModel((ComponentModel)model);
            ClientModel fooClient = realm.addClient("foo-client");
            ClientModel barClient = realm.addClient("bar-client");
            ClientScopeModel fooScope = realm.addClientScope("foo");
            fooScope.setProtocol("openid-connect");
            ClientScopeModel barScope = realm.addClientScope("bar");
            fooScope.setProtocol("openid-connect");
            UserModel john = currentSession.users().addUser(realm, "john");
            UserModel mary = currentSession.users().addUser(realm, "mary");
            UserConsentModel johnFooGrant = new UserConsentModel(fooClient);
            johnFooGrant.addGrantedClientScope(fooScope);
            realmManager.getSession().users().addConsent(realm, john.getId(), johnFooGrant);
            UserConsentModel johnBarGrant = new UserConsentModel(barClient);
            johnBarGrant.addGrantedClientScope(barScope);
            try {
                currentSession.users().updateConsent(realm, john.getId(), johnBarGrant);
                Assert.fail((String)"Not expected to end here");
            }
            catch (ModelException modelException) {
                // empty catch block
            }
            realmManager.getSession().users().addConsent(realm, john.getId(), johnBarGrant);
            UserConsentModel maryFooGrant = new UserConsentModel(fooClient);
            maryFooGrant.addGrantedClientScope(fooScope);
            realmManager.getSession().users().addConsent(realm, mary.getId(), maryFooGrant);
            ClientStorageProviderModel clientStorage = new ClientStorageProviderModel();
            clientStorage.setProviderId("hardcoded-client");
            clientStorage.getConfig().putSingle((Object)"client_id", (Object)"hardcoded-client");
            clientStorage.getConfig().putSingle((Object)"redirect_uri", (Object)"http://localhost:8081/*");
            clientStorage.getConfig().putSingle((Object)"consent", (Object)"true");
            clientStorage.setParentId(realm.getId());
            clientStorageComponent = realm.addComponentModel((ComponentModel)clientStorage);
            ClientModel hardcodedClient = currentSession.clients().getClientByClientId(realm, "hardcoded-client");
            Assert.assertNotNull((Object)hardcodedClient);
            UserConsentModel maryHardcodedGrant = new UserConsentModel(hardcodedClient);
            realmManager.getSession().users().addConsent(realm, mary.getId(), maryHardcodedGrant);
        });
    }

    @Test
    @ModelTest
    public void basicConsentTest(KeycloakSession session) {
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), currentSessionCT -> {
            KeycloakSession currentSession = currentSessionCT;
            RealmModel realm = currentSession.realms().getRealmByName("original");
            ClientModel fooClient = realm.getClientByClientId("foo-client");
            ClientModel barClient = realm.getClientByClientId("bar-client");
            UserModel john = currentSessionCT.users().getUserByUsername(realm, "john");
            UserModel mary = currentSessionCT.users().getUserByUsername(realm, "mary");
            UserConsentModel johnFooConsent = currentSession.users().getConsentByClient(realm, john.getId(), fooClient.getId());
            Assert.assertEquals((long)johnFooConsent.getGrantedClientScopes().size(), (long)1L);
            Assert.assertTrue((boolean)this.isClientScopeGranted(realm, "foo", johnFooConsent));
            Assert.assertNotNull((String)"Created Date should be set", (Object)johnFooConsent.getCreatedDate());
            Assert.assertNotNull((String)"Last Updated Date should be set", (Object)johnFooConsent.getLastUpdatedDate());
            UserConsentModel johnBarConsent = currentSession.users().getConsentByClient(realm, john.getId(), barClient.getId());
            Assert.assertEquals((long)johnBarConsent.getGrantedClientScopes().size(), (long)1L);
            Assert.assertTrue((boolean)this.isClientScopeGranted(realm, "bar", johnBarConsent));
            Assert.assertNotNull((String)"Created Date should be set", (Object)johnBarConsent.getCreatedDate());
            Assert.assertNotNull((String)"Last Updated Date should be set", (Object)johnBarConsent.getLastUpdatedDate());
            UserConsentModel maryConsent = currentSession.users().getConsentByClient(realm, mary.getId(), fooClient.getId());
            Assert.assertEquals((long)maryConsent.getGrantedClientScopes().size(), (long)1L);
            Assert.assertTrue((boolean)this.isClientScopeGranted(realm, "foo", maryConsent));
            Assert.assertNotNull((String)"Created Date should be set", (Object)maryConsent.getCreatedDate());
            Assert.assertNotNull((String)"Last Updated Date should be set", (Object)maryConsent.getLastUpdatedDate());
            ClientModel hardcodedClient = currentSessionCT.clients().getClientByClientId(realm, "hardcoded-client");
            UserConsentModel maryHardcodedConsent = currentSession.users().getConsentByClient(realm, mary.getId(), hardcodedClient.getId());
            Assert.assertEquals((long)maryHardcodedConsent.getGrantedClientScopes().size(), (long)0L);
            Assert.assertNotNull((String)"Created Date should be set", (Object)maryHardcodedConsent.getCreatedDate());
            Assert.assertNotNull((String)"Last Updated Date should be set", (Object)maryHardcodedConsent.getLastUpdatedDate());
            Assert.assertNull((Object)currentSession.users().getConsentByClient(realm, mary.getId(), barClient.getId()));
            Assert.assertNull((Object)currentSession.users().getConsentByClient(realm, john.getId(), hardcodedClient.getId()));
        });
    }

    @Test
    @ModelTest
    public void getAllConsentTest(KeycloakSession session) {
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), currentSessionACT -> {
            KeycloakSession currentSession = currentSessionACT;
            RealmModel realm = currentSession.realms().getRealmByName("original");
            ClientModel fooClient = realm.getClientByClientId("foo-client");
            UserModel john = currentSessionACT.users().getUserByUsername(realm, "john");
            UserModel mary = currentSessionACT.users().getUserByUsername(realm, "mary");
            Assert.assertEquals((long)2L, (long)currentSession.users().getConsentsStream(realm, john.getId()).count());
            ClientModel hardcodedClient = currentSessionACT.clients().getClientByClientId(realm, "hardcoded-client");
            List maryConsents = currentSession.users().getConsentsStream(realm, mary.getId()).collect(Collectors.toList());
            Assert.assertEquals((long)2L, (long)maryConsents.size());
            UserConsentModel maryConsent = (UserConsentModel)maryConsents.get(0);
            UserConsentModel maryHardcodedConsent = (UserConsentModel)maryConsents.get(1);
            if (((UserConsentModel)maryConsents.get(0)).getClient().getId().equals(hardcodedClient.getId())) {
                maryConsent = (UserConsentModel)maryConsents.get(1);
                maryHardcodedConsent = (UserConsentModel)maryConsents.get(0);
            }
            Assert.assertEquals((Object)maryConsent.getClient().getId(), (Object)fooClient.getId());
            Assert.assertEquals((long)maryConsent.getGrantedClientScopes().size(), (long)1L);
            Assert.assertTrue((boolean)this.isClientScopeGranted(realm, "foo", maryConsent));
            Assert.assertEquals((Object)maryHardcodedConsent.getClient().getId(), (Object)hardcodedClient.getId());
            Assert.assertEquals((long)maryHardcodedConsent.getGrantedClientScopes().size(), (long)0L);
        });
    }

    @Test
    @ModelTest
    public void updateWithClientScopeRemovalTest(KeycloakSession session) {
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sessionScopeRemoval1 -> {
            KeycloakSession currentSession = sessionScopeRemoval1;
            RealmModel realm = currentSession.realms().getRealmByName("original");
            ClientModel fooClient = realm.getClientByClientId("foo-client");
            UserModel john = currentSession.users().getUserByUsername(realm, "john");
            UserConsentModel johnConsent = currentSession.users().getConsentByClient(realm, john.getId(), fooClient.getId());
            Assert.assertEquals((long)1L, (long)johnConsent.getGrantedClientScopes().size());
            ClientScopeModel fooScope = KeycloakModelUtils.getClientScopeByName((RealmModel)realm, (String)"foo");
            johnConsent.getGrantedClientScopes().remove(fooScope);
            currentSession.users().updateConsent(realm, john.getId(), johnConsent);
        });
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sessionScopeRemoval2 -> {
            KeycloakSession currentSession = sessionScopeRemoval2;
            RealmModel realm = currentSession.realms().getRealmByName("original");
            ClientModel fooClient = realm.getClientByClientId("foo-client");
            UserModel john = currentSession.users().getUserByUsername(realm, "john");
            UserConsentModel johnConsent = currentSession.users().getConsentByClient(realm, john.getId(), fooClient.getId());
            Assert.assertEquals((long)johnConsent.getGrantedClientScopes().size(), (long)0L);
            Assert.assertTrue((String)"Created date should be less than last updated date", (johnConsent.getCreatedDate() < johnConsent.getLastUpdatedDate() ? 1 : 0) != 0);
        });
    }

    @Test
    @ModelTest
    public void revokeTest(KeycloakSession session) {
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sessionRevoke1 -> {
            KeycloakSession currentSession = sessionRevoke1;
            RealmModel realm = currentSession.realms().getRealmByName("original");
            ClientModel fooClient = realm.getClientByClientId("foo-client");
            UserModel john = currentSession.users().getUserByUsername(realm, "john");
            UserModel mary = currentSession.users().getUserByUsername(realm, "mary");
            currentSession.users().revokeConsentForClient(realm, john.getId(), fooClient.getId());
            ClientModel hardcodedClient = currentSession.clients().getClientByClientId(realm, "hardcoded-client");
            currentSession.users().revokeConsentForClient(realm, mary.getId(), hardcodedClient.getId());
        });
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sessionRevoke2 -> {
            KeycloakSession currentSession = sessionRevoke2;
            RealmModel realm = currentSession.realms().getRealmByName("original");
            ClientModel fooClient = realm.getClientByClientId("foo-client");
            ClientModel hardcodedClient = currentSession.clients().getClientByClientId(realm, "hardcoded-client");
            UserModel john = currentSession.users().getUserByUsername(realm, "john");
            Assert.assertNull((Object)currentSession.users().getConsentByClient(realm, john.getId(), fooClient.getId()));
            UserModel mary = currentSession.users().getUserByUsername(realm, "mary");
            Assert.assertNull((Object)currentSession.users().getConsentByClient(realm, mary.getId(), hardcodedClient.getId()));
        });
    }

    @Test
    @ModelTest
    public void deleteUserTest(KeycloakSession session) {
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sessionDelete -> {
            KeycloakSession currentSession = sessionDelete;
            RealmModel realm = currentSession.realms().getRealmByName("original");
            UserModel john = currentSession.users().getUserByUsername(realm, "john");
            currentSession.users().removeUser(realm, john);
            UserModel mary = currentSession.users().getUserByUsername(realm, "mary");
            currentSession.users().removeUser(realm, mary);
        });
    }

    @Test
    @ModelTest
    public void deleteClientScopeTest(KeycloakSession session) {
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sesDelClScope1 -> {
            KeycloakSession currentSession = sesDelClScope1;
            RealmModel realm = currentSession.realms().getRealmByName("original");
            ClientModel fooClient = realm.getClientByClientId("foo-client");
            ClientScopeModel fooScope = KeycloakModelUtils.getClientScopeByName((RealmModel)realm, (String)"foo");
            realm.removeClientScope(fooScope.getId());
        });
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sesDelClScope2 -> {
            KeycloakSession currentSession = sesDelClScope2;
            RealmModel realm = currentSession.realms().getRealmByName("original");
            ClientModel fooClient = realm.getClientByClientId("foo-client");
            UserModel john = currentSession.users().getUserByUsername(realm, "john");
            UserConsentModel johnConsent = currentSession.users().getConsentByClient(realm, john.getId(), fooClient.getId());
            Assert.assertEquals((long)johnConsent.getGrantedClientScopes().size(), (long)0L);
        });
    }

    @Test
    @ModelTest
    public void deleteClientTest(KeycloakSession session) {
        AtomicReference barClientID = new AtomicReference();
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sesDelClient1 -> {
            KeycloakSession currentSession = sesDelClient1;
            RealmManager realmManager = new RealmManager(currentSession);
            RealmModel realm = realmManager.getRealmByName("original");
            ClientModel barClient = realm.getClientByClientId("bar-client");
            barClientID.set(barClient.getId());
            realm.removeClient(barClient.getId());
        });
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sesDelClient2 -> {
            KeycloakSession currentSession = sesDelClient2;
            RealmManager realmManager = new RealmManager(currentSession);
            RealmModel realm = realmManager.getRealm("original");
            ClientModel fooClient = realm.getClientByClientId("foo-client");
            Assert.assertNull((Object)realm.getClientByClientId("bar-client"));
            UserModel john = realmManager.getSession().users().getUserByUsername(realm, "john");
            UserConsentModel johnFooConsent = realmManager.getSession().users().getConsentByClient(realm, john.getId(), fooClient.getId());
            Assert.assertEquals((long)johnFooConsent.getGrantedClientScopes().size(), (long)1L);
            Assert.assertTrue((boolean)this.isClientScopeGranted(realm, "foo", johnFooConsent));
            Assert.assertNull((Object)realmManager.getSession().users().getConsentByClient(realm, john.getId(), (String)barClientID.get()));
        });
    }

    @Test
    @ModelTest
    public void deleteClientStorageTest(KeycloakSession session) {
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sesDelClientStore1 -> {
            KeycloakSession currentSession = sesDelClientStore1;
            RealmModel realm = currentSession.realms().getRealmByName("original");
            realm.removeComponent(clientStorageComponent);
        });
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sesDelClientStore2 -> {
            KeycloakSession currentSession = sesDelClientStore2;
            RealmModel realm = currentSession.realms().getRealmByName("original");
            ClientModel hardcodedClient = currentSession.clients().getClientByClientId(realm, "hardcoded-client");
            Assert.assertNull((Object)hardcodedClient);
            UserModel mary = currentSession.users().getUserByUsername(realm, "mary");
            Assert.assertEquals((long)1L, (long)currentSession.users().getConsentsStream(realm, mary.getId()).count());
        });
    }

    private boolean isClientScopeGranted(RealmModel realm, String scopeName, UserConsentModel consentModel) {
        ClientScopeModel clientScope = KeycloakModelUtils.getClientScopeByName((RealmModel)realm, (String)scopeName);
        return consentModel.isClientScopeGranted(clientScope);
    }

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
    }
}

