/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.model;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.arquillian.annotation.ModelTest;
import org.keycloak.testsuite.runonserver.RunOnServerException;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class SimpleModelTest
extends AbstractKeycloakTest {
    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
    }

    @Test
    @ModelTest
    public void simpleModelTest(KeycloakSession session) {
        this.log.infof("simpleModelTest", new Object[0]);
        RealmModel realm = session.realms().getRealmByName("master");
        Assert.assertNotNull((String)"Master realm was not found!", (Object)realm);
    }

    @Test
    @ModelTest
    public void simpleModelTestWithNestedTransactions(KeycloakSession session) {
        this.log.infof("simpleModelTestWithNestedTransactions", new Object[0]);
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), session1 -> {
            RealmModel realm = session1.realms().createRealm("foo");
            realm.setDefaultRole(session1.roles().addRealmRole(realm, "default-roles-" + realm.getName()));
        });
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), session2 -> {
            RealmModel realm = session2.realms().getRealmByName("foo");
            Assert.assertNotNull((Object)realm);
            realm.setAttribute("bar", "baz");
        });
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), session3 -> {
            RealmModel realm = session3.realms().getRealmByName("foo");
            Assert.assertNotNull((Object)realm);
            String attrValue = realm.getAttribute("bar");
            Assert.assertEquals((Object)"baz", (Object)attrValue);
            realm.setAttribute("bar", "baz2");
            session3.getTransactionManager().setRollbackOnly();
        });
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), session4 -> {
            RealmModel realm = session4.realms().getRealmByName("foo");
            Assert.assertNotNull((Object)realm);
            String attrValue = realm.getAttribute("bar");
            Assert.assertEquals((Object)"baz", (Object)attrValue);
            new RealmManager(session4).removeRealm(realm);
        });
    }

    @Test(expected=AssertionError.class)
    @ModelTest
    public void simpleModelTestWithAssertionError(KeycloakSession session) {
        this.log.infof("simpleModelTestWithAssertionError", new Object[0]);
        RealmModel realm = session.realms().getRealmByName("masterr");
        Assert.assertNotNull((String)"Master realm was not found!", (Object)realm);
    }

    @Test(expected=RunOnServerException.class)
    @ModelTest
    public void simpleModelTestWithOtherError(KeycloakSession session) {
        this.log.infof("simpleModelTestWithOtherError", new Object[0]);
        throw new RuntimeException("Some strange exception");
    }
}

