/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.model;

import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.AuthenticatorConfigModel;
import org.keycloak.models.ClientInitialAccessModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.ModelException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RealmProvider;
import org.keycloak.models.RequiredActionProviderModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.RoleProvider;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.arquillian.annotation.ModelTest;
import org.keycloak.testsuite.util.RealmBuilder;
import org.keycloak.testsuite.util.UserBuilder;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class OwnerReplacementTest
extends AbstractKeycloakTest {
    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        this.log.debug((Object)"Adding test realm for import from testrealm.json");
        RealmRepresentation testRealm = AbstractAdminTest.loadJson(this.getClass().getResourceAsStream("/testrealm.json"), RealmRepresentation.class);
        testRealms.add(testRealm);
        UserRepresentation user = UserBuilder.create().username("foo@user").email("foo@user.com").password("password").build();
        RealmRepresentation realm2 = RealmBuilder.create().name("foo").user(user).build();
        realm2.setId("foo");
        testRealms.add(realm2);
    }

    @Test
    @ModelTest
    public void componentsTest(KeycloakSession session1) {
        this.doTest(session1, (session, realm1) -> ((ComponentModel)realm1.getComponentsStream().findFirst().get()).getId(), (session, realm2, realm1ComponentId) -> {
            ComponentModel component = realm2.getComponent(realm1ComponentId);
            Assert.assertNull((Object)component);
        }, (session, realm1, realm2, realm1ComponentId) -> {
            ComponentModel component = realm1.getComponent(realm1ComponentId);
            component.put("key1", "Val1");
            realm2.updateComponent(component);
        }, (session, realm1, realm1ComponentId) -> {
            ComponentModel component = realm1.getComponent(realm1ComponentId);
            Assert.assertNull((Object)component.get("key1"));
        }, (session, realm1, realm2, realm1ComponentId) -> {
            ComponentModel component = realm1.getComponent(realm1ComponentId);
            realm2.removeComponent(component);
        }, (session, realm1, realm1ComponentId) -> {
            ComponentModel component = realm1.getComponent(realm1ComponentId);
            Assert.assertNotNull((Object)component);
        });
    }

    @Test
    @ModelTest
    public void requiredActionProvidersTest(KeycloakSession session1) {
        this.doTest(session1, (session, realm1) -> ((RequiredActionProviderModel)realm1.getRequiredActionProvidersStream().findFirst().get()).getId(), (session, realm2, realm1ReqActionId) -> {
            RequiredActionProviderModel reqAction = realm2.getRequiredActionProviderById(realm1ReqActionId);
            Assert.assertNull((Object)reqAction);
        }, (session, realm1, realm2, realm1ReqActionId) -> {
            RequiredActionProviderModel reqAction = realm1.getRequiredActionProviderById(realm1ReqActionId);
            reqAction.getConfig().put("key1", "Val1");
            realm2.updateRequiredActionProvider(reqAction);
        }, (session, realm1, realm1ReqActionId) -> {
            RequiredActionProviderModel reqAction = realm1.getRequiredActionProviderById(realm1ReqActionId);
            Assert.assertNull(reqAction.getConfig().get("key1"));
        }, (session, realm1, realm2, realm1ReqActionId) -> {
            RequiredActionProviderModel reqAction = realm1.getRequiredActionProviderById(realm1ReqActionId);
            realm2.removeRequiredActionProvider(reqAction);
        }, (session, realm1, realm1ReqActionId) -> {
            RequiredActionProviderModel reqAction = realm1.getRequiredActionProviderById(realm1ReqActionId);
            Assert.assertNotNull((Object)reqAction);
        });
    }

    @Test
    @ModelTest
    public void authenticationFlowsTest(KeycloakSession session1) {
        this.doTest(session1, (session, realm1) -> {
            AuthenticationFlowModel flow = realm1.getFlowByAlias("browser");
            return flow.getId();
        }, (session, realm2, realm1FlowId) -> {
            AuthenticationFlowModel flow = realm2.getAuthenticationFlowById(realm1FlowId);
            Assert.assertNull((Object)flow);
        }, (session, realm1, realm2, realm1FlowId) -> {
            AuthenticationFlowModel flow = realm1.getAuthenticationFlowById(realm1FlowId);
            flow.setDescription("foo");
            realm2.updateAuthenticationFlow(flow);
        }, (session, realm1, realm1FlowId) -> {
            AuthenticationFlowModel flow = realm1.getAuthenticationFlowById(realm1FlowId);
            Assert.assertNotEquals((Object)"foo", (Object)flow.getDescription());
        }, (session, realm1, realm2, realm1FlowId) -> {
            AuthenticationFlowModel flow = realm1.getAuthenticationFlowById(realm1FlowId);
            realm2.removeAuthenticationFlow(flow);
        }, (session, realm1, realm1FlowId) -> {
            AuthenticationFlowModel flow = realm1.getAuthenticationFlowById(realm1FlowId);
            Assert.assertNotNull((Object)flow);
        });
    }

    @Test
    @ModelTest
    public void authenticationExecutionsTest(KeycloakSession session1) {
        this.doTest(session1, (session, realm1) -> {
            AuthenticationFlowModel flow = realm1.getFlowByAlias("browser");
            return ((AuthenticationExecutionModel)realm1.getAuthenticationExecutionsStream(flow.getId()).findFirst().get()).getId();
        }, (session, realm2, realm1ExecutionId) -> {
            AuthenticationExecutionModel execution = realm2.getAuthenticationExecutionById(realm1ExecutionId);
            Assert.assertNull((Object)execution);
        }, (session, realm1, realm2, realm1ExecutionId) -> {
            AuthenticationExecutionModel execution = realm1.getAuthenticationExecutionById(realm1ExecutionId);
            execution.setPriority(1234);
            realm2.updateAuthenticatorExecution(execution);
        }, (session, realm1, realm1ExecutionId) -> {
            AuthenticationExecutionModel execution = realm1.getAuthenticationExecutionById(realm1ExecutionId);
            Assert.assertNotEquals((long)1234L, (long)execution.getPriority());
        }, (session, realm1, realm2, realm1ExecutionId) -> {
            AuthenticationExecutionModel execution = realm1.getAuthenticationExecutionById(realm1ExecutionId);
            realm2.removeAuthenticatorExecution(execution);
        }, (session, realm1, realm1ExecutionId) -> {
            AuthenticationExecutionModel execution = realm1.getAuthenticationExecutionById(realm1ExecutionId);
            Assert.assertNotNull((Object)execution);
        });
    }

    @Test
    @ModelTest
    public void authenticationConfigsTest(KeycloakSession session1) {
        this.doTest(session1, (session, realm1) -> ((AuthenticatorConfigModel)realm1.getAuthenticatorConfigsStream().findFirst().get()).getId(), (session, realm2, realm1AuthConfigId) -> {
            AuthenticatorConfigModel config = realm2.getAuthenticatorConfigById(realm1AuthConfigId);
            Assert.assertNull((Object)config);
        }, (session, realm1, realm2, realm1AuthConfigId) -> {
            AuthenticatorConfigModel config = realm1.getAuthenticatorConfigById(realm1AuthConfigId);
            config.getConfig().put("key1", "val1");
            realm2.updateAuthenticatorConfig(config);
        }, (session, realm1, realm1AuthConfigId) -> {
            AuthenticatorConfigModel config = realm1.getAuthenticatorConfigById(realm1AuthConfigId);
            Assert.assertNull(config.getConfig().get("key1"));
        }, (session, realm1, realm2, realm1AuthConfigId) -> {
            AuthenticatorConfigModel config = realm1.getAuthenticatorConfigById(realm1AuthConfigId);
            realm2.removeAuthenticatorConfig(config);
        }, (session, realm1, realm1AuthConfigId) -> {
            AuthenticatorConfigModel config = realm1.getAuthenticatorConfigById(realm1AuthConfigId);
            Assert.assertNotNull((Object)config);
        });
    }

    @Test
    @ModelTest
    public void clientInitialAccessTest(KeycloakSession session1) {
        this.doTest(session1, (session, realm1) -> {
            ClientInitialAccessModel clientInitialAccess = ((RealmProvider)session.getProvider(RealmProvider.class)).createClientInitialAccessModel(realm1, 10, 20);
            return clientInitialAccess.getId();
        }, (session, realm2, realm1ClientInitialAccessId) -> {
            ClientInitialAccessModel clientInitialAccess = ((RealmProvider)session.getProvider(RealmProvider.class)).getClientInitialAccessModel(realm2, realm1ClientInitialAccessId);
            Assert.assertNull((Object)clientInitialAccess);
        }, (session, realm1, realm2, realm1ClientInitialAccessId) -> {}, (session, realm1, realm1ClientInitialAccessId) -> {}, (session, realm1, realm2, realm1ClientInitialAccessId) -> ((RealmProvider)session.getProvider(RealmProvider.class)).removeClientInitialAccessModel(realm2, realm1ClientInitialAccessId), (session, realm1, realm1ClientInitialAccessId) -> {
            ClientInitialAccessModel clientInitialAccess = ((RealmProvider)session.getProvider(RealmProvider.class)).getClientInitialAccessModel(realm1, realm1ClientInitialAccessId);
            Assert.assertNotNull((Object)clientInitialAccess);
        });
    }

    @Test
    @ModelTest
    public void rolesTest(KeycloakSession session1) {
        this.doTest(session1, (session, realm1) -> {
            RoleModel role = ((RoleProvider)session.getProvider(RoleProvider.class)).addRealmRole(realm1, "foo");
            return role.getId();
        }, (session, realm2, realm1RoleId) -> {
            RoleModel role = ((RoleProvider)session.getProvider(RoleProvider.class)).getRoleById(realm2, realm1RoleId);
            Assert.assertNull((Object)role);
        }, (session, realm1, realm2, realm1RoleId) -> {}, (session, realm1, realm1RoleId) -> {}, (session, realm1, realm2, realm1RoleId) -> {}, (session, realm1, realm1RoleId) -> {});
    }

    @Test
    @ModelTest
    public void userSessionsTest(KeycloakSession session1) {
        this.doTest(session1, (session, realm1) -> {
            UserModel user = session.users().getUserByUsername(realm1, "test-user@localhost");
            UserSessionModel userSession = session.sessions().createUserSession(realm1, user, user.getUsername(), "1.2.3.4", "bar", false, null, null);
            return userSession.getId();
        }, (session, realm2, realm1SessionId) -> {
            UserSessionModel userSession = session.sessions().getUserSession(realm2, realm1SessionId);
            Assert.assertNull((Object)userSession);
        }, (session, realm1, realm2, realm1SessionId) -> {}, (session, realm1, realm1SessionId) -> {}, (session, realm1, realm2, realm1SessionId) -> {
            UserSessionModel userSession = session.sessions().getUserSession(realm1, realm1SessionId);
            session.sessions().removeUserSession(realm2, userSession);
        }, (session, realm1, realm1SessionId) -> {
            UserSessionModel userSession = session.sessions().getUserSession(realm1, realm1SessionId);
            Assert.assertNotNull((Object)userSession);
        });
    }

    private void doTest(KeycloakSession session1, BiFunction<KeycloakSession, RealmModel, String> realm1ObjectIdProducer, TriConsumer<KeycloakSession, RealmModel, String> testLookupRealm1ObjectInRealm2, TetraConsumer<KeycloakSession, RealmModel, RealmModel, String> updaterRealm1ObjectInRealm2, TriConsumer<KeycloakSession, RealmModel, String> testUpdateFailed, TetraConsumer<KeycloakSession, RealmModel, RealmModel, String> removeRealm1ObjectInRealm2, TriConsumer<KeycloakSession, RealmModel, String> testRemoveFailed) {
        AtomicReference realm1ObjectId = new AtomicReference();
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session1.getKeycloakSessionFactory(), session -> {
            RealmModel realm1 = ((RealmProvider)session.getProvider(RealmProvider.class)).getRealm("test");
            realm1ObjectId.set((String)realm1ObjectIdProducer.apply(session, realm1));
        });
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session1.getKeycloakSessionFactory(), session -> {
            RealmModel realm1 = ((RealmProvider)session.getProvider(RealmProvider.class)).getRealm("test");
            RealmModel realm2 = ((RealmProvider)session.getProvider(RealmProvider.class)).getRealm("foo");
            testLookupRealm1ObjectInRealm2.accept(session, realm2, (String)realm1ObjectId.get());
            updaterRealm1ObjectInRealm2.accept(session, realm1, realm2, (String)realm1ObjectId.get());
        });
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session1.getKeycloakSessionFactory(), session -> {
            RealmModel realm1 = ((RealmProvider)session.getProvider(RealmProvider.class)).getRealm("test");
            testUpdateFailed.accept(session, realm1, (String)realm1ObjectId.get());
        });
        try {
            KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session1.getKeycloakSessionFactory(), session -> {
                RealmModel realm1 = ((RealmProvider)session.getProvider(RealmProvider.class)).getRealm("test");
                RealmModel realm2 = ((RealmProvider)session.getProvider(RealmProvider.class)).getRealm("foo");
                removeRealm1ObjectInRealm2.accept(session, realm1, realm2, (String)realm1ObjectId.get());
            });
        }
        catch (ModelException modelException) {
            // empty catch block
        }
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session1.getKeycloakSessionFactory(), session -> {
            RealmModel realm1 = ((RealmProvider)session.getProvider(RealmProvider.class)).getRealm("test");
            testRemoveFailed.accept(session, realm1, (String)realm1ObjectId.get());
        });
    }

    @FunctionalInterface
    public static interface TetraConsumer<T, U, V, W> {
        public void accept(T var1, U var2, V var3, W var4);
    }

    @FunctionalInterface
    public static interface TriConsumer<T, U, V> {
        public void accept(T var1, U var2, V var3);
    }
}

