/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.model;

import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.credential.CredentialInput;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserManager;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.AbstractTestRealmKeycloakTest;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.arquillian.annotation.ModelTest;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class MultipleRealmsTest
extends AbstractTestRealmKeycloakTest {
    public static void createObjects(KeycloakSession session, RealmModel realm) {
        ClientModel app1 = realm.addClient("app1");
        realm.addClient("app2");
        session.users().addUser(realm, "user1");
        session.users().addUser(realm, "user2");
        realm.addRole("role1");
        realm.addRole("role2");
        app1.addRole("app1Role1");
        app1.addScopeMapping(realm.getRole("role1"));
        realm.addClient("cl1");
    }

    @Test
    @ModelTest
    public void testUsers(KeycloakSession session) {
        AtomicReference r1user1Atomic = new AtomicReference();
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sessionTestUser1 -> {
            KeycloakSession currentSession = sessionTestUser1;
            RealmModel realm1 = currentSession.realms().createRealm("id1", "realm1");
            RealmModel realm2 = currentSession.realms().createRealm("id2", "realm2");
            realm1.setDefaultRole(currentSession.roles().addRealmRole(realm1, "default-roles-" + realm1.getName()));
            realm2.setDefaultRole(currentSession.roles().addRealmRole(realm2, "default-roles-" + realm2.getName()));
            MultipleRealmsTest.createObjects(currentSession, realm1);
            MultipleRealmsTest.createObjects(currentSession, realm2);
            UserModel r1user1 = currentSession.users().getUserByUsername(realm1, "user1");
            UserModel r2user1 = currentSession.users().getUserByUsername(realm2, "user1");
            r1user1Atomic.set(r1user1);
            Assert.assertEquals((Object)r1user1.getUsername(), (Object)r2user1.getUsername());
            Assert.assertNotEquals((Object)r1user1.getId(), (Object)r2user1.getId());
            currentSession.userCredentialManager().updateCredential(realm1, r1user1, (CredentialInput)UserCredentialModel.password((String)"pass1"));
            currentSession.userCredentialManager().updateCredential(realm2, r2user1, (CredentialInput)UserCredentialModel.password((String)"pass2"));
            Assert.assertTrue((boolean)currentSession.userCredentialManager().isValid(realm1, r1user1, new CredentialInput[]{UserCredentialModel.password((String)"pass1")}));
            Assert.assertFalse((boolean)currentSession.userCredentialManager().isValid(realm1, r1user1, new CredentialInput[]{UserCredentialModel.password((String)"pass2")}));
            Assert.assertFalse((boolean)currentSession.userCredentialManager().isValid(realm2, r2user1, new CredentialInput[]{UserCredentialModel.password((String)"pass1")}));
            Assert.assertTrue((boolean)currentSession.userCredentialManager().isValid(realm2, r2user1, new CredentialInput[]{UserCredentialModel.password((String)"pass2")}));
            Assert.assertEquals((long)2L, (long)currentSession.users().searchForUserStream(realm1, "user").count());
        });
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sessionTestUser2 -> {
            KeycloakSession currentSession = sessionTestUser2;
            RealmModel realm1 = currentSession.realms().getRealm("id1");
            RealmModel realm2 = currentSession.realms().getRealm("id2");
            UserModel r1user1 = (UserModel)r1user1Atomic.get();
            currentSession.users().removeUser(realm1, r1user1);
            UserModel user2 = currentSession.users().getUserByUsername(realm1, "user2");
            currentSession.users().removeUser(realm1, user2);
            Assert.assertEquals((long)0L, (long)currentSession.users().searchForUserStream(realm1, "user").count());
            Assert.assertEquals((long)2L, (long)currentSession.users().searchForUserStream(realm2, "user").count());
            UserModel user1 = currentSession.users().getUserByUsername(realm1, "user1");
            UserModel user1a = currentSession.users().getUserByUsername(realm2, "user1");
            UserManager um = new UserManager(currentSession);
            if (user1 != null) {
                um.removeUser(realm1, user1);
            }
            if (user1a != null) {
                um.removeUser(realm2, user1a);
            }
        });
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sessionTestUser3 -> {
            KeycloakSession currentSession = sessionTestUser3;
            currentSession.realms().removeRealm("id1");
            currentSession.realms().removeRealm("id2");
        });
    }

    @Test
    @ModelTest
    public void testGetById(KeycloakSession session) {
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sessionById -> {
            KeycloakSession currentSession = sessionById;
            RealmModel realm1 = currentSession.realms().createRealm("id1", "realm1");
            RealmModel realm2 = currentSession.realms().createRealm("id2", "realm2");
            realm1.setDefaultRole(currentSession.roles().addRealmRole(realm1, "default-roles-" + realm1.getName()));
            realm2.setDefaultRole(currentSession.roles().addRealmRole(realm2, "default-roles-" + realm2.getName()));
            MultipleRealmsTest.createObjects(currentSession, realm1);
            MultipleRealmsTest.createObjects(currentSession, realm2);
            Assert.assertEquals((Object)realm1, (Object)currentSession.realms().getRealm("id1"));
            Assert.assertEquals((Object)realm1, (Object)currentSession.realms().getRealmByName("realm1"));
            Assert.assertEquals((Object)realm2, (Object)currentSession.realms().getRealm("id2"));
            Assert.assertEquals((Object)realm2, (Object)currentSession.realms().getRealmByName("realm2"));
            ClientModel r1app1 = realm1.getClientByClientId("app1");
            Assert.assertNotNull((Object)realm1.getClientByClientId("app2"));
            Assert.assertNotNull((Object)realm2.getClientByClientId("app1"));
            Assert.assertNotNull((Object)realm2.getClientByClientId("app2"));
            Assert.assertEquals((Object)r1app1, (Object)realm1.getClientById(r1app1.getId()));
            Assert.assertNull((Object)realm2.getClientById(r1app1.getId()));
            ClientModel r2cl1 = realm2.getClientByClientId("cl1");
            Assert.assertEquals((Object)r2cl1.getId(), (Object)realm2.getClientById(r2cl1.getId()).getId());
            Assert.assertNull((Object)realm1.getClientByClientId(r2cl1.getId()));
            RoleModel r1App1Role = r1app1.getRole("app1Role1");
            Assert.assertEquals((Object)r1App1Role, (Object)realm1.getRoleById(r1App1Role.getId()));
            Assert.assertNull((Object)realm2.getRoleById(r1App1Role.getId()));
            RoleModel r2Role1 = realm2.getRole("role2");
            Assert.assertNull((Object)realm1.getRoleById(r2Role1.getId()));
            Assert.assertEquals((Object)r2Role1, (Object)realm2.getRoleById(r2Role1.getId()));
            UserModel user1 = currentSession.users().getUserByUsername(realm1, "user1");
            UserModel user1a = currentSession.users().getUserByUsername(realm2, "user1");
            UserManager um = new UserManager(currentSession);
            if (user1 != null) {
                um.removeUser(realm1, user1);
            }
            if (user1a != null) {
                um.removeUser(realm2, user1a);
            }
            currentSession.realms().removeRealm("id1");
            currentSession.realms().removeRealm("id2");
        });
    }

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
    }
}

