/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.model;

import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.junit.Test;
import org.keycloak.credential.CredentialModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.credential.OTPCredentialModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.AbstractTestRealmKeycloakTest;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.arquillian.annotation.ModelTest;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class CredentialModelTest
extends AbstractTestRealmKeycloakTest {
    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
    }

    @Test
    @ModelTest
    public void testCredentialCRUD(KeycloakSession session) throws Exception {
        AtomicReference passwordId = new AtomicReference();
        AtomicReference otp1Id = new AtomicReference();
        AtomicReference otp2Id = new AtomicReference();
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), currentSession -> {
            RealmModel realm = currentSession.realms().getRealmByName("test");
            UserModel user = currentSession.users().getUserByUsername(realm, "test-user@localhost");
            List list = currentSession.userCredentialManager().getStoredCredentialsStream(realm, user).collect(Collectors.toList());
            Assert.assertEquals((long)1L, (long)list.size());
            passwordId.set(((CredentialModel)list.get(0)).getId());
            OTPCredentialModel otp1 = OTPCredentialModel.createFromPolicy((RealmModel)realm, (String)"secret1");
            OTPCredentialModel otp2 = OTPCredentialModel.createFromPolicy((RealmModel)realm, (String)"secret2");
            otp1 = currentSession.userCredentialManager().createCredential(realm, user, (CredentialModel)otp1);
            otp2 = currentSession.userCredentialManager().createCredential(realm, user, (CredentialModel)otp2);
            otp1Id.set(otp1.getId());
            otp2Id.set(otp2.getId());
        });
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), currentSession -> {
            RealmModel realm = currentSession.realms().getRealmByName("test");
            UserModel user = currentSession.users().getUserByUsername(realm, "test-user@localhost");
            List<CredentialModel> list = currentSession.userCredentialManager().getStoredCredentialsStream(realm, user).collect(Collectors.toList());
            this.assertOrder(list, (String)passwordId.get(), (String)otp1Id.get(), (String)otp2Id.get());
            Assert.assertFalse((boolean)currentSession.userCredentialManager().moveCredentialTo(realm, user, (String)passwordId.get(), "not-known"));
            Assert.assertFalse((boolean)currentSession.userCredentialManager().moveCredentialTo(realm, user, "not-known", (String)otp2Id.get()));
            Assert.assertTrue((boolean)currentSession.userCredentialManager().moveCredentialTo(realm, user, (String)otp2Id.get(), (String)passwordId.get()));
        });
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), currentSession -> {
            RealmModel realm = currentSession.realms().getRealmByName("test");
            UserModel user = currentSession.users().getUserByUsername(realm, "test-user@localhost");
            List<CredentialModel> list = currentSession.userCredentialManager().getStoredCredentialsStream(realm, user).collect(Collectors.toList());
            this.assertOrder(list, (String)passwordId.get(), (String)otp2Id.get(), (String)otp1Id.get());
            Assert.assertTrue((boolean)currentSession.userCredentialManager().moveCredentialTo(realm, user, (String)otp2Id.get(), null));
        });
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), currentSession -> {
            RealmModel realm = currentSession.realms().getRealmByName("test");
            UserModel user = currentSession.users().getUserByUsername(realm, "test-user@localhost");
            List<CredentialModel> list = currentSession.userCredentialManager().getStoredCredentialsStream(realm, user).collect(Collectors.toList());
            this.assertOrder(list, (String)otp2Id.get(), (String)passwordId.get(), (String)otp1Id.get());
            Assert.assertTrue((boolean)currentSession.userCredentialManager().moveCredentialTo(realm, user, (String)passwordId.get(), (String)otp1Id.get()));
        });
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), currentSession -> {
            RealmModel realm = currentSession.realms().getRealmByName("test");
            UserModel user = currentSession.users().getUserByUsername(realm, "test-user@localhost");
            List<CredentialModel> list = currentSession.userCredentialManager().getStoredCredentialsStream(realm, user).collect(Collectors.toList());
            this.assertOrder(list, (String)otp2Id.get(), (String)otp1Id.get(), (String)passwordId.get());
            Assert.assertTrue((boolean)currentSession.userCredentialManager().moveCredentialTo(realm, user, (String)otp2Id.get(), (String)passwordId.get()));
        });
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), currentSession -> {
            RealmModel realm = currentSession.realms().getRealmByName("test");
            UserModel user = currentSession.users().getUserByUsername(realm, "test-user@localhost");
            List<CredentialModel> list = currentSession.userCredentialManager().getStoredCredentialsStream(realm, user).collect(Collectors.toList());
            this.assertOrder(list, (String)otp1Id.get(), (String)passwordId.get(), (String)otp2Id.get());
            Assert.assertTrue((boolean)currentSession.userCredentialManager().removeStoredCredential(realm, user, (String)passwordId.get()));
        });
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), currentSession -> {
            RealmModel realm = currentSession.realms().getRealmByName("test");
            UserModel user = currentSession.users().getUserByUsername(realm, "test-user@localhost");
            List<CredentialModel> list = currentSession.userCredentialManager().getStoredCredentialsStream(realm, user).collect(Collectors.toList());
            this.assertOrder(list, (String)otp1Id.get(), (String)otp2Id.get());
        });
    }

    private void assertOrder(List<CredentialModel> creds, String ... expectedIds) {
        Assert.assertEquals((long)expectedIds.length, (long)creds.size());
        if (creds.size() == 0) {
            return;
        }
        for (int i = 0; i < expectedIds.length; ++i) {
            Assert.assertEquals((Object)creds.get(i).getId(), (Object)expectedIds[i]);
        }
    }
}

