/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.model;

import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.logging.Logger;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserManager;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.AbstractTestRealmKeycloakTest;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.arquillian.annotation.ModelTest;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class ConcurrentTransactionsTest
extends AbstractTestRealmKeycloakTest {
    private static final int LATCH_TIMEOUT_MS = 30000;
    private static final Logger logger = Logger.getLogger(ConcurrentTransactionsTest.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @ModelTest
    public void persistClient(KeycloakSession session) {
        ClientModel[] client = new ClientModel[]{null};
        AtomicReference clientDBIdAtomic = new AtomicReference();
        AtomicReference exceptionHolder = new AtomicReference();
        try {
            KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sessionSetup -> {
                RealmModel realm = sessionSetup.realms().getRealm("test");
                sessionSetup.users().addUser(realm, "user1").setEmail("user1@localhost");
                sessionSetup.users().addUser(realm, "user2").setEmail("user2@localhost");
                realm = sessionSetup.realms().createRealm("original");
                RoleModel defaultRole = sessionSetup.roles().addRealmRole(realm, "default-roles-" + realm.getName());
                realm.setDefaultRole(defaultRole);
                client[0] = sessionSetup.clients().addClient(realm, "client");
                client[0].setSecret("old");
            });
            KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), session1 -> {
                String clientDBId = client[0].getId();
                clientDBIdAtomic.set(clientDBId);
                KeycloakSessionFactory sessionFactory = session1.getKeycloakSessionFactory();
                CountDownLatch transactionsCounter = new CountDownLatch(2);
                CountDownLatch readLatch = new CountDownLatch(1);
                CountDownLatch updateLatch = new CountDownLatch(1);
                Thread thread1 = new Thread(() -> KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)sessionFactory, session11 -> {
                    try {
                        KeycloakSession currentSession = session11;
                        transactionsCounter.countDown();
                        logger.info((Object)"transaction1 started");
                        if (!transactionsCounter.await(30000L, TimeUnit.MILLISECONDS)) {
                            throw new IllegalStateException("Timeout when waiting for transactionsCounter latch in thread1");
                        }
                        RealmModel realm1 = currentSession.realms().getRealmByName("original");
                        ClientModel client1 = currentSession.clients().getClientByClientId(realm1, "client");
                        logger.info((Object)"transaction1: Read client finished");
                        readLatch.countDown();
                        if (!updateLatch.await(30000L, TimeUnit.MILLISECONDS)) {
                            throw new IllegalStateException("Timeout when waiting for updateLatch");
                        }
                        logger.info((Object)"transaction1: Going to read client again");
                        client1 = currentSession.clients().getClientByClientId(realm1, "client");
                        logger.info((Object)("transaction1: secret: " + client1.getSecret()));
                    }
                    catch (Exception e) {
                        exceptionHolder.set(e);
                        throw new RuntimeException(e);
                    }
                }));
                Thread thread2 = new Thread(() -> {
                    KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)sessionFactory, session22 -> {
                        try {
                            KeycloakSession currentSession = session22;
                            transactionsCounter.countDown();
                            logger.info((Object)"transaction2 started");
                            if (!transactionsCounter.await(30000L, TimeUnit.MILLISECONDS)) {
                                throw new IllegalStateException("Timeout when waiting for transactionsCounter latch in thread2");
                            }
                            if (!readLatch.await(30000L, TimeUnit.MILLISECONDS)) {
                                throw new IllegalStateException("Timeout when waiting for readLatch");
                            }
                            logger.info((Object)"transaction2: Going to update client secret");
                            RealmModel realm12 = currentSession.realms().getRealmByName("original");
                            ClientModel client12 = currentSession.clients().getClientByClientId(realm12, "client");
                            client12.setSecret("new");
                        }
                        catch (Exception e) {
                            exceptionHolder.set(e);
                            throw new RuntimeException(e);
                        }
                    });
                    logger.info((Object)"transaction2: commited");
                    updateLatch.countDown();
                });
                thread1.start();
                thread2.start();
                try {
                    thread1.join();
                    thread2.join();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (exceptionHolder.get() != null) {
                    Assert.fail((String)"Some thread thrown an exception. See the log for the details");
                }
                logger.info((Object)"after thread join");
            });
            KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), session2 -> {
                RealmModel realm = session2.realms().getRealmByName("original");
                String clientDBId = (String)clientDBIdAtomic.get();
                ClientModel clientFromCache = session2.clients().getClientById(realm, clientDBId);
                ClientModel clientFromDB = ((ClientProvider)session2.getProvider(ClientProvider.class)).getClientById(realm, clientDBId);
                logger.info((Object)("SECRET FROM DB : " + clientFromDB.getSecret()));
                logger.info((Object)("SECRET FROM CACHE : " + clientFromCache.getSecret()));
                Assert.assertEquals((Object)"new", (Object)clientFromDB.getSecret());
                Assert.assertEquals((Object)"new", (Object)clientFromCache.getSecret());
                session2.sessions().removeUserSessions(realm);
            });
        }
        finally {
            this.tearDownRealm(session, "user1", "user2");
        }
    }

    @Test
    @ModelTest
    public void removeUserAttribute(KeycloakSession session) throws Exception {
        try {
            KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sessionSet -> {
                RealmModel realm = sessionSet.realms().createRealm("original");
                realm.setDefaultRole(sessionSet.roles().addRealmRole(realm, "default-roles-" + realm.getName()));
                UserModel john = sessionSet.users().addUser(realm, "john");
                john.setSingleAttribute("foo", "val1");
                UserModel john2 = sessionSet.users().addUser(realm, "john2");
                john2.setAttribute("foo", Arrays.asList("val1", "val2"));
            });
            KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), session2 -> {
                KeycloakSessionFactory sessionFactory = session2.getKeycloakSessionFactory();
                AtomicReference reference = new AtomicReference();
                CountDownLatch readAttrLatch = new CountDownLatch(2);
                Runnable runnable = () -> {
                    try {
                        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)sessionFactory, session1 -> {
                            try {
                                RealmModel realm = session1.realms().getRealmByName("original");
                                UserModel john = session1.users().getUserByUsername(realm, "john");
                                String attrVal = john.getFirstAttribute("foo");
                                UserModel john2 = session1.users().getUserByUsername(realm, "john2");
                                String attrVal2 = john2.getFirstAttribute("foo");
                                readAttrLatch.countDown();
                                readAttrLatch.await();
                                john.removeAttribute("foo");
                                john2.setSingleAttribute("foo", "bar");
                            }
                            catch (Exception e) {
                                throw new RuntimeException(e);
                            }
                        });
                    }
                    catch (Exception e) {
                        reference.set(e);
                        throw new RuntimeException(e);
                    }
                    finally {
                        readAttrLatch.countDown();
                    }
                };
                Thread thread1 = new Thread(runnable);
                Thread thread2 = new Thread(runnable);
                thread1.start();
                thread2.start();
                try {
                    thread1.join();
                    thread2.join();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                logger.info((Object)"removeUserAttribute: after thread join");
                if (reference.get() != null) {
                    Assert.fail((String)("Exception happened in some of threads. Details: " + ((Exception)reference.get()).getMessage()));
                }
            });
        }
        finally {
            this.tearDownRealm(session, "john", "john2");
        }
    }

    private void tearDownRealm(KeycloakSession session, String user1, String user2) {
        KeycloakSession currentSession = session;
        RealmModel realm = currentSession.realms().getRealmByName("original");
        UserModel realmUser1 = currentSession.users().getUserByUsername(realm, user1);
        UserModel realmUser2 = currentSession.users().getUserByUsername(realm, user2);
        UserManager um = new UserManager(currentSession);
        if (realmUser1 != null) {
            um.removeUser(realm, realmUser1);
        }
        if (realmUser2 != null) {
            um.removeUser(realm, realmUser2);
        }
        Assert.assertTrue((boolean)currentSession.realms().removeRealm(realm.getId()));
        Assert.assertThat((Object)currentSession.realms().getRealm(realm.getId()), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
    }
}

