/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.model;

import java.io.Serializable;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.junit.Test;
import org.keycloak.models.ClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.cache.infinispan.ClientAdapter;
import org.keycloak.models.cache.infinispan.RealmAdapter;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.AbstractTestRealmKeycloakTest;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.runonserver.RunOnServer;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class CacheTest
extends AbstractTestRealmKeycloakTest {
    private ClientModel testApp = null;
    private int grantedRolesCount = 0;
    private RealmModel realm = null;
    private UserModel user = null;

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
    }

    @Test
    public void testStaleCache() throws Exception {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            String appId = null;
            RealmModel realm = session.realms().getRealmByName("test");
            org.junit.Assert.assertTrue((boolean)(realm instanceof RealmAdapter));
            ClientModel testApp = realm.getClientByClientId("test-app");
            org.junit.Assert.assertTrue((boolean)(testApp instanceof ClientAdapter));
            org.junit.Assert.assertNotNull((Object)testApp);
            appId = testApp.getId();
            org.junit.Assert.assertTrue((boolean)testApp.isEnabled());
            realm = session.realms().getRealmsStream().filter(r -> {
                org.junit.Assert.assertTrue((boolean)(r instanceof RealmAdapter));
                return "test".equals(r.getName());
            }).findFirst().orElse(null);
            org.junit.Assert.assertNotNull((Object)realm);
            realm.setAccessCodeLifespanLogin(200);
            testApp = realm.getClientByClientId("test-app");
            org.junit.Assert.assertNotNull((Object)testApp);
            testApp.setEnabled(false);
            realm = session.realms().getRealmByName("test");
            Assert.assertEquals((long)200L, (long)realm.getAccessCodeLifespanLogin());
            testApp = session.clients().getClientById(realm, appId);
            Assert.assertFalse((boolean)testApp.isEnabled());
        });
    }

    @Test
    public void testAddUserNotAddedToCache() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel realm = session.realms().getRealmByName("test");
            UserModel user = session.users().addUser(realm, "testAddUserNotAddedToCache");
            user.setFirstName("firstName");
            user.addRequiredAction(UserModel.RequiredAction.CONFIGURE_TOTP);
            UserSessionModel userSession = session.sessions().createUserSession(UUID.randomUUID().toString(), realm, user, "testAddUserNotAddedToCache", "127.0.0.1", "auth", false, null, null, UserSessionModel.SessionPersistenceState.PERSISTENT);
            user = userSession.getUser();
            user.setLastName("lastName");
            org.junit.Assert.assertNotNull((Object)user.getLastName());
        });
    }

    @Test
    public void testRoleMappingsInvalidatedWhenClientRemoved() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel realm = session.realms().getRealmByName("test");
            UserModel user = session.users().addUser(realm, "joel");
            ClientModel client = realm.addClient("foo");
            RoleModel fooRole = client.addRole("foo-role");
            user.grantRole(fooRole);
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel realm = session.realms().getRealmByName("test");
            UserModel user = session.users().getUserByUsername(realm, "joel");
            long grantedRolesCount = user.getRoleMappingsStream().count();
            ClientModel client = realm.getClientByClientId("foo");
            realm.removeClient(client.getId());
            realm = session.realms().getRealmByName("test");
            user = session.users().getUserByUsername(realm, "joel");
            Set roles = user.getRoleMappingsStream().collect(Collectors.toSet());
            for (RoleModel role : roles) {
                Assert.assertNotNull((Object)role.getContainer());
            }
            Assert.assertEquals((long)roles.size(), (long)(grantedRolesCount - 1L));
        });
    }
}

