/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.model;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.common.util.Time;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserManager;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.ResetTimeOffsetEvent;
import org.keycloak.provider.ProviderEvent;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.services.managers.ClientManager;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.sessions.CommonClientSessionModel;
import org.keycloak.sessions.RootAuthenticationSessionModel;
import org.keycloak.testsuite.AbstractTestRealmKeycloakTest;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.arquillian.annotation.ModelTest;
import org.keycloak.testsuite.runonserver.RunOnServer;
import org.keycloak.testsuite.util.InfinispanTestTimeServiceRule;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class AuthenticationSessionProviderTest
extends AbstractTestRealmKeycloakTest {
    @Rule
    public InfinispanTestTimeServiceRule ispnTestTimeService = new InfinispanTestTimeServiceRule(this);

    @Before
    public void before() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel realm = session.realms().getRealm("test");
            session.users().addUser(realm, "user1").setEmail("user1@localhost");
            session.users().addUser(realm, "user2").setEmail("user2@localhost");
        });
    }

    @After
    public void after() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel realm = session.realms().getRealm("test");
            session.sessions().removeUserSessions(realm);
            UserModel user1 = session.users().getUserByUsername(realm, "user1");
            UserModel user2 = session.users().getUserByUsername(realm, "user2");
            UserManager um = new UserManager(session);
            if (user1 != null) {
                um.removeUser(realm, user1);
            }
            if (user2 != null) {
                um.removeUser(realm, user2);
            }
        });
    }

    @Test
    @ModelTest
    public void testLoginSessionsCRUD(KeycloakSession session) {
        AtomicReference rootAuthSessionID = new AtomicReference();
        AtomicReference tabID = new AtomicReference();
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sessionCRUD1 -> {
            KeycloakSession currentSession = sessionCRUD1;
            RealmModel realm = currentSession.realms().getRealm("test");
            ClientModel client1 = realm.getClientByClientId("test-app");
            RootAuthenticationSessionModel rootAuthSession = currentSession.authenticationSessions().createRootAuthenticationSession(realm);
            rootAuthSessionID.set(rootAuthSession.getId());
            AuthenticationSessionModel authSession = rootAuthSession.createAuthenticationSession(client1);
            tabID.set(authSession.getTabId());
            authSession.setAction("foo");
            rootAuthSession.setTimestamp(100);
        });
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sessionCRUD2 -> {
            KeycloakSession currentSession = sessionCRUD2;
            RealmModel realm = currentSession.realms().getRealm("test");
            ClientModel client1 = realm.getClientByClientId("test-app");
            RootAuthenticationSessionModel rootAuthSession = currentSession.authenticationSessions().getRootAuthenticationSession(realm, (String)rootAuthSessionID.get());
            AuthenticationSessionModel authSession = rootAuthSession.getAuthenticationSession(client1, (String)tabID.get());
            this.testAuthenticationSession(authSession, client1.getId(), null, "foo");
            Assert.assertThat((Object)rootAuthSession.getTimestamp(), (Matcher)Is.is((Object)100));
            authSession.setAction("foo-updated");
            rootAuthSession.setTimestamp(200);
            authSession.setAuthenticatedUser(currentSession.users().getUserByUsername(realm, "user1"));
        });
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sessionCRUD3 -> {
            KeycloakSession currentSession = sessionCRUD3;
            RealmModel realm = currentSession.realms().getRealm("test");
            UserModel user1 = currentSession.users().getUserByUsername(realm, "user1");
            RootAuthenticationSessionModel rootAuthSession = currentSession.authenticationSessions().getRootAuthenticationSession(realm, (String)rootAuthSessionID.get());
            ClientModel client1 = realm.getClientByClientId("test-app");
            AuthenticationSessionModel authSession = rootAuthSession.getAuthenticationSession(client1, (String)tabID.get());
            this.testAuthenticationSession(authSession, client1.getId(), user1.getId(), "foo-updated");
            Assert.assertThat((Object)rootAuthSession.getTimestamp(), (Matcher)Is.is((Object)200));
            currentSession.authenticationSessions().removeRootAuthenticationSession(realm, rootAuthSession);
        });
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sessionCRUD4 -> {
            KeycloakSession currentSession = sessionCRUD4;
            RealmModel realm = currentSession.realms().getRealm("test");
            Assert.assertThat((Object)currentSession.authenticationSessions().getRootAuthenticationSession(realm, (String)rootAuthSessionID.get()), (Matcher)IsNull.nullValue());
        });
    }

    @Test
    @ModelTest
    public void testAuthenticationSessionRestart(KeycloakSession session) {
        AtomicReference parentAuthSessionID = new AtomicReference();
        AtomicReference tabID = new AtomicReference();
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sessionRestart1 -> {
            KeycloakSession currentSession = sessionRestart1;
            RealmModel realm = currentSession.realms().getRealm("test");
            ClientModel client1 = realm.getClientByClientId("test-app");
            UserModel user1 = currentSession.users().getUserByUsername(realm, "user1");
            AuthenticationSessionModel authSession = currentSession.authenticationSessions().createRootAuthenticationSession(realm).createAuthenticationSession(client1);
            parentAuthSessionID.set(authSession.getParentSession().getId());
            tabID.set(authSession.getTabId());
            authSession.setAction("foo");
            authSession.getParentSession().setTimestamp(100);
            authSession.setAuthenticatedUser(user1);
            authSession.setAuthNote("foo", "bar");
            authSession.setClientNote("foo2", "bar2");
            authSession.setExecutionStatus("123", CommonClientSessionModel.ExecutionStatus.SUCCESS);
        });
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sessionRestart2 -> {
            KeycloakSession currentSession = sessionRestart2;
            RealmModel realm = currentSession.realms().getRealm("test");
            ClientModel client1 = realm.getClientByClientId("test-app");
            AuthenticationSessionModel authSession = currentSession.authenticationSessions().getRootAuthenticationSession(realm, (String)parentAuthSessionID.get()).getAuthenticationSession(client1, (String)tabID.get());
            authSession.getParentSession().restartSession(realm);
        });
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sessionRestart3 -> {
            KeycloakSession currentSession = sessionRestart3;
            RealmModel realm = currentSession.realms().getRealm("test");
            ClientModel client1 = realm.getClientByClientId("test-app");
            RootAuthenticationSessionModel rootAuthSession = currentSession.authenticationSessions().getRootAuthenticationSession(realm, (String)parentAuthSessionID.get());
            Assert.assertThat((Object)rootAuthSession.getAuthenticationSession(client1, (String)tabID.get()), (Matcher)IsNull.nullValue());
            Assert.assertThat((Object)(rootAuthSession.getTimestamp() > 0 ? 1 : 0), (Matcher)Is.is((Object)true));
        });
    }

    @Test
    @ModelTest
    public void testExpiredAuthSessions(KeycloakSession session) {
        AtomicReference authSessionID = new AtomicReference();
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sessionExpired -> {
            KeycloakSession mainSession = sessionExpired;
            try {
                this.setAccessCodeLifespan(mainSession, 10, 10, 30);
                this.createAuthSession(mainSession, authSessionID);
                this.testExpiredOffset(mainSession, 25, false, (String)authSessionID.get());
                this.testExpiredOffset(mainSession, 35, true, (String)authSessionID.get());
                this.setAccessCodeLifespan(mainSession, -1, 40, -1);
                this.createAuthSession(mainSession, authSessionID);
                this.testExpiredOffset(mainSession, 35, false, (String)authSessionID.get());
                this.testExpiredOffset(mainSession, 45, true, (String)authSessionID.get());
                this.setAccessCodeLifespan(mainSession, 50, -1, -1);
                this.createAuthSession(mainSession, authSessionID);
                this.testExpiredOffset(mainSession, 45, false, (String)authSessionID.get());
                this.testExpiredOffset(mainSession, 55, true, (String)authSessionID.get());
            }
            finally {
                Time.setOffset((int)0);
                session.getKeycloakSessionFactory().publish((ProviderEvent)new ResetTimeOffsetEvent());
                this.setAccessCodeLifespan(mainSession, 60, 300, 1800);
            }
        });
    }

    @Test
    @ModelTest
    public void testOnRealmRemoved(KeycloakSession session) {
        AtomicReference authSessionID = new AtomicReference();
        AtomicReference authSessionID2 = new AtomicReference();
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sesRealmRemoved1 -> {
            KeycloakSession currentSession = sesRealmRemoved1;
            RealmModel realm = currentSession.realms().getRealm("test");
            RealmModel fooRealm = currentSession.realms().createRealm("foo-realm");
            fooRealm.setDefaultRole(currentSession.roles().addRealmRole(fooRealm, "default-roles-" + fooRealm.getName()));
            fooRealm.addClient("foo-client");
            authSessionID.set(currentSession.authenticationSessions().createRootAuthenticationSession(realm).getId());
            authSessionID2.set(currentSession.authenticationSessions().createRootAuthenticationSession(fooRealm).getId());
        });
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sesRealmRemoved2 -> {
            KeycloakSession currentSession = sesRealmRemoved2;
            new RealmManager(currentSession).removeRealm(currentSession.realms().getRealmByName("foo-realm"));
        });
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sesRealmRemoved3 -> {
            KeycloakSession currentSession = sesRealmRemoved3;
            RealmModel realm = currentSession.realms().getRealm("test");
            RootAuthenticationSessionModel authSession = currentSession.authenticationSessions().getRootAuthenticationSession(realm, (String)authSessionID.get());
            Assert.assertThat((Object)authSession, (Matcher)IsNull.notNullValue());
            Assert.assertThat((Object)currentSession.authenticationSessions().getRootAuthenticationSession(realm, (String)authSessionID2.get()), (Matcher)IsNull.nullValue());
        });
    }

    @Test
    @ModelTest
    public void testOnClientRemoved(KeycloakSession session) {
        AtomicReference tab1ID = new AtomicReference();
        AtomicReference tab2ID = new AtomicReference();
        AtomicReference authSessionID = new AtomicReference();
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sesRealmRemoved1 -> {
            KeycloakSession currentSession = sesRealmRemoved1;
            RealmModel realm = currentSession.realms().getRealm("test");
            authSessionID.set(currentSession.authenticationSessions().createRootAuthenticationSession(realm).getId());
            AuthenticationSessionModel authSession1 = currentSession.authenticationSessions().getRootAuthenticationSession(realm, (String)authSessionID.get()).createAuthenticationSession(realm.getClientByClientId("test-app"));
            AuthenticationSessionModel authSession2 = currentSession.authenticationSessions().getRootAuthenticationSession(realm, (String)authSessionID.get()).createAuthenticationSession(realm.getClientByClientId("third-party"));
            tab1ID.set(authSession1.getTabId());
            tab2ID.set(authSession2.getTabId());
            authSession1.setAuthNote("foo", "bar");
            authSession2.setAuthNote("foo", "baz");
        });
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sesRealmRemoved1 -> {
            KeycloakSession currentSession = sesRealmRemoved1;
            RealmModel realm = currentSession.realms().getRealm("test");
            RootAuthenticationSessionModel rootAuthSession = currentSession.authenticationSessions().getRootAuthenticationSession(realm, (String)authSessionID.get());
            Assert.assertThat((Object)rootAuthSession.getAuthenticationSessions().size(), (Matcher)Is.is((Object)2));
            Assert.assertThat((Object)rootAuthSession.getAuthenticationSession(realm.getClientByClientId("test-app"), (String)tab1ID.get()).getAuthNote("foo"), (Matcher)Is.is((Object)"bar"));
            Assert.assertThat((Object)rootAuthSession.getAuthenticationSession(realm.getClientByClientId("third-party"), (String)tab2ID.get()).getAuthNote("foo"), (Matcher)Is.is((Object)"baz"));
            new ClientManager(new RealmManager(currentSession)).removeClient(realm, realm.getClientByClientId("third-party"));
        });
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sesRealmRemoved1 -> {
            KeycloakSession currentSession = sesRealmRemoved1;
            RealmModel realm = currentSession.realms().getRealm("test");
            RootAuthenticationSessionModel rootAuthSession = currentSession.authenticationSessions().getRootAuthenticationSession(realm, (String)authSessionID.get());
            Assert.assertThat((Object)rootAuthSession.getAuthenticationSession(realm.getClientByClientId("test-app"), (String)tab1ID.get()).getAuthNote("foo"), (Matcher)Is.is((Object)"bar"));
            Assert.assertThat((Object)rootAuthSession.getAuthenticationSession(realm.getClientByClientId("third-party"), (String)tab2ID.get()), (Matcher)IsNull.nullValue());
            realm.addClient("third-party");
        });
    }

    private void testAuthenticationSession(AuthenticationSessionModel authSession, String expectedClientId, String expectedUserId, String expectedAction) {
        Assert.assertThat((Object)authSession.getClient().getId(), (Matcher)Is.is((Object)expectedClientId));
        if (expectedUserId == null) {
            Assert.assertThat((Object)authSession.getAuthenticatedUser(), (Matcher)IsNull.nullValue());
        } else {
            Assert.assertThat((Object)authSession.getAuthenticatedUser().getId(), (Matcher)Is.is((Object)expectedUserId));
        }
        if (expectedAction == null) {
            Assert.assertThat((Object)authSession.getAction(), (Matcher)IsNull.nullValue());
        } else {
            Assert.assertThat((Object)authSession.getAction(), (Matcher)Is.is((Object)expectedAction));
        }
    }

    private void createAuthSession(KeycloakSession session, AtomicReference<String> authSessionID) {
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), createAuthSession -> {
            KeycloakSession currentSession = createAuthSession;
            RealmModel realm = currentSession.realms().getRealm("test");
            Time.setOffset((int)0);
            authSessionID.set(currentSession.authenticationSessions().createRootAuthenticationSession(realm).getId());
        });
    }

    private void testExpiredOffset(KeycloakSession session, int offset, boolean isSessionNull, String authSessionID) {
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sessionExp -> {
            KeycloakSession currentSession = sessionExp;
            RealmModel realm = currentSession.realms().getRealm("test");
            Time.setOffset((int)offset);
            currentSession.authenticationSessions().removeExpired(realm);
        });
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sessionExpVerify -> {
            KeycloakSession currentSession = sessionExpVerify;
            RealmModel realm = currentSession.realms().getRealm("test");
            if (isSessionNull) {
                Assert.assertThat((Object)currentSession.authenticationSessions().getRootAuthenticationSession(realm, authSessionID), (Matcher)IsNull.nullValue());
            } else {
                Assert.assertThat((Object)currentSession.authenticationSessions().getRootAuthenticationSession(realm, authSessionID), (Matcher)IsNull.notNullValue());
            }
        });
    }

    private void setAccessCodeLifespan(KeycloakSession session, int lifespan, int lifespanUserAction, int lifespanLogin) {
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sessionLifespan -> {
            KeycloakSession currentSession = sessionLifespan;
            RealmModel realm = currentSession.realms().getRealm("test");
            if (lifespan != -1) {
                realm.setAccessCodeLifespan(lifespan);
            }
            if (lifespanUserAction != -1) {
                realm.setAccessCodeLifespanUserAction(lifespanUserAction);
            }
            if (lifespanLogin != -1) {
                realm.setAccessCodeLifespanLogin(lifespanLogin);
            }
        });
    }

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
    }
}

