/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.migration.cluster;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.infinispan.Cache;
import org.infinispan.util.concurrent.TimeoutException;
import org.jboss.arquillian.graphene.page.Page;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Indexer;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleLoader;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.After;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.keycloak.cluster.ClusterEvent;
import org.keycloak.cluster.infinispan.WrapperClusterEvent;
import org.keycloak.common.util.reflections.Reflections;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.sessions.infinispan.entities.AuthenticatedClientSessionStore;
import org.keycloak.models.sessions.infinispan.entities.SessionEntity;
import org.keycloak.models.sessions.infinispan.entities.UserSessionEntity;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.arquillian.ContainerInfo;
import org.keycloak.testsuite.arquillian.containers.KeycloakContainerEventsController;
import org.keycloak.testsuite.client.KeycloakTestingClient;
import org.keycloak.testsuite.cluster.AbstractClusterTest;
import org.keycloak.testsuite.migration.cluster.SerializableTestClass;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.rest.TestClassLoader;
import org.keycloak.testsuite.runonserver.FetchOnServer;
import org.keycloak.testsuite.runonserver.RunOnServer;
import org.keycloak.testsuite.runonserver.RunOnServerException;
import org.keycloak.testsuite.runonserver.SerializationUtil;
import org.keycloak.testsuite.util.DroneUtils;
import org.keycloak.testsuite.util.OAuthClient;

public class MultiVersionClusterTest
extends AbstractClusterTest {
    private static ContainerInfo currentNode;
    private static ContainerInfo legacyNode;
    private static boolean initialized;
    @Page
    protected LoginPage loginPage;

    @BeforeClass
    public static void enabled() {
        Assume.assumeThat((Object)System.getProperty("auth.server.legacy.version"), (Matcher)Matchers.notNullValue());
    }

    @Override
    @Before
    public void beforeClusterTest() {
        if (!initialized) {
            currentNode = this.backendNode(0);
            legacyNode = this.suiteContext.getLegacyAuthServerInfo();
            this.addAdminJsonFileToLegacy();
            initialized = true;
        }
        this.startBackendNode(legacyNode);
        this.startBackendNode(currentNode);
    }

    @After
    public void after() {
        this.killBackendNode(legacyNode);
        this.killBackendNode(currentNode);
    }

    private JavaArchive deployment() {
        return (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"negative.jar")).addPackage("org/keycloak/testsuite")).addClass(SerializableTestClass.class);
    }

    @Test
    public void verifyFailureOnLegacy() throws Exception {
        KeycloakContainerEventsController.deploy((Archive)this.deployment(), (ContainerInfo)currentNode);
        try {
            ((KeycloakTestingClient)backendTestingClients.get(currentNode)).server().run((RunOnServer & Serializable)session -> {
                try {
                    Class itShouldFail = Module.getContextModuleLoader().loadModule("deployment.negative.jar").getClassLoader().loadClassLocal(SerializableTestClass.class.getName());
                    ((InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class)).getCache("sessions").put((Object)"itShouldFail", Reflections.newInstance((Class)itShouldFail));
                }
                catch (Exception ex) {
                    throw new RunOnServerException((Throwable)ex);
                }
            });
        }
        catch (Exception e) {
            MatcherAssert.assertThat((Object)e, (Matcher)Matchers.instanceOf(RunOnServerException.class));
            MatcherAssert.assertThat((Object)e.getCause().getCause(), (Matcher)Matchers.instanceOf(TimeoutException.class));
        }
        finally {
            KeycloakContainerEventsController.undeploy((Archive)this.deployment(), (ContainerInfo)currentNode);
        }
    }

    @Test
    public void verifyFailureOnCurrent() throws Exception {
        KeycloakContainerEventsController.deploy((Archive)this.deployment(), (ContainerInfo)legacyNode);
        try {
            ((KeycloakTestingClient)backendTestingClients.get(legacyNode)).server().run((RunOnServer & Serializable)session -> {
                try {
                    Class itShouldFail = Module.getContextModuleLoader().loadModule("deployment.negative.jar").getClassLoader().loadClassLocal(SerializableTestClass.class.getName());
                    ((InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class)).getCache("sessions").put((Object)"itShouldFail", Reflections.newInstance((Class)itShouldFail));
                }
                catch (Exception ex) {
                    throw new RunOnServerException((Throwable)ex);
                }
            });
        }
        catch (Exception e) {
            MatcherAssert.assertThat((Object)e, (Matcher)Matchers.instanceOf(RunOnServerException.class));
            MatcherAssert.assertThat((Object)e.getCause().getCause(), (Matcher)Matchers.instanceOf(TimeoutException.class));
        }
        finally {
            KeycloakContainerEventsController.undeploy((Archive)this.deployment(), (ContainerInfo)legacyNode);
        }
    }

    @Test
    public void loginSuccessToLegacy() throws Exception {
        String originalServerRoot = OAuthClient.SERVER_ROOT;
        try {
            OAuthClient.updateURLs((String)legacyNode.getContextRoot().toString());
            OAuthClient oauth = new OAuthClient();
            oauth.init(DroneUtils.getCurrentDriver());
            oauth.realm("master").clientId("account").redirectUri(legacyNode.getContextRoot().toString() + "/auth/realms/master/account/");
            oauth.openLoginForm();
            MatcherAssert.assertThat((Object)DroneUtils.getCurrentDriver().getTitle(), (Matcher)Matchers.containsString((String)"Sign in to "));
            this.loginPage.login("admin", "admin");
            MatcherAssert.assertThat((String)"Login was not successful.", (Object)((String)oauth.getCurrentQuery().get("code")), (Matcher)Matchers.notNullValue());
        }
        finally {
            OAuthClient.updateURLs((String)originalServerRoot);
        }
    }

    @Test
    public void fromLegacyToCurrent() {
        Map<String, Map<String, Object>> expected = this.createCacheAndGetFromServer(legacyNode);
        Map<String, Map<String, Object>> actual = this.getFromServer(currentNode, SerializationUtil.encode((Object)expected.keySet().toString()));
        MatcherAssert.assertThat(actual, (Matcher)Matchers.equalTo(expected));
    }

    @Test
    public void fromCurrentToLegacy() {
        Map<String, Map<String, Object>> expected = this.createCacheAndGetFromServer(currentNode);
        Map<String, Map<String, Object>> actual = this.getFromServer(legacyNode, SerializationUtil.encode((Object)expected.keySet().toString()));
        MatcherAssert.assertThat(actual, (Matcher)Matchers.equalTo(expected));
    }

    private void addAdminJsonFileToLegacy() {
        try {
            FileUtils.copyFile((File)new File("target/test-classes/keycloak-add-user.json"), (File)new File(System.getProperty("auth.server.legacy.home") + "/standalone/configuration/keycloak-add-user.json"));
            this.log.debug((Object)("Successfully added keycloak-add-user.json to " + System.getProperty("auth.server.legacy.home") + "/standalone/configuration/keycloak-add-user.json"));
        }
        catch (IOException ex) {
            throw new RuntimeException("Adding admin json file failed.", ex);
        }
    }

    private Map<String, Map<String, Object>> createCacheAndGetFromServer(ContainerInfo container) {
        return ((CacheValuesHolder)((KeycloakTestingClient)backendTestingClients.get(container)).server().fetch((FetchOnServer & Serializable)session -> {
            HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>();
            try {
                Indexer indexer = new Indexer();
                DotName serializeWith = DotName.createSimple((String)"org.infinispan.commons.marshall.SerializeWith");
                ModuleLoader contextModuleLoader = Module.getContextModuleLoader();
                Module module = contextModuleLoader.loadModule("org.keycloak.keycloak-model-infinispan");
                ModuleClassLoader classLoader = module.getClassLoader();
                Enumeration resources = classLoader.getResources("org/keycloak");
                while (resources.hasMoreElements()) {
                    URL nextElement = (URL)resources.nextElement();
                    Enumeration<JarEntry> entries = new JarFile(nextElement.getFile().replace("file:", "").replace("!/org/keycloak", "")).entries();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        if (!entry.getName().endsWith(".class")) continue;
                        indexer.index(classLoader.getResourceAsStream(entry.getName()));
                    }
                }
                Cache cache = ((InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class)).getCache("sessions");
                for (AnnotationInstance annotation : indexer.complete().getAnnotations(serializeWith)) {
                    switch (annotation.target().kind()) {
                        case CLASS: {
                            Object newInstance;
                            HashMap<String, KeycloakSession> fieldValue = new HashMap<String, KeycloakSession>();
                            String className = annotation.target().asClass().name().toString();
                            Class classForName = Reflections.classForName((String)className, (ClassLoader[])new ClassLoader[]{classLoader});
                            if (Arrays.asList(classForName.getDeclaredConstructors()).stream().filter(c -> !c.isSynthetic()).anyMatch(c -> c.getParameterTypes().length == 0)) {
                                newInstance = Reflections.newInstance((Class)classForName);
                            } else {
                                Constructor constructor = Arrays.asList(classForName.getDeclaredConstructors()).stream().filter(c -> !c.isSynthetic()).findFirst().get();
                                constructor.setAccessible(true);
                                ArrayList<Comparable<Boolean>> parameters = new ArrayList<Comparable<Boolean>>();
                                for (Class<?> type : constructor.getParameterTypes()) {
                                    if (type.isPrimitive()) {
                                        if (type.equals(Boolean.TYPE)) {
                                            parameters.add(Boolean.valueOf(false));
                                            continue;
                                        }
                                        if (type.equals(Character.TYPE)) {
                                            parameters.add(Character.valueOf(' '));
                                            continue;
                                        }
                                        parameters.add(Integer.valueOf(0));
                                        continue;
                                    }
                                    if (type.equals(UUID.class)) {
                                        parameters.add(UUID.randomUUID());
                                        continue;
                                    }
                                    parameters.add(null);
                                }
                                newInstance = constructor.newInstance(parameters.toArray());
                            }
                            Set fields = Reflections.getAllDeclaredFields((Class)classForName).stream().filter(field -> !Modifier.isStatic(field.getModifiers())).collect(Collectors.toSet());
                            for (Field field2 : fields) {
                                Object value;
                                field2.setAccessible(true);
                                Class<?> type = field2.getType();
                                if (type.equals(KeycloakSession.class)) {
                                    value = session;
                                } else if (type.equals(String.class)) {
                                    value = UUID.randomUUID().toString();
                                } else if (type.equals(Boolean.TYPE) || type.equals(Boolean.class)) {
                                    value = Boolean.FALSE;
                                } else if (type.equals(Integer.TYPE) || type.equals(Integer.class)) {
                                    value = new Random().nextInt();
                                } else if (type.equals(Long.TYPE) || type.equals(Long.class)) {
                                    value = new Random().nextLong();
                                } else if (type.equals(AuthenticatedClientSessionStore.class)) {
                                    value = new AuthenticatedClientSessionStore();
                                } else if (type.equals(UserSessionModel.State.class)) {
                                    value = UserSessionModel.State.LOGGING_OUT;
                                } else if (type.equals(Map.class)) {
                                    value = new HashMap();
                                } else if (type.equals(ConcurrentHashMap.class)) {
                                    value = new ConcurrentHashMap();
                                } else if (type.equals(Set.class)) {
                                    value = new HashSet();
                                } else if (type.equals(ClusterEvent.class)) {
                                    value = new WrapperClusterEvent();
                                } else if (type.equals(UUID.class)) {
                                    value = UUID.randomUUID();
                                } else if (type.equals(SessionEntity.class)) {
                                    value = new UserSessionEntity();
                                } else if (type.equals(BitSet.class)) {
                                    value = new BitSet();
                                } else {
                                    throw new IllegalStateException(className + " - Uncovered parameter type: " + type);
                                }
                                field2.set(newInstance, value);
                                fieldValue.put(field2.getName(), (KeycloakSession)value);
                            }
                            cache.put((Object)className, newInstance);
                            result.put(className, fieldValue);
                        }
                    }
                }
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            return new CacheValuesHolder(result);
        }, CacheValuesHolder.class)).getValues();
    }

    private Map<String, Map<String, Object>> getFromServer(ContainerInfo container, String classes) {
        return ((CacheValuesHolder)((KeycloakTestingClient)backendTestingClients.get(container)).server().fetch((FetchOnServer & Serializable)session -> {
            HashMap<String, Map<String, Object>> mapa = new HashMap<String, Map<String, Object>>();
            Cache cache = ((InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class)).getCache("sessions");
            String decoded = (String)SerializationUtil.decode((String)classes, (ClassLoader)TestClassLoader.getInstance());
            for (String className : decoded.replace("[", "").replace("]", "").split(", ")) {
                HashMap fieldValues = new HashMap();
                Object cacheEntry = cache.get((Object)className);
                Reflections.getAllDeclaredFields(cacheEntry.getClass()).stream().filter(field -> !Modifier.isStatic(field.getModifiers())).forEach(field -> {
                    field.setAccessible(true);
                    Object fieldValue = Reflections.getFieldValue((Field)field, (Object)cacheEntry);
                    fieldValues.put(field.getName(), fieldValue);
                });
                mapa.put(className, fieldValues);
            }
            return new CacheValuesHolder(mapa);
        }, CacheValuesHolder.class)).getValues();
    }

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
    }

    static {
        initialized = false;
    }

    static class CacheValuesHolder {
        private Map<String, Map<String, Object>> values;

        public CacheValuesHolder() {
        }

        public CacheValuesHolder(Map<String, Map<String, Object>> values) {
            this.values = values;
        }

        public Map<String, Map<String, Object>> getValues() {
            return this.values;
        }

        public void setValues(Map<String, Map<String, Object>> values) {
            this.values = values;
        }
    }
}

