/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.migration;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.junit.Test;
import org.keycloak.exportimport.util.ImportUtils;
import org.keycloak.representations.idm.ClientPoliciesRepresentation;
import org.keycloak.representations.idm.ClientProfilesRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.migration.AbstractJsonFileImportMigrationTest;
import org.keycloak.testsuite.utils.io.IOUtil;
import org.keycloak.util.JsonSerialization;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class JsonFileImport1301MigrationClientPoliciesTest
extends AbstractJsonFileImportMigrationTest {
    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        Map reps = null;
        try {
            reps = ImportUtils.getRealmsFromStream((ObjectMapper)JsonSerialization.mapper, (InputStream)IOUtil.class.getResourceAsStream("/migration-test/migration-realm-13.0.1-client-policies.json"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        for (RealmRepresentation rep : reps.values()) {
            testRealms.add(rep);
        }
    }

    @Test
    public void migration13_0_1_Test() throws Exception {
        RealmRepresentation testRealm = this.adminClient.realms().realm("test").toRepresentation();
        Assert.assertTrue((boolean)testRealm.getParsedClientProfiles().getProfiles().isEmpty());
        Assert.assertTrue((boolean)testRealm.getParsedClientPolicies().getPolicies().isEmpty());
        ClientProfilesRepresentation clientProfiles = this.adminClient.realms().realm("test").clientPoliciesProfilesResource().getProfiles(Boolean.valueOf(false));
        Assert.assertTrue((boolean)clientProfiles.getProfiles().isEmpty());
        ClientPoliciesRepresentation clientPolicies = this.adminClient.realms().realm("test").clientPoliciesPoliciesResource().getPolicies();
        Assert.assertTrue((boolean)clientPolicies.getPolicies().isEmpty());
    }
}

