/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.migration;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.ClientsResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.RoleResource;
import org.keycloak.broker.provider.util.SimpleHttp;
import org.keycloak.keys.KeyProvider;
import org.keycloak.models.AdminRoles;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.Constants;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.TimeBasedOTP;
import org.keycloak.protocol.saml.util.ArtifactBindingUtils;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.RefreshToken;
import org.keycloak.representations.idm.AuthenticationExecutionExportRepresentation;
import org.keycloak.representations.idm.AuthenticationExecutionInfoRepresentation;
import org.keycloak.representations.idm.AuthenticationFlowRepresentation;
import org.keycloak.representations.idm.ClientMappingsRepresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ClientScopeRepresentation;
import org.keycloak.representations.idm.ComponentRepresentation;
import org.keycloak.representations.idm.MappingsRepresentation;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RequiredActionProviderRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.authorization.DecisionStrategy;
import org.keycloak.representations.idm.authorization.ResourceRepresentation;
import org.keycloak.representations.idm.authorization.ResourceServerRepresentation;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.exportimport.ExportImportUtil;
import org.keycloak.testsuite.runonserver.RunHelpers;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.util.TokenUtil;

public abstract class AbstractMigrationTest
extends AbstractKeycloakTest {
    public static final String MIGRATION = "Migration";
    public static final String MIGRATION2 = "Migration2";
    protected RealmResource migrationRealm;
    protected RealmResource migrationRealm2;
    protected RealmResource masterRealm;

    protected void testMigratedData() {
        this.testMigratedData(true);
    }

    protected void testMigratedData(boolean supportsAuthzService) {
        this.log.info((Object)"testing migrated data");
        this.testMigratedMasterData();
        this.testMigratedMigrationData(supportsAuthzService);
    }

    protected void testMigratedMigrationData(boolean supportsAuthzService) {
        Assert.assertNames(this.migrationRealm.roles().list(), "offline_access", "uma_authorization", "default-roles-migration", "migration-test-realm-role");
        ArrayList<String> expectedClientIds = new ArrayList<String>(Arrays.asList("account", "account-console", "admin-cli", "broker", "migration-test-client", "migration-saml-client", "realm-management", "security-admin-console"));
        if (supportsAuthzService) {
            expectedClientIds.add("authz-servlet");
            expectedClientIds.add("client-with-template");
        }
        Assert.assertNames(this.migrationRealm.clients().findAll(), expectedClientIds.toArray(new String[expectedClientIds.size()]));
        String id2 = ((ClientRepresentation)this.migrationRealm.clients().findByClientId("migration-test-client").get(0)).getId();
        Assert.assertNames(this.migrationRealm.clients().get(id2).roles().list(), "migration-test-client-role");
        Assert.assertNames(this.migrationRealm.users().search("", Integer.valueOf(0), Integer.valueOf(5)), "migration-test-user", "offline-test-user");
        Assert.assertNames(this.migrationRealm.groups().groups(), "migration-test-group");
    }

    protected void testMigratedMasterData() {
        Assert.assertNames(this.masterRealm.roles().list(), "offline_access", "uma_authorization", "default-roles-master", "create-realm", "master-test-realm-role", "admin");
        Assert.assertNames(this.masterRealm.clients().findAll(), "admin-cli", "security-admin-console", "broker", "account", "account-console", "master-realm", "master-test-client", "Migration-realm", "Migration2-realm");
        String id = ((ClientRepresentation)this.masterRealm.clients().findByClientId("master-test-client").get(0)).getId();
        Assert.assertNames(this.masterRealm.clients().get(id).roles().list(), "master-test-client-role");
        Assert.assertNames(this.masterRealm.users().search("", Integer.valueOf(0), Integer.valueOf(5)), "admin", "master-test-user");
        Assert.assertNames(this.masterRealm.groups().groups(), "master-test-group");
    }

    protected void testMigrationTo2_0_0() {
        this.testAuthorizationServices(this.masterRealm, this.migrationRealm);
    }

    protected void testMigrationTo2_1_0() {
        this.testNameOfOTPRequiredAction(this.masterRealm, this.migrationRealm);
    }

    protected void testMigrationTo2_2_0() {
        this.testIdentityProviderAuthenticator(this.masterRealm, this.migrationRealm);
    }

    protected void testMigrationTo2_3_0() {
        this.testUpdateProtocolMappers(this.masterRealm, this.migrationRealm);
        this.testExtractRealmKeysMasterRealm(this.masterRealm);
        this.testExtractRealmKeysMigrationRealm(this.migrationRealm);
    }

    protected void testMigrationTo2_5_0() {
        this.testLdapKerberosMigration_2_5_0();
        this.testDuplicateEmailSupport(this.masterRealm, this.migrationRealm);
    }

    protected void testMigrationTo3_0_0() {
        this.testRoleManageAccountLinks(this.masterRealm, this.migrationRealm);
    }

    protected void testMigrationTo3_2_0() {
        org.junit.Assert.assertNull((Object)this.masterRealm.toRepresentation().getPasswordPolicy());
        org.junit.Assert.assertNull((Object)this.migrationRealm.toRepresentation().getPasswordPolicy());
        this.testDockerAuthenticationFlow(this.masterRealm, this.migrationRealm);
    }

    protected void testMigrationTo3_4_0() {
        Map securityHeaders = this.masterRealm.toRepresentation().getBrowserSecurityHeaders();
        if (securityHeaders != null) {
            org.junit.Assert.assertEquals((Object)"max-age=31536000; includeSubDomains", securityHeaders.get("strictTransportSecurity"));
        } else {
            org.junit.Assert.fail((String)"Browser security headers not found");
        }
    }

    protected void testMigrationTo3_4_1() {
        Map securityHeaders = this.masterRealm.toRepresentation().getBrowserSecurityHeaders();
        if (securityHeaders != null) {
            org.junit.Assert.assertEquals((Object)"frame-src 'self'; frame-ancestors 'self'; object-src 'none';", securityHeaders.get("contentSecurityPolicy"));
        } else {
            org.junit.Assert.fail((String)"Browser security headers not found");
        }
    }

    protected void testMigrationTo3_4_2() {
        this.testCliConsoleScopeSize(this.masterRealm);
        this.testCliConsoleScopeSize(this.migrationRealm);
    }

    protected void testMigrationTo4_0_0() {
        this.testRealmDefaultClientScopes(this.masterRealm);
        this.testRealmDefaultClientScopes(this.migrationRealm);
        this.testClientDefaultClientScopes(this.migrationRealm);
        this.testOfflineScopeAddedToClient();
    }

    protected void testMigrationTo4_2_0(boolean supportsAuthzService) {
        this.testRequiredActionsPriority(this.masterRealm, this.migrationRealm);
        if (supportsAuthzService) {
            this.testResourceWithMultipleUris();
        }
    }

    protected void testMigrationTo4_6_0(boolean supportsAuthzService, boolean checkMigrationData) {
        if (supportsAuthzService && checkMigrationData) {
            this.testGroupPolicyTypeFineGrainedAdminPermission();
        }
        this.testRolesAndWebOriginsScopesAddedToClient();
    }

    protected void testMigrationTo6_0_0() {
        this.testRealmDefaultClientScopes(this.migrationRealm);
        this.testMicroprofileJWTScopeAddedToClient();
    }

    protected void testMigrationTo8_0_0() {
        this.testAdminClientUrls(this.masterRealm);
        this.testAdminClientUrls(this.migrationRealm);
        this.testAccountClientUrls(this.masterRealm);
        this.testAccountClientUrls(this.migrationRealm);
        this.testCredentialsMigratedToNewFormat();
        this.testOTPAuthenticatorsMigratedToConditionalFlow();
        this.testResourceTag();
    }

    protected void testMigrationTo9_0_0() {
        this.testAccountConsoleClient(this.masterRealm);
        this.testAccountConsoleClient(this.migrationRealm);
        this.testAlwaysDisplayInConsole();
        this.testFirstBrokerLoginFlowMigrated(this.masterRealm);
        this.testFirstBrokerLoginFlowMigrated(this.migrationRealm);
        this.testAccountClient(this.masterRealm);
        this.testAccountClient(this.migrationRealm);
        this.testAdminClientPkce(this.masterRealm);
        this.testAdminClientPkce(this.migrationRealm);
        this.testUserLocaleActionAdded(this.masterRealm);
        this.testUserLocaleActionAdded(this.migrationRealm);
    }

    protected void testMigrationTo12_0_0() {
        this.testDeleteAccount(this.masterRealm);
        this.testDeleteAccount(this.migrationRealm);
    }

    protected void testMigrationTo13_0_0(boolean testRealmAttributesMigration) {
        this.testDefaultRoles(this.masterRealm);
        this.testDefaultRoles(this.migrationRealm);
        this.testDefaultRolesNameWhenTaken();
        if (testRealmAttributesMigration) {
            this.testRealmAttributesMigration();
        }
    }

    protected void testMigrationTo14_0_0() {
        this.testSamlAttributes(this.migrationRealm);
    }

    protected void testDeleteAccount(RealmResource realm) {
        ClientRepresentation accountClient = (ClientRepresentation)realm.clients().findByClientId("account").get(0);
        ClientResource accountResource = realm.clients().get(accountClient.getId());
        org.junit.Assert.assertNotNull((Object)accountResource.roles().get("delete-account").toRepresentation());
        org.junit.Assert.assertNotNull((Object)realm.flows().getRequiredAction("delete_account"));
    }

    private void testAccountClient(RealmResource realm) {
        ClientRepresentation accountClient = (ClientRepresentation)realm.clients().findByClientId("account").get(0);
        ClientResource accountResource = realm.clients().get(accountClient.getId());
        RoleRepresentation viewAppRole = accountResource.roles().get("view-applications").toRepresentation();
        org.junit.Assert.assertNotNull((Object)viewAppRole);
        RoleRepresentation viewConsentRole = accountResource.roles().get("view-consent").toRepresentation();
        org.junit.Assert.assertNotNull((Object)viewConsentRole);
        RoleResource manageConsentResource = accountResource.roles().get("manage-consent");
        RoleRepresentation manageConsentRole = manageConsentResource.toRepresentation();
        org.junit.Assert.assertNotNull((Object)manageConsentRole);
        org.junit.Assert.assertTrue((boolean)manageConsentRole.isComposite());
        Set composites = manageConsentResource.getRoleComposites();
        org.junit.Assert.assertEquals((long)1L, (long)composites.size());
        org.junit.Assert.assertEquals((Object)viewConsentRole.getId(), (Object)((RoleRepresentation)composites.iterator().next()).getId());
    }

    private void testAdminClientUrls(RealmResource realm) {
        ClientRepresentation adminConsoleClient = (ClientRepresentation)realm.clients().findByClientId("security-admin-console").get(0);
        org.junit.Assert.assertEquals((Object)"${authAdminUrl}", (Object)adminConsoleClient.getRootUrl());
        String baseUrl = "/admin/" + realm.toRepresentation().getRealm() + "/console/";
        org.junit.Assert.assertEquals((Object)baseUrl, (Object)adminConsoleClient.getBaseUrl());
        org.junit.Assert.assertEquals((Object)(baseUrl + "*"), adminConsoleClient.getRedirectUris().iterator().next());
        org.junit.Assert.assertEquals((long)1L, (long)adminConsoleClient.getRedirectUris().size());
        org.junit.Assert.assertEquals((Object)"+", adminConsoleClient.getWebOrigins().iterator().next());
        org.junit.Assert.assertEquals((long)1L, (long)adminConsoleClient.getWebOrigins().size());
    }

    private void testAdminClientPkce(RealmResource realm) {
        ClientRepresentation adminConsoleClient = (ClientRepresentation)realm.clients().findByClientId("security-admin-console").get(0);
        org.junit.Assert.assertEquals((Object)"S256", adminConsoleClient.getAttributes().get("pkce.code.challenge.method"));
    }

    private void testAccountClientUrls(RealmResource realm) {
        ClientRepresentation accountConsoleClient = (ClientRepresentation)realm.clients().findByClientId("account").get(0);
        org.junit.Assert.assertEquals((Object)"${authBaseUrl}", (Object)accountConsoleClient.getRootUrl());
        String baseUrl = "/realms/" + realm.toRepresentation().getRealm() + "/account/";
        org.junit.Assert.assertEquals((Object)baseUrl, (Object)accountConsoleClient.getBaseUrl());
        org.junit.Assert.assertEquals((Object)(baseUrl + "*"), accountConsoleClient.getRedirectUris().iterator().next());
        org.junit.Assert.assertEquals((long)1L, (long)accountConsoleClient.getRedirectUris().size());
    }

    private void testAccountConsoleClient(RealmResource realm) {
        ClientRepresentation accountConsoleClient = (ClientRepresentation)realm.clients().findByClientId("account-console").get(0);
        org.junit.Assert.assertEquals((Object)"${authBaseUrl}", (Object)accountConsoleClient.getRootUrl());
        org.junit.Assert.assertEquals((Object)("/realms/" + realm.toRepresentation().getRealm() + "/account/"), (Object)accountConsoleClient.getBaseUrl());
        org.junit.Assert.assertTrue((boolean)accountConsoleClient.isPublicClient());
        org.junit.Assert.assertFalse((boolean)accountConsoleClient.isFullScopeAllowed());
        org.junit.Assert.assertTrue((boolean)accountConsoleClient.isStandardFlowEnabled());
        org.junit.Assert.assertFalse((boolean)accountConsoleClient.isDirectAccessGrantsEnabled());
        org.junit.Assert.assertEquals((Object)"S256", accountConsoleClient.getAttributes().get("pkce.code.challenge.method"));
        ClientResource clientResource = realm.clients().get(accountConsoleClient.getId());
        MappingsRepresentation scopes = clientResource.getScopeMappings().getAll();
        org.junit.Assert.assertNull((Object)scopes.getRealmMappings());
        org.junit.Assert.assertEquals((long)1L, (long)scopes.getClientMappings().size());
        org.junit.Assert.assertEquals((long)1L, (long)((ClientMappingsRepresentation)scopes.getClientMappings().get("account")).getMappings().size());
        org.junit.Assert.assertEquals((Object)"manage-account", (Object)((RoleRepresentation)((ClientMappingsRepresentation)scopes.getClientMappings().get("account")).getMappings().get(0)).getName());
        List mappers = clientResource.getProtocolMappers().getMappers();
        org.junit.Assert.assertEquals((long)1L, (long)mappers.size());
        org.junit.Assert.assertEquals((Object)"oidc-audience-resolve-mapper", (Object)((ProtocolMapperRepresentation)mappers.get(0)).getProtocolMapper());
    }

    private void testFirstBrokerLoginFlowMigrated(RealmResource realm) {
        this.log.infof("Test that firstBrokerLogin flow was migrated in new realm '%s'", (Object)realm.toRepresentation().getRealm());
        List authExecutions = realm.flows().getExecutions("first broker login");
        this.testAuthenticationExecution((AuthenticationExecutionInfoRepresentation)authExecutions.get(0), null, "idp-review-profile", AuthenticationExecutionModel.Requirement.REQUIRED, 0, 0);
        this.testAuthenticationExecution((AuthenticationExecutionInfoRepresentation)authExecutions.get(1), true, null, AuthenticationExecutionModel.Requirement.REQUIRED, 0, 1);
        this.testAuthenticationExecution((AuthenticationExecutionInfoRepresentation)authExecutions.get(2), null, "idp-create-user-if-unique", AuthenticationExecutionModel.Requirement.ALTERNATIVE, 1, 0);
        this.testAuthenticationExecution((AuthenticationExecutionInfoRepresentation)authExecutions.get(3), true, null, AuthenticationExecutionModel.Requirement.ALTERNATIVE, 1, 1);
        this.testAuthenticationExecution((AuthenticationExecutionInfoRepresentation)authExecutions.get(4), null, "idp-confirm-link", AuthenticationExecutionModel.Requirement.REQUIRED, 2, 0);
        this.testAuthenticationExecution((AuthenticationExecutionInfoRepresentation)authExecutions.get(5), true, null, AuthenticationExecutionModel.Requirement.REQUIRED, 2, 1);
        this.testAuthenticationExecution((AuthenticationExecutionInfoRepresentation)authExecutions.get(6), null, "idp-email-verification", AuthenticationExecutionModel.Requirement.ALTERNATIVE, 3, 0);
        this.testAuthenticationExecution((AuthenticationExecutionInfoRepresentation)authExecutions.get(7), true, null, AuthenticationExecutionModel.Requirement.ALTERNATIVE, 3, 1);
        this.testAuthenticationExecution((AuthenticationExecutionInfoRepresentation)authExecutions.get(8), null, "idp-username-password-form", AuthenticationExecutionModel.Requirement.REQUIRED, 4, 0);
        this.testAuthenticationExecution((AuthenticationExecutionInfoRepresentation)authExecutions.get(9), true, null, AuthenticationExecutionModel.Requirement.CONDITIONAL, 4, 1);
        this.testAuthenticationExecution((AuthenticationExecutionInfoRepresentation)authExecutions.get(10), null, "conditional-user-configured", AuthenticationExecutionModel.Requirement.REQUIRED, 5, 0);
        this.testAuthenticationExecution((AuthenticationExecutionInfoRepresentation)authExecutions.get(11), null, "auth-otp-form", AuthenticationExecutionModel.Requirement.REQUIRED, 5, 1);
    }

    private void testAuthenticationExecution(AuthenticationExecutionInfoRepresentation execution, Boolean expectedAuthenticationFlow, String expectedProviderId, AuthenticationExecutionModel.Requirement expectedRequirement, int expectedLevel, int expectedIndex) {
        Assert.assertEquals((Object)execution.getAuthenticationFlow(), (Object)expectedAuthenticationFlow);
        Assert.assertEquals((Object)execution.getProviderId(), (Object)expectedProviderId);
        Assert.assertEquals((Object)execution.getRequirement(), (Object)expectedRequirement.toString());
        Assert.assertEquals((long)execution.getLevel(), (long)expectedLevel);
        Assert.assertEquals((long)execution.getIndex(), (long)expectedIndex);
    }

    private void testDecisionStrategySetOnResourceServer() {
        ClientsResource clients = this.migrationRealm.clients();
        ClientRepresentation clientRepresentation = (ClientRepresentation)clients.findByClientId("authz-servlet").get(0);
        ResourceServerRepresentation settings = clients.get(clientRepresentation.getId()).authorization().getSettings();
        org.junit.Assert.assertEquals((Object)DecisionStrategy.UNANIMOUS, (Object)settings.getDecisionStrategy());
    }

    private void testGroupPolicyTypeFineGrainedAdminPermission() {
        ClientsResource clients = this.migrationRealm.clients();
        ClientRepresentation clientRepresentation = (ClientRepresentation)clients.findByClientId("realm-management").get(0);
        List resources = clients.get(clientRepresentation.getId()).authorization().resources().resources();
        org.junit.Assert.assertEquals((long)5L, (long)resources.size());
        for (ResourceRepresentation resource : resources) {
            org.junit.Assert.assertEquals((Object)"Group", (Object)resource.getType());
        }
    }

    private void testCliConsoleScopeSize(RealmResource realm) {
        ClientRepresentation cli = (ClientRepresentation)realm.clients().findByClientId("admin-cli").get(0);
        ClientRepresentation console = (ClientRepresentation)realm.clients().findByClientId("security-admin-console").get(0);
        MappingsRepresentation scopeMappings = realm.clients().get(console.getId()).getScopeMappings().getAll();
        Assert.assertNull((Object)scopeMappings.getClientMappings());
        Assert.assertNull((Object)scopeMappings.getRealmMappings());
        scopeMappings = realm.clients().get(cli.getId()).getScopeMappings().getAll();
        Assert.assertNull((Object)scopeMappings.getClientMappings());
        Assert.assertNull((Object)scopeMappings.getRealmMappings());
    }

    protected void testDockerAuthenticationFlow(RealmResource ... realms) {
        for (RealmResource realm : realms) {
            AuthenticationFlowRepresentation flow = null;
            for (AuthenticationFlowRepresentation f : realm.flows().getFlows()) {
                if (!"docker auth".equals(f.getAlias())) continue;
                flow = f;
            }
            org.junit.Assert.assertNotNull(flow);
        }
    }

    protected void testRoleManageAccountLinks(RealmResource ... realms) {
        this.log.info((Object)"testing role manage account links");
        for (RealmResource realm : realms) {
            List clients = realm.clients().findByClientId("account");
            if (clients.isEmpty()) continue;
            String accountClientId = ((ClientRepresentation)clients.get(0)).getId();
            ClientResource accountClient = realm.clients().get(accountClientId);
            accountClient.roles().get("manage-account-links").toRepresentation();
            Set roleComposites = accountClient.roles().get("manage-account").getRoleComposites();
            boolean success = false;
            for (RoleRepresentation roleComposite : roleComposites) {
                if (!roleComposite.getName().equals("manage-account-links")) continue;
                success = true;
            }
            if (success) continue;
            org.junit.Assert.fail((String)"'manage-account' role of client 'account' should have composite role 'manage-account-links'.");
        }
    }

    protected void testExtractRealmKeysMasterRealm(RealmResource masterRealm) {
        this.log.info((Object)"testing extract realm keys");
        String expectedMasterRealmKey = "MIIEowIBAAKCAQEAiU54OXoCbHy0L0gHn1yasctcnKHRU1pHFIJnWvaI7rClJydet9dDJaiYXOxMKseiBm3eYznfN3cPyU8udYmRnMuKjiocZ77LT2IEttAjXb6Ggazx7loriFHRy0IOJeX4KxXhAPWmxqa3mkFNfLBEvFqVaBgUDHQ60cmnPvNSHYudBTW9K80s8nvmP2pso7HTwWJ1+Xatj1Ey/gTmB3CXlyqBegGWC9TeuErEYpYhdh+11TVWasgMBZyUCtL3NRPaBuhaPg1LpW8lWGk05nS+YM6dvTk3Mppv+z2RygEpxyO09oT3b4G+Zfwit1STqn0AvDTGzINdoKcNtFScV0j8TwIDAQABAoIBAHcbPKsPLZ8SJfOF1iblW8OzFulAbaaSf2pJHIMJrQrw7LKkMkPjVXoLX+/rgr7xYZmWIP2OLBWfEHCeYTzQUyHiZpSf7vgHx7Fa45/5uVQOe/ttHIiYa37bCtP4vvEdJkOpvP7qGPvljwsebqsk9Ns28LfVez66bHOjK5Mt2yOIulbTeEs7ch//h39YwKJv96vc+CHbV2O6qoOxZessO6y+287cOBvbFXmS2GaGle5Nx/EwncBNS4b7czoetmm70+9ht3yX+kxaP311YUT31KQjuaJt275kOiKsrXr27PvgO++bsIyGuSzqyS7G7fmxF2zUyphEqEpalyDGMKMnrAECgYEA1fCgFox03rPDjm0MhW/ThoS2Ld27sbWQ6reS+PBMdUTJZVZIU1D2//h6VXDnlddhk6avKjA4smdy1aDKzmjz3pt9AKn+kgkXqtTC2fD3wp+fC9hND0z+rQPGe/Gk7ZUnTdsqnfyowxr+woIgzdnRukOUrG+xQiP3RUUT7tt6NQECgYEApEz2xvgqMm+9/f/YxjLdsFUfLqc4WlafB863stYEVqlCYy5ujyo0VQ0ahKSKJkLDnf52+aMUqPOpwaGePpu3O6VkvpcKfPY2MUlZW7/6Sa9et9hxNkdTS7Gui2d1ELpaCBe1Bc62sk8EA01iHXE1PpvyUqDWrhNh+NrDICA9oU8CgYBgGDYACtTP11TmW2r9YK5VRLUDww30k4ZlN1GnyV++aMhBYVEZQ0u+y+A/EnijIFwu0vbo70H4OGknNZMCxbeMbLDoJHM5KyZbUDe5ZvgSjloFGwH59m6KTiDQOUkIgi9mVCQ/VGaFRFHcElEjxUvj60kTbxPijn8ZuR5r8l9hAQKBgQCQ9jL5pHWeoIayN20smi6M6N2lTPbkhe60dcgQatHTIG2pkosLl8IqlHAkPgSB84AiwyR351JQKwRJCm7TcJI/dxMnMZ6YWKfB3qSP1hdfsfJRJQ/mQxIUBAYrizF3e+P5peka4aLCOgMhYsJBlePThMZN7wja99EGPwXQL4IQ8wKBgB8Nis1lQK6Z30GCp9u4dYleGfEP71Lwqvk/eJb89/uz0fjF9CTpJMULFc+nA5u4yHP3LFnRg3zCU6aEwfwUyk4GH9lWGV/qIAisQtgrCEraVe4qxz0DVE59C7qjO26IhU2U66TEzPAqvQ3zqey+woDn/cz/JMWK1vpcSk+TKn3K";
        List components = masterRealm.components().query("master", KeyProvider.class.getName());
        org.junit.Assert.assertEquals((long)3L, (long)components.size());
        components = masterRealm.components().query("master", KeyProvider.class.getName(), "rsa");
        org.junit.Assert.assertEquals((long)1L, (long)components.size());
        ComponentRepresentation component = (ComponentRepresentation)this.testingClient.server("master").fetch(RunHelpers.internalComponent((String)((ComponentRepresentation)components.get(0)).getId()));
        org.junit.Assert.assertEquals((Object)expectedMasterRealmKey, (Object)component.getConfig().getFirst((Object)"privateKey"));
        components = masterRealm.components().query("master", KeyProvider.class.getName(), "hmac-generated");
        org.junit.Assert.assertEquals((long)1L, (long)components.size());
    }

    protected void testExtractRealmKeysMigrationRealm(RealmResource migrationRealm) {
        this.log.info((Object)"testing extract realm keys");
        String expectedMigrationRealmKey = "MIIEpAIBAAKCAQEApt6gCllWkVTZ7fy/oRIx6Bxjt9x3eKKyKGFXvN4iaafrNqpYU9lcqPngWJ9DyXGqUf8RpjPaQWiLWLxjw3xGBqLk2E1/Frb9e/dy8rj//fHGq6bujN1iguzyFwxPGT5Asd7jflRI3qU04M8JE52PArqPhGL2Fn+FiSK5SWRIGm+hVL7Ck/E/tVxM25sFG1/UTQqvrROm4q76TmP8FsyZaTLVf7cCwW2QPIX0N5HTVb3QbBb5KIsk4kKmk/g7uUxS9r42tu533LISzRr5CTyWZAL2XFRuF2RrKdE8gwqkEubw6sDmB2mE0EoPdY1DUhBQgVP/5rwJrCtTsUBR2xdEYQIDAQABAoIBAFbbsNBSOlZBpYJUOmcb8nBQPrOYhXN8tGGCccn0klMOvcdhmcJjdPDbyCQ5Gm7DxJUTwNsTSHsdcNMKlJ9Pk5+msJnKlOl87KrXXbTsCQvlCrWUmb0nCzz9GvJWTOHl3oT3cND0DE4gDksqWR4luCgCdevCGzgQvrBoK6wBD+r578uEW3iw10hnJ0+wnGiw8IvPzE1a9xbY4HD8/QrYdaLxuLb/aC1PDuzrz0cOjnvPkrws5JrbUSnbFygJiOv1z4l2Q00uGIxlHtXdwQBnTZZjVi4vOec2BYSHffgwDYEZIglw1mnrV7y0N1nnPbtJK/cegIkXoBQHXm8Q99TrWMUCgYEA9au86qcwrXZZg5H4BpR5cpy0MSkcKDbA1aRL1cAyTCqJxsczlAtLhFADF+NhnlXj4y7gwDEYWrz064nF73I+ZGicvCiyOy+tCTugTyTGS+XR948ElDMS6PCUUXsotS3dKa0b3c9wd2mxeddTjq/ArfgEVZJ6fE1KtjLt9dtfA+8CgYEAreK3JsvjR5b/Xct28TghYUU7Qnasombb/shqqy8FOMjYUr5OUm/OjNIgoCqhOlE8oQDJ4dOZofNSa7tL+oM8Gmbal+E3fRzxnx/9/EC4QV6sVaPLTIyk7EPfKTcZuzH7+BNZtAziTxJw9d6YJQRbkpg92EZIEoR8iDj2Xs5xrK8CgYEAwMVWwwYX8zT3vn7ukTM2LRH7bsvkVUXJgJqgCwT6Mrv6SmkK9vL5+cPS+Y6pjdW1sRGauBSOGL1Grf/4ug/6F03jFt4UJM8fRyxreU7Q7sNSQ6AMpsGA6BnHODycz7ZCYa59PErG5FyiL4of/cm5Nolz1TXQOPNpWZiTEqVlZC8CgYA4YPbjVF4nuxSnU64H/hwMjsbtAM9uhI016cN0J3W4+J3zDhMU9X1x+Tts0wWdg/N1fGz4lIQOl3cUyRCUc/KL2OdtMS+tmDHbVyMho9ZaE5kq10W2Vy+uDz+O/HeSU12QDK4cC8Vgv+jyPy7zaZtLR6NduUPrBRvfiyCOkr8WrwKBgQCY0h4RCdNFhr0KKLLmJipAtV8wBCGcg1jY1KoWKQswbcykfBKwHbF6EooVqkRW0ITjWB7ZZCf8TnSUxe0NXCUAkVBrhzS4DScgtoSZYOOUaSHgOxpfwgnQ3oYotKi98Yg3IsaLs1j4RuPG5Sp1z6o+ELP1uvr8azyn9YlLa+523Q==";
        List components = migrationRealm.components().query(MIGRATION, KeyProvider.class.getName());
        org.junit.Assert.assertEquals((long)3L, (long)components.size());
        components = migrationRealm.components().query(MIGRATION, KeyProvider.class.getName(), "rsa");
        org.junit.Assert.assertEquals((long)1L, (long)components.size());
        ComponentRepresentation component = (ComponentRepresentation)this.testingClient.server(MIGRATION).fetch(RunHelpers.internalComponent((String)((ComponentRepresentation)components.get(0)).getId()));
        org.junit.Assert.assertEquals((Object)expectedMigrationRealmKey, (Object)component.getConfig().getFirst((Object)"privateKey"));
        components = migrationRealm.components().query(MIGRATION, KeyProvider.class.getName(), "hmac-generated");
        org.junit.Assert.assertEquals((long)1L, (long)components.size());
    }

    protected void testLdapKerberosMigration_2_5_0() {
        this.log.info((Object)"testing ldap kerberos migration");
        RealmRepresentation realmRep = this.migrationRealm2.toRepresentation();
        List components = this.migrationRealm2.components().query(realmRep.getId(), UserStorageProvider.class.getName());
        org.junit.Assert.assertEquals((long)2L, (long)components.size());
        boolean testedLdap = false;
        boolean testedKerberos = false;
        for (ComponentRepresentation component : components) {
            if (component.getName().equals("ldap-provider")) {
                org.junit.Assert.assertEquals((Object)"2", (Object)component.getConfig().getFirst((Object)"priority"));
                org.junit.Assert.assertEquals((Object)"READ_ONLY", (Object)component.getConfig().getFirst((Object)"editMode"));
                org.junit.Assert.assertEquals((Object)"true", (Object)component.getConfig().getFirst((Object)"syncRegistrations"));
                org.junit.Assert.assertEquals((Object)"rhds", (Object)component.getConfig().getFirst((Object)"vendor"));
                org.junit.Assert.assertEquals((Object)"uid", (Object)component.getConfig().getFirst((Object)"usernameLDAPAttribute"));
                org.junit.Assert.assertEquals((Object)"uid", (Object)component.getConfig().getFirst((Object)"rdnLDAPAttribute"));
                org.junit.Assert.assertEquals((Object)"nsuniqueid", (Object)component.getConfig().getFirst((Object)"uuidLDAPAttribute"));
                org.junit.Assert.assertEquals((Object)"inetOrgPerson, organizationalPerson", (Object)component.getConfig().getFirst((Object)"userObjectClasses"));
                org.junit.Assert.assertEquals((Object)"http://localhost", (Object)component.getConfig().getFirst((Object)"connectionUrl"));
                org.junit.Assert.assertEquals((Object)"dn", (Object)component.getConfig().getFirst((Object)"usersDn"));
                org.junit.Assert.assertEquals((Object)"none", (Object)component.getConfig().getFirst((Object)"authType"));
                org.junit.Assert.assertEquals((Object)"true", (Object)component.getConfig().getFirst((Object)"allowKerberosAuthentication"));
                org.junit.Assert.assertEquals((Object)"realm", (Object)component.getConfig().getFirst((Object)"kerberosRealm"));
                org.junit.Assert.assertEquals((Object)"principal", (Object)component.getConfig().getFirst((Object)"serverPrincipal"));
                org.junit.Assert.assertEquals((Object)"keytab", (Object)component.getConfig().getFirst((Object)"keyTab"));
                testedLdap = true;
                continue;
            }
            if (!component.getName().equals("kerberos-provider")) continue;
            org.junit.Assert.assertEquals((Object)"3", (Object)component.getConfig().getFirst((Object)"priority"));
            org.junit.Assert.assertEquals((Object)"realm", (Object)component.getConfig().getFirst((Object)"kerberosRealm"));
            org.junit.Assert.assertEquals((Object)"principal", (Object)component.getConfig().getFirst((Object)"serverPrincipal"));
            org.junit.Assert.assertEquals((Object)"keytab", (Object)component.getConfig().getFirst((Object)"keyTab"));
        }
    }

    private void testResourceWithMultipleUris() {
        ClientsResource clients = this.migrationRealm.clients();
        ClientRepresentation clientRepresentation = (ClientRepresentation)clients.findByClientId("authz-servlet").get(0);
        ResourceRepresentation resource = (ResourceRepresentation)clients.get(clientRepresentation.getId()).authorization().resources().findByName("Protected Resource").get(0);
        MatcherAssert.assertThat((Object)resource.getUris(), (org.hamcrest.Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"/*"}));
    }

    protected void testAuthorizationServices(RealmResource ... realms) {
        this.log.info((Object)"testing authorization services");
        for (RealmResource realm : realms) {
            for (String roleName : Constants.AUTHZ_DEFAULT_AUTHORIZATION_ROLES) {
                RoleResource role = realm.roles().get(roleName);
                org.junit.Assert.assertFalse((String)"Role shouldn't be composite should be false.", (boolean)role.toRepresentation().isComposite());
                MatcherAssert.assertThat((String)"role should be added to default roles for new users", realm.roles().get("default-roles-" + realm.toRepresentation().getRealm().toLowerCase()).getRoleComposites().stream().map(RoleRepresentation::getName).collect(Collectors.toSet()), (org.hamcrest.Matcher)Matchers.hasItem((Object)roleName));
            }
            List clients = realm.clients().findByClientId(realm.toRepresentation().getRealm() + "-realm");
            if (clients.isEmpty()) continue;
            ClientResource masterAdminClient = realm.clients().get(((ClientRepresentation)clients.get(0)).getId());
            masterAdminClient.roles().get(AdminRoles.VIEW_AUTHORIZATION).toRepresentation();
            masterAdminClient.roles().get(AdminRoles.MANAGE_AUTHORIZATION).toRepresentation();
            HashSet<String> roleNames = new HashSet<String>();
            for (RoleResource role : realm.roles().get(AdminRoles.ADMIN).getRoleComposites()) {
                roleNames.add(role.getName());
            }
            org.junit.Assert.assertTrue((String)(AdminRoles.VIEW_AUTHORIZATION + " should be composite role of " + AdminRoles.ADMIN), (boolean)roleNames.contains(AdminRoles.VIEW_AUTHORIZATION));
            org.junit.Assert.assertTrue((String)(AdminRoles.MANAGE_AUTHORIZATION + " should be composite role of " + AdminRoles.ADMIN), (boolean)roleNames.contains(AdminRoles.MANAGE_AUTHORIZATION));
        }
    }

    protected void testNameOfOTPRequiredAction(RealmResource ... realms) {
        this.log.info((Object)"testing OTP Required Action");
        for (RealmResource realm : realms) {
            RequiredActionProviderRepresentation otpAction = realm.flows().getRequiredAction(UserModel.RequiredAction.CONFIGURE_TOTP.name());
            org.junit.Assert.assertEquals((String)"The name of CONFIGURE_TOTP required action should be 'Configure OTP'.", (Object)"Configure OTP", (Object)otpAction.getName());
        }
    }

    protected void testIdentityProviderAuthenticator(RealmResource ... realms) {
        this.log.info((Object)"testing identity provider authenticator");
        for (RealmResource realm : realms) {
            boolean success = false;
            for (AuthenticationFlowRepresentation flow : realm.flows().getFlows()) {
                if (!flow.getAlias().equals("browser")) continue;
                for (AuthenticationExecutionExportRepresentation execution : flow.getAuthenticationExecutions()) {
                    if (!"identity-provider-redirector".equals(execution.getAuthenticator())) continue;
                    org.junit.Assert.assertEquals((String)"Requirement should be ALTERNATIVE.", (Object)AuthenticationExecutionModel.Requirement.ALTERNATIVE.name(), (Object)execution.getRequirement());
                    org.junit.Assert.assertTrue((String)"Priority should be 25.", (execution.getPriority() == 25 ? 1 : 0) != 0);
                    success = true;
                }
            }
            if (success) continue;
            org.junit.Assert.fail((String)"BROWSER_FLOW should contain execution: 'identity-provider-redirector' authenticator.");
        }
    }

    protected void testUpdateProtocolMappers(RealmResource ... realms) {
        this.log.info((Object)"testing updated protocol mappers");
        for (RealmResource realm : realms) {
            for (ClientRepresentation client : realm.clients().findAll()) {
                if (client.getProtocolMappers() == null) continue;
                for (ProtocolMapperRepresentation protocolMapper : client.getProtocolMappers()) {
                    this.testUpdateProtocolMapper(protocolMapper, client.getClientId());
                }
            }
            for (ClientScopeRepresentation clientScope : realm.clientScopes().findAll()) {
                if (clientScope.getProtocolMappers() == null) continue;
                for (ProtocolMapperRepresentation protocolMapper : clientScope.getProtocolMappers()) {
                    this.testUpdateProtocolMapper(protocolMapper, clientScope.getName());
                }
            }
        }
    }

    protected void testUpdateProtocolMapper(ProtocolMapperRepresentation protocolMapper, String clientId) {
        if (protocolMapper.getConfig().get("id.token.claim") != null) {
            org.junit.Assert.assertEquals((String)("ProtocolMapper's config should contain key 'userinfo.token.claim'. But it doesn't for protocolMapper '" + protocolMapper.getName() + "' of client/clientScope '" + clientId + "'"), protocolMapper.getConfig().get("id.token.claim"), protocolMapper.getConfig().get("userinfo.token.claim"));
        }
    }

    protected void testDuplicateEmailSupport(RealmResource ... realms) {
        this.log.info((Object)"testing duplicate email");
        for (RealmResource realm : realms) {
            RealmRepresentation rep = realm.toRepresentation();
            org.junit.Assert.assertTrue((String)"LoginWithEmailAllowed should be enabled.", (boolean)rep.isLoginWithEmailAllowed());
            org.junit.Assert.assertFalse((String)"DuplicateEmailsAllowed should be disabled.", (boolean)rep.isDuplicateEmailsAllowed());
        }
    }

    protected void testOfflineTokenLogin() throws Exception {
        this.log.info((Object)"test login with old offline token");
        String oldOfflineToken = this.suiteContext.getMigrationContext().loadOfflineToken();
        Assert.assertNotNull((Object)oldOfflineToken);
        this.oauth.realm(MIGRATION);
        this.oauth.clientId("migration-test-client");
        OAuthClient.AccessTokenResponse response = this.oauth.doRefreshTokenRequest(oldOfflineToken, "secret");
        if (response.getError() != null) {
            String errorMessage = String.format("Error when refreshing offline token. Error: %s, Error details: %s, offline token from previous version: %s", response.getError(), response.getErrorDescription(), oldOfflineToken);
            this.log.error((Object)errorMessage);
            Assert.fail((String)errorMessage);
        }
        AccessToken accessToken = this.oauth.verifyToken(response.getAccessToken());
        org.junit.Assert.assertEquals((Object)"offline-test-user", (Object)accessToken.getPreferredUsername());
        String newOfflineToken1 = response.getRefreshToken();
        this.assertOfflineToken(newOfflineToken1);
        response = this.oauth.doRefreshTokenRequest(newOfflineToken1, "secret");
        String newOfflineToken2 = response.getRefreshToken();
        this.assertOfflineToken(newOfflineToken2);
    }

    private void assertOfflineToken(String offlineToken) {
        RefreshToken offlineTokenParsed = this.oauth.parseRefreshToken(offlineToken);
        org.junit.Assert.assertEquals((Object)"Offline", (Object)offlineTokenParsed.getType());
        org.junit.Assert.assertEquals((long)0L, (long)offlineTokenParsed.getExpiration());
        org.junit.Assert.assertTrue((boolean)TokenUtil.hasScope((String)offlineTokenParsed.getScope(), (String)"offline_access"));
    }

    private void testRealmDefaultClientScopes(RealmResource realm) {
        this.log.info((Object)("Testing default client scopes created in realm: " + realm.toRepresentation().getRealm()));
        ExportImportUtil.testRealmDefaultClientScopes(realm);
    }

    private void testClientDefaultClientScopes(RealmResource realm) {
        this.log.info((Object)("Testing default client scopes transferred from client scope in realm: " + realm.toRepresentation().getRealm()));
        ExportImportUtil.testClientDefaultClientScopes(realm);
    }

    private void testOfflineScopeAddedToClient() {
        this.log.infof("Testing offline_access optional scope present in realm %s for client migration-test-client", (Object)this.migrationRealm.toRepresentation().getRealm());
        List optionalClientScopes = ApiUtil.findClientByClientId((RealmResource)this.migrationRealm, (String)"migration-test-client").getOptionalClientScopes();
        boolean found = optionalClientScopes.stream().filter(clientScope -> "offline_access".equals(clientScope.getName())).findFirst().isPresent();
        if (!found) {
            Assert.fail((String)"Offline_access not found as optional scope of client migration-test-client");
        }
    }

    private void testRolesAndWebOriginsScopesAddedToClient() {
        this.log.infof("Testing roles and web-origins default scopes present in realm %s for client migration-test-client", (Object)this.migrationRealm.toRepresentation().getRealm());
        List defaultClientScopes = ApiUtil.findClientByClientId((RealmResource)this.migrationRealm, (String)"migration-test-client").getDefaultClientScopes();
        Set defaultClientScopeNames = defaultClientScopes.stream().map(ClientScopeRepresentation::getName).collect(Collectors.toSet());
        if (!defaultClientScopeNames.contains("roles")) {
            Assert.fail((String)"Client scope 'roles' not found as default scope of client migration-test-client");
        }
        if (!defaultClientScopeNames.contains("web-origins")) {
            Assert.fail((String)"Client scope 'web-origins' not found as default scope of client migration-test-client");
        }
    }

    private void testMicroprofileJWTScopeAddedToClient() {
        this.log.infof("Testing microprofile-jwt optional scope present in realm %s for client migration-test-client", (Object)this.migrationRealm.toRepresentation().getRealm());
        List optionalClientScopes = ApiUtil.findClientByClientId((RealmResource)this.migrationRealm, (String)"migration-test-client").getOptionalClientScopes();
        Set defaultClientScopeNames = optionalClientScopes.stream().map(ClientScopeRepresentation::getName).collect(Collectors.toSet());
        if (!defaultClientScopeNames.contains("microprofile-jwt")) {
            Assert.fail((String)"Client scope 'microprofile-jwt' not found as optional scope of client migration-test-client");
        }
    }

    private void testRequiredActionsPriority(RealmResource ... realms) {
        this.log.info((Object)"testing required action's priority");
        for (RealmResource realm : realms) {
            this.log.info((Object)("Taking required actions from realm: " + realm.toRepresentation().getRealm()));
            List actions = realm.flows().getRequiredActions();
            int priority = 10;
            for (RequiredActionProviderRepresentation action : actions) {
                if (action.getAlias().equals("update_user_locale")) {
                    org.junit.Assert.assertEquals((long)1000L, (long)action.getPriority());
                } else {
                    org.junit.Assert.assertEquals((long)priority, (long)action.getPriority());
                }
                priority += 10;
            }
        }
    }

    protected void testCredentialsMigratedToNewFormat() {
        this.log.info((Object)"testing user's credentials migrated to new format with secretData and credentialData");
        try {
            this.oauth.realm(MIGRATION);
            this.oauth.clientId("migration-test-client");
            TimeBasedOTP otpGenerator = new TimeBasedOTP("HmacSHA1", 8, 40, 1);
            String otp = otpGenerator.generateTOTP("dSdmuHLQhkm54oIm0A0S");
            OAuthClient.AccessTokenResponse response = this.oauth.doGrantAccessTokenRequest("secret", "migration-test-user", "password", otp);
            Assert.assertNull((Object)response.getAccessToken());
            Assert.assertNotNull((Object)response.getError());
            response = this.oauth.doGrantAccessTokenRequest("secret", "migration-test-user", "password2", "invalid");
            Assert.assertNull((Object)response.getAccessToken());
            Assert.assertNotNull((Object)response.getError());
            response = this.oauth.doGrantAccessTokenRequest("secret", "migration-test-user", "password2", otp);
            Assert.assertNull((Object)response.getError());
            AccessToken accessToken = this.oauth.verifyToken(response.getAccessToken());
            org.junit.Assert.assertEquals((Object)"migration-test-user", (Object)accessToken.getPreferredUsername());
        }
        catch (Exception e) {
            throw new AssertionError("Failed to login with user 'migration-test-user' after migration", e);
        }
    }

    protected void testOTPAuthenticatorsMigratedToConditionalFlow() {
        this.log.info((Object)"testing optional authentication executions migrated");
        this.testOTPExecutionMigratedToConditionalFlow("browser", "forms - auth-otp-form - Conditional", "OTP Form");
        this.testOTPExecutionMigratedToConditionalFlow("direct grant", "direct grant - direct-grant-validate-otp - Conditional", "OTP");
        this.testOTPExecutionMigratedToConditionalFlow("reset credentials", "reset credentials - reset-otp - Conditional", "Reset OTP");
        this.testOTPExecutionMigratedToConditionalFlow("first broker login", "Verify Existing Account by Re-authentication - auth-otp-form - Conditional", "OTP Form");
    }

    private void testOTPExecutionMigratedToConditionalFlow(String topFlowAlias, String expectedOTPSubflowAlias, String expectedOTPExecutionDisplayName) {
        List authExecutions = this.migrationRealm.flows().getExecutions(topFlowAlias);
        int counter = -1;
        AuthenticationExecutionInfoRepresentation subflowExecution = null;
        for (AuthenticationExecutionInfoRepresentation ex : authExecutions) {
            ++counter;
            if (!expectedOTPSubflowAlias.equals(ex.getDisplayName())) continue;
            subflowExecution = ex;
            break;
        }
        if (subflowExecution == null) {
            throw new AssertionError((Object)("Not found subflow with displayName '" + expectedOTPSubflowAlias + "' in the flow " + topFlowAlias));
        }
        Assert.assertEquals((Object)AuthenticationExecutionModel.Requirement.CONDITIONAL.toString(), (Object)subflowExecution.getRequirement());
        AuthenticationExecutionInfoRepresentation childEx1 = (AuthenticationExecutionInfoRepresentation)authExecutions.get(counter + 1);
        Assert.assertEquals((Object)"Condition - user configured", (Object)childEx1.getDisplayName());
        Assert.assertEquals((Object)AuthenticationExecutionModel.Requirement.REQUIRED.toString(), (Object)childEx1.getRequirement());
        Assert.assertEquals((long)0L, (long)childEx1.getIndex());
        Assert.assertEquals((long)(subflowExecution.getLevel() + 1), (long)childEx1.getLevel());
        AuthenticationExecutionInfoRepresentation childEx2 = (AuthenticationExecutionInfoRepresentation)authExecutions.get(counter + 2);
        Assert.assertEquals((Object)expectedOTPExecutionDisplayName, (Object)childEx2.getDisplayName());
        Assert.assertEquals((Object)AuthenticationExecutionModel.Requirement.REQUIRED.toString(), (Object)childEx2.getRequirement());
        Assert.assertEquals((long)1L, (long)childEx2.getIndex());
        Assert.assertEquals((long)(subflowExecution.getLevel() + 1), (long)childEx2.getLevel());
    }

    protected void testUserLocaleActionAdded(RealmResource realm) {
        RequiredActionProviderRepresentation rep = realm.flows().getRequiredAction("update_user_locale");
        org.junit.Assert.assertNotNull((Object)rep);
        org.junit.Assert.assertEquals((Object)"update_user_locale", (Object)rep.getAlias());
        org.junit.Assert.assertEquals((Object)"update_user_locale", (Object)rep.getProviderId());
        org.junit.Assert.assertEquals((Object)"Update User Locale", (Object)rep.getName());
        org.junit.Assert.assertEquals((long)1000L, (long)rep.getPriority());
        org.junit.Assert.assertTrue((boolean)rep.isEnabled());
        org.junit.Assert.assertFalse((boolean)rep.isDefaultAction());
    }

    protected void testMigrationTo2_x() throws Exception {
        this.testMigrationTo2_0_0();
        this.testMigrationTo2_1_0();
        this.testMigrationTo2_2_0();
        this.testMigrationTo2_3_0();
        this.testMigrationTo2_5_0();
    }

    protected void testMigrationTo3_x() {
        this.testMigrationTo3_0_0();
        this.testMigrationTo3_2_0();
        this.testMigrationTo3_4_0();
        this.testMigrationTo3_4_1();
        this.testMigrationTo3_4_2();
    }

    protected void testMigrationTo4_x(boolean supportsAuthzServices, boolean checkMigrationData) {
        this.testMigrationTo4_0_0();
        this.testMigrationTo4_2_0(supportsAuthzServices);
        this.testMigrationTo4_6_0(supportsAuthzServices, checkMigrationData);
    }

    protected void testMigrationTo4_x() {
        this.testMigrationTo4_x(true, true);
    }

    protected void testMigrationTo5_x() {
    }

    protected void testMigrationTo6_x() {
        this.testMigrationTo6_0_0();
    }

    protected void testMigrationTo8_x() {
        this.testMigrationTo8_0_0();
    }

    protected void testMigrationTo9_x() {
        this.testMigrationTo9_0_0();
    }

    protected void testMigrationTo12_x(boolean testRealmAttributesMigration) {
        this.testMigrationTo12_0_0();
        this.testMigrationTo13_0_0(testRealmAttributesMigration);
        this.testMigrationTo14_0_0();
    }

    protected void testMigrationTo7_x(boolean supportedAuthzServices) {
        if (supportedAuthzServices) {
            this.testDecisionStrategySetOnResourceServer();
        }
    }

    protected void testResourceTag() {
        try (CloseableHttpClient client = HttpClientBuilder.create().build();){
            URI url = this.suiteContext.getAuthServerInfo().getUriBuilder().path("/auth").build(new Object[0]);
            String response = SimpleHttp.doGet((String)url.toString(), (HttpClient)client).asString();
            Matcher m = Pattern.compile("resources/([^/]*)/welcome").matcher(response);
            org.junit.Assert.assertTrue((boolean)m.find());
            org.junit.Assert.assertTrue((boolean)m.group(1).matches("[a-zA-Z0-9_\\-.~]{5}"));
        }
        catch (IOException e) {
            org.junit.Assert.fail((String)e.getMessage());
        }
    }

    protected void testAlwaysDisplayInConsole() {
        for (ClientRepresentation clientRep : this.masterRealm.clients().findAll()) {
            Assert.assertFalse((boolean)clientRep.isAlwaysDisplayInConsole());
        }
    }

    protected void testDefaultRoles(RealmResource realm) {
        String realmName = realm.toRepresentation().getRealm().toLowerCase();
        MatcherAssert.assertThat(realm.roles().get("default-roles-" + realmName).getRoleComposites().stream().map(RoleRepresentation::getName).collect(Collectors.toSet()), (org.hamcrest.Matcher)Matchers.allOf((org.hamcrest.Matcher)Matchers.hasItem((Object)(realmName + "-test-realm-role")), (org.hamcrest.Matcher)Matchers.hasItem((Object)(realmName + "-test-client-role"))));
    }

    protected void testDefaultRolesNameWhenTaken() {
        MatcherAssert.assertThat((Object)this.migrationRealm2.toRepresentation().getDefaultRole().getName(), (org.hamcrest.Matcher)Matchers.equalTo((Object)"default-roles-migration2-1"));
    }

    protected void testSamlAttributes(RealmResource realm) {
        this.log.info((Object)"Testing SAML ARTIFACT BINDING IDENTIFIER");
        realm.clients().findAll().stream().filter(clientRepresentation -> Objects.equals("saml", clientRepresentation.getProtocol())).forEach(clientRepresentation -> {
            String clientId = clientRepresentation.getClientId();
            MatcherAssert.assertThat((Object)clientRepresentation.getAttributes(), (org.hamcrest.Matcher)Matchers.hasEntry((Object)"saml.artifact.binding.identifier", (Object)ArtifactBindingUtils.computeArtifactBindingIdentifierString((String)clientId)));
        });
    }

    protected void testExtremelyLongClientAttribute(RealmResource realm) {
        this.log.info((Object)"Testing SAML certfificates attribute");
        realm.clients().findByClientId("migration-saml-client").forEach(clientRepresentation -> MatcherAssert.assertThat((Object)clientRepresentation.getAttributes(), (org.hamcrest.Matcher)Matchers.hasEntry((Object)"extremely_long_attribute", (Object)"     00000     00010     00020     00030     00040     00050     00060     00070     00080     00090     00100     00110     00120     00130     00140     00150     00160     00170     00180     00190     00200     00210     00220     00230     00240     00250     00260     00270     00280     00290     00300     00310     00320     00330     00340     00350     00360     00370     00380     00390     00400     00410     00420     00430     00440     00450     00460     00470     00480     00490     00500     00510     00520     00530     00540     00550     00560     00570     00580     00590     00600     00610     00620     00630     00640     00650     00660     00670     00680     00690     00700     00710     00720     00730     00740     00750     00760     00770     00780     00790     00800     00810     00820     00830     00840     00850     00860     00870     00880     00890     00900     00910     00920     00930     00940     00950     00960     00970     00980     00990     01000     01010     01020     01030     01040     01050     01060     01070     01080     01090     01100     01110     01120     01130     01140     01150     01160     01170     01180     01190     01200     01210     01220     01230     01240     01250     01260     01270     01280     01290     01300     01310     01320     01330     01340     01350     01360     01370     01380     01390     01400     01410     01420     01430     01440     01450     01460     01470     01480     01490     01500     01510     01520     01530     01540     01550     01560     01570     01580     01590     01600     01610     01620     01630     01640     01650     01660     01670     01680     01690     01700     01710     01720     01730     01740     01750     01760     01770     01780     01790     01800     01810     01820     01830     01840     01850     01860     01870     01880     01890     01900     01910     01920     01930     01940     01950     01960     01970     01980     01990     02000     02010     02020     02030     02040     02050     02060     02070     02080     02090     02100     02110     02120     02130     02140     02150     02160     02170     02180     02190     02200     02210     02220     02230     02240     02250     02260     02270     02280     02290     02300     02310     02320     02330     02340     02350     02360     02370     02380     02390     02400     02410     02420     02430     02440     02450     02460     02470     02480     02490     02500     02510     02520     02530     02540     02550     02560     02570     02580     02590     02600     02610     02620     02630     02640     02650     02660     02670     02680     02690     02700     02710     02720     02730     02740     02750     02760     02770     02780     02790     02800     02810     02820     02830     02840     02850     02860     02870     02880     02890     02900     02910     02920     02930     02940     02950     02960     02970     02980     02990     03000     03010     03020     03030     03040     03050     03060     03070     03080     03090     03100     03110     03120     03130     03140     03150     03160     03170     03180     03190     03200     03210     03220     03230     03240     03250     03260     03270     03280     03290     03300     03310     03320     03330     03340     03350     03360     03370     03380     03390     03400     03410     03420     03430     03440     03450     03460     03470     03480     03490     03500     03510     03520     03530     03540     03550     03560     03570     03580     03590     03600     03610     03620     03630     03640     03650     03660     03670     03680     03690     03700     03710     03720     03730     03740     03750     03760     03770     03780     03790     03800     03810     03820     03830     03840     03850     03860     03870     03880     03890     03900     03910     03920     03930     03940     03950     03960     03970     03980")));
    }

    protected void testRealmAttributesMigration() {
        this.log.info((Object)"testing realm attributes migration");
        Map realmAttributes = this.migrationRealm.toRepresentation().getAttributes();
        org.junit.Assert.assertEquals((Object)"custom_value", realmAttributes.get("custom_attribute"));
    }
}

