/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.metrics;

import java.util.List;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.junit.BeforeClass;
import org.junit.Test;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.util.AdminClientUtil;
import org.keycloak.testsuite.util.ContainerAssume;
import org.keycloak.testsuite.util.Matchers;

public class MetricsRestServiceTest
extends AbstractKeycloakTest {
    private static final String MGMT_PORT = System.getProperty("auth.server.management.port", "10090");
    private static final String MGMT_HOST = System.getProperty("auth.server.management.host", "localhost");

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
    }

    @BeforeClass
    public static void enabled() {
        ContainerAssume.assumeNotAuthServerUndertow();
        ContainerAssume.assumeNotAuthServerQuarkus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHealthEndpoint() {
        String expectedString = "{\"name\" : \"server-state\", \"outcome\" : true, \"data\" : [{ \"value\" : \"running\" }]}";
        try (ResteasyClient client = AdminClientUtil.createResteasyClient();
             Response response = client.target("http://" + MGMT_HOST + ":" + MGMT_PORT + "/health").request().get();){
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.statusCodeIs((Response.Status)Response.Status.OK));
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.body((Matcher)org.hamcrest.Matchers.containsString((String)"{\"name\" : \"server-state\", \"outcome\" : true, \"data\" : [{ \"value\" : \"running\" }]}")));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMetricsEndpoint() {
        try (ResteasyClient client = AdminClientUtil.createResteasyClient();
             Response response = client.target("http://" + MGMT_HOST + ":" + MGMT_PORT + "/metrics").request().get();){
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.statusCodeIs((Response.Status)Response.Status.OK));
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.body((Matcher)org.hamcrest.Matchers.containsString((String)"base_memory_maxHeap_bytes")));
        }
    }
}

