/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.keys;

import java.security.Key;
import java.security.KeyPair;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.ws.rs.core.Response;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.common.util.CertificateUtils;
import org.keycloak.common.util.KeyUtils;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.common.util.PemUtils;
import org.keycloak.jose.jws.AlgorithmType;
import org.keycloak.keys.KeyProvider;
import org.keycloak.representations.idm.ComponentRepresentation;
import org.keycloak.representations.idm.ErrorRepresentation;
import org.keycloak.representations.idm.KeysMetadataRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.pages.AppPage;
import org.keycloak.testsuite.pages.LoginPage;

public class ImportedRsaKeyProviderTest
extends AbstractKeycloakTest {
    @Rule
    public AssertEvents events = new AssertEvents(this);
    @Page
    protected AppPage appPage;
    @Page
    protected LoginPage loginPage;

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation realm = AbstractAdminTest.loadJson(this.getClass().getResourceAsStream("/testrealm.json"), RealmRepresentation.class);
        testRealms.add(realm);
    }

    @Test
    public void privateKeyOnly() throws Exception {
        long priority = System.currentTimeMillis();
        KeyPair keyPair = KeyUtils.generateRsaKeyPair((int)2048);
        String kid = KeyUtils.createKeyId((Key)keyPair.getPublic());
        ComponentRepresentation rep = this.createRep("valid", "rsa");
        rep.getConfig().putSingle((Object)"privateKey", (Object)PemUtils.encodeKey((Key)keyPair.getPrivate()));
        rep.getConfig().putSingle((Object)"priority", (Object)Long.toString(priority));
        Response response = this.adminClient.realm("test").components().add(rep);
        String id = ApiUtil.getCreatedId((Response)response);
        response.close();
        ComponentRepresentation createdRep = this.adminClient.realm("test").components().component(id).toRepresentation();
        Assert.assertEquals((Object)"**********", (Object)createdRep.getConfig().getFirst((Object)"privateKey"));
        Assert.assertNotNull((Object)createdRep.getConfig().getFirst((Object)"certificate"));
        Assert.assertEquals((Object)keyPair.getPublic(), (Object)PemUtils.decodeCertificate((String)((String)createdRep.getConfig().getFirst((Object)"certificate"))).getPublicKey());
        KeysMetadataRepresentation keys = this.adminClient.realm("test").keys().getKeyMetadata();
        Assert.assertEquals((Object)kid, keys.getActive().get("RS256"));
        KeysMetadataRepresentation.KeyMetadataRepresentation key = (KeysMetadataRepresentation.KeyMetadataRepresentation)keys.getKeys().get(0);
        Assert.assertEquals((Object)id, (Object)key.getProviderId());
        Assert.assertEquals((Object)AlgorithmType.RSA.name(), (Object)key.getType());
        Assert.assertEquals((long)priority, (long)key.getProviderPriority());
        Assert.assertEquals((Object)kid, (Object)key.getKid());
        Assert.assertEquals((Object)PemUtils.encodeKey((Key)keyPair.getPublic()), (Object)((KeysMetadataRepresentation.KeyMetadataRepresentation)keys.getKeys().get(0)).getPublicKey());
        Assert.assertEquals((Object)keyPair.getPublic(), (Object)PemUtils.decodeCertificate((String)key.getCertificate()).getPublicKey());
    }

    @Test
    public void keyAndCertificate() throws Exception {
        long priority = System.currentTimeMillis();
        KeyPair keyPair = KeyUtils.generateRsaKeyPair((int)2048);
        X509Certificate certificate = CertificateUtils.generateV1SelfSignedCertificate((KeyPair)keyPair, (String)"test");
        String certificatePem = PemUtils.encodeCertificate((Certificate)certificate);
        ComponentRepresentation rep = this.createRep("valid", "rsa");
        rep.getConfig().putSingle((Object)"privateKey", (Object)PemUtils.encodeKey((Key)keyPair.getPrivate()));
        rep.getConfig().putSingle((Object)"certificate", (Object)certificatePem);
        rep.getConfig().putSingle((Object)"priority", (Object)Long.toString(priority));
        Response response = this.adminClient.realm("test").components().add(rep);
        String id = ApiUtil.getCreatedId((Response)response);
        response.close();
        ComponentRepresentation createdRep = this.adminClient.realm("test").components().component(id).toRepresentation();
        Assert.assertEquals((Object)"**********", (Object)createdRep.getConfig().getFirst((Object)"privateKey"));
        Assert.assertEquals((Object)certificatePem, (Object)createdRep.getConfig().getFirst((Object)"certificate"));
        KeysMetadataRepresentation keys = this.adminClient.realm("test").keys().getKeyMetadata();
        KeysMetadataRepresentation.KeyMetadataRepresentation key = (KeysMetadataRepresentation.KeyMetadataRepresentation)keys.getKeys().get(0);
        Assert.assertEquals((Object)certificatePem, (Object)key.getCertificate());
    }

    @Test
    public void invalidPriority() throws Exception {
        KeyPair keyPair = KeyUtils.generateRsaKeyPair((int)2048);
        ComponentRepresentation rep = this.createRep("invalid", "rsa");
        rep.getConfig().putSingle((Object)"privateKey", (Object)PemUtils.encodeKey((Key)keyPair.getPrivate()));
        rep.getConfig().putSingle((Object)"priority", (Object)"invalid");
        Response response = this.adminClient.realm("test").components().add(rep);
        this.assertErrror(response, "'Priority' should be a number");
    }

    @Test
    public void invalidEnabled() throws Exception {
        KeyPair keyPair = KeyUtils.generateRsaKeyPair((int)2048);
        ComponentRepresentation rep = this.createRep("invalid", "rsa");
        rep.getConfig().putSingle((Object)"privateKey", (Object)PemUtils.encodeKey((Key)keyPair.getPrivate()));
        rep.getConfig().putSingle((Object)"enabled", (Object)"invalid");
        Response response = this.adminClient.realm("test").components().add(rep);
        this.assertErrror(response, "'Enabled' should be 'true' or 'false'");
    }

    @Test
    public void invalidActive() throws Exception {
        KeyPair keyPair = KeyUtils.generateRsaKeyPair((int)2048);
        ComponentRepresentation rep = this.createRep("invalid", "rsa");
        rep.getConfig().putSingle((Object)"privateKey", (Object)PemUtils.encodeKey((Key)keyPair.getPrivate()));
        rep.getConfig().putSingle((Object)"active", (Object)"invalid");
        Response response = this.adminClient.realm("test").components().add(rep);
        this.assertErrror(response, "'Active' should be 'true' or 'false'");
    }

    @Test
    public void invalidPrivateKey() throws Exception {
        KeyPair keyPair = KeyUtils.generateRsaKeyPair((int)2048);
        ComponentRepresentation rep = this.createRep("invalid", "rsa");
        Response response = this.adminClient.realm("test").components().add(rep);
        this.assertErrror(response, "'Private RSA Key' is required");
        rep.getConfig().putSingle((Object)"privateKey", (Object)"nonsense");
        response = this.adminClient.realm("test").components().add(rep);
        this.assertErrror(response, "Failed to decode private key");
        rep.getConfig().putSingle((Object)"privateKey", (Object)PemUtils.encodeKey((Key)keyPair.getPublic()));
        response = this.adminClient.realm("test").components().add(rep);
        this.assertErrror(response, "Failed to decode private key");
    }

    @Test
    public void invalidCertificate() throws Exception {
        KeyPair keyPair = KeyUtils.generateRsaKeyPair((int)2048);
        X509Certificate invalidCertificate = CertificateUtils.generateV1SelfSignedCertificate((KeyPair)KeyUtils.generateRsaKeyPair((int)2048), (String)"test");
        ComponentRepresentation rep = this.createRep("invalid", "rsa");
        rep.getConfig().putSingle((Object)"privateKey", (Object)PemUtils.encodeKey((Key)keyPair.getPrivate()));
        rep.getConfig().putSingle((Object)"certificate", (Object)"nonsense");
        Response response = this.adminClient.realm("test").components().add(rep);
        this.assertErrror(response, "Failed to decode certificate");
        rep.getConfig().putSingle((Object)"certificate", (Object)PemUtils.encodeCertificate((Certificate)invalidCertificate));
        response = this.adminClient.realm("test").components().add(rep);
        this.assertErrror(response, "Certificate does not match private key");
    }

    protected void assertErrror(Response response, String error) {
        if (!response.hasEntity()) {
            Assert.fail((String)"No error message set");
        }
        ErrorRepresentation errorRepresentation = (ErrorRepresentation)response.readEntity(ErrorRepresentation.class);
        Assert.assertEquals((Object)error, (Object)errorRepresentation.getErrorMessage());
        response.close();
    }

    protected ComponentRepresentation createRep(String name, String providerId) {
        ComponentRepresentation rep = new ComponentRepresentation();
        rep.setName(name);
        rep.setParentId("test");
        rep.setProviderId(providerId);
        rep.setProviderType(KeyProvider.class.getName());
        rep.setConfig(new MultivaluedHashMap());
        return rep;
    }
}

