/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.keys;

import java.util.List;
import javax.ws.rs.core.Response;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.common.util.Base64Url;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.keys.KeyProvider;
import org.keycloak.representations.idm.ComponentRepresentation;
import org.keycloak.representations.idm.ErrorRepresentation;
import org.keycloak.representations.idm.KeysMetadataRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.pages.AppPage;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.runonserver.RunHelpers;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class GeneratedHmacKeyProviderTest
extends AbstractKeycloakTest {
    @Rule
    public AssertEvents events = new AssertEvents(this);
    @Page
    protected AppPage appPage;
    @Page
    protected LoginPage loginPage;

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation realm = AbstractAdminTest.loadJson(this.getClass().getResourceAsStream("/testrealm.json"), RealmRepresentation.class);
        testRealms.add(realm);
    }

    @Test
    public void defaultKeysize() throws Exception {
        long priority = System.currentTimeMillis();
        ComponentRepresentation rep = this.createRep("valid", "hmac-generated");
        rep.setConfig(new MultivaluedHashMap());
        rep.getConfig().putSingle((Object)"priority", (Object)Long.toString(priority));
        Response response = this.adminClient.realm("test").components().add(rep);
        String id = ApiUtil.getCreatedId((Response)response);
        response.close();
        ComponentRepresentation createdRep = this.adminClient.realm("test").components().component(id).toRepresentation();
        Assert.assertEquals((long)1L, (long)createdRep.getConfig().size());
        Assert.assertEquals((Object)Long.toString(priority), (Object)createdRep.getConfig().getFirst((Object)"priority"));
        KeysMetadataRepresentation keys = this.adminClient.realm("test").keys().getKeyMetadata();
        KeysMetadataRepresentation.KeyMetadataRepresentation key = null;
        for (KeysMetadataRepresentation.KeyMetadataRepresentation k : keys.getKeys()) {
            if (!k.getAlgorithm().equals("HS256")) continue;
            key = k;
            break;
        }
        Assert.assertEquals((Object)id, (Object)key.getProviderId());
        Assert.assertEquals((Object)"OCT", (Object)key.getType());
        Assert.assertEquals((long)priority, (long)key.getProviderPriority());
        ComponentRepresentation component = (ComponentRepresentation)this.testingClient.server("test").fetch(RunHelpers.internalComponent((String)id));
        Assert.assertEquals((long)64L, (long)Base64Url.decode((String)((String)component.getConfig().getFirst((Object)"secret"))).length);
    }

    @Test
    public void largeKeysize() {
        long priority = System.currentTimeMillis();
        ComponentRepresentation rep = this.createRep("valid", "hmac-generated");
        rep.setConfig(new MultivaluedHashMap());
        rep.getConfig().putSingle((Object)"priority", (Object)Long.toString(priority));
        rep.getConfig().putSingle((Object)"secretSize", (Object)"512");
        Response response = this.adminClient.realm("test").components().add(rep);
        String id = ApiUtil.getCreatedId((Response)response);
        response.close();
        ComponentRepresentation createdRep = this.adminClient.realm("test").components().component(id).toRepresentation();
        Assert.assertEquals((long)2L, (long)createdRep.getConfig().size());
        Assert.assertEquals((Object)"512", (Object)createdRep.getConfig().getFirst((Object)"secretSize"));
        KeysMetadataRepresentation keys = this.adminClient.realm("test").keys().getKeyMetadata();
        KeysMetadataRepresentation.KeyMetadataRepresentation key = null;
        for (KeysMetadataRepresentation.KeyMetadataRepresentation k : keys.getKeys()) {
            if (!k.getAlgorithm().equals("HS256")) continue;
            key = k;
            break;
        }
        Assert.assertEquals((Object)id, (Object)key.getProviderId());
        Assert.assertEquals((Object)"OCT", (Object)key.getType());
        Assert.assertEquals((long)priority, (long)key.getProviderPriority());
        ComponentRepresentation component = (ComponentRepresentation)this.testingClient.server("test").fetch(RunHelpers.internalComponent((String)id));
        Assert.assertEquals((long)512L, (long)Base64Url.decode((String)((String)component.getConfig().getFirst((Object)"secret"))).length);
    }

    @Test
    public void updateKeysize() throws Exception {
        long priority = System.currentTimeMillis();
        ComponentRepresentation rep = this.createRep("valid", "hmac-generated");
        rep.setConfig(new MultivaluedHashMap());
        rep.getConfig().putSingle((Object)"priority", (Object)Long.toString(priority));
        Response response = this.adminClient.realm("test").components().add(rep);
        String id = ApiUtil.getCreatedId((Response)response);
        response.close();
        ComponentRepresentation component = (ComponentRepresentation)this.testingClient.server("test").fetch(RunHelpers.internalComponent((String)id));
        Assert.assertEquals((long)64L, (long)Base64Url.decode((String)((String)component.getConfig().getFirst((Object)"secret"))).length);
        ComponentRepresentation createdRep = this.adminClient.realm("test").components().component(id).toRepresentation();
        createdRep.getConfig().putSingle((Object)"secretSize", (Object)"512");
        this.adminClient.realm("test").components().component(id).update(createdRep);
        component = (ComponentRepresentation)this.testingClient.server("test").fetch(RunHelpers.internalComponent((String)id));
        Assert.assertEquals((long)512L, (long)Base64Url.decode((String)((String)component.getConfig().getFirst((Object)"secret"))).length);
    }

    @Test
    public void invalidKeysize() throws Exception {
        ComponentRepresentation rep = this.createRep("invalid", "hmac-generated");
        rep.getConfig().putSingle((Object)"secretSize", (Object)"1234");
        Response response = this.adminClient.realm("test").components().add(rep);
        this.assertErrror(response, "'Secret size' should be 16, 24, 32, 64, 128, 256 or 512");
    }

    protected void assertErrror(Response response, String error) {
        if (!response.hasEntity()) {
            Assert.fail((String)"No error message set");
        }
        ErrorRepresentation errorRepresentation = (ErrorRepresentation)response.readEntity(ErrorRepresentation.class);
        Assert.assertEquals((Object)error, (Object)errorRepresentation.getErrorMessage());
    }

    protected ComponentRepresentation createRep(String name, String providerId) {
        ComponentRepresentation rep = new ComponentRepresentation();
        rep.setName(name);
        rep.setParentId("test");
        rep.setProviderId(providerId);
        rep.setProviderType(KeyProvider.class.getName());
        rep.setConfig(new MultivaluedHashMap());
        return rep;
    }
}

