/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.keys;

import java.security.KeyFactory;
import java.security.interfaces.ECPublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.List;
import javax.ws.rs.core.Response;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.common.util.Base64;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.keys.AbstractEcdsaKeyProviderFactory;
import org.keycloak.keys.KeyProvider;
import org.keycloak.representations.idm.ComponentRepresentation;
import org.keycloak.representations.idm.KeysMetadataRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.pages.AppPage;
import org.keycloak.testsuite.pages.LoginPage;

public class GeneratedEcdsaKeyProviderTest
extends AbstractKeycloakTest {
    private static final String DEFAULT_EC = "P-256";
    private static final String ECDSA_ELLIPTIC_CURVE_KEY = "ecdsaEllipticCurveKey";
    private static final String TEST_REALM_NAME = "test";
    @Rule
    public AssertEvents events = new AssertEvents(this);
    @Page
    protected AppPage appPage;
    @Page
    protected LoginPage loginPage;

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation realm = AbstractAdminTest.loadJson(this.getClass().getResourceAsStream("/testrealm.json"), RealmRepresentation.class);
        testRealms.add(realm);
    }

    @Test
    public void defaultEc() {
        this.supportedEc(null);
    }

    @Test
    public void supportedEcP521() {
        this.supportedEc("P-521");
    }

    @Test
    public void supportedEcP384() {
        this.supportedEc("P-384");
    }

    @Test
    public void supportedEcP256() {
        this.supportedEc(DEFAULT_EC);
    }

    @Test
    public void unsupportedEcK163() {
        this.unsupportedEc("K-163");
    }

    private String supportedEc(String ecInNistRep) {
        long priority = System.currentTimeMillis();
        ComponentRepresentation rep = this.createRep("valid", "ecdsa-generated");
        rep.setConfig(new MultivaluedHashMap());
        rep.getConfig().putSingle((Object)"priority", (Object)Long.toString(priority));
        if (ecInNistRep != null) {
            rep.getConfig().putSingle((Object)ECDSA_ELLIPTIC_CURVE_KEY, (Object)ecInNistRep);
        } else {
            ecInNistRep = DEFAULT_EC;
        }
        Response response = this.adminClient.realm(TEST_REALM_NAME).components().add(rep);
        String id = ApiUtil.getCreatedId((Response)response);
        this.getCleanup().addComponentId(id);
        response.close();
        ComponentRepresentation createdRep = this.adminClient.realm(TEST_REALM_NAME).components().component(id).toRepresentation();
        Assert.assertEquals((long)2L, (long)createdRep.getConfig().size());
        Assert.assertEquals((Object)Long.toString(priority), (Object)createdRep.getConfig().getFirst((Object)"priority"));
        Assert.assertEquals((Object)ecInNistRep, (Object)createdRep.getConfig().getFirst((Object)ECDSA_ELLIPTIC_CURVE_KEY));
        KeysMetadataRepresentation keys = this.adminClient.realm(TEST_REALM_NAME).keys().getKeyMetadata();
        KeysMetadataRepresentation.KeyMetadataRepresentation key = null;
        for (KeysMetadataRepresentation.KeyMetadataRepresentation k : keys.getKeys()) {
            if (!"EC".equals(k.getType()) || !id.equals(k.getProviderId())) continue;
            key = k;
            break;
        }
        Assert.assertNotNull(key);
        Assert.assertEquals((Object)id, (Object)key.getProviderId());
        Assert.assertEquals((Object)"EC", (Object)key.getType());
        Assert.assertEquals((long)priority, (long)key.getProviderPriority());
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unsupportedEc(String ecInNistRep) {
        long priority = System.currentTimeMillis();
        ComponentRepresentation rep = this.createRep("valid", "ecdsa-generated");
        rep.setConfig(new MultivaluedHashMap());
        rep.getConfig().putSingle((Object)"priority", (Object)Long.toString(priority));
        rep.getConfig().putSingle((Object)ECDSA_ELLIPTIC_CURVE_KEY, (Object)ecInNistRep);
        boolean isEcAccepted = true;
        try (Response response = null;){
            response = this.adminClient.realm(TEST_REALM_NAME).components().add(rep);
            String id = ApiUtil.getCreatedId((Response)response);
            this.getCleanup().addComponentId(id);
            response.close();
        }
        Assert.assertEquals((Object)isEcAccepted, (Object)false);
    }

    @Test
    public void changeCurveFromP256ToP384() throws Exception {
        this.changeCurve(DEFAULT_EC, "P-384");
    }

    @Test
    public void changeCurveFromP384ToP521() throws Exception {
        this.changeCurve("P-384", "P-521");
    }

    @Test
    public void changeCurveFromP521ToP256() throws Exception {
        this.changeCurve("P-521", DEFAULT_EC);
    }

    private void changeCurve(String FromEcInNistRep, String ToEcInNistRep) throws Exception {
        String keyComponentId = this.supportedEc(FromEcInNistRep);
        KeysMetadataRepresentation keys = this.adminClient.realm(TEST_REALM_NAME).keys().getKeyMetadata();
        KeysMetadataRepresentation.KeyMetadataRepresentation originalKey = null;
        for (KeysMetadataRepresentation.KeyMetadataRepresentation k : keys.getKeys()) {
            if (!"EC".equals(k.getType()) || !keyComponentId.equals(k.getProviderId())) continue;
            originalKey = k;
            break;
        }
        ComponentRepresentation createdRep = this.adminClient.realm(TEST_REALM_NAME).components().component(keyComponentId).toRepresentation();
        createdRep.getConfig().putSingle((Object)ECDSA_ELLIPTIC_CURVE_KEY, (Object)ToEcInNistRep);
        this.adminClient.realm(TEST_REALM_NAME).components().component(keyComponentId).update(createdRep);
        createdRep = this.adminClient.realm(TEST_REALM_NAME).components().component(keyComponentId).toRepresentation();
        Assert.assertEquals((long)2L, (long)createdRep.getConfig().size());
        Assert.assertEquals((Object)ToEcInNistRep, (Object)createdRep.getConfig().getFirst((Object)ECDSA_ELLIPTIC_CURVE_KEY));
        keys = this.adminClient.realm(TEST_REALM_NAME).keys().getKeyMetadata();
        KeysMetadataRepresentation.KeyMetadataRepresentation key = null;
        for (KeysMetadataRepresentation.KeyMetadataRepresentation k : keys.getKeys()) {
            if (!"EC".equals(k.getType()) || !keyComponentId.equals(k.getProviderId())) continue;
            key = k;
            break;
        }
        Assert.assertNotNull(key);
        Assert.assertEquals((Object)keyComponentId, (Object)key.getProviderId());
        Assert.assertNotEquals((Object)originalKey.getKid(), (Object)key.getKid());
        Assert.assertEquals((Object)"EC", (Object)key.getType());
        Assert.assertNotEquals((Object)originalKey.getAlgorithm(), (Object)key.getAlgorithm());
        Assert.assertEquals((Object)ToEcInNistRep, (Object)AbstractEcdsaKeyProviderFactory.convertAlgorithmToECDomainParmNistRep((String)key.getAlgorithm()));
        Assert.assertEquals((Object)ToEcInNistRep, (Object)this.getCurveFromPublicKey(key.getPublicKey()));
    }

    protected ComponentRepresentation createRep(String name, String providerId) {
        ComponentRepresentation rep = new ComponentRepresentation();
        rep.setName(name);
        rep.setParentId(TEST_REALM_NAME);
        rep.setProviderId(providerId);
        rep.setProviderType(KeyProvider.class.getName());
        rep.setConfig(new MultivaluedHashMap());
        return rep;
    }

    private String getCurveFromPublicKey(String publicEcdsaKeyBase64Encoded) throws Exception {
        KeyFactory kf = KeyFactory.getInstance("EC");
        X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(Base64.decode((String)publicEcdsaKeyBase64Encoded));
        ECPublicKey ecKey = (ECPublicKey)kf.generatePublic(publicKeySpec);
        return "P-" + ecKey.getParams().getCurve().getField().getFieldSize();
    }
}

