/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.keys;

import java.util.LinkedList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsCollectionWithSize;
import org.hamcrest.collection.IsIterableContainingInAnyOrder;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.representations.idm.ComponentRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.pages.AppPage;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.util.OAuthClient;

public class FallbackKeyProviderTest
extends AbstractKeycloakTest {
    @Rule
    public AssertEvents events = new AssertEvents(this);
    @Page
    protected AppPage appPage;
    @Page
    protected LoginPage loginPage;

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation realm = AbstractAdminTest.loadJson(this.getClass().getResourceAsStream("/testrealm.json"), RealmRepresentation.class);
        testRealms.add(realm);
    }

    @Test
    public void fallbackAfterDeletingAllKeysInRealm() {
        String realmId = this.realmsResouce().realm("test").toRepresentation().getId();
        List providers = this.realmsResouce().realm("test").components().query(realmId, "org.keycloak.keys.KeyProvider");
        Assert.assertEquals((long)3L, (long)providers.size());
        for (ComponentRepresentation p : providers) {
            this.realmsResouce().realm("test").components().component(p.getId()).remove();
        }
        providers = this.realmsResouce().realm("test").components().query(realmId, "org.keycloak.keys.KeyProvider");
        Assert.assertEquals((long)0L, (long)providers.size());
        this.oauth.doLogin("test-user@localhost", "password");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse response = this.oauth.doAccessTokenRequest(code, "password");
        Assert.assertNotNull((Object)response.getAccessToken());
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        providers = this.realmsResouce().realm("test").components().query(realmId, "org.keycloak.keys.KeyProvider");
        this.assertProviders(providers, "fallback-RS256", "fallback-HS256");
    }

    @Test
    public void differentAlgorithms() {
        String realmId = this.realmsResouce().realm("test").toRepresentation().getId();
        String[] algorithmsToTest = new String[]{"RS384", "RS512", "PS256", "PS384", "PS512", "ES256", "ES384", "ES512"};
        this.oauth.doLogin("test-user@localhost", "password");
        for (String algorithm : algorithmsToTest) {
            RealmRepresentation rep = this.realmsResouce().realm("test").toRepresentation();
            rep.setDefaultSignatureAlgorithm(algorithm);
            this.realmsResouce().realm("test").update(rep);
            this.oauth.openLoginForm();
            String code = (String)this.oauth.getCurrentQuery().get("code");
            OAuthClient.AccessTokenResponse response = this.oauth.doAccessTokenRequest(code, "password");
            Assert.assertNotNull((Object)response.getAccessToken());
        }
        List providers = this.realmsResouce().realm("test").components().query(realmId, "org.keycloak.keys.KeyProvider");
        LinkedList<String> expected = new LinkedList<String>();
        expected.add("rsa");
        expected.add("hmac-generated");
        expected.add("aes-generated");
        for (String a : algorithmsToTest) {
            expected.add("fallback-" + a);
        }
        this.assertProviders(providers, expected.toArray(new String[providers.size()]));
    }

    @Override
    protected boolean isImportAfterEachMethod() {
        return true;
    }

    private void assertProviders(List<ComponentRepresentation> providers, String ... expected) {
        LinkedList<String> names = new LinkedList<String>();
        for (ComponentRepresentation p : providers) {
            names.add(p.getName());
        }
        Assert.assertThat(names, (Matcher)IsCollectionWithSize.hasSize((int)expected.length));
        Assert.assertThat(names, (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])expected));
    }
}

