/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.javascript;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsMapContaining;
import org.jboss.arquillian.graphene.page.Page;
import org.jboss.arquillian.graphene.wait.StringMatcher;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.common.Profile;
import org.keycloak.common.util.Retry;
import org.keycloak.events.EventType;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.EventRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.arquillian.SuiteContext;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.arquillian.annotation.DisableFeature;
import org.keycloak.testsuite.auth.page.account.Applications;
import org.keycloak.testsuite.auth.page.login.OAuthGrant;
import org.keycloak.testsuite.auth.page.login.OIDCLogin;
import org.keycloak.testsuite.auth.page.login.UpdatePassword;
import org.keycloak.testsuite.javascript.AbstractJavascriptTest;
import org.keycloak.testsuite.util.JavascriptBrowser;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.RealmBuilder;
import org.keycloak.testsuite.util.ServerURLs;
import org.keycloak.testsuite.util.URLAssert;
import org.keycloak.testsuite.util.UserBuilder;
import org.keycloak.testsuite.util.WaitUtils;
import org.keycloak.testsuite.util.javascript.JSObjectBuilder;
import org.keycloak.testsuite.util.javascript.JavascriptStateValidator;
import org.keycloak.testsuite.util.javascript.JavascriptTestExecutor;
import org.keycloak.testsuite.util.javascript.ResponseValidator;
import org.keycloak.testsuite.util.javascript.XMLHttpRequest;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class JavascriptAdapterTest
extends AbstractJavascriptTest {
    private String testAppUrl;
    private String testAppWithInitInHeadUrl;
    protected JavascriptTestExecutor testExecutor;
    private static int TIME_SKEW_TOLERANCE = 3;
    @Rule
    public AssertEvents events = new AssertEvents(this);
    @Page
    @JavascriptBrowser
    private Applications applicationsPage;
    @Page
    @JavascriptBrowser
    private OAuthGrant oAuthGrantPage;
    @Page
    @JavascriptBrowser
    private UpdatePassword updatePasswordPage;

    @Override
    protected RealmRepresentation updateRealm(RealmBuilder builder) {
        return builder.accessTokenLifespan(30 + TOKEN_LIFESPAN_LEEWAY).build();
    }

    @Before
    public void setDefaultEnvironment() {
        String testAppRootUrl = this.authServerContextRootPage.toString().replace(ServerURLs.AUTH_SERVER_HOST, JS_APP_HOST) + "/auth/realms/test/testing/javascript";
        this.testAppUrl = testAppRootUrl + "/index.html";
        this.testAppWithInitInHeadUrl = testAppRootUrl + "/init-in-head.html";
        this.jsDriverTestRealmLoginPage.setAuthRealm("test");
        this.oAuthGrantPage.setAuthRealm("test");
        this.applicationsPage.setAuthRealm("test");
        this.jsDriver.navigate().to(this.oauth.getLoginFormUrl());
        WaitUtils.waitForPageToLoad();
        this.events.poll();
        this.jsDriver.manage().deleteAllCookies();
        this.navigateToTestApp(this.testAppUrl);
        this.testExecutor = JavascriptTestExecutor.create((WebDriver)this.jsDriver, (OIDCLogin)this.jsDriverTestRealmLoginPage);
        this.jsDriver.manage().deleteAllCookies();
        this.setStandardFlowForClient();
        this.oauth.setDriver(this.driver);
        this.setTimeOffset(0);
    }

    protected JSObjectBuilder defaultArguments() {
        return JSObjectBuilder.create().defaultSettings();
    }

    private void assertOnTestAppUrl(WebDriver jsDriver, Object output, WebElement events) {
        this.assertOnTestAppUrl(jsDriver, output, events, this.testAppUrl);
    }

    private void assertOnTestAppWithInitInHeadUrl(WebDriver jsDriver, Object output, WebElement events) {
        this.assertOnTestAppUrl(jsDriver, output, events, this.testAppWithInitInHeadUrl);
    }

    private void assertOnTestAppUrl(WebDriver jsDriver, Object output, WebElement events, String testAppUrl) {
        WaitUtils.waitForPageToLoad();
        URLAssert.assertCurrentUrlStartsWith(testAppUrl, jsDriver);
    }

    @Test
    public void testJSConsoleAuth() {
        this.testExecutor.init(this.defaultArguments(), this::assertInitNotAuth).login(this::assertOnLoginPage).loginForm(UserBuilder.create().username("user").password("invalid-password").build(), (JavascriptStateValidator & Serializable)(driver1, output, events) -> URLAssert.assertCurrentUrlDoesntStartWith(this.testAppUrl, driver1)).loginForm(UserBuilder.create().username("invalid-user").password("password").build(), (JavascriptStateValidator & Serializable)(driver1, output, events) -> URLAssert.assertCurrentUrlDoesntStartWith(this.testAppUrl, driver1)).loginForm(testUser, this::assertOnTestAppUrl).init(this.defaultArguments(), this::assertInitAuth).logout(this::assertOnTestAppUrl).init(this.defaultArguments(), this::assertInitNotAuth);
    }

    @Test
    public void testLoginWithPkceS256() {
        JSObjectBuilder pkceS256 = this.defaultArguments().pkceS256();
        this.testExecutor.init(pkceS256, this::assertInitNotAuth).login(this::assertOnLoginPage).loginForm(testUser, this::assertOnTestAppUrl).init(pkceS256, this::assertInitAuth).logout(this::assertOnTestAppUrl).init(pkceS256, this::assertInitNotAuth);
    }

    @Test
    public void testSilentCheckSso() {
        JSObjectBuilder checkSSO = this.defaultArguments().checkSSOOnLoad().add("silentCheckSsoRedirectUri", (Object)(this.authServerContextRootPage.toString().replace(ServerURLs.AUTH_SERVER_HOST, JS_APP_HOST) + "/auth/realms/test/testing/javascript" + "/silent-check-sso.html"));
        this.testExecutor.init(checkSSO, this::assertInitNotAuth, SuiteContext.BROWSER_STRICT_COOKIES).login(this::assertOnLoginPage).loginForm(testUser, this::assertOnTestAppUrl).init(checkSSO, this::assertInitAuth, false).refresh().init(checkSSO, this::assertInitAuth, SuiteContext.BROWSER_STRICT_COOKIES);
    }

    @Test
    public void testSilentCheckSsoLoginWithLoginIframeDisabled() {
        JSObjectBuilder checkSSO = this.defaultArguments().checkSSOOnLoad().add("silentCheckSsoRedirectUri", (Object)(this.authServerContextRootPage.toString().replace(ServerURLs.AUTH_SERVER_HOST, JS_APP_HOST) + "/auth/realms/test/testing/javascript" + "/silent-check-sso.html"));
        this.testExecutor.init(checkSSO, this::assertInitNotAuth, SuiteContext.BROWSER_STRICT_COOKIES).login(this::assertOnLoginPage).loginForm(testUser, this::assertOnTestAppUrl).init(checkSSO, this::assertInitAuth, false).refresh().init(checkSSO.disableCheckLoginIframe(), this::assertInitAuth, SuiteContext.BROWSER_STRICT_COOKIES);
    }

    @Test
    public void testSilentCheckSsoWithFallbackDisabled() {
        JSObjectBuilder checkSSO = this.defaultArguments().checkSSOOnLoad().disableSilentCheckSSOFallback().add("silentCheckSsoRedirectUri", (Object)(this.authServerContextRootPage.toString().replace(ServerURLs.AUTH_SERVER_HOST, JS_APP_HOST) + "/auth/realms/test/testing/javascript" + "/silent-check-sso.html"));
        this.testExecutor.init(checkSSO, this::assertInitNotAuth).login(this::assertOnLoginPage).loginForm(testUser, this::assertOnTestAppUrl).init(checkSSO, this::assertInitAuth).refresh().init(checkSSO, (JavascriptStateValidator)(SuiteContext.BROWSER_STRICT_COOKIES ? this::assertInitNotAuth : this::assertInitAuth));
    }

    @Test
    public void testCheckSso() {
        JSObjectBuilder checkSSO = this.defaultArguments().checkSSOOnLoad();
        this.testExecutor.init(checkSSO, this::assertInitNotAuth, SuiteContext.BROWSER_STRICT_COOKIES).login(this::assertOnLoginPage).loginForm(testUser, this::assertOnTestAppUrl).init(checkSSO, this::assertInitAuth, false).refresh().init(checkSSO, this::assertInitAuth, true);
    }

    @Test
    public void testSilentCheckSsoNotAuthenticated() {
        JSObjectBuilder checkSSO = this.defaultArguments().checkSSOOnLoad().add("checkLoginIframe", (Object)false).add("silentCheckSsoRedirectUri", (Object)(this.authServerContextRootPage.toString().replace(ServerURLs.AUTH_SERVER_HOST, JS_APP_HOST) + "/auth/realms/test/testing/javascript" + "/silent-check-sso.html"));
        this.testExecutor.init(checkSSO, this::assertInitNotAuth, SuiteContext.BROWSER_STRICT_COOKIES);
    }

    @Test
    public void testIframeInit() {
        JSObjectBuilder iframeInterval = this.defaultArguments().setCheckLoginIframeIntervalTo1();
        this.testExecutor.init(iframeInterval).login().loginForm(testUser).init(iframeInterval).wait(2000L, (JavascriptStateValidator & Serializable)(driver1, output, events) -> {
            this.assertAdapterIsLoggedIn(driver1, output, events);
            String logMsg = "3rd party cookies aren't supported by this browser.";
            if (SuiteContext.BROWSER_STRICT_COOKIES) {
                this.assertEventsWebElementContains("3rd party cookies aren't supported by this browser.", driver1, output, events);
            } else {
                this.assertEventsWebElementDoesntContain("3rd party cookies aren't supported by this browser.", driver1, output, events);
            }
        });
    }

    @Test
    public void testRefreshToken() {
        this.testExecutor.init(this.defaultArguments(), this::assertInitNotAuth).refreshToken(9999, this.assertOutputContains("Failed to refresh token")).login(this::assertOnLoginPage).loginForm(testUser, this::assertOnTestAppUrl).init(this.defaultArguments(), this::assertInitAuth).refreshToken(9999, this.assertEventsContains("Auth Refresh Success"));
    }

    @Test
    public void testRefreshTokenIfUnder30s() {
        this.testExecutor.init(this.defaultArguments(), this::assertInitNotAuth).login(this::assertOnLoginPage).loginForm(testUser, this::assertOnTestAppUrl).init(this.defaultArguments(), this::assertInitAuth).refreshToken(30, this.assertOutputContains("Token not refreshed, valid for")).addTimeSkew(-5).refreshToken(30, this.assertEventsContains("Auth Refresh Success"));
    }

    @Test
    public void testGetProfile() {
        this.testExecutor.init(this.defaultArguments(), this::assertInitNotAuth).getProfile(this.assertOutputContains("Failed to load profile")).login(this::assertOnLoginPage).loginForm(testUser, this::assertOnTestAppUrl).init(this.defaultArguments(), this::assertInitAuth).getProfile((JavascriptStateValidator & Serializable)(driver1, output, events) -> Assert.assertThat((Object)((Map)output), (Matcher)IsMapContaining.hasEntry((Object)"username", (Object)testUser.getUsername())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @DisableFeature(value=Profile.Feature.ACCOUNT2, skipRestart=true)
    public void grantBrowserBasedApp() {
        Assume.assumeTrue((String)"This test doesn't work with phantomjs", (!"phantomjs".equals(System.getProperty("js.browser")) ? 1 : 0) != 0);
        ClientResource clientResource = ApiUtil.findClientResourceByClientId((RealmResource)this.adminClient.realm("test"), (String)"js-console");
        ClientRepresentation client = clientResource.toRepresentation();
        try {
            client.setConsentRequired(Boolean.valueOf(true));
            clientResource.update(client);
            this.testExecutor.init(this.defaultArguments(), this::assertInitNotAuth).login(this::assertOnLoginPage).loginForm(testUser, (JavascriptStateValidator & Serializable)(driver1, output, events) -> org.junit.Assert.assertTrue((boolean)this.oAuthGrantPage.isCurrent(driver1)));
            this.oAuthGrantPage.accept();
            EventRepresentation loginEvent = this.events.expectLogin().client("js-console").detail("consent", "consent_granted").detail("redirect_uri", this.testAppUrl).detail("username", testUser.getUsername()).assertEvent();
            String codeId = (String)loginEvent.getDetails().get("code_id");
            this.testExecutor.init(this.defaultArguments(), this::assertInitAuth);
            this.applicationsPage.navigateTo();
            this.events.expectCodeToToken(codeId, loginEvent.getSessionId()).client("js-console").assertEvent();
            this.applicationsPage.revokeGrantForApplication("js-console");
            this.events.expect(EventType.REVOKE_GRANT).client("account").detail("revoked_client", "js-console").assertEvent();
            this.jsDriver.navigate().to(this.testAppUrl);
            this.testExecutor.configure().init(this.defaultArguments(), this::assertInitNotAuth).login((JavascriptStateValidator & Serializable)(driver1, output, events) -> org.junit.Assert.assertTrue((boolean)this.oAuthGrantPage.isCurrent(driver1)));
        }
        finally {
            client.setConsentRequired(Boolean.valueOf(false));
            clientResource.update(client);
        }
    }

    @Test
    public void implicitFlowTest() {
        this.testExecutor.init(this.defaultArguments().implicitFlow(), this::assertInitNotAuth).login(this::assertOnTestAppUrl).errorResponse(this.assertOutputContains("Implicit flow is disabled for the client"));
        this.setImplicitFlowForClient();
        this.jsDriver.navigate().to(this.testAppUrl);
        this.testExecutor.init(this.defaultArguments(), this::assertInitNotAuth).login(this::assertOnTestAppUrl).errorResponse(this.assertOutputContains("Standard flow is disabled for the client"));
        this.jsDriver.navigate().to(this.testAppUrl);
        this.testExecutor.init(this.defaultArguments().implicitFlow(), this::assertInitNotAuth).login(this::assertOnLoginPage).loginForm(testUser, this::assertOnTestAppUrl).init(this.defaultArguments().implicitFlow(), this::assertInitAuth);
    }

    @Test
    public void testCertEndpoint() {
        this.testExecutor.logInAndInit(this.defaultArguments(), testUser, this::assertInitAuth).sendXMLHttpRequest(XMLHttpRequest.create().url(this.authServerContextRootPage + "/auth/realms/" + "test" + "/protocol/openid-connect/certs").method("GET").addHeader("Accept", "application/json").addHeader("Authorization", "Bearer ' + keycloak.token + '"), this.assertResponseStatus(200L));
    }

    @Test
    public void implicitFlowQueryTest() {
        this.setImplicitFlowForClient();
        this.testExecutor.init(JSObjectBuilder.create().implicitFlow().queryResponse(), this::assertInitNotAuth).login((JavascriptStateValidator & Serializable)(driver1, output, events1) -> Retry.execute(() -> org.junit.Assert.assertThat((Object)driver1.getCurrentUrl(), (Matcher)CoreMatchers.containsString((String)"Response_mode+%27query%27+not+allowed")), (int)20, (long)50L));
    }

    @Test
    public void implicitFlowRefreshTokenTest() {
        this.setImplicitFlowForClient();
        this.testExecutor.logInAndInit(this.defaultArguments().implicitFlow(), testUser, this::assertInitAuth).refreshToken(9999, this.assertOutputContains("Failed to refresh token"));
    }

    @Test
    public void implicitFlowOnTokenExpireTest() {
        RealmRepresentation realm = this.adminClient.realms().realm("test").toRepresentation();
        Integer storeAccesTokenLifespan = realm.getAccessTokenLifespanForImplicitFlow();
        try {
            realm.setAccessTokenLifespanForImplicitFlow(Integer.valueOf(5));
            this.adminClient.realms().realm("test").update(realm);
            this.setImplicitFlowForClient();
            this.testExecutor.logInAndInit(this.defaultArguments().implicitFlow(), testUser, this::assertInitAuth).addTimeSkew(-5);
            WaitUtils.waitUntilElement((WebElement)this.eventsArea).text().contains("Access token expired");
        }
        finally {
            realm.setAccessTokenLifespanForImplicitFlow(storeAccesTokenLifespan);
            this.adminClient.realms().realm("test").update(realm);
        }
    }

    @Test
    public void implicitFlowCertEndpoint() {
        this.setImplicitFlowForClient();
        this.testExecutor.logInAndInit(this.defaultArguments().implicitFlow(), testUser, this::assertInitAuth).sendXMLHttpRequest(XMLHttpRequest.create().url(this.authServerContextRootPage + "/auth/realms/" + "test" + "/protocol/openid-connect/certs").method("GET").addHeader("Accept", "application/json").addHeader("Authorization", "Bearer ' + keycloak.token + '"), this.assertResponseStatus(200L));
    }

    @Test
    public void testBearerRequest() {
        XMLHttpRequest request = XMLHttpRequest.create().url(this.authServerContextRootPage + "/auth/admin/realms/" + "test" + "/roles").method("GET").addHeader("Accept", "application/json").addHeader("Authorization", "Bearer ' + keycloak.token + '");
        this.testExecutor.init(this.defaultArguments()).sendXMLHttpRequest(request, (ResponseValidator & Serializable)response -> org.junit.Assert.assertThat((Object)response, (Matcher)IsMapContaining.hasEntry((Matcher)Matchers.is((Object)"status"), (Matcher)CoreMatchers.anyOf((Matcher)Matchers.is((Object)0L), (Matcher)Matchers.is((Object)401L))))).refresh();
        if (!"phantomjs".equals(System.getProperty("js.browser"))) {
            this.testExecutor.logInAndInit(this.defaultArguments(), unauthorizedUser, this::assertInitAuth).sendXMLHttpRequest(request, (ResponseValidator & Serializable)output -> Assert.assertThat((Object)output, (Matcher)IsMapContaining.hasEntry((Object)"status", (Object)403L))).logout(this::assertOnTestAppUrl).refresh();
        }
        this.testExecutor.logInAndInit(this.defaultArguments(), testUser, this::assertInitAuth).sendXMLHttpRequest(request, this.assertResponseStatus(200L));
    }

    @Test
    public void loginRequiredAction() {
        try {
            this.testExecutor.init(this.defaultArguments().loginRequiredOnLoad());
            throw new RuntimeException("Probably the login-required OnLoad mode doesn't work, because testExecutor should fail with error that page was redirected.");
        }
        catch (WebDriverException webDriverException) {
            this.testExecutor.loginForm(testUser, this::assertOnTestAppUrl).init(this.defaultArguments(), this::assertInitAuth);
            return;
        }
    }

    @Test
    public void testScopeInInitOptionsShouldBeConsideredByLoginUrl() {
        JSObjectBuilder initOptions = this.defaultArguments().loginRequiredOnLoad().add("scope", (Object)"openid profile email phone");
        try {
            this.testExecutor.init(initOptions);
            throw new RuntimeException("Probably the login-required OnLoad mode doesn't work, because testExecutor should fail with error that page was redirected.");
        }
        catch (WebDriverException webDriverException) {
            this.testExecutor.loginForm(testUser, this::assertOnTestAppUrl).init(initOptions, this::assertAdapterIsLoggedIn).executeScript("return window.keycloak.tokenParsed.scope", this.assertOutputContains("phone"));
            return;
        }
    }

    @Test
    public void testScopeInLoginOptionsShouldBeConsideredByLoginUrl() {
        this.testExecutor.configure().init(this.defaultArguments());
        JSObjectBuilder loginOptions = JSObjectBuilder.create().add("scope", (Object)"profile email phone");
        this.testExecutor.login(loginOptions, (JavascriptStateValidator & Serializable)(driver, output, events) -> org.junit.Assert.assertThat((Object)driver.getCurrentUrl(), (Matcher)CoreMatchers.containsString((String)"&scope=openid%20profile%20email%20phone")));
    }

    @Test
    public void testUpdateToken() {
        XMLHttpRequest request = XMLHttpRequest.create().url(this.authServerContextRootPage + "/auth/admin/realms/" + "test" + "/roles").method("GET").addHeader("Accept", "application/json").addHeader("Authorization", "Bearer ' + keycloak.token + '");
        this.testExecutor.logInAndInit(this.defaultArguments(), testUser, this::assertInitAuth).addTimeSkew(-33);
        this.setTimeOffset(33);
        this.testExecutor.refreshToken(5, this.assertEventsContains("Auth Refresh Success"));
        this.setTimeOffset(67);
        this.testExecutor.addTimeSkew(-34).sendXMLHttpRequest(request, (ResponseValidator & Serializable)response -> org.junit.Assert.assertThat((Object)response, (Matcher)IsMapContaining.hasEntry((Matcher)Matchers.is((Object)"status"), (Matcher)CoreMatchers.anyOf((Matcher)Matchers.is((Object)0L), (Matcher)Matchers.is((Object)401L))))).refreshToken(5, this.assertEventsContains("Auth Refresh Success")).sendXMLHttpRequest(request, this.assertResponseStatus(200L));
    }

    @Test
    public void timeSkewTest() {
        this.testExecutor.logInAndInit(this.defaultArguments(), testUser, this::assertInitAuth).checkTimeSkew((JavascriptStateValidator & Serializable)(driver1, output, events) -> org.junit.Assert.assertThat((Object)Math.toIntExact((Long)output), (Matcher)Matchers.is((Matcher)CoreMatchers.both((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0 - TIME_SKEW_TOLERANCE))).and(Matchers.lessThan((Comparable)Integer.valueOf(TIME_SKEW_TOLERANCE))))));
        this.setTimeOffset(40);
        this.testExecutor.refreshToken(9999, this.assertEventsContains("Auth Refresh Success")).checkTimeSkew((JavascriptStateValidator & Serializable)(driver1, output, events) -> org.junit.Assert.assertThat((Object)Math.toIntExact((Long)output), (Matcher)Matchers.is((Matcher)CoreMatchers.both((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(-40 - TIME_SKEW_TOLERANCE))).and(Matchers.lessThan((Comparable)Integer.valueOf(-40 + TIME_SKEW_TOLERANCE))))));
    }

    @Test
    public void testOneSecondTimeSkewTokenUpdate() {
        this.setTimeOffset(1);
        this.testExecutor.logInAndInit(this.defaultArguments(), testUser, this::assertInitAuth).refreshToken(9999, this.assertEventsContains("Auth Refresh Success"));
        try {
            WaitUtils.waitUntilElement((WebElement)this.eventsArea).text().contains("Auth Logout");
            throw new RuntimeException("The events element shouldn't contain \"Auth Logout\" text");
        }
        catch (TimeoutException timeoutException) {
            return;
        }
    }

    @Test
    public void testLocationHeaderInResponse() {
        XMLHttpRequest request = XMLHttpRequest.create().url(this.authServerContextRootPage + "/auth/admin/realms/" + "test" + "/users").method("POST").content("JSON.stringify(JSON.parse('{\"emailVerified\" : false, \"enabled\" : true, \"username\": \"mhajas\", \"firstName\" :\"First\", \"lastName\":\"Last\",\"email\":\"email@redhat.com\", \"attributes\": {}}'))").addHeader("Accept", "application/json").addHeader("Authorization", "Bearer ' + keycloak.token + '").addHeader("Content-Type", "application/json; charset=UTF-8");
        this.testExecutor.logInAndInit(this.defaultArguments(), testUser, this::assertInitAuth).sendXMLHttpRequest(request, (ResponseValidator & Serializable)response -> {
            List users = this.adminClient.realm("test").users().search("mhajas", Integer.valueOf(0), Integer.valueOf(1));
            org.junit.Assert.assertEquals((String)"There should be created user mhajas", (long)1L, (long)users.size());
            org.junit.Assert.assertThat((Object)((String)response.get("responseHeaders")).toLowerCase(), (Matcher)CoreMatchers.containsString((String)("location: " + this.authServerContextRootPage.toString() + "/auth/admin/realms/" + "test" + "/users/" + ((UserRepresentation)users.get(0)).getId())));
        });
    }

    @Test
    public void equalsSignInRedirectUrl() {
        this.testAppUrl = this.authServerContextRootPage.toString().replace(ServerURLs.AUTH_SERVER_HOST, JS_APP_HOST) + "/auth/realms/test/testing/javascript" + "/index.html?test=bla=bla&super=man";
        this.jsDriver.navigate().to(this.testAppUrl);
        JSObjectBuilder arguments = this.defaultArguments();
        this.testExecutor.init(arguments, this::assertInitNotAuth).login(this::assertOnLoginPage).loginForm(testUser, this::assertOnTestAppUrl).init(arguments, (JavascriptStateValidator & Serializable)(driver1, output1, events2) -> {
            org.junit.Assert.assertTrue((boolean)driver1.getCurrentUrl().contains("bla=bla"));
            this.assertInitAuth(driver1, output1, events2);
        });
    }

    @Test
    public void spaceInRealmNameTest() {
        Assume.assumeTrue((String)"This test doesn't work with phantomjs", (!"phantomjs".equals(System.getProperty("js.browser")) ? 1 : 0) != 0);
        try {
            this.adminClient.realm("test").update(RealmBuilder.edit(this.adminClient.realm("test").toRepresentation()).name("Example realm").build());
            JSObjectBuilder configuration = JSObjectBuilder.create().add("url", (Object)(this.authServerContextRootPage + "/auth")).add("realm", (Object)"Example realm").add("clientId", (Object)"js-console");
            this.testAppUrl = this.authServerContextRootPage + "/auth/realms/Example%20realm/testing/javascript" + "/index.html";
            this.jsDriver.navigate().to(this.testAppUrl);
            this.jsDriverTestRealmLoginPage.setAuthRealm("Example realm");
            this.testExecutor.configure(configuration).init(this.defaultArguments(), this::assertInitNotAuth).login(this::assertOnLoginPage).loginForm(testUser, this::assertOnTestAppUrl).configure(configuration).init(this.defaultArguments(), this::assertInitAuth);
        }
        finally {
            this.adminClient.realm("Example realm").update(RealmBuilder.edit(this.adminClient.realm("Example realm").toRepresentation()).name("test").build());
            this.jsDriverTestRealmLoginPage.setAuthRealm("test");
        }
    }

    @Test
    public void initializeWithTokenTest() {
        this.oauth.setDriver(this.jsDriver);
        this.oauth.realm("test");
        this.oauth.clientId("js-console");
        this.oauth.redirectUri(this.testAppUrl);
        this.oauth.doLogin(testUser);
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doAccessTokenRequest(code, "password");
        String token = tokenResponse.getAccessToken();
        String refreshToken = tokenResponse.getRefreshToken();
        this.testExecutor.init(JSObjectBuilder.create().add("token", (Object)token).add("refreshToken", (Object)refreshToken), (JavascriptStateValidator & Serializable)(driver1, output, events) -> {
            this.assertInitAuth(driver1, output, events);
            if (SuiteContext.BROWSER_STRICT_COOKIES) {
                this.assertEventsContains("Auth Refresh Success").validate(driver1, output, events);
            } else {
                this.assertEventsDoesntContain("Auth Refresh Success").validate(driver1, output, events);
            }
        }).refreshToken(9999, this.assertEventsContains("Auth Refresh Success"));
    }

    @Test
    public void initializeWithTimeSkew() {
        this.oauth.setDriver(this.jsDriver);
        this.setTimeOffset(600);
        this.oauth.realm("test");
        this.oauth.clientId("js-console");
        this.oauth.redirectUri(this.testAppUrl);
        this.oauth.doLogin(testUser);
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doAccessTokenRequest(code, "password");
        String token = tokenResponse.getAccessToken();
        String refreshToken = tokenResponse.getRefreshToken();
        this.testExecutor.init(JSObjectBuilder.create().add("token", (Object)token).add("refreshToken", (Object)refreshToken).add("timeSkew", (Object)-600), this::assertInitAuth).checkTimeSkew((JavascriptStateValidator & Serializable)(driver1, output, events) -> org.junit.Assert.assertThat((Object)((Long)output), (Matcher)Matchers.is((Matcher)CoreMatchers.both((Matcher)Matchers.greaterThan((Comparable)Long.valueOf(-600L - (long)TIME_SKEW_TOLERANCE))).and(Matchers.lessThan((Comparable)Long.valueOf(-600L + (long)TIME_SKEW_TOLERANCE)))))).refreshToken(9999, this.assertEventsContains("Auth Refresh Success")).checkTimeSkew((JavascriptStateValidator & Serializable)(driver1, output, events) -> org.junit.Assert.assertThat((Object)((Long)output), (Matcher)Matchers.is((Matcher)CoreMatchers.both((Matcher)Matchers.greaterThan((Comparable)Long.valueOf(-600L - (long)TIME_SKEW_TOLERANCE))).and(Matchers.lessThan((Comparable)Long.valueOf(-600L + (long)TIME_SKEW_TOLERANCE))))));
    }

    @Test
    public void initializeWithRefreshToken() {
        this.oauth.setDriver(this.jsDriver);
        this.oauth.realm("test");
        this.oauth.clientId("js-console");
        this.oauth.redirectUri(this.testAppUrl);
        this.oauth.doLogin(testUser);
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doAccessTokenRequest(code, "password");
        String token = tokenResponse.getAccessToken();
        String refreshToken = tokenResponse.getRefreshToken();
        this.testExecutor.init(JSObjectBuilder.create().add("refreshToken", (Object)refreshToken), (JavascriptStateValidator & Serializable)(driver1, output, events) -> {
            this.assertInitNotAuth(driver1, output, events);
            ((StringMatcher)WaitUtils.waitUntilElement((WebElement)events).text().not()).contains("Auth Success");
        });
    }

    @Test
    public void reentrancyCallbackTest() {
        this.testExecutor.logInAndInit(this.defaultArguments(), testUser, this::assertInitAuth).executeAsyncScript("var callback = arguments[arguments.length - 1];keycloak.updateToken(60).then(function () {       event(\"First callback\");       keycloak.updateToken(60).then(function () {          event(\"Second callback\");          callback(\"Success\");       });    });", (JavascriptStateValidator & Serializable)(driver1, output, events) -> {
            WaitUtils.waitUntilElement((WebElement)events).text().contains("First callback");
            WaitUtils.waitUntilElement((WebElement)events).text().contains("Second callback");
            ((StringMatcher)WaitUtils.waitUntilElement((WebElement)events).text().not()).contains("Auth Logout");
        });
    }

    @Test
    public void fragmentInURLTest() {
        this.jsDriver.navigate().to(this.testAppUrl + "#fragmentPart");
        this.testExecutor.init(this.defaultArguments(), this::assertInitNotAuth).login(this::assertOnLoginPage).loginForm(testUser, this::assertOnTestAppUrl).init(this.defaultArguments(), (JavascriptStateValidator & Serializable)(driver1, output, events1) -> {
            this.assertInitAuth(driver1, output, events1);
            org.junit.Assert.assertThat((Object)driver1.getCurrentUrl(), (Matcher)CoreMatchers.containsString((String)"#fragmentPart"));
        });
    }

    @Test
    public void fragmentInLoginFunction() {
        this.testExecutor.init(this.defaultArguments(), this::assertInitNotAuth).login(JSObjectBuilder.create().add("redirectUri", (Object)(this.testAppUrl + "#fragmentPart")).build(), this::assertOnLoginPage).loginForm(testUser, this::assertOnTestAppUrl).init(this.defaultArguments(), (JavascriptStateValidator & Serializable)(driver1, output, events1) -> {
            this.assertInitAuth(driver1, output, events1);
            org.junit.Assert.assertThat((Object)driver1.getCurrentUrl(), (Matcher)CoreMatchers.containsString((String)"#fragmentPart"));
        });
    }

    @Test
    public void testRefreshTokenWithDeprecatedPromiseHandles() {
        String refreshWithDeprecatedHandles = "var callback = arguments[arguments.length - 1];   window.keycloak.updateToken(9999).success(function (refreshed) {            callback('Success handle');   }).error(function () {       callback('Error handle');   });";
        this.testExecutor.init(this.defaultArguments(), this::assertInitNotAuth).executeAsyncScript(refreshWithDeprecatedHandles, this.assertOutputContains("Error handle")).login(this::assertOnLoginPage).loginForm(testUser, this::assertOnTestAppUrl).init(this.defaultArguments(), this::assertInitAuth).executeAsyncScript(refreshWithDeprecatedHandles, this.assertOutputContains("Success handle"));
    }

    @Test
    public void testAIAFromJavascriptAdapterSuccess() {
        this.testExecutor.init(this.defaultArguments(), this::assertInitNotAuth).login(JSObjectBuilder.create().add("action", (Object)"UPDATE_PASSWORD").build(), this::assertOnLoginPage).loginForm(testUser);
        this.updatePasswordPage.updatePasswords("password", "password");
        this.testExecutor.init(this.defaultArguments(), (JavascriptStateValidator & Serializable)(driver1, output, events1) -> {
            this.assertInitAuth(driver1, output, events1);
            WaitUtils.waitUntilElement((WebElement)events1).text().contains("AIA status: success");
        });
    }

    @Test
    public void testAIAFromJavascriptAdapterCancelled() {
        this.testExecutor.init(this.defaultArguments(), this::assertInitNotAuth).login(JSObjectBuilder.create().add("action", (Object)"UPDATE_PASSWORD").build(), this::assertOnLoginPage).loginForm(testUser);
        this.updatePasswordPage.cancel();
        this.testExecutor.init(this.defaultArguments(), (JavascriptStateValidator & Serializable)(driver1, output, events1) -> {
            this.assertInitAuth(driver1, output, events1);
            WaitUtils.waitUntilElement((WebElement)events1).text().contains("AIA status: cancelled");
        });
    }

    @Test
    public void testInitInHead() {
        this.navigateToTestApp(this.testAppWithInitInHeadUrl);
        this.testExecutor.validateOutputField(this::assertInitNotAuth).login(this::assertOnLoginPage).loginForm(testUser, this::assertOnTestAppWithInitInHeadUrl).validateOutputField(this::assertInitAuth);
    }

    @Test
    public void check3pCookiesMessageCallbackTest() {
        this.testExecutor.attachCheck3pCookiesIframeMutationObserver().init(this.defaultArguments(), this::assertInitNotAuth);
    }

    @Test
    public void checkInitWithInvalidRealm() {
        JSObjectBuilder keycloakConfig = JSObjectBuilder.create().add("url", (Object)(this.authServerContextRootPage + "/auth")).add("realm", (Object)"invalid-realm-name").add("clientId", (Object)"js-console");
        JSObjectBuilder initOptions = this.defaultArguments().add("messageReceiveTimeout", (Object)5000);
        this.testExecutor.configure(keycloakConfig).init(initOptions, this.assertErrorResponse("Timeout when waiting for 3rd party check iframe message."));
    }

    @Test
    public void checkInitWithUnavailableAuthServer() {
        JSObjectBuilder keycloakConfig = JSObjectBuilder.create().add("url", (Object)"https://localhost:12345/auth").add("realm", (Object)"test").add("clientId", (Object)"js-console");
        JSObjectBuilder initOptions = this.defaultArguments().add("messageReceiveTimeout", (Object)5000);
        this.testExecutor.configure(keycloakConfig).init(initOptions, this.assertErrorResponse("Timeout when waiting for 3rd party check iframe message."));
    }

    protected void assertAdapterIsLoggedIn(WebDriver driver1, Object output, WebElement events) {
        org.junit.Assert.assertTrue((boolean)this.testExecutor.isLoggedIn());
    }

    protected void navigateToTestApp(String testAppUrl) {
        this.jsDriver.navigate().to(testAppUrl);
        WaitUtils.waitUntilElement((WebElement)this.outputArea).is().present();
        URLAssert.assertCurrentUrlStartsWith(testAppUrl, this.jsDriver);
    }
}

