/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.i18n;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.ws.rs.core.Response;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.CloseableHttpClient;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.arquillian.graphene.page.Page;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.engines.ApacheHttpClient4Engine;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.adapters.HttpClientBuilder;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.models.UserModel;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.ProfileAssume;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.i18n.AbstractI18NTest;
import org.keycloak.testsuite.pages.AppPage;
import org.keycloak.testsuite.pages.LanguageComboboxAwarePage;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.pages.LoginPasswordUpdatePage;
import org.keycloak.testsuite.pages.OAuthGrantPage;
import org.keycloak.testsuite.util.IdentityProviderBuilder;
import org.openqa.selenium.Cookie;

public class LoginPageTest
extends AbstractI18NTest {
    @Page
    protected AppPage appPage;
    @Page
    protected LoginPage loginPage;
    @Page
    protected LoginPasswordUpdatePage changePasswordPage;
    @Page
    protected OAuthGrantPage grantPage;

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
        testRealm.addIdentityProvider(IdentityProviderBuilder.create().providerId("github").alias("github").build());
        testRealm.addIdentityProvider(IdentityProviderBuilder.create().providerId("saml").alias("mysaml").build());
        testRealm.addIdentityProvider(IdentityProviderBuilder.create().providerId("oidc").alias("myoidc").displayName("MyOIDC").build());
    }

    @Test
    public void languageDropdown() {
        ProfileAssume.assumeCommunity();
        this.loginPage.open();
        Assert.assertEquals((Object)"English", (Object)this.loginPage.getLanguageDropdownText());
        this.switchLanguageToGermanAndBack("Username or email", "Benutzername oder E-Mail", (LanguageComboboxAwarePage)this.loginPage);
    }

    @Test
    public void uiLocalesParameter() {
        this.loginPage.open();
        Assert.assertEquals((Object)"English", (Object)this.loginPage.getLanguageDropdownText());
        this.oauth.uiLocales("de");
        this.loginPage.open();
        Assert.assertEquals((Object)"Deutsch", (Object)this.loginPage.getLanguageDropdownText());
        this.driver.manage().deleteAllCookies();
        this.loginPage.open();
        Assert.assertEquals((Object)"Deutsch", (Object)this.loginPage.getLanguageDropdownText());
        this.oauth.uiLocales("en de");
        this.driver.manage().deleteAllCookies();
        this.loginPage.open();
        Assert.assertEquals((Object)"English", (Object)this.loginPage.getLanguageDropdownText());
        this.oauth.uiLocales("fr de");
        this.driver.manage().deleteAllCookies();
        this.loginPage.open();
        Assert.assertEquals((Object)"Deutsch", (Object)this.loginPage.getLanguageDropdownText());
    }

    @Test
    public void acceptLanguageHeader() throws IOException {
        ProfileAssume.assumeCommunity();
        try (CloseableHttpClient httpClient = (CloseableHttpClient)new HttpClientBuilder().build();){
            ApacheHttpClient4Engine engine = new ApacheHttpClient4Engine((HttpClient)httpClient);
            ResteasyClient client = new ResteasyClientBuilder().httpEngine((ClientHttpEngine)engine).build();
            this.loginPage.open();
            try (Response responseDe = client.target(this.driver.getCurrentUrl()).request().acceptLanguage(new String[]{"de"}).get();){
                Assert.assertTrue((boolean)((String)responseDe.readEntity(String.class)).contains("Anmeldung bei test"));
                try (Response responseEn = client.target(this.driver.getCurrentUrl()).request().acceptLanguage(new String[]{"en"}).get();){
                    Assert.assertTrue((boolean)((String)responseEn.readEntity(String.class)).contains("Sign in to test"));
                }
            }
            client.close();
        }
    }

    @Test
    public void testIdentityProviderCapitalization() {
        this.loginPage.open();
        Assert.assertEquals((Object)"GitHub", (Object)this.loginPage.findSocialButton("github").getText());
        Assert.assertEquals((Object)"mysaml", (Object)this.loginPage.findSocialButton("mysaml").getText());
        Assert.assertEquals((Object)"MyOIDC", (Object)this.loginPage.findSocialButton("myoidc").getText());
    }

    @Test
    public void languageChangeRequiredActions() {
        ProfileAssume.assumeCommunity();
        UserResource user = ApiUtil.findUserByUsernameId((RealmResource)this.testRealm(), (String)"test-user@localhost");
        UserRepresentation userRep = user.toRepresentation();
        userRep.setRequiredActions(Arrays.asList(UserModel.RequiredAction.UPDATE_PASSWORD.toString()));
        user.update(userRep);
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.changePasswordPage.assertCurrent();
        Assert.assertEquals((Object)"English", (Object)this.changePasswordPage.getLanguageDropdownText());
        this.switchLanguageToGermanAndBack("Update password", "Passwort aktualisieren", (LanguageComboboxAwarePage)this.changePasswordPage);
        this.changePasswordPage.changePassword("password", "password");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
    }

    @Test
    public void languageChangeConsentScreen() {
        ProfileAssume.assumeCommunity();
        this.oauth.clientId("third-party");
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.grantPage.assertCurrent();
        Assert.assertEquals((Object)"English", (Object)this.grantPage.getLanguageDropdownText());
        this.switchLanguageToGermanAndBack("Do you grant these access privileges?", "Wollen Sie diese Zugriffsrechte", (LanguageComboboxAwarePage)this.changePasswordPage);
        this.grantPage.accept();
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
        this.oauth.clientId("test-app");
    }

    @Test
    public void languageUserUpdates() {
        ProfileAssume.assumeCommunity();
        this.loginPage.open();
        this.loginPage.openLanguage("Deutsch");
        Assert.assertEquals((Object)"Deutsch", (Object)this.loginPage.getLanguageDropdownText());
        Cookie localeCookie = this.driver.manage().getCookieNamed("KEYCLOAK_LOCALE");
        Assert.assertEquals((Object)"de", (Object)localeCookie.getValue());
        this.loginPage.login("test-user@localhost", "password");
        UserResource user = ApiUtil.findUserByUsernameId((RealmResource)this.testRealm(), (String)"test-user@localhost");
        UserRepresentation userRep = user.toRepresentation();
        Assert.assertEquals((Object)"de", ((List)userRep.getAttributes().get("locale")).get(0));
        this.appPage.logout();
        this.loginPage.open();
        Assert.assertEquals((Object)"Deutsch", (Object)this.loginPage.getLanguageDropdownText());
        userRep.getAttributes().remove("locale");
        user.update(userRep);
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        userRep = user.toRepresentation();
        Assert.assertNull((Object)userRep.getAttributes());
        this.appPage.logout();
        this.loginPage.open();
        localeCookie = this.driver.manage().getCookieNamed("KEYCLOAK_LOCALE");
        Assert.assertNull((Object)localeCookie);
    }

    @Test
    public void realmLocalizationMessagesAreNotCachedWithinTheTheme() throws IOException {
        String locale = Locale.ENGLISH.toLanguageTag();
        String realmLocalizationMessageKey = "loginAccountTitle";
        String realmLocalizationMessageValue = "Localization Test";
        try (CloseableHttpClient httpClient = (CloseableHttpClient)new HttpClientBuilder().build();){
            ApacheHttpClient4Engine engine = new ApacheHttpClient4Engine((HttpClient)httpClient);
            this.testRealm().localization().saveRealmLocalizationText(locale, "loginAccountTitle", "Localization Test");
            ResteasyClient client = new ResteasyClientBuilder().httpEngine((ClientHttpEngine)engine).build();
            this.loginPage.open();
            try (Response responseWithLocalization = client.target(this.driver.getCurrentUrl()).request().acceptLanguage(new String[]{locale}).get();){
                MatcherAssert.assertThat((Object)((String)responseWithLocalization.readEntity(String.class)), (Matcher)Matchers.containsString((String)"Localization Test"));
                this.testRealm().localization().deleteRealmLocalizationText(locale, "loginAccountTitle");
                this.loginPage.open();
                try (Response responseWithoutLocalization = client.target(this.driver.getCurrentUrl()).request().acceptLanguage(new String[]{locale}).get();){
                    MatcherAssert.assertThat((Object)((String)responseWithoutLocalization.readEntity(String.class)), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Localization Test")));
                }
            }
            client.close();
        }
    }

    private void switchLanguageToGermanAndBack(String expectedEnglishMessage, String expectedGermanMessage, LanguageComboboxAwarePage page) {
        page.openLanguage("Deutsch");
        Assert.assertEquals((Object)"Deutsch", (Object)page.getLanguageDropdownText());
        String pageSource = this.driver.getPageSource();
        Assert.assertFalse((boolean)pageSource.contains(expectedEnglishMessage));
        Assert.assertTrue((boolean)pageSource.contains(expectedGermanMessage));
        page.openLanguage("English");
        Assert.assertEquals((Object)"English", (Object)page.getLanguageDropdownText());
        pageSource = this.driver.getPageSource();
        Assert.assertTrue((boolean)pageSource.contains(expectedEnglishMessage));
        Assert.assertFalse((boolean)pageSource.contains(expectedGermanMessage));
    }
}

