/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.i18n;

import java.io.IOException;
import java.util.Arrays;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.models.UserModel;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.ProfileAssume;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.i18n.AbstractI18NTest;
import org.keycloak.testsuite.pages.InfoPage;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.pages.LoginPasswordResetPage;
import org.keycloak.testsuite.pages.LoginPasswordUpdatePage;
import org.keycloak.testsuite.util.DroneUtils;
import org.keycloak.testsuite.util.GreenMailRule;
import org.keycloak.testsuite.util.MailUtils;
import org.keycloak.testsuite.util.WaitUtils;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class EmailTest
extends AbstractI18NTest {
    @Rule
    public GreenMailRule greenMail = new GreenMailRule();
    @Page
    protected LoginPage loginPage;
    @Page
    protected LoginPasswordResetPage resetPasswordPage;
    @Page
    private InfoPage infoPage;
    @Page
    private LoginPasswordUpdatePage loginPasswordUpdatePage;

    private void changeUserLocale(String locale) {
        UserRepresentation user = this.findUser("login-test");
        user.singleAttribute("locale", locale);
        ApiUtil.findUserByUsernameId((RealmResource)this.testRealm(), (String)"login-test").update(user);
    }

    @Test
    public void restPasswordEmail() throws IOException, MessagingException {
        this.loginPage.open();
        this.loginPage.resetPassword();
        this.resetPasswordPage.changePassword("login-test");
        Assert.assertEquals((long)1L, (long)this.greenMail.getReceivedMessages().length);
        MimeMessage message = this.greenMail.getReceivedMessages()[0];
        Assert.assertEquals((Object)"Reset password", (Object)message.getSubject());
        this.changeUserLocale("en");
        this.loginPage.open();
        this.loginPage.resetPassword();
        this.resetPasswordPage.changePassword("login-test");
        Assert.assertEquals((long)2L, (long)this.greenMail.getReceivedMessages().length);
        message = this.greenMail.getReceivedMessages()[1];
        Assert.assertEquals((Object)"Reset password", (Object)message.getSubject());
    }

    @Test
    public void restPasswordEmailGerman() throws IOException, MessagingException {
        ProfileAssume.assumeCommunity();
        this.changeUserLocale("de");
        this.loginPage.open();
        this.loginPage.resetPassword();
        this.resetPasswordPage.changePassword("login-test");
        Assert.assertEquals((long)1L, (long)this.greenMail.getReceivedMessages().length);
        MimeMessage message = this.greenMail.getReceivedMessages()[0];
        Assert.assertEquals((Object)"Passwort zur\u00fccksetzen", (Object)message.getSubject());
        this.changeUserLocale("en");
    }

    @Test
    public void changeLocaleOnInfoPage() throws InterruptedException, IOException, MessagingException {
        ProfileAssume.assumeCommunity();
        UserResource testUser = ApiUtil.findUserByUsernameId((RealmResource)this.testRealm(), (String)"login-test");
        testUser.executeActionsEmail(Arrays.asList(UserModel.RequiredAction.UPDATE_PASSWORD.toString()));
        if (!this.greenMail.waitForIncomingEmail(1)) {
            Assert.fail((String)"Error when receiving email");
        }
        String link = MailUtils.getPasswordResetEmailLink((MimeMessage)this.greenMail.getLastReceivedMessage());
        link = link + "&kc_locale=de";
        DroneUtils.getCurrentDriver().navigate().to(link);
        WaitUtils.waitForPageToLoad();
        Assert.assertTrue((String)("Expected to be on InfoPage, but it was on " + DroneUtils.getCurrentDriver().getTitle()), (boolean)this.infoPage.isCurrent());
        Assert.assertThat((Object)this.infoPage.getLanguageDropdownText(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"English")));
        this.infoPage.openLanguage("Deutsch");
        Assert.assertThat((Object)DroneUtils.getCurrentDriver().getPageSource(), (Matcher)Matchers.containsString((String)"Passwort aktualisieren"));
        this.infoPage.clickToContinueDe();
        this.loginPasswordUpdatePage.openLanguage("English");
        this.loginPasswordUpdatePage.changePassword("pass", "pass");
        WaitUtils.waitForPageToLoad();
        Assert.assertTrue((String)("Expected to be on InfoPage, but it was on " + DroneUtils.getCurrentDriver().getTitle()), (boolean)this.infoPage.isCurrent());
        Assert.assertThat((Object)this.infoPage.getInfo(), (Matcher)Matchers.containsString((String)"Your account has been updated."));
    }
}

