/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.hok;

import java.io.IOException;
import java.net.URI;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.impl.client.CloseableHttpClient;
import org.hamcrest.Matcher;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.common.util.KeystoreUtil;
import org.keycloak.events.EventType;
import org.keycloak.jose.jws.JWSHeader;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.JWSInputException;
import org.keycloak.jose.jws.crypto.HashUtils;
import org.keycloak.protocol.oidc.OIDCAdvancedConfigWrapper;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.IDToken;
import org.keycloak.representations.RefreshToken;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.EventRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.oidc.TokenMetadataRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.AbstractTestRealmKeycloakTest;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.drone.Different;
import org.keycloak.testsuite.util.ClientManager;
import org.keycloak.testsuite.util.KeycloakModelUtils;
import org.keycloak.testsuite.util.Matchers;
import org.keycloak.testsuite.util.MutualTLSUtils;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.ServerURLs;
import org.keycloak.testsuite.util.UserInfoClientUtil;
import org.keycloak.util.JsonSerialization;
import org.openqa.selenium.WebDriver;

public class HoKTest
extends AbstractTestRealmKeycloakTest {
    @Drone
    @Different
    protected WebDriver driver2;
    private static final List<String> CLIENT_LIST = Arrays.asList("test-app", "named-test-app", "service-account-client");
    @Rule
    public HoKAssertEvents events = new HoKAssertEvents(this);

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
        for (String clientId : CLIENT_LIST) {
            this.addRedirectUrlForTls(testRealm, clientId);
        }
        this.configTestRealmForTokenIntrospection(testRealm);
    }

    @BeforeClass
    public static void checkIfTLSIsTurnedOn() {
        Assume.assumeTrue((boolean)ServerURLs.AUTH_SERVER_SSL_REQUIRED);
    }

    private void addRedirectUrlForTls(RealmRepresentation testRealm, String clientId) {
        for (ClientRepresentation client : testRealm.getClients()) {
            if (!client.getClientId().equals(clientId)) continue;
            URI baseUri = URI.create((String)client.getRedirectUris().get(0));
            URI redir = URI.create("https://localhost:" + System.getProperty("auth.server.https.port", "8543") + baseUri.getRawPath());
            client.getRedirectUris().add(redir.toString());
            break;
        }
    }

    private void configTestRealmForTokenIntrospection(RealmRepresentation testRealm) {
        ClientRepresentation confApp = KeycloakModelUtils.createClient(testRealm, "confidential-cli");
        confApp.setSecret("secret1");
        confApp.setServiceAccountsEnabled(Boolean.TRUE);
        ClientRepresentation serviceAccountApp = KeycloakModelUtils.createClient(testRealm, "service-account-client");
        serviceAccountApp.setSecret("secret1");
        serviceAccountApp.setServiceAccountsEnabled(Boolean.TRUE);
        ClientRepresentation pubApp = KeycloakModelUtils.createClient(testRealm, "public-cli");
        pubApp.setPublicClient(Boolean.TRUE);
        UserRepresentation user = new UserRepresentation();
        user.setUsername("no-permissions");
        CredentialRepresentation credential = new CredentialRepresentation();
        credential.setType("password");
        credential.setValue("password");
        ArrayList<CredentialRepresentation> creds = new ArrayList<CredentialRepresentation>();
        creds.add(credential);
        user.setCredentials(creds);
        user.setEnabled(Boolean.TRUE);
        ArrayList<String> realmRoles = new ArrayList<String>();
        realmRoles.add("user");
        user.setRealmRoles(realmRoles);
        testRealm.getUsers().add(user);
    }

    @Before
    public void enableHoKToken() {
        for (String clientId : CLIENT_LIST) {
            this.enableHoKToken(clientId);
        }
    }

    private void enableHoKToken(String clientId) {
        ClientResource clientResource = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)clientId);
        ClientRepresentation clientRep = clientResource.toRepresentation();
        OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).setUseMtlsHoKToken(true);
        clientResource.update(clientRep);
    }

    @Test
    public void accessTokenRequestWithClientCertificate() throws Exception {
        OAuthClient.AccessTokenResponse response;
        this.oauth.doLogin("test-user@localhost", "password");
        EventRepresentation loginEvent = this.events.expectLogin().assertEvent();
        String sessionId = loginEvent.getSessionId();
        String codeId = (String)loginEvent.getDetails().get("code_id");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        try (CloseableHttpClient client = MutualTLSUtils.newCloseableHttpClientWithDefaultKeyStoreAndTrustStore();){
            response = this.oauth.doAccessTokenRequest(code, "password", client);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        this.expectSuccessfulResponseFromTokenEndpoint(sessionId, codeId, response);
        this.verifyHoKTokenDefaultCertThumbPrint(response);
    }

    @Test
    public void accessTokenRequestWithoutClientCertificate() throws Exception {
        OAuthClient.AccessTokenResponse response;
        this.oauth.doLogin("test-user@localhost", "password");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        try (CloseableHttpClient client = MutualTLSUtils.newCloseableHttpClientWithoutKeyStoreAndTrustStore();){
            response = this.oauth.doAccessTokenRequest(code, "password", client);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        Assert.assertEquals((long)400L, (long)response.getStatusCode());
        Assert.assertEquals((Object)"invalid_request", (Object)response.getError());
        Assert.assertEquals((Object)"Client Certification missing for MTLS HoK Token Binding", (Object)response.getErrorDescription());
    }

    private void expectSuccessfulResponseFromTokenEndpoint(String sessionId, String codeId, OAuthClient.AccessTokenResponse response) throws Exception {
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        Assert.assertThat((Object)response.getExpiresIn(), (Matcher)org.hamcrest.Matchers.allOf((Matcher)org.hamcrest.Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(250)), (Matcher)org.hamcrest.Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(300))));
        Assert.assertThat((Object)response.getRefreshExpiresIn(), (Matcher)org.hamcrest.Matchers.allOf((Matcher)org.hamcrest.Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1750)), (Matcher)org.hamcrest.Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(1800))));
        Assert.assertEquals((Object)"Bearer", (Object)response.getTokenType());
        String expectedKid = this.oauth.doCertsRequest("test").getKeys()[0].getKeyId();
        JWSHeader header = new JWSInput(response.getAccessToken()).getHeader();
        Assert.assertEquals((Object)"RS256", (Object)header.getAlgorithm().name());
        Assert.assertEquals((Object)"JWT", (Object)header.getType());
        Assert.assertEquals((Object)expectedKid, (Object)header.getKeyId());
        Assert.assertNull((Object)header.getContentType());
        header = new JWSInput(response.getIdToken()).getHeader();
        Assert.assertEquals((Object)"RS256", (Object)header.getAlgorithm().name());
        Assert.assertEquals((Object)"JWT", (Object)header.getType());
        Assert.assertEquals((Object)expectedKid, (Object)header.getKeyId());
        Assert.assertNull((Object)header.getContentType());
        header = new JWSInput(response.getRefreshToken()).getHeader();
        Assert.assertEquals((Object)"HS256", (Object)header.getAlgorithm().name());
        Assert.assertEquals((Object)"JWT", (Object)header.getType());
        Assert.assertNull((Object)header.getContentType());
        AccessToken token = this.oauth.verifyToken(response.getAccessToken());
        Assert.assertEquals((Object)ApiUtil.findUserByUsername((RealmResource)this.adminClient.realm("test"), (String)"test-user@localhost").getId(), (Object)token.getSubject());
        Assert.assertNotEquals((Object)"test-user@localhost", (Object)token.getSubject());
        Assert.assertEquals((Object)sessionId, (Object)token.getSessionState());
        Assert.assertEquals((long)2L, (long)token.getRealmAccess().getRoles().size());
        Assert.assertTrue((boolean)token.getRealmAccess().isUserInRole("user"));
        Assert.assertEquals((long)1L, (long)token.getResourceAccess(this.oauth.getClientId()).getRoles().size());
        Assert.assertTrue((boolean)token.getResourceAccess(this.oauth.getClientId()).isUserInRole("customer-user"));
        EventRepresentation event = this.events.expectCodeToToken(codeId, sessionId).assertEvent();
        Assert.assertEquals((Object)token.getId(), event.getDetails().get("token_id"));
        Assert.assertEquals((Object)this.oauth.parseRefreshToken(response.getRefreshToken()).getId(), event.getDetails().get("refresh_token_id"));
        Assert.assertEquals((Object)sessionId, (Object)token.getSessionState());
    }

    @Test
    public void refreshTokenRequestByHoKRefreshTokenByOtherClient() throws Exception {
        this.oauth.doLogin("test-user@localhost", "password");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse tokenResponse = null;
        try (CloseableHttpClient client = MutualTLSUtils.newCloseableHttpClientWithDefaultKeyStoreAndTrustStore();){
            tokenResponse = this.oauth.doAccessTokenRequest(code, "password", client);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        this.verifyHoKTokenDefaultCertThumbPrint(tokenResponse);
        String refreshTokenString = tokenResponse.getRefreshToken();
        OAuthClient oauth2 = new OAuthClient();
        oauth2.init(this.driver2);
        oauth2.doLogin("john-doh@localhost", "password");
        String code2 = (String)oauth2.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse tokenResponse2 = null;
        try (CloseableHttpClient client = MutualTLSUtils.newCloseableHttpClientWithOtherKeyStoreAndTrustStore();){
            tokenResponse2 = oauth2.doAccessTokenRequest(code2, "password", client);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        this.verifyHoKTokenOtherCertThumbPrint(tokenResponse2);
        OAuthClient.AccessTokenResponse response = null;
        try (CloseableHttpClient client = MutualTLSUtils.newCloseableHttpClientWithOtherKeyStoreAndTrustStore();){
            response = oauth2.doRefreshTokenRequest(refreshTokenString, "password", client);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        Assert.assertEquals((long)401L, (long)response.getStatusCode());
        Assert.assertEquals((Object)"unauthorized_client", (Object)response.getError());
        Assert.assertEquals((Object)"Client certificate missing, or its thumbprint and one in the refresh token did NOT match", (Object)response.getErrorDescription());
    }

    @Test
    public void refreshTokenRequestByHoKRefreshTokenWithClientCertificate() throws Exception {
        this.oauth.doLogin("test-user@localhost", "password");
        EventRepresentation loginEvent = this.events.expectLogin().assertEvent();
        String sessionId = loginEvent.getSessionId();
        String codeId = (String)loginEvent.getDetails().get("code_id");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse tokenResponse = null;
        try (CloseableHttpClient client = MutualTLSUtils.newCloseableHttpClientWithDefaultKeyStoreAndTrustStore();){
            tokenResponse = this.oauth.doAccessTokenRequest(code, "password", client);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        this.verifyHoKTokenDefaultCertThumbPrint(tokenResponse);
        AccessToken token = this.oauth.verifyToken(tokenResponse.getAccessToken());
        String refreshTokenString = tokenResponse.getRefreshToken();
        RefreshToken refreshToken = this.oauth.parseRefreshToken(refreshTokenString);
        EventRepresentation tokenEvent = this.events.expectCodeToToken(codeId, sessionId).assertEvent();
        Assert.assertNotNull((Object)refreshTokenString);
        Assert.assertEquals((Object)"Bearer", (Object)tokenResponse.getTokenType());
        Assert.assertThat((Object)(token.getExpiration() - this.getCurrentTime()), (Matcher)org.hamcrest.Matchers.allOf((Matcher)org.hamcrest.Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(200)), (Matcher)org.hamcrest.Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(350))));
        int actual = refreshToken.getExpiration() - this.getCurrentTime();
        Assert.assertThat((Object)actual, (Matcher)org.hamcrest.Matchers.allOf((Matcher)org.hamcrest.Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1796)), (Matcher)org.hamcrest.Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(1803))));
        Assert.assertEquals((Object)sessionId, (Object)refreshToken.getSessionState());
        this.setTimeOffset(2);
        OAuthClient.AccessTokenResponse response = null;
        try (CloseableHttpClient client = MutualTLSUtils.newCloseableHttpClientWithDefaultKeyStoreAndTrustStore();){
            response = this.oauth.doRefreshTokenRequest(refreshTokenString, "password", client);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        this.expectSuccessfulResponseFromTokenEndpoint(response, sessionId, token, refreshToken, tokenEvent);
        this.verifyHoKTokenDefaultCertThumbPrint(response);
    }

    @Test
    public void refreshTokenRequestByRefreshTokenWithoutClientCertificate() throws Exception {
        this.oauth.doLogin("test-user@localhost", "password");
        EventRepresentation loginEvent = this.events.expectLogin().assertEvent();
        String sessionId = loginEvent.getSessionId();
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse tokenResponse = null;
        tokenResponse = this.oauth.doAccessTokenRequest(code, "password");
        this.verifyHoKTokenDefaultCertThumbPrint(tokenResponse);
        AccessToken token = this.oauth.verifyToken(tokenResponse.getAccessToken());
        String refreshTokenString = tokenResponse.getRefreshToken();
        RefreshToken refreshToken = this.oauth.parseRefreshToken(refreshTokenString);
        Assert.assertNotNull((Object)refreshTokenString);
        Assert.assertEquals((Object)"Bearer", (Object)tokenResponse.getTokenType());
        Assert.assertThat((Object)(token.getExpiration() - this.getCurrentTime()), (Matcher)org.hamcrest.Matchers.allOf((Matcher)org.hamcrest.Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(200)), (Matcher)org.hamcrest.Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(350))));
        int actual = refreshToken.getExpiration() - this.getCurrentTime();
        Assert.assertThat((Object)actual, (Matcher)org.hamcrest.Matchers.allOf((Matcher)org.hamcrest.Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1796)), (Matcher)org.hamcrest.Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(1803))));
        Assert.assertEquals((Object)sessionId, (Object)refreshToken.getSessionState());
        this.setTimeOffset(2);
        OAuthClient.AccessTokenResponse response = null;
        try (CloseableHttpClient client = MutualTLSUtils.newCloseableHttpClientWithoutKeyStoreAndTrustStore();){
            response = this.oauth.doRefreshTokenRequest(refreshTokenString, "password", client);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        Assert.assertEquals((long)401L, (long)response.getStatusCode());
        Assert.assertEquals((Object)"unauthorized_client", (Object)response.getError());
        Assert.assertEquals((Object)"Client certificate missing, or its thumbprint and one in the refresh token did NOT match", (Object)response.getErrorDescription());
    }

    private void expectSuccessfulResponseFromTokenEndpoint(OAuthClient.AccessTokenResponse response, String sessionId, AccessToken token, RefreshToken refreshToken, EventRepresentation tokenEvent) {
        this.expectSuccessfulResponseFromTokenEndpoint(this.oauth, "test-user@localhost", response, sessionId, token, refreshToken, tokenEvent);
    }

    private void expectSuccessfulResponseFromTokenEndpoint(OAuthClient oauth, String username, OAuthClient.AccessTokenResponse response, String sessionId, AccessToken token, RefreshToken refreshToken, EventRepresentation tokenEvent) {
        AccessToken refreshedToken = oauth.verifyToken(response.getAccessToken());
        RefreshToken refreshedRefreshToken = oauth.parseRefreshToken(response.getRefreshToken());
        if (refreshedToken.getCertConf() != null) {
            this.log.warnf("refreshed access token's cnf-x5t#256 = %s", (Object)refreshedToken.getCertConf().getCertThumbprint());
            this.log.warnf("refreshed refresh token's cnf-x5t#256 = %s", (Object)refreshedRefreshToken.getCertConf().getCertThumbprint());
        }
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        Assert.assertEquals((Object)sessionId, (Object)refreshedToken.getSessionState());
        Assert.assertEquals((Object)sessionId, (Object)refreshedRefreshToken.getSessionState());
        Assert.assertThat((Object)response.getExpiresIn(), (Matcher)org.hamcrest.Matchers.allOf((Matcher)org.hamcrest.Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(250)), (Matcher)org.hamcrest.Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(300))));
        Assert.assertThat((Object)(refreshedToken.getExpiration() - this.getCurrentTime()), (Matcher)org.hamcrest.Matchers.allOf((Matcher)org.hamcrest.Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(247)), (Matcher)org.hamcrest.Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(303))));
        Assert.assertThat((Object)(refreshedToken.getExpiration() - token.getExpiration()), (Matcher)org.hamcrest.Matchers.allOf((Matcher)org.hamcrest.Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)), (Matcher)org.hamcrest.Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(10))));
        Assert.assertThat((Object)(refreshedRefreshToken.getExpiration() - refreshToken.getExpiration()), (Matcher)org.hamcrest.Matchers.allOf((Matcher)org.hamcrest.Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)), (Matcher)org.hamcrest.Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(10))));
        Assert.assertNotEquals((Object)token.getId(), (Object)refreshedToken.getId());
        Assert.assertNotEquals((Object)refreshToken.getId(), (Object)refreshedRefreshToken.getId());
        Assert.assertEquals((Object)"Bearer", (Object)response.getTokenType());
        Assert.assertEquals((Object)ApiUtil.findUserByUsername((RealmResource)this.adminClient.realm("test"), (String)username).getId(), (Object)refreshedToken.getSubject());
        Assert.assertNotEquals((Object)username, (Object)refreshedToken.getSubject());
        Assert.assertEquals((long)2L, (long)refreshedToken.getRealmAccess().getRoles().size());
        Assert.assertTrue((boolean)refreshedToken.getRealmAccess().isUserInRole("user"));
        Assert.assertEquals((long)1L, (long)refreshedToken.getResourceAccess(oauth.getClientId()).getRoles().size());
        Assert.assertTrue((boolean)refreshedToken.getResourceAccess(oauth.getClientId()).isUserInRole("customer-user"));
        EventRepresentation refreshEvent = this.events.expectRefresh((String)tokenEvent.getDetails().get("refresh_token_id"), sessionId).user(AssertEvents.isUUID()).assertEvent();
        Assert.assertNotEquals(tokenEvent.getDetails().get("token_id"), refreshEvent.getDetails().get("token_id"));
        Assert.assertNotEquals(tokenEvent.getDetails().get("refresh_token_id"), refreshEvent.getDetails().get("updated_refresh_token_id"));
        this.setTimeOffset(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void getUserInfoByHoKAccessTokenWithClientCertificate() throws Exception {
        this.oauth.doLogin("test-user@localhost", "password");
        EventRepresentation loginEvent = this.events.expectLogin().assertEvent();
        String sessionId = loginEvent.getSessionId();
        String codeId = (String)loginEvent.getDetails().get("code_id");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse tokenResponse = null;
        try (CloseableHttpClient client = MutualTLSUtils.newCloseableHttpClientWithDefaultKeyStoreAndTrustStore();){
            tokenResponse = this.oauth.doAccessTokenRequest(code, "password", client);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        this.verifyHoKTokenDefaultCertThumbPrint(tokenResponse);
        this.events.expectCodeToToken(codeId, sessionId).assertEvent();
        ClientBuilder clientBuilder = ClientBuilder.newBuilder();
        KeyStore keystore = null;
        keystore = KeystoreUtil.loadKeyStore((String)MutualTLSUtils.DEFAULT_KEYSTOREPATH, (String)MutualTLSUtils.DEFAULT_KEYSTOREPASSWORD);
        clientBuilder.keyStore(keystore, MutualTLSUtils.DEFAULT_KEYSTOREPASSWORD);
        Client client = clientBuilder.build();
        WebTarget userInfoTarget = null;
        Response response = null;
        try {
            userInfoTarget = UserInfoClientUtil.getUserInfoWebTarget((Client)client);
            response = userInfoTarget.request().header("Authorization", (Object)("Bearer " + tokenResponse.getAccessToken())).get();
            this.testSuccessfulUserInfoResponse(response);
        }
        finally {
            response.close();
            client.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void getUserInfoByHoKAccessTokenWithoutClientCertificate() throws Exception {
        this.oauth.doLogin("test-user@localhost", "password");
        EventRepresentation loginEvent = this.events.expectLogin().assertEvent();
        String sessionId = loginEvent.getSessionId();
        String codeId = (String)loginEvent.getDetails().get("code_id");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse tokenResponse = null;
        try (CloseableHttpClient client = MutualTLSUtils.newCloseableHttpClientWithDefaultKeyStoreAndTrustStore();){
            tokenResponse = this.oauth.doAccessTokenRequest(code, "password", client);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        this.verifyHoKTokenDefaultCertThumbPrint(tokenResponse);
        this.events.expectCodeToToken(codeId, sessionId).assertEvent();
        ClientBuilder clientBuilder = ClientBuilder.newBuilder();
        Client client = clientBuilder.build();
        WebTarget userInfoTarget = null;
        Response response = null;
        try {
            userInfoTarget = UserInfoClientUtil.getUserInfoWebTarget((Client)client);
            response = userInfoTarget.request().header("Authorization", (Object)("Bearer " + tokenResponse.getAccessToken())).get();
            Assert.assertEquals((long)401L, (long)response.getStatus());
        }
        finally {
            response.close();
            client.close();
        }
    }

    private void testSuccessfulUserInfoResponse(Response response) {
        this.events.expect(EventType.USER_INFO_REQUEST).session((Matcher<String>)org.hamcrest.Matchers.notNullValue(String.class)).detail("auth_method", "validate_access_token").detail("username", "test-user@localhost").detail("signature_required", "false").assertEvent();
        UserInfoClientUtil.testSuccessfulUserInfoResponse((Response)response, (String)"test-user@localhost", (String)"test-user@localhost");
    }

    @Test
    public void postLogoutByHoKRefreshTokenWithClientCertificate() throws Exception {
        String refreshTokenString = this.execPreProcessPostLogout();
        CloseableHttpResponse response = null;
        try (CloseableHttpClient client = MutualTLSUtils.newCloseableHttpClientWithDefaultKeyStoreAndTrustStore();){
            response = this.oauth.doLogout(refreshTokenString, "password", client);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        Assert.assertThat((Object)response, (Matcher)Matchers.statusCodeIsHC((Response.Status)Response.Status.NO_CONTENT));
        Assert.assertNotNull((Object)this.testingClient.testApp().getAdminLogoutAction());
    }

    @Test
    public void postLogoutByHoKRefreshTokenWithoutClientCertificate() throws Exception {
        String refreshTokenString = this.execPreProcessPostLogout();
        CloseableHttpResponse response = null;
        try (CloseableHttpClient client = MutualTLSUtils.newCloseableHttpClientWithoutKeyStoreAndTrustStore();){
            response = this.oauth.doLogout(refreshTokenString, "password", client);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        Assert.assertEquals((long)401L, (long)response.getStatusLine().getStatusCode());
    }

    private String execPreProcessPostLogout() throws Exception {
        this.oauth.doLogin("test-user@localhost", "password");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        this.oauth.clientSessionState("client-session");
        OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doAccessTokenRequest(code, "password");
        this.verifyHoKTokenDefaultCertThumbPrint(tokenResponse);
        return tokenResponse.getRefreshToken();
    }

    @Test
    public void accessTokenRequestWithClientCertificateInHybridFlowWithCodeIDToken() throws Exception {
        String nonce = "ckw938gnspa93dj";
        ClientManager.realm(this.adminClient.realm("test")).clientId("test-app").standardFlow(true).implicitFlow(true);
        this.oauth.clientId("test-app");
        this.oauth.responseType("code id_token");
        this.oauth.nonce(nonce);
        this.oauth.doLogin("test-user@localhost", "password");
        EventRepresentation loginEvent = this.events.expectLogin().assertEvent();
        OAuthClient.AuthorizationEndpointResponse authzResponse = new OAuthClient.AuthorizationEndpointResponse(this.oauth, true);
        Assert.assertNotNull((Object)authzResponse.getSessionState());
        List<IDToken> idTokens = this.testAuthzResponseAndRetrieveIDTokens(authzResponse, loginEvent);
        for (IDToken idToken : idTokens) {
            Assert.assertEquals((Object)nonce, (Object)idToken.getNonce());
            Assert.assertEquals((Object)authzResponse.getSessionState(), (Object)idToken.getSessionState());
        }
    }

    protected List<IDToken> testAuthzResponseAndRetrieveIDTokens(OAuthClient.AuthorizationEndpointResponse authzResponse, EventRepresentation loginEvent) {
        Assert.assertEquals((Object)"code id_token", loginEvent.getDetails().get("response_type"));
        Assert.assertNull((Object)authzResponse.getAccessToken());
        String idTokenStr = authzResponse.getIdToken();
        IDToken idToken = this.oauth.verifyIDToken(idTokenStr);
        Assert.assertNull((Object)idToken.getAccessTokenHash());
        Assert.assertNotNull((Object)idToken.getCodeHash());
        Assert.assertEquals((Object)idToken.getCodeHash(), (Object)HashUtils.oidcHash((String)"RS256", (String)authzResponse.getCode()));
        IDToken idToken2 = this.sendTokenRequestAndGetIDToken(loginEvent);
        return Arrays.asList(idToken, idToken2);
    }

    @Test
    public void testIntrospectHoKAccessToken() throws Exception {
        String tokenResponse;
        this.oauth.doLogin("test-user@localhost", "password");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        EventRepresentation loginEvent = this.events.expectLogin().assertEvent();
        OAuthClient.AccessTokenResponse accessTokenResponse = null;
        try (CloseableHttpClient client = MutualTLSUtils.newCloseableHttpClientWithDefaultKeyStoreAndTrustStore();){
            accessTokenResponse = this.oauth.doAccessTokenRequest(code, "password", client);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        try (CloseableHttpClient client = MutualTLSUtils.newCloseableHttpClientWithoutKeyStoreAndTrustStore();){
            tokenResponse = this.oauth.introspectTokenWithClientCredential("confidential-cli", "secret1", "access_token", accessTokenResponse.getAccessToken(), client);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        TokenMetadataRepresentation rep = (TokenMetadataRepresentation)JsonSerialization.readValue((String)tokenResponse, TokenMetadataRepresentation.class);
        JWSInput jws = new JWSInput(accessTokenResponse.getAccessToken());
        AccessToken at = (AccessToken)jws.readJsonContent(AccessToken.class);
        jws = new JWSInput(accessTokenResponse.getRefreshToken());
        RefreshToken rt = (RefreshToken)jws.readJsonContent(RefreshToken.class);
        String certThumprintFromAccessToken = at.getCertConf().getCertThumbprint();
        String certThumprintFromRefreshToken = rt.getCertConf().getCertThumbprint();
        String certThumprintFromTokenIntrospection = rep.getCertConf().getCertThumbprint();
        String certThumprintFromBoundClientCertificate = MutualTLSUtils.getThumbprintFromDefaultClientCert();
        Assert.assertTrue((boolean)rep.isActive());
        Assert.assertEquals((Object)"test-user@localhost", (Object)rep.getUserName());
        Assert.assertEquals((Object)"test-app", (Object)rep.getClientId());
        Assert.assertEquals((Object)loginEvent.getUserId(), (Object)rep.getSubject());
        Assert.assertEquals((Object)certThumprintFromTokenIntrospection, (Object)certThumprintFromBoundClientCertificate);
        Assert.assertEquals((Object)certThumprintFromBoundClientCertificate, (Object)certThumprintFromAccessToken);
        Assert.assertEquals((Object)certThumprintFromAccessToken, (Object)certThumprintFromRefreshToken);
    }

    @Test
    public void serviceAccountWithClientCertificate() throws Exception {
        this.oauth.clientId("service-account-client");
        Supplier previous = this.oauth.getHttpClient();
        try {
            this.oauth.httpClient(MutualTLSUtils::newCloseableHttpClientWithoutKeyStoreAndTrustStore);
            OAuthClient.AccessTokenResponse response = this.oauth.doClientCredentialsGrantAccessTokenRequest("secret1");
            Assert.assertEquals((long)400L, (long)response.getStatusCode());
            Assert.assertEquals((Object)"invalid_request", (Object)response.getError());
            Assert.assertEquals((Object)"Client Certification missing for MTLS HoK Token Binding", (Object)response.getErrorDescription());
            this.oauth.httpClient(MutualTLSUtils::newCloseableHttpClientWithDefaultKeyStoreAndTrustStore);
            response = this.oauth.doClientCredentialsGrantAccessTokenRequest("secret1");
            Assert.assertEquals((long)200L, (long)response.getStatusCode());
            this.verifyHoKTokenCertThumbPrint(response, MutualTLSUtils.getThumbprintFromDefaultClientCert(), false);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        finally {
            this.oauth.httpClient(previous);
        }
    }

    private void verifyHoKTokenDefaultCertThumbPrint(OAuthClient.AccessTokenResponse response) throws Exception {
        this.verifyHoKTokenCertThumbPrint(response, MutualTLSUtils.getThumbprintFromDefaultClientCert(), true);
    }

    private void verifyHoKTokenOtherCertThumbPrint(OAuthClient.AccessTokenResponse response) throws Exception {
        this.verifyHoKTokenCertThumbPrint(response, MutualTLSUtils.getThumbprintFromOtherClientCert(), true);
    }

    private void verifyHoKTokenCertThumbPrint(OAuthClient.AccessTokenResponse response, String certThumbPrint, boolean checkRefreshToken) {
        JWSInput jws = null;
        AccessToken at = null;
        try {
            jws = new JWSInput(response.getAccessToken());
            at = (AccessToken)jws.readJsonContent(AccessToken.class);
        }
        catch (JWSInputException e) {
            Assert.fail((String)e.toString());
        }
        Assert.assertTrue((boolean)MessageDigest.isEqual(certThumbPrint.getBytes(), at.getCertConf().getCertThumbprint().getBytes()));
        if (checkRefreshToken) {
            RefreshToken rt = null;
            try {
                jws = new JWSInput(response.getRefreshToken());
                rt = (RefreshToken)jws.readJsonContent(RefreshToken.class);
            }
            catch (JWSInputException e) {
                Assert.fail((String)e.toString());
            }
            Assert.assertTrue((boolean)MessageDigest.isEqual(certThumbPrint.getBytes(), rt.getCertConf().getCertThumbprint().getBytes()));
        }
    }

    public static class HoKAssertEvents
    extends AssertEvents {
        private final String defaultRedirectUri = "https://localhost:8543/auth/realms/master/app/auth";

        public HoKAssertEvents(AbstractKeycloakTest ctx) {
            super(ctx);
        }

        @Override
        public AssertEvents.ExpectedEvent expectLogin() {
            return this.expect(EventType.LOGIN).detail("code_id", HoKAssertEvents.isCodeId()).detail("redirect_uri", "https://localhost:8543/auth/realms/master/app/auth").detail("consent", "no_consent_required").session(HoKAssertEvents.isUUID());
        }
    }
}

