/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.forms;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.jboss.arquillian.graphene.page.Page;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.common.Profile;
import org.keycloak.events.EventType;
import org.keycloak.models.UserModel;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RequiredActionProviderRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.AbstractTestRealmKeycloakTest;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.arquillian.annotation.EnableFeature;
import org.keycloak.testsuite.forms.RegisterWithUserProfileTest;
import org.keycloak.testsuite.pages.AppPage;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.pages.VerifyProfilePage;
import org.keycloak.testsuite.util.ClientScopeBuilder;
import org.keycloak.testsuite.util.KeycloakModelUtils;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.RealmBuilder;
import org.keycloak.testsuite.util.UserBuilder;
import org.keycloak.userprofile.UserProfileContext;
import org.openqa.selenium.By;

@EnableFeature(value=Profile.Feature.DECLARATIVE_USER_PROFILE)
@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class VerifyProfileTest
extends AbstractTestRealmKeycloakTest {
    public static final String SCOPE_DEPARTMENT = "department";
    public static final String ATTRIBUTE_DEPARTMENT = "department";
    public static final String PERMISSIONS_ALL = "\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}";
    public static final String PERMISSIONS_ADMIN_ONLY = "\"permissions\": {\"view\": [\"admin\"], \"edit\": [\"admin\"]}";
    public static final String PERMISSIONS_ADMIN_EDITABLE = "\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\"]}";
    public static String VALIDATIONS_LENGTH = "\"validations\": {\"length\": { \"min\": 3, \"max\": 255 }}";
    public static final String CONFIGURATION_FOR_USER_EDIT = "{\"attributes\": [{\"name\": \"firstName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"lastName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"department\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}}]}";
    private static String userId;
    private static String user2Id;
    private static String user3Id;
    private static String user4Id;
    private static String user5Id;
    private static String user6Id;
    private static ClientRepresentation client_scope_default;
    private static ClientRepresentation client_scope_optional;
    @Rule
    public AssertEvents events = new AssertEvents(this);
    @Page
    protected AppPage appPage;
    @Page
    protected LoginPage loginPage;
    @Page
    protected VerifyProfilePage verifyProfilePage;
    @ArquillianResource
    protected OAuthClient oauth;

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
        VerifyProfileTest.enableDynamicUserProfile(testRealm);
        UserRepresentation user = UserBuilder.create().id(UUID.randomUUID().toString()).username("login-test").email("login@test.com").enabled(true).password("password").build();
        userId = user.getId();
        UserRepresentation user2 = UserBuilder.create().id(UUID.randomUUID().toString()).username("login-test2").email("login2@test.com").enabled(true).password("password").build();
        user2Id = user2.getId();
        UserRepresentation user3 = UserBuilder.create().id(UUID.randomUUID().toString()).username("login-test3").email("login3@test.com").enabled(true).password("password").lastName("ExistingLast").build();
        user3Id = user3.getId();
        UserRepresentation user4 = UserBuilder.create().id(UUID.randomUUID().toString()).username("login-test4").email("login4@test.com").enabled(true).password("password").lastName("ExistingLast").build();
        user4Id = user4.getId();
        UserRepresentation user5 = UserBuilder.create().id(UUID.randomUUID().toString()).username("login-test5").email("login5@test.com").enabled(true).password("password").firstName("ExistingFirst").lastName("ExistingLast").build();
        user5Id = user5.getId();
        UserRepresentation user6 = UserBuilder.create().id(UUID.randomUUID().toString()).username("login-test6").email("login6@test.com").enabled(true).password("password").firstName("ExistingFirst").lastName("ExistingLast").build();
        user6Id = user6.getId();
        RealmBuilder.edit(testRealm).user(user).user(user2).user(user3).user(user4).user(user5).user(user6);
        RequiredActionProviderRepresentation action = new RequiredActionProviderRepresentation();
        action.setAlias(UserModel.RequiredAction.VERIFY_PROFILE.name());
        action.setProviderId(UserModel.RequiredAction.VERIFY_PROFILE.name());
        action.setEnabled(true);
        action.setDefaultAction(false);
        action.setPriority(10);
        ArrayList<RequiredActionProviderRepresentation> actions = new ArrayList<RequiredActionProviderRepresentation>();
        actions.add(action);
        testRealm.setRequiredActions(actions);
        testRealm.setClientScopes(new ArrayList());
        testRealm.getClientScopes().add(ClientScopeBuilder.create().name("department").protocol("openid-connect").build());
        testRealm.getClientScopes().add(ClientScopeBuilder.create().name("profile").protocol("openid-connect").build());
        client_scope_default = KeycloakModelUtils.createClient(testRealm, "client-a");
        client_scope_default.setDefaultClientScopes(Collections.singletonList("department"));
        client_scope_default.setRedirectUris(Collections.singletonList("*"));
        client_scope_optional = KeycloakModelUtils.createClient(testRealm, "client-b");
        client_scope_optional.setOptionalClientScopes(Collections.singletonList("department"));
        client_scope_optional.setRedirectUris(Collections.singletonList("*"));
    }

    @Test
    public void testDisplayName() {
        this.setUserProfileConfiguration(CONFIGURATION_FOR_USER_EDIT);
        this.updateUser(user5Id, "ExistingFirst", "ExistingLast", null);
        this.setUserProfileConfiguration("{\"attributes\": [{\"name\": \"firstName\",\"displayName\":\"${firstName}\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\": {}},{\"name\": \"lastName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"department\", \"displayName\" : \"Department\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\":{}}]}");
        this.loginPage.open();
        this.loginPage.login("login-test5", "password");
        this.verifyProfilePage.assertCurrent();
        Assert.assertEquals((Object)"First name", (Object)this.verifyProfilePage.getLabelForField("firstName"));
        Assert.assertEquals((Object)"lastName", (Object)this.verifyProfilePage.getLabelForField("lastName"));
        Assert.assertEquals((Object)"Department", (Object)this.verifyProfilePage.getLabelForField("department"));
    }

    @Test
    public void testAttributeGrouping() {
        this.setUserProfileConfiguration(CONFIGURATION_FOR_USER_EDIT);
        this.updateUser(user5Id, "ExistingFirst", "ExistingLast", null);
        this.setUserProfileConfiguration("{\"attributes\": [{\"name\": \"lastName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"username\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"firstName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\": {}},{\"name\": \"department\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\":{}, \"group\": \"company\"},{\"name\": \"email\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"group\": \"contact\"}], \"groups\": [{\"name\": \"company\", \"displayDescription\": \"Company field desc\" },{\"name\": \"contact\" }]}");
        this.loginPage.open();
        this.loginPage.login("login-test5", "password");
        this.verifyProfilePage.assertCurrent();
        String htmlFormId = "kc-update-profile-form";
        Assert.assertTrue((boolean)this.driver.findElement(By.cssSelector((String)("form#" + htmlFormId + " > div:nth-child(1) > div:nth-child(2) > input#lastName"))).isDisplayed());
        Assert.assertTrue((boolean)this.driver.findElement(By.cssSelector((String)("form#" + htmlFormId + " > div:nth-child(2) > div:nth-child(2) > input#username"))).isDisplayed());
        Assert.assertTrue((boolean)this.driver.findElement(By.cssSelector((String)("form#" + htmlFormId + " > div:nth-child(3) > div:nth-child(2) > input#firstName"))).isDisplayed());
        Assert.assertTrue((boolean)this.driver.findElement(By.cssSelector((String)("form#" + htmlFormId + " > div:nth-child(4) > div:nth-child(1) > label#header-company"))).isDisplayed());
        Assert.assertTrue((boolean)this.driver.findElement(By.cssSelector((String)("form#" + htmlFormId + " > div:nth-child(4) > div:nth-child(2) > label#description-company"))).isDisplayed());
        Assert.assertTrue((boolean)this.driver.findElement(By.cssSelector((String)("form#" + htmlFormId + " > div:nth-child(5) > div:nth-child(2) > input#department"))).isDisplayed());
        Assert.assertTrue((boolean)this.driver.findElement(By.cssSelector((String)("form#" + htmlFormId + " > div:nth-child(6) > div:nth-child(1) > label#header-contact"))).isDisplayed());
        Assert.assertTrue((boolean)this.driver.findElement(By.cssSelector((String)("form#" + htmlFormId + " > div:nth-child(7) > div:nth-child(2) > input#email"))).isDisplayed());
    }

    @Test
    public void testAttributeGuiOrder() {
        this.setUserProfileConfiguration(CONFIGURATION_FOR_USER_EDIT);
        this.updateUser(user5Id, "ExistingFirst", "ExistingLast", null);
        this.setUserProfileConfiguration("{\"attributes\": [{\"name\": \"lastName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"department\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\":{}},{\"name\": \"username\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"firstName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\": {}},{\"name\": \"email\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}}]}");
        this.loginPage.open();
        this.loginPage.login("login-test5", "password");
        this.verifyProfilePage.assertCurrent();
        Assert.assertTrue((boolean)this.driver.findElement(By.cssSelector((String)"form#kc-update-profile-form > div:nth-child(1) > div:nth-child(2) > input#lastName")).isDisplayed());
        Assert.assertTrue((boolean)this.driver.findElement(By.cssSelector((String)"form#kc-update-profile-form > div:nth-child(2) > div:nth-child(2) > input#department")).isDisplayed());
        Assert.assertTrue((boolean)this.driver.findElement(By.cssSelector((String)"form#kc-update-profile-form > div:nth-child(3) > div:nth-child(2) > input#username")).isDisplayed());
        Assert.assertTrue((boolean)this.driver.findElement(By.cssSelector((String)"form#kc-update-profile-form > div:nth-child(4) > div:nth-child(2) > input#firstName")).isDisplayed());
        Assert.assertTrue((boolean)this.driver.findElement(By.cssSelector((String)"form#kc-update-profile-form > div:nth-child(5) > div:nth-child(2) > input#email")).isDisplayed());
    }

    @Test
    public void testAttributeInputTypes() {
        this.setUserProfileConfiguration(CONFIGURATION_FOR_USER_EDIT);
        this.updateUser(user5Id, "ExistingFirst", "ExistingLast", null);
        this.setUserProfileConfiguration("{\"attributes\": [{\"name\": \"department\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\":{}},{\"name\": \"defaultType\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"placeholderAttribute\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"annotations\":{\"inputType\":\"text\",\"inputTypePlaceholder\":\"Example.\"}},{\"name\": \"helperTexts\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"annotations\":{\"inputType\":\"text\",\"inputHelperTextBefore\":\"Example <b>bold text</b> before.\",\"inputHelperTextAfter\":\"Example <i>i text</i> after.\"}},{\"name\": \"textWithBasicAttributes\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"annotations\":{\"inputType\":\"text\",\"inputTypeSize\":\"35\",\"inputTypeMinlength\":\"1\",\"inputTypeMaxlength\":\"10\",\"inputTypePattern\":\".*\"}},{\"name\": \"html5NumberWithAttributes\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"annotations\":{\"inputType\":\"html5-number\",\"inputTypeMin\":\"10\",\"inputTypeMax\":\"20\",\"inputTypeStep\":1}},{\"name\": \"textareaWithAttributes\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"annotations\":{\"inputType\":\"textarea\",\"inputTypeCols\":\"35\",\"inputTypeRows\":\"7\",\"inputTypeMaxlength\":\"10\"}},{\"name\": \"selectWithoutOptions\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"annotations\":{\"inputType\":\"select\",\"inputTypeSize\":\"5\"}},{\"name\": \"selectWithOptionsWithoutLabels\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"validations\":{\"options\":{\"options\":[ \"opt1\",\"opt2\"]}}, \"annotations\":{\"inputType\":\"select\"}},{\"name\": \"multiselectWithOptionsAndSimpleI18nLabels\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"validations\":{\"options\":{ \"options\":[\"totp\",\"opt2\"]}}, \"annotations\":{\"inputType\":\"multiselect\",\"inputOptionLabelsI18nPrefix\": \"loginTotp\"}},{\"name\": \"multiselectWithOptionsAndLabels\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"validations\":{\"options\":{ \"options\":[\"opt1\",\"opt2\",\"opt3\"]}}, \"annotations\":{\"inputType\":\"multiselect\",\"inputOptionLabels\":{\"opt1\": \"Option 1\",\"opt2\":\"${username}\"}}},{\"name\": \"selectWithOptionsFromCustomValidatorAndLabels\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"validations\":{\"dummyOptions\":{\"options\" : [\"vopt1\",\"vopt2\",\"vopt3\"]}} ,\"annotations\":{\"inputType\":\"select\",\"inputOptionsFromValidation\":\"dummyOptions\",\"inputOptionLabels\":{\"vopt1\": \"Option 1\",\"vopt2\":\"${username}\"}}},{\"name\": \"selectRadiobuttons\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"validations\" : {\"options\" : {\"options\":[\"opt1\",\"opt2\",\"opt3\"]}}, \"annotations\":{\"inputType\":\"select-radiobuttons\",\"inputOptionLabels\":{\"opt1\": \"Option 1\",\"opt2\":\"${username}\"}}},{\"name\": \"selectRadiobuttonsWithOptionsFromCustomValidatorAndLabels\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"validations\" : {\"dummyOptions\" : {\"options\" : [\"vopt1\",\"vopt2\",\"vopt3\"]}} ,\"annotations\":{\"inputType\":\"select-radiobuttons\",\"inputOptionsFromValidation\":\"dummyOptions\",\"inputOptionLabels\":{\"vopt1\": \"Option 1\",\"vopt2\":\"${username}\"}}},{\"name\": \"multiselectCheckboxes\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"validations\": {\"options\":{\"options\":[\"opt1\",\"opt2\",\"opt3\"]}}, \"annotations\":{\"inputType\":\"multiselect-checkboxes\",\"inputOptionLabels\":{\"opt1\": \"Option 1\",\"opt2\":\"${username}\"}}}]}");
        this.loginPage.open();
        this.loginPage.login("login-test5", "password");
        this.verifyProfilePage.assertCurrent();
        RegisterWithUserProfileTest.assertFieldTypes(this.driver);
    }

    @Test
    public void testEvents() {
        this.setUserProfileConfiguration(CONFIGURATION_FOR_USER_EDIT);
        this.updateUser(user5Id, "ExistingFirst", "ExistingLast", null);
        this.setUserProfileConfiguration("{\"attributes\": [{\"name\": \"firstName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\": {}},{\"name\": \"lastName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"department\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\":{}}]}");
        this.loginPage.open();
        this.loginPage.login("login-test5", "password");
        this.verifyProfilePage.assertCurrent();
        this.events.expectRequiredAction(EventType.VERIFY_PROFILE).user(user5Id).detail("fields_to_update", "department").assertEvent();
        this.verifyProfilePage.update("First", "Last", "Department");
        this.events.expectRequiredAction(EventType.UPDATE_PROFILE).user(user5Id).detail("context", UserProfileContext.UPDATE_PROFILE.name()).detail("previous_first_name", "ExistingFirst").detail("updated_first_name", "First").detail("previous_last_name", "ExistingLast").detail("updated_last_name", "Last").detail("updated_department", "Department").assertEvent();
    }

    @Test
    public void testDefaultProfile() {
        this.setUserProfileConfiguration(null);
        this.loginPage.open();
        this.loginPage.login("login-test", "password");
        this.verifyProfilePage.assertCurrent();
        Assert.assertFalse((boolean)this.verifyProfilePage.isDepartmentPresent());
        this.verifyProfilePage.update("First", " ");
        this.verifyProfilePage.assertCurrent();
        Assert.assertFalse((boolean)this.verifyProfilePage.isDepartmentPresent());
        this.verifyProfilePage.update("First", "Last");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
        UserRepresentation user = this.getUser(userId);
        Assert.assertEquals((Object)"First", (Object)user.getFirstName());
        Assert.assertEquals((Object)"Last", (Object)user.getLastName());
    }

    @Test
    public void testUsernameOnlyIfEditAllowed() {
        RealmRepresentation realm = this.testRealm().toRepresentation();
        boolean r = realm.isEditUsernameAllowed();
        try {
            this.setUserProfileConfiguration(null);
            realm.setEditUsernameAllowed(Boolean.valueOf(false));
            this.testRealm().update(realm);
            this.loginPage.open();
            this.loginPage.login("login-test", "password");
            Assert.assertFalse((boolean)this.verifyProfilePage.isUsernamePresent());
            realm.setEditUsernameAllowed(Boolean.valueOf(true));
            this.testRealm().update(realm);
            this.driver.navigate().refresh();
            Assert.assertTrue((boolean)this.verifyProfilePage.isUsernamePresent());
        }
        finally {
            realm.setEditUsernameAllowed(Boolean.valueOf(r));
            this.testRealm().update(realm);
        }
    }

    @Test
    public void testOptionalAttribute() {
        this.setUserProfileConfiguration("{\"attributes\": [{\"name\": \"firstName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\": {}},{\"name\": \"lastName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}}]}");
        this.loginPage.open();
        this.loginPage.login("login-test2", "password");
        this.verifyProfilePage.assertCurrent();
        this.verifyProfilePage.update("First", "");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
        UserRepresentation user = this.getUser(user2Id);
        Assert.assertEquals((Object)"First", (Object)user.getFirstName());
        MatcherAssert.assertThat((Object)StringUtils.isEmpty((CharSequence)user.getLastName()), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testCustomValidationLastName() {
        this.setUserProfileConfiguration(CONFIGURATION_FOR_USER_EDIT);
        this.updateUser(user5Id, "ExistingFirst", "La", "Department");
        this.setUserProfileConfiguration("{\"attributes\": [{\"name\": \"firstName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\": {}},{\"name\": \"lastName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}," + VALIDATIONS_LENGTH + "},{\"name\": \"department\"," + PERMISSIONS_ADMIN_ONLY + "}]}");
        this.loginPage.open();
        this.loginPage.login("login-test5", "password");
        this.verifyProfilePage.assertCurrent();
        this.verifyProfilePage.update("First", "L");
        this.verifyProfilePage.assertCurrent();
        this.verifyProfilePage.update("First", "Last");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
        UserRepresentation user = this.getUser(user5Id);
        Assert.assertEquals((Object)"First", (Object)user.getFirstName());
        Assert.assertEquals((Object)"Last", (Object)user.getLastName());
        Assert.assertEquals((Object)"Department", (Object)user.firstAttribute("department"));
    }

    @Test
    public void testNoActionIfNoValidationError() {
        this.setUserProfileConfiguration(CONFIGURATION_FOR_USER_EDIT);
        this.updateUser(user5Id, "ExistingFirst", "ExistingLast", "Department");
        this.setUserProfileConfiguration("{\"attributes\": [{\"name\": \"firstName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\": {}},{\"name\": \"lastName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}," + VALIDATIONS_LENGTH + "}]}");
        this.loginPage.open();
        this.loginPage.login("login-test5", "password");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
    }

    @Test
    public void testDoNotValidateUsernameWhenRegistrationAsEmailEnabled() {
        RealmResource realmResource = this.testRealm();
        RealmRepresentation realm = realmResource.toRepresentation();
        try {
            this.setUserProfileConfiguration(CONFIGURATION_FOR_USER_EDIT);
            this.updateUser(user6Id, "ExistingFirst", "ExistingLast", "Department");
            realm.setRegistrationEmailAsUsername(Boolean.valueOf(true));
            realmResource.update(realm);
            this.setUserProfileConfiguration("{\"attributes\": [{\"name\": \"firstName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\": {}},{\"name\": \"lastName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}," + VALIDATIONS_LENGTH + "}]}");
            this.loginPage.open();
            this.loginPage.login("login6@test.com", "password");
            Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
            Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
        }
        finally {
            realm.setRegistrationEmailAsUsername(Boolean.valueOf(false));
            realmResource.update(realm);
        }
    }

    @Test
    public void testRequiredReadOnlyAttribute() {
        this.setUserProfileConfiguration("{\"attributes\": [{\"name\": \"firstName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\": {}},{\"name\": \"lastName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"department\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\"]}, \"required\":{}}]}");
        this.loginPage.open();
        this.loginPage.login("login-test3", "password");
        this.verifyProfilePage.assertCurrent();
        Assert.assertEquals((Object)"ExistingLast", (Object)this.verifyProfilePage.getLastName());
        Assert.assertFalse((boolean)this.verifyProfilePage.isDepartmentEnabled());
        this.verifyProfilePage.update("First", "Last");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
        UserRepresentation user = this.getUser(user3Id);
        Assert.assertEquals((Object)"First", (Object)user.getFirstName());
        Assert.assertEquals((Object)"Last", (Object)user.getLastName());
    }

    @Test
    public void testAttributeNotVisible() {
        this.setUserProfileConfiguration("{\"attributes\": [{\"name\": \"firstName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\": {}},{\"name\": \"lastName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"department\",\"permissions\": {\"view\": [\"admin\"], \"edit\": [\"admin\"]}, \"required\":{}}]}");
        this.loginPage.open();
        this.loginPage.login("login-test4", "password");
        this.verifyProfilePage.assertCurrent();
        Assert.assertEquals((Object)"ExistingLast", (Object)this.verifyProfilePage.getLastName());
        Assert.assertFalse((String)"'department' field is visible", (boolean)this.verifyProfilePage.isDepartmentPresent());
        this.verifyProfilePage.update("First", "Last");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
        UserRepresentation user = this.getUser(user4Id);
        Assert.assertEquals((Object)"First", (Object)user.getFirstName());
        Assert.assertEquals((Object)"Last", (Object)user.getLastName());
    }

    @Test
    public void testRequiredAttribute() {
        this.setUserProfileConfiguration(CONFIGURATION_FOR_USER_EDIT);
        this.updateUser(user5Id, "ExistingFirst", "ExistingLast", null);
        this.setUserProfileConfiguration("{\"attributes\": [{\"name\": \"firstName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\": {}},{\"name\": \"lastName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"department\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\":{}}]}");
        this.loginPage.open();
        this.loginPage.login("login-test5", "password");
        this.verifyProfilePage.assertCurrent();
        this.verifyProfilePage.update("FirstCC", "LastCC", " ");
        this.verifyProfilePage.assertCurrent();
        this.verifyProfilePage.update("FirstCC", "LastCC", "DepartmentCC");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
        UserRepresentation user = this.getUser(user5Id);
        Assert.assertEquals((Object)"FirstCC", (Object)user.getFirstName());
        Assert.assertEquals((Object)"LastCC", (Object)user.getLastName());
        Assert.assertEquals((Object)"DepartmentCC", (Object)user.firstAttribute("department"));
    }

    @Test
    public void testRequiredOnlyIfUser() {
        this.setUserProfileConfiguration("{\"attributes\": [{\"name\": \"firstName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\": {}},{\"name\": \"lastName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"department\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\":{\"roles\":[\"user\"]}}]}");
        this.updateUser(user5Id, "ExistingFirst", "ExistingLast", null);
        this.loginPage.open();
        this.loginPage.login("login-test5", "password");
        this.verifyProfilePage.assertCurrent();
        this.verifyProfilePage.update("FirstCC", "LastCC", " ");
        this.verifyProfilePage.assertCurrent();
        this.verifyProfilePage.update("FirstCC", "LastCC", "DepartmentCC");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
        UserRepresentation user = this.getUser(user5Id);
        Assert.assertEquals((Object)"FirstCC", (Object)user.getFirstName());
        Assert.assertEquals((Object)"LastCC", (Object)user.getLastName());
        Assert.assertEquals((Object)"DepartmentCC", (Object)user.firstAttribute("department"));
    }

    @Test
    public void testAttributeNotRequiredWhenMissingScope() {
        this.setUserProfileConfiguration("{\"attributes\": [{\"name\": \"firstName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\": {}},{\"name\": \"lastName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"department\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\":{\"scopes\":[\"profile\"]}}]}");
        this.updateUser(user5Id, "ExistingFirst", "ExistingLast", null);
        this.oauth.clientId(client_scope_optional.getClientId()).openLoginForm();
        this.loginPage.login("login-test5", "password");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
        UserRepresentation user = this.getUser(user5Id);
        Assert.assertEquals((Object)"ExistingFirst", (Object)user.getFirstName());
        Assert.assertEquals((Object)"ExistingLast", (Object)user.getLastName());
    }

    @Test
    public void testAttributeRequiredForScope() {
        this.setUserProfileConfiguration("{\"attributes\": [{\"name\": \"firstName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\": {}},{\"name\": \"lastName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"department\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\":{\"scopes\":[\"department\"]}}]}");
        this.updateUser(user5Id, "ExistingFirst", "ExistingLast", null);
        this.oauth.scope("department").clientId(client_scope_optional.getClientId()).openLoginForm();
        this.loginPage.assertCurrent();
        this.loginPage.login("login-test5", "password");
        this.verifyProfilePage.assertCurrent();
        this.verifyProfilePage.update("FirstAA", "LastAA", "DepartmentAA");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
        UserRepresentation user = this.getUser(user5Id);
        Assert.assertEquals((Object)"FirstAA", (Object)user.getFirstName());
        Assert.assertEquals((Object)"LastAA", (Object)user.getLastName());
        Assert.assertEquals((Object)"DepartmentAA", (Object)user.firstAttribute("department"));
    }

    @Test
    public void testAttributeRequiredForDefaultScope() {
        this.setUserProfileConfiguration("{\"attributes\": [{\"name\": \"firstName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\": {}},{\"name\": \"lastName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"department\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\":{\"scopes\":[\"department\"]}}]}");
        this.updateUser(user5Id, "ExistingFirst", "ExistingLast", null);
        this.oauth.clientId(client_scope_default.getClientId()).openLoginForm();
        this.loginPage.assertCurrent();
        this.loginPage.login("login-test5", "password");
        this.verifyProfilePage.assertCurrent();
        this.verifyProfilePage.update("FirstBB", "LastBB", " ");
        this.verifyProfilePage.assertCurrent();
        this.verifyProfilePage.update("FirstBB", "LastBB", "DepartmentBB");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
        UserRepresentation user = this.getUser(user5Id);
        Assert.assertEquals((Object)"FirstBB", (Object)user.getFirstName());
        Assert.assertEquals((Object)"LastBB", (Object)user.getLastName());
        Assert.assertEquals((Object)"DepartmentBB", (Object)user.firstAttribute("department"));
    }

    @Test
    public void testNoActionIfValidForScope() {
        this.setUserProfileConfiguration("{\"attributes\": [{\"name\": \"firstName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\": {}},{\"name\": \"lastName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"department\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\":{\"scopes\":[\"department\"]}}]}");
        this.updateUser(user5Id, "ExistingFirst", "ExistingLast", "ExistingDepartment");
        this.oauth.clientId(client_scope_default.getClientId()).openLoginForm();
        this.loginPage.assertCurrent();
        this.loginPage.login("login-test5", "password");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
        UserRepresentation user = this.getUser(user5Id);
        Assert.assertEquals((Object)"ExistingFirst", (Object)user.getFirstName());
        Assert.assertEquals((Object)"ExistingLast", (Object)user.getLastName());
        Assert.assertEquals((Object)"ExistingDepartment", (Object)user.firstAttribute("department"));
    }

    @Test
    public void testAttributeRequiredButNotSelectedByScopeDoesntForceVerificationScreen() {
        this.setUserProfileConfiguration(CONFIGURATION_FOR_USER_EDIT);
        this.updateUser(user5Id, "ExistingFirst", "ExistingLast", null);
        this.setUserProfileConfiguration("{\"attributes\": [{\"name\": \"firstName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\": {}},{\"name\": \"lastName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"department\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\":{}, \"selector\":{\"scopes\":[\"department\"]}}]}");
        this.oauth.clientId(client_scope_optional.getClientId()).openLoginForm();
        this.loginPage.assertCurrent();
        this.loginPage.login("login-test5", "password");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
    }

    @Test
    public void testAttributeRequiredAndSelectedByScope() {
        this.setUserProfileConfiguration(CONFIGURATION_FOR_USER_EDIT);
        this.updateUser(user5Id, "ExistingFirst", "ExistingLast", null);
        this.setUserProfileConfiguration("{\"attributes\": [{\"name\": \"firstName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\": {}},{\"name\": \"lastName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"department\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\":{}, \"selector\":{\"scopes\":[\"department\"]}}]}");
        this.oauth.scope("department").clientId(client_scope_optional.getClientId()).openLoginForm();
        this.loginPage.assertCurrent();
        this.loginPage.login("login-test5", "password");
        this.verifyProfilePage.assertCurrent();
        this.verifyProfilePage.update("FirstAA", "LastAA", "DepartmentAA");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
        UserRepresentation user = this.getUser(user5Id);
        Assert.assertEquals((Object)"FirstAA", (Object)user.getFirstName());
        Assert.assertEquals((Object)"LastAA", (Object)user.getLastName());
        Assert.assertEquals((Object)"DepartmentAA", (Object)user.firstAttribute("department"));
    }

    @Test
    public void testAttributeNotRequiredAndSelectedByScopeCanBeUpdatedFromVerificationScreenForcedByAnotherAttribute() {
        this.setUserProfileConfiguration(CONFIGURATION_FOR_USER_EDIT);
        this.updateUser(user5Id, "ExistingFirst", null, null);
        this.setUserProfileConfiguration("{\"attributes\": [{\"name\": \"firstName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\": {}},{\"name\": \"lastName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\": {}},{\"name\": \"department\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"selector\":{\"scopes\":[\"department\"]}}]}");
        this.oauth.scope("department").clientId(client_scope_optional.getClientId()).openLoginForm();
        this.loginPage.assertCurrent();
        this.loginPage.login("login-test5", "password");
        this.verifyProfilePage.assertCurrent();
        Assert.assertTrue((boolean)this.verifyProfilePage.isDepartmentPresent());
        this.verifyProfilePage.update("FirstAA", "LastAA", "Department AA");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
        UserRepresentation user = this.getUser(user5Id);
        Assert.assertEquals((Object)"FirstAA", (Object)user.getFirstName());
        Assert.assertEquals((Object)"LastAA", (Object)user.getLastName());
        Assert.assertEquals((Object)"Department AA", (Object)user.firstAttribute("department"));
    }

    @Test
    public void testAttributeRequiredButNotSelectedByScopeIsNotRenderedOnVerificationScreenForcedByAnotherAttribute() {
        this.setUserProfileConfiguration(CONFIGURATION_FOR_USER_EDIT);
        this.updateUser(user5Id, "ExistingFirst", null, null);
        this.setUserProfileConfiguration("{\"attributes\": [{\"name\": \"firstName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\": {}},{\"name\": \"lastName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\": {}},{\"name\": \"department\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\":{}, \"selector\":{\"scopes\":[\"department\"]}}]}");
        this.oauth.clientId(client_scope_optional.getClientId()).openLoginForm();
        this.loginPage.assertCurrent();
        this.loginPage.login("login-test5", "password");
        this.verifyProfilePage.assertCurrent();
        Assert.assertFalse((boolean)this.verifyProfilePage.isDepartmentPresent());
        this.verifyProfilePage.update("FirstAA", "LastAA");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
        UserRepresentation user = this.getUser(user5Id);
        Assert.assertEquals((Object)"FirstAA", (Object)user.getFirstName());
        Assert.assertEquals((Object)"LastAA", (Object)user.getLastName());
        Assert.assertEquals(null, (Object)user.firstAttribute("department"));
    }

    @Test
    public void testCustomValidationInCustomAttribute() {
        this.setUserProfileConfiguration(CONFIGURATION_FOR_USER_EDIT);
        this.updateUser(user5Id, "ExistingFirst", "ExistingLast", "D");
        this.setUserProfileConfiguration("{\"attributes\": [{\"name\": \"firstName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\": {}},{\"name\": \"lastName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"department\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, " + VALIDATIONS_LENGTH + "}]}");
        this.loginPage.open();
        this.loginPage.login("login-test5", "password");
        this.verifyProfilePage.assertCurrent();
        this.verifyProfilePage.update("FirstCC", "LastCC", "De");
        this.verifyProfilePage.assertCurrent();
        this.verifyProfilePage.update("FirstCC", "LastCC", "DepartmentCC");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
        UserRepresentation user = this.getUser(user5Id);
        Assert.assertEquals((Object)"FirstCC", (Object)user.getFirstName());
        Assert.assertEquals((Object)"LastCC", (Object)user.getLastName());
        Assert.assertEquals((Object)"DepartmentCC", (Object)user.firstAttribute("department"));
    }

    @Test
    public void testEmailChangeSetsEmailVerified() {
        this.setUserProfileConfiguration(CONFIGURATION_FOR_USER_EDIT);
        this.updateUser(user5Id, true, "", "ExistingLast");
        this.setUserProfileConfiguration("{\"attributes\": [{\"name\": \"firstName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\": {}},{\"name\": \"lastName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}}]}");
        this.loginPage.open();
        this.loginPage.login("login-test5", "password");
        this.verifyProfilePage.assertCurrent();
        this.verifyProfilePage.updateEmail("newemail@test.org", "FirstCC", "LastCC");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
        UserRepresentation user = this.getUser(user5Id);
        Assert.assertEquals((Object)"newemail@test.org", (Object)user.getEmail());
        Assert.assertEquals((Object)false, (Object)user.isEmailVerified());
    }

    @Test
    public void testNoActionIfSuccessfulValidationForCustomAttribute() {
        this.setUserProfileConfiguration(CONFIGURATION_FOR_USER_EDIT);
        this.updateUser(user5Id, "ExistingFirst", "ExistingLast", "Department");
        this.setUserProfileConfiguration("{\"attributes\": [{\"name\": \"firstName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\": {}},{\"name\": \"lastName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"department\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, " + VALIDATIONS_LENGTH + "}]}");
        this.loginPage.open();
        this.loginPage.login("login-test5", "password");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
    }

    protected UserRepresentation getUser(String userId) {
        return VerifyProfileTest.getUser(this.testRealm(), userId);
    }

    protected void updateUser(String userId, String firstName, String lastName, String department) {
        VerifyProfileTest.updateUser(this.testRealm(), userId, firstName, lastName, department);
    }

    protected void updateUser(String userId, boolean emailVerified, String firstName, String lastName) {
        UserRepresentation ur = VerifyProfileTest.getUser(this.testRealm(), userId);
        ur.setFirstName(firstName);
        ur.setLastName(lastName);
        ur.setEmailVerified(Boolean.valueOf(emailVerified));
        this.testRealm().users().get(userId).update(ur);
    }

    protected void setUserProfileConfiguration(String configuration) {
        VerifyProfileTest.setUserProfileConfiguration(this.testRealm(), configuration);
    }

    public static void enableDynamicUserProfile(RealmRepresentation testRealm) {
        if (testRealm.getAttributes() == null) {
            testRealm.setAttributes(new HashMap());
        }
        testRealm.getAttributes().put("userProfileEnabled", Boolean.TRUE.toString());
    }

    public static void disableDynamicUserProfile(RealmResource realm) {
        RealmRepresentation realmRep = realm.toRepresentation();
        if (realmRep.getAttributes() == null) {
            realmRep.setAttributes(new HashMap());
        }
        realmRep.getAttributes().put("userProfileEnabled", Boolean.FALSE.toString());
        realm.update(realmRep);
    }

    public static void setUserProfileConfiguration(RealmResource testRealm, String configuration) {
        try (Response r = testRealm.users().userProfile().update(configuration);){
            if (r.getStatus() != 200) {
                Assert.fail((String)("UserProfile Configuration not set due to error: " + (String)r.readEntity(String.class)));
            }
        }
    }

    public static UserRepresentation getUser(RealmResource testRealm, String userId) {
        return testRealm.users().get(userId).toRepresentation();
    }

    public static UserRepresentation getUserByUsername(RealmResource testRealm, String username) {
        List users = testRealm.users().search(username);
        if (users != null && !users.isEmpty()) {
            return (UserRepresentation)users.get(0);
        }
        return null;
    }

    public static void updateUser(RealmResource testRealm, String userId, String firstName, String lastName, String department) {
        UserRepresentation ur = VerifyProfileTest.getUser(testRealm, userId);
        ur.setFirstName(firstName);
        ur.setLastName(lastName);
        ur.singleAttribute("department", department);
        testRealm.users().get(userId).update(ur);
    }
}

