/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.forms;

import org.jboss.arquillian.graphene.page.Page;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.AbstractTestRealmKeycloakTest;
import org.keycloak.testsuite.pages.LoginPage;

public class ThemeSelectorTest
extends AbstractTestRealmKeycloakTest {
    @Page
    protected LoginPage loginPage;

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
    }

    @Test
    public void clientOverride() {
        this.loginPage.open();
        Assert.assertEquals((Object)"keycloak", (Object)this.detectTheme());
        ClientRepresentation rep = (ClientRepresentation)this.testRealm().clients().findByClientId("test-app").get(0);
        try {
            rep.getAttributes().put("login_theme", "base");
            this.testRealm().clients().get(rep.getId()).update(rep);
            this.loginPage.open();
            Assert.assertEquals((Object)"base", (Object)this.detectTheme());
            rep.getAttributes().put("login_theme", "unavailable-theme");
            this.testRealm().clients().get(rep.getId()).update(rep);
            this.loginPage.open();
            Assert.assertEquals((Object)"keycloak", (Object)this.detectTheme());
        }
        finally {
            rep.getAttributes().put("login_theme", "");
            this.testRealm().clients().get(rep.getId()).update(rep);
        }
    }

    private String detectTheme() {
        if (this.driver.getPageSource().contains("/login/keycloak/css/login.css") || this.driver.getPageSource().contains("/login/rh-sso/css/login.css")) {
            return "keycloak";
        }
        return "base";
    }
}

