/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.forms;

import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.common.Profile;
import org.keycloak.events.EventType;
import org.keycloak.models.UserModel;
import org.keycloak.representations.IDToken;
import org.keycloak.representations.idm.EventRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.AbstractTestRealmKeycloakTest;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.arquillian.annotation.DisableFeature;
import org.keycloak.testsuite.drone.Different;
import org.keycloak.testsuite.pages.AccountUpdateProfilePage;
import org.keycloak.testsuite.pages.AppPage;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.pages.LoginPasswordUpdatePage;
import org.keycloak.testsuite.util.OAuthClient;
import org.openqa.selenium.WebDriver;

public class SSOTest
extends AbstractTestRealmKeycloakTest {
    @Drone
    @Different
    protected WebDriver driver2;
    @Page
    protected AppPage appPage;
    @Page
    protected LoginPage loginPage;
    @Page
    protected AccountUpdateProfilePage profilePage;
    @Page
    protected LoginPasswordUpdatePage updatePasswordPage;
    @Rule
    public AssertEvents events = new AssertEvents(this);

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
    }

    @Test
    @DisableFeature(value=Profile.Feature.ACCOUNT2, skipRestart=true)
    public void loginSuccess() {
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
        EventRepresentation loginEvent = this.events.expectLogin().assertEvent();
        String sessionId = loginEvent.getSessionId();
        IDToken idToken = this.sendTokenRequestAndGetIDToken(loginEvent);
        Assert.assertEquals((Object)"1", (Object)idToken.getAcr());
        Long authTime = idToken.getAuth_time();
        this.appPage.open();
        this.oauth.openLoginForm();
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        loginEvent = this.events.expectLogin().removeDetail("username").client("test-app").assertEvent();
        String sessionId2 = loginEvent.getSessionId();
        Assert.assertEquals((Object)sessionId, (Object)sessionId2);
        idToken = this.sendTokenRequestAndGetIDToken(loginEvent);
        Assert.assertEquals((Object)"0", (Object)idToken.getAcr());
        Assert.assertEquals((Object)authTime, (Object)idToken.getAuth_time());
        this.profilePage.open();
        Assert.assertTrue((boolean)this.profilePage.isCurrent());
        this.testingClient.testing().removeUserSession("test", sessionId);
        this.oauth.doLogin("test-user@localhost", "password");
        String sessionId4 = this.events.expectLogin().assertEvent().getSessionId();
        Assert.assertNotEquals((Object)sessionId, (Object)sessionId4);
        this.events.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void multipleSessions() {
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
        EventRepresentation login1 = this.events.expectLogin().assertEvent();
        try {
            OAuthClient oauth2 = new OAuthClient();
            oauth2.init(this.driver2);
            oauth2.doLogin("test-user@localhost", "password");
            EventRepresentation login2 = this.events.expectLogin().assertEvent();
            Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)AppPage.RequestType.valueOf((String)this.driver2.getTitle()));
            Assert.assertNotNull(oauth2.getCurrentQuery().get("code"));
            Assert.assertNotEquals((Object)login1.getSessionId(), (Object)login2.getSessionId());
            this.oauth.openLogout();
            this.events.expectLogout(login1.getSessionId()).assertEvent();
            this.oauth.openLoginForm();
            Assert.assertTrue((boolean)this.loginPage.isCurrent());
            oauth2.openLoginForm();
            this.events.expectLogin().session(login2.getSessionId()).removeDetail("username").assertEvent();
            Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)AppPage.RequestType.valueOf((String)this.driver2.getTitle()));
            Assert.assertNotNull(oauth2.getCurrentQuery().get("code"));
            oauth2.openLogout();
            this.events.expectLogout(login2.getSessionId()).assertEvent();
            oauth2.openLoginForm();
            Assert.assertTrue((boolean)this.driver2.getTitle().equals("Sign in to test"));
        }
        finally {
            this.driver2.close();
        }
    }

    @Test
    public void loginWithRequiredActionAddedInTheMeantime() {
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
        EventRepresentation loginEvent = this.events.expectLogin().assertEvent();
        String sessionId = loginEvent.getSessionId();
        UserRepresentation user = this.testRealm().users().get(loginEvent.getUserId()).toRepresentation();
        user.getRequiredActions().add(UserModel.RequiredAction.UPDATE_PASSWORD.toString());
        this.testRealm().users().get(loginEvent.getUserId()).update(user);
        this.oauth.openLoginForm();
        this.updatePasswordPage.assertCurrent();
        this.updatePasswordPage.changePassword("password", "password");
        this.events.expectRequiredAction(EventType.UPDATE_PASSWORD).assertEvent();
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        loginEvent = this.events.expectLogin().removeDetail("username").client("test-app").assertEvent();
        String sessionId2 = loginEvent.getSessionId();
        Assert.assertEquals((Object)sessionId, (Object)sessionId2);
    }
}

