/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.forms;

import java.io.IOException;
import java.io.Serializable;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.jose.jws.JWSBuilder;
import org.keycloak.models.KeyManager;
import org.keycloak.models.RealmModel;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.AbstractTestRealmKeycloakTest;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.runonserver.FetchOnServer;
import org.openqa.selenium.Cookie;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class RestartCookieTest
extends AbstractTestRealmKeycloakTest {
    @Page
    protected LoginPage loginPage;
    @Rule
    public AssertEvents events = new AssertEvents(this);
    private static final String OLD_RESTART_COOKIE_JSON = "{\n  \"cs\": \"874a1ea8-5579-4f21-add0-903dd8e3ec1b\",\n  \"cid\": \"test-app\",\n  \"pty\": \"openid-connect\",\n  \"ruri\": \"http://localhost:8081/auth/realms/master/app/auth\",\n  \"act\": \"AUTHENTICATE\",\n  \"notes\": {\n    \"auth_type\": \"code\",\n    \"scope\": \"openid\",\n    \"iss\": \"http://localhost:8081/auth/realms/master/app/auth\",\n    \"response_type\": \"code\",\n    \"redirect_uri\": \"http://localhost:8081/auth/realms/master/app/auth/\",\n    \"state\": \"6c983e5b-2dc1-411a-9ed1-0f51095949c5\",\n    \"code_challenge_method\": \"plain\",\n    \"nonce\": \"65639660-99b2-4cdf-bc9f-9978fdce5b03\",\n    \"response_mode\": \"fragment\"\n  }\n}";

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
    }

    @Test
    public void testRestartCookieBackwardsCompatible_Keycloak25() throws IOException {
        String oldRestartCookie = this.testingClient.server().fetchString((FetchOnServer & Serializable)session -> {
            try {
                String cookieVal = OLD_RESTART_COOKIE_JSON.replace("\n", "").replace(" ", "");
                RealmModel realm = session.realms().getRealmByName("test");
                KeyManager.ActiveHmacKey activeKey = session.keys().getActiveHmacKey(realm);
                String encodedToken = new JWSBuilder().kid(activeKey.getKid()).content(cookieVal.getBytes("UTF-8")).hmac256(activeKey.getSecretKey());
                return encodedToken;
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        });
        this.oauth.openLoginForm();
        this.driver.manage().deleteAllCookies();
        this.driver.manage().addCookie(new Cookie("KC_RESTART", oldRestartCookie));
        this.loginPage.login("foo", "bar");
        this.loginPage.assertCurrent();
        Assert.assertEquals((Object)"Your login attempt timed out. Login will start from the beginning.", (Object)this.loginPage.getError());
        this.events.expectLogin().user((String)null).session((String)null).error("expired_code").clearDetails().detail("restart_after_timeout", "true").client((String)null).assertEvent();
    }

    @Test
    public void testRestartCookieBackwardsCompatible_Keycloak19() throws IOException {
        String oldRestartCookie = this.testingClient.server().fetchString((FetchOnServer & Serializable)session -> {
            try {
                String cookieVal = OLD_RESTART_COOKIE_JSON.replace("\n", "").replace(" ", "");
                RealmModel realm = session.realms().getRealmByName("test");
                KeyManager.ActiveHmacKey activeKey = session.keys().getActiveHmacKey(realm);
                String encodedToken = new JWSBuilder().content(cookieVal.getBytes("UTF-8")).hmac256(activeKey.getSecretKey());
                return encodedToken;
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        });
        this.oauth.openLoginForm();
        this.driver.manage().deleteAllCookies();
        this.driver.manage().addCookie(new Cookie("KC_RESTART", oldRestartCookie));
        this.loginPage.login("foo", "bar");
        this.loginPage.assertCurrent();
        Assert.assertEquals((Object)"Your login attempt timed out. Login will start from the beginning.", (Object)this.loginPage.getError());
        this.events.expectLogin().user((String)null).session((String)null).error("expired_code").clearDetails().detail("restart_after_timeout", "true").client((String)null).assertEvent();
    }
}

