/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.forms;

import java.io.IOException;
import java.io.Serializable;
import javax.mail.internet.MimeMessage;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.arquillian.graphene.page.Page;
import org.jgroups.util.Util;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.common.Profile;
import org.keycloak.events.EventType;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.AbstractTestRealmKeycloakTest;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.arquillian.annotation.DisableFeature;
import org.keycloak.testsuite.pages.AccountUpdateProfilePage;
import org.keycloak.testsuite.pages.AppPage;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.pages.RegisterPage;
import org.keycloak.testsuite.pages.VerifyEmailPage;
import org.keycloak.testsuite.runonserver.RunOnServer;
import org.keycloak.testsuite.updaters.RealmAttributeUpdater;
import org.keycloak.testsuite.util.FlowUtil;
import org.keycloak.testsuite.util.GreenMailRule;
import org.keycloak.testsuite.util.MailUtils;
import org.keycloak.testsuite.util.UserBuilder;

public class RegisterTest
extends AbstractTestRealmKeycloakTest {
    @Rule
    public AssertEvents events = new AssertEvents(this);
    @Page
    protected AppPage appPage;
    @Page
    protected LoginPage loginPage;
    @Page
    protected RegisterPage registerPage;
    @Page
    protected VerifyEmailPage verifyEmailPage;
    @Page
    protected AccountUpdateProfilePage accountPage;
    @Rule
    public GreenMailRule greenMail = new GreenMailRule();

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
    }

    @Test
    public void registerExistingUsernameForbidden() {
        this.loginPage.open();
        this.loginPage.clickRegister();
        this.registerPage.assertCurrent();
        this.registerPage.register("firstName", "lastName", "registerExistingUser@email", "roleRichUser", "password", "password");
        this.registerPage.assertCurrent();
        Assert.assertEquals((Object)"Username already exists.", (Object)this.registerPage.getInputAccountErrors().getUsernameError());
        Assert.assertEquals((Object)"firstName", (Object)this.registerPage.getFirstName());
        Assert.assertEquals((Object)"lastName", (Object)this.registerPage.getLastName());
        Assert.assertEquals((Object)"registerExistingUser@email", (Object)this.registerPage.getEmail());
        Assert.assertEquals((Object)"roleRichUser", (Object)this.registerPage.getUsername());
        Assert.assertEquals((Object)"", (Object)this.registerPage.getPassword());
        Assert.assertEquals((Object)"", (Object)this.registerPage.getPasswordConfirm());
        this.events.expectRegister("rolerichuser", "registerExistingUser@email").removeDetail("email").user((String)null).error("username_in_use").assertEvent();
    }

    @Test
    public void registerExistingEmailForbidden() {
        this.loginPage.open();
        this.loginPage.clickRegister();
        this.registerPage.assertCurrent();
        this.registerPage.register("firstName", "lastName", "test-user@localhost", "registerExistingUser", "password", "password");
        this.registerPage.assertCurrent();
        Assert.assertEquals((Object)"Email already exists.", (Object)this.registerPage.getInputAccountErrors().getEmailError());
        Assert.assertEquals((Object)"firstName", (Object)this.registerPage.getFirstName());
        Assert.assertEquals((Object)"lastName", (Object)this.registerPage.getLastName());
        Assert.assertEquals((Object)"test-user@localhost", (Object)this.registerPage.getEmail());
        Assert.assertEquals((Object)"registerExistingUser", (Object)this.registerPage.getUsername());
        Assert.assertEquals((Object)"", (Object)this.registerPage.getPassword());
        Assert.assertEquals((Object)"", (Object)this.registerPage.getPasswordConfirm());
        this.events.expectRegister("registerexistinguser", "registerExistingUser@email").removeDetail("email").user((String)null).error("email_in_use").assertEvent();
    }

    @Test
    public void registerExistingEmailAllowed() throws IOException {
        try (RealmAttributeUpdater rau = (RealmAttributeUpdater)this.setDuplicateEmailsAllowed(true).update();){
            this.loginPage.open();
            this.loginPage.clickRegister();
            this.registerPage.assertCurrent();
            this.registerPage.register("firstName", "lastName", "test-user@localhost", "registerExistingEmailUser", "password", "password");
            Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
            String userId = this.events.expectRegister("registerExistingEmailUser", "test-user@localhost").assertEvent().getUserId();
            this.events.expectLogin().detail("username", "registerexistingemailuser").user(userId).assertEvent();
            this.assertUserBasicRegisterAttributes(userId, "registerexistingemailuser", "test-user@localhost", "firstName", "lastName");
            this.testRealm().users().get(userId).remove();
        }
    }

    @Test
    public void registerUpperCaseEmail() throws IOException {
        String userId = this.registerUpperCaseAndGetUserId(false);
        MatcherAssert.assertThat((Object)userId, (Matcher)CoreMatchers.notNullValue());
        this.testRealm().users().get(userId).remove();
    }

    @Test
    public void registerUpperCaseEmailAsUsername() throws IOException {
        try (RealmAttributeUpdater rau = (RealmAttributeUpdater)this.configureRealmRegistrationEmailAsUsername(true).update();){
            String userId = this.registerUpperCaseAndGetUserId(true);
            MatcherAssert.assertThat((Object)userId, (Matcher)CoreMatchers.notNullValue());
            this.testRealm().users().get(userId).remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void registerUpperCaseEmailWithChangedEmailAsUsername() throws IOException {
        String userId = this.registerUpperCaseAndGetUserId(false);
        MatcherAssert.assertThat((Object)userId, (Matcher)CoreMatchers.notNullValue());
        this.oauth.openLogout();
        this.events.clear();
        try (RealmAttributeUpdater rau = (RealmAttributeUpdater)this.configureRealmRegistrationEmailAsUsername(true).update();){
            this.loginPage.open();
            this.loginPage.assertCurrent();
            String EMAIL = "TEST@localhost";
            this.loginPage.login("TEST@localhost", "password");
            MatcherAssert.assertThat((Object)AppPage.RequestType.AUTH_RESPONSE, (Matcher)Matchers.is((Object)this.appPage.getRequestType()));
            this.events.expectLogin().detail("username", "TEST@localhost").user(userId).assertEvent();
        }
        finally {
            MatcherAssert.assertThat((Object)userId, (Matcher)CoreMatchers.notNullValue());
            this.testRealm().users().get(userId).remove();
        }
    }

    @Test
    public void registerUserInvalidPasswordConfirm() {
        this.loginPage.open();
        this.loginPage.clickRegister();
        this.registerPage.assertCurrent();
        this.registerPage.register("firstName", "lastName", "registerUserInvalidPasswordConfirm@email", "registerUserInvalidPasswordConfirm", "password", "invalid");
        this.registerPage.assertCurrent();
        Assert.assertEquals((Object)"Password confirmation doesn't match.", (Object)this.registerPage.getInputPasswordErrors().getPasswordConfirmError());
        Assert.assertEquals((Object)"firstName", (Object)this.registerPage.getFirstName());
        Assert.assertEquals((Object)"lastName", (Object)this.registerPage.getLastName());
        Assert.assertEquals((Object)"registerUserInvalidPasswordConfirm@email", (Object)this.registerPage.getEmail());
        Assert.assertEquals((Object)"registerUserInvalidPasswordConfirm", (Object)this.registerPage.getUsername());
        Assert.assertEquals((Object)"", (Object)this.registerPage.getPassword());
        Assert.assertEquals((Object)"", (Object)this.registerPage.getPasswordConfirm());
        this.events.expectRegister("registerUserInvalidPasswordConfirm", "registerUserInvalidPasswordConfirm@email").removeDetail("username").removeDetail("email").user((String)null).error("invalid_registration").assertEvent();
    }

    @Test
    public void registerUserMissingPassword() {
        this.loginPage.open();
        this.loginPage.clickRegister();
        this.registerPage.assertCurrent();
        this.registerPage.register("firstName", "lastName", "registerUserMissingPassword@email", "registerUserMissingPassword", null, null);
        this.registerPage.assertCurrent();
        Assert.assertEquals((Object)"Please specify password.", (Object)this.registerPage.getInputPasswordErrors().getPasswordError());
        this.events.expectRegister("registerUserMissingPassword", "registerUserMissingPassword@email").removeDetail("username").removeDetail("email").user((String)null).error("invalid_registration").assertEvent();
    }

    @Test
    public void registerPasswordPolicy() throws IOException {
        try (RealmAttributeUpdater rau = (RealmAttributeUpdater)this.getRealmAttributeUpdater().setPasswordPolicy("length").update();){
            this.loginPage.open();
            this.loginPage.clickRegister();
            this.registerPage.assertCurrent();
            this.registerPage.register("firstName", "lastName", "registerPasswordPolicy@email", "registerPasswordPolicy", "pass", "pass");
            this.registerPage.assertCurrent();
            Assert.assertEquals((Object)"Invalid password: minimum length 8.", (Object)this.registerPage.getInputPasswordErrors().getPasswordError());
            this.events.expectRegister("registerPasswordPolicy", "registerPasswordPolicy@email").removeDetail("username").removeDetail("email").user((String)null).error("invalid_registration").assertEvent();
            this.registerPage.register("firstName", "lastName", "registerPasswordPolicy@email", "registerPasswordPolicy", "password", "password");
            Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
            String userId = this.events.expectRegister("registerPasswordPolicy", "registerPasswordPolicy@email").assertEvent().getUserId();
            this.events.expectLogin().user(userId).detail("username", "registerpasswordpolicy").assertEvent();
        }
    }

    @Test
    public void registerUserMissingUsername() {
        this.loginPage.open();
        this.loginPage.clickRegister();
        this.registerPage.assertCurrent();
        this.registerPage.register("firstName", "lastName", "registerUserMissingUsername@email", null, "password", "password");
        this.registerPage.assertCurrent();
        Assert.assertEquals((Object)"Please specify username.", (Object)this.registerPage.getInputAccountErrors().getUsernameError());
        this.events.expectRegister(null, "registerUserMissingUsername@email").removeDetail("username").removeDetail("email").error("invalid_registration").assertEvent();
    }

    @Test
    public void registerUserManyErrors() {
        this.loginPage.open();
        this.loginPage.clickRegister();
        this.registerPage.assertCurrent();
        this.registerPage.register(null, null, null, null, null, null);
        this.registerPage.assertCurrent();
        Assert.assertEquals((Object)"Please specify username.", (Object)this.registerPage.getInputAccountErrors().getUsernameError());
        MatcherAssert.assertThat((Object)this.registerPage.getInputAccountErrors().getFirstNameError(), (Matcher)Matchers.anyOf((Matcher)Matchers.containsString((String)"Please specify first name"), (Matcher)Matchers.containsString((String)"Please specify this field")));
        MatcherAssert.assertThat((Object)this.registerPage.getInputAccountErrors().getLastNameError(), (Matcher)Matchers.anyOf((Matcher)Matchers.containsString((String)"Please specify last name"), (Matcher)Matchers.containsString((String)"Please specify this field")));
        MatcherAssert.assertThat((Object)this.registerPage.getInputAccountErrors().getEmailError(), (Matcher)Matchers.anyOf((Matcher)Matchers.containsString((String)"Please specify email"), (Matcher)Matchers.containsString((String)"Please specify this field")));
        MatcherAssert.assertThat((Object)this.registerPage.getInputPasswordErrors().getPasswordError(), (Matcher)Matchers.is((Object)"Please specify password."));
        this.events.expectRegister(null, "registerUserMissingUsername@email").removeDetail("username").removeDetail("email").error("invalid_registration").assertEvent();
    }

    @Test
    public void registerUserMissingEmail() {
        this.loginPage.open();
        this.loginPage.clickRegister();
        this.registerPage.assertCurrent();
        this.registerPage.register("firstName", "lastName", null, "registerUserMissingEmail", "password", "password");
        this.registerPage.assertCurrent();
        Assert.assertEquals((Object)"Please specify email.", (Object)this.registerPage.getInputAccountErrors().getEmailError());
        this.events.expectRegister("registerusermissingemail", null).removeDetail("email").error("invalid_registration").assertEvent();
    }

    @Test
    public void registerUserInvalidEmail() {
        this.loginPage.open();
        this.loginPage.clickRegister();
        this.registerPage.assertCurrent();
        this.registerPage.register("firstName", "lastName", "registerUserInvalidEmailemail", "registerUserInvalidEmail", "password", "password");
        this.registerPage.assertCurrent();
        Assert.assertEquals((Object)"registerUserInvalidEmailemail", (Object)this.registerPage.getEmail());
        Assert.assertEquals((Object)"Invalid email address.", (Object)this.registerPage.getInputAccountErrors().getEmailError());
        this.events.expectRegister("registeruserinvalidemail", "registerUserInvalidEmailemail").error("invalid_registration").assertEvent();
    }

    @Test
    public void registerUserSuccess() {
        this.loginPage.open();
        this.loginPage.clickRegister();
        this.registerPage.assertCurrent();
        String username = "register.U-se@rS_uccess";
        this.registerPage.register("firstName", "lastName", "registerUserSuccess@email", username, "password", "password");
        this.appPage.assertCurrent();
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        String userId = this.events.expectRegister(username, "registerUserSuccess@email").assertEvent().getUserId();
        this.assertUserRegistered(userId, username.toLowerCase(), "registerusersuccess@email");
    }

    private void assertUserRegistered(String userId, String username, String email) {
        this.events.expectLogin().detail("username", username.toLowerCase()).user(userId).assertEvent();
        UserRepresentation user = this.getUser(userId);
        Assert.assertNotNull((Object)user);
        Assert.assertNotNull((Object)user.getCreatedTimestamp());
        Assert.assertTrue((System.currentTimeMillis() - user.getCreatedTimestamp() < 10000L ? 1 : 0) != 0);
        this.assertUserBasicRegisterAttributes(userId, username, email, "firstName", "lastName");
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void registerUserSuccessWithEmailVerification() throws Exception {
        try (RealmAttributeUpdater rau = (RealmAttributeUpdater)this.setVerifyEmail(true).update();){
            this.loginPage.open();
            this.loginPage.clickRegister();
            this.registerPage.assertCurrent();
            this.registerPage.register("firstName", "lastName", "registerUserSuccessWithEmailVerification@email", "registerUserSuccessWithEmailVerification", "password", "password");
            this.verifyEmailPage.assertCurrent();
            String userId = this.events.expectRegister("registerUserSuccessWithEmailVerification", "registerUserSuccessWithEmailVerification@email").assertEvent().getUserId();
            Util.assertTrue((String)"Expecting verify email", (boolean)this.greenMail.waitForIncomingEmail(1000L, 1));
            this.events.expect(EventType.SEND_VERIFY_EMAIL).detail("email", "registerUserSuccessWithEmailVerification@email".toLowerCase()).user(userId).assertEvent();
            MimeMessage message = this.greenMail.getLastReceivedMessage();
            String link = MailUtils.getPasswordResetEmailLink((MimeMessage)message);
            this.driver.navigate().to(link);
            this.events.expectRequiredAction(EventType.VERIFY_EMAIL).detail("email", "registerUserSuccessWithEmailVerification@email".toLowerCase()).user(userId).assertEvent();
            this.assertUserRegistered(userId, "registerUserSuccessWithEmailVerification", "registerUserSuccessWithEmailVerification@email");
            this.appPage.assertCurrent();
            Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        }
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void registerUserSuccessWithEmailVerificationWithResend() throws Exception {
        try (RealmAttributeUpdater rau = (RealmAttributeUpdater)this.setVerifyEmail(true).update();){
            this.loginPage.open();
            this.loginPage.clickRegister();
            this.registerPage.assertCurrent();
            this.registerPage.register("firstName", "lastName", "registerUserSuccessWithEmailVerificationWithResend@email", "registerUserSuccessWithEmailVerificationWithResend", "password", "password");
            this.verifyEmailPage.assertCurrent();
            String userId = this.events.expectRegister("registerUserSuccessWithEmailVerificationWithResend", "registerUserSuccessWithEmailVerificationWithResend@email").assertEvent().getUserId();
            Util.assertTrue((String)"Expecting verify email", (boolean)this.greenMail.waitForIncomingEmail(1000L, 1));
            this.events.expect(EventType.SEND_VERIFY_EMAIL).detail("email", "registerUserSuccessWithEmailVerificationWithResend@email".toLowerCase()).user(userId).assertEvent();
            this.verifyEmailPage.clickResendEmail();
            this.verifyEmailPage.assertCurrent();
            Util.assertTrue((String)"Expecting second verify email", (boolean)this.greenMail.waitForIncomingEmail(1000L, 1));
            this.events.expect(EventType.SEND_VERIFY_EMAIL).detail("email", "registerUserSuccessWithEmailVerificationWithResend@email".toLowerCase()).user(userId).assertEvent();
            MimeMessage message = this.greenMail.getLastReceivedMessage();
            String link = MailUtils.getPasswordResetEmailLink((MimeMessage)message);
            this.driver.navigate().to(link);
            this.events.expectRequiredAction(EventType.VERIFY_EMAIL).detail("email", "registerUserSuccessWithEmailVerificationWithResend@email".toLowerCase()).user(userId).assertEvent();
            this.assertUserRegistered(userId, "registerUserSuccessWithEmailVerificationWithResend", "registerUserSuccessWithEmailVerificationWithResend@email");
            this.appPage.assertCurrent();
            Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        }
    }

    @Test
    @DisableFeature(value=Profile.Feature.ACCOUNT2, skipRestart=true)
    public void registerUserUmlats() {
        this.loginPage.open();
        Util.assertTrue((boolean)this.loginPage.isCurrent());
        this.loginPage.clickRegister();
        this.registerPage.assertCurrent();
        this.registerPage.register("\u00c4\u01dc\u1e73\u01da\u01d8\u01d6", "\u00d6\u1e4f\u1e4f", "registeruserumlats@email", "registeruserumlats", "password", "password");
        String userId = this.events.expectRegister("registeruserumlats", "registeruserumlats@email").assertEvent().getUserId();
        this.events.expectLogin().detail("username", "registeruserumlats").user(userId).assertEvent();
        this.accountPage.open();
        Util.assertTrue((boolean)this.accountPage.isCurrent());
        UserRepresentation user = this.getUser(userId);
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)"\u00c4\u01dc\u1e73\u01da\u01d8\u01d6", (Object)user.getFirstName());
        Assert.assertEquals((Object)"\u00d6\u1e4f\u1e4f", (Object)user.getLastName());
        Assert.assertEquals((Object)"\u00c4\u01dc\u1e73\u01da\u01d8\u01d6", (Object)this.accountPage.getFirstName());
        Assert.assertEquals((Object)"\u00d6\u1e4f\u1e4f", (Object)this.accountPage.getLastName());
    }

    @Test
    public void registerUserNotUsernamePasswordPolicy() throws IOException {
        try (RealmAttributeUpdater rau = (RealmAttributeUpdater)this.getRealmAttributeUpdater().setPasswordPolicy("notUsername").update();){
            this.loginPage.open();
            Util.assertTrue((boolean)this.loginPage.isCurrent());
            this.loginPage.clickRegister();
            this.registerPage.assertCurrent();
            this.registerPage.register("firstName", "lastName", "registerUserNotUsername@email", "registerUserNotUsername", "registerUserNotUsername", "registerUserNotUsername");
            Util.assertTrue((boolean)this.registerPage.isCurrent());
            Assert.assertEquals((Object)"Invalid password: must not be equal to the username.", (Object)this.registerPage.getInputPasswordErrors().getPasswordError());
            this.adminClient.realm("test").users().create(UserBuilder.create().username("registerUserNotUsername").build());
            this.registerPage.register("firstName", "lastName", "registerUserNotUsername@email", "registerUserNotUsername", "registerUserNotUsername", "registerUserNotUsername");
            Util.assertTrue((boolean)this.registerPage.isCurrent());
            Assert.assertEquals((Object)"Username already exists.", (Object)this.registerPage.getInputAccountErrors().getUsernameError());
            this.registerPage.register("firstName", "lastName", "registerUserNotUsername@email", null, "password", "password");
            Util.assertTrue((boolean)this.registerPage.isCurrent());
            Assert.assertEquals((Object)"Please specify username.", (Object)this.registerPage.getInputAccountErrors().getUsernameError());
        }
    }

    @Test
    public void registerUserNotEmailPasswordPolicy() throws IOException {
        try (RealmAttributeUpdater rau = (RealmAttributeUpdater)this.configureRealmRegistrationEmailAsUsername(true).setPasswordPolicy("notEmail").update();){
            this.loginPage.open();
            Util.assertTrue((boolean)this.loginPage.isCurrent());
            this.loginPage.clickRegister();
            this.registerPage.assertCurrent();
            this.registerPage.registerWithEmailAsUsername("firstName", "lastName", "registerUserNotEmail@email", "registerUserNotEmail@email", "registerUserNotEmail@email");
            Util.assertTrue((boolean)this.registerPage.isCurrent());
            Assert.assertEquals((Object)"Invalid password: must not be equal to the email.", (Object)this.registerPage.getInputPasswordErrors().getPasswordError());
        }
    }

    protected UserRepresentation getUser(String userId) {
        return this.testRealm().users().get(userId).toRepresentation();
    }

    @Test
    public void registerExistingUser_emailAsUsername() throws IOException {
        try (RealmAttributeUpdater rau = (RealmAttributeUpdater)this.configureRealmRegistrationEmailAsUsername(true).update();){
            this.loginPage.open();
            this.loginPage.clickRegister();
            this.registerPage.assertCurrent();
            this.registerPage.registerWithEmailAsUsername("firstName", "lastName", "test-user@localhost", "password", "password");
            this.registerPage.assertCurrent();
            Assert.assertEquals((Object)"Email already exists.", (Object)this.registerPage.getInputAccountErrors().getEmailError());
            this.events.expectRegister("test-user@localhost", "test-user@localhost").user((String)null).error("email_in_use").assertEvent();
        }
    }

    @Test
    public void registerUserMissingOrInvalidEmail_emailAsUsername() throws IOException {
        try (RealmAttributeUpdater rau = (RealmAttributeUpdater)this.configureRealmRegistrationEmailAsUsername(true).update();){
            this.loginPage.open();
            this.loginPage.clickRegister();
            this.registerPage.assertCurrent();
            this.registerPage.registerWithEmailAsUsername("firstName", "lastName", null, "password", "password");
            this.registerPage.assertCurrent();
            Assert.assertEquals((Object)"Please specify email.", (Object)this.registerPage.getInputAccountErrors().getEmailError());
            this.events.expectRegister(null, null).removeDetail("username").removeDetail("email").error("invalid_registration").assertEvent();
            this.registerPage.registerWithEmailAsUsername("firstName", "lastName", "registerUserInvalidEmailemail", "password", "password");
            this.registerPage.assertCurrent();
            Assert.assertEquals((Object)"Invalid email address.", (Object)this.registerPage.getInputAccountErrors().getEmailError());
            this.events.expectRegister("registerUserInvalidEmailemail", "registerUserInvalidEmailemail").error("invalid_registration").assertEvent();
        }
    }

    @Test
    public void registerUserSuccess_emailAsUsername() throws IOException {
        try (RealmAttributeUpdater rau = (RealmAttributeUpdater)this.configureRealmRegistrationEmailAsUsername(true).update();){
            this.loginPage.open();
            this.loginPage.clickRegister();
            this.registerPage.assertCurrent();
            this.registerPage.registerWithEmailAsUsername("firstName", "lastName", "registerUserSuccessE@email", "password", "password");
            Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
            String userId = this.events.expectRegister("registerUserSuccessE@email", "registerUserSuccessE@email").assertEvent().getUserId();
            this.events.expectLogin().detail("username", "registerusersuccesse@email").user(userId).assertEvent();
            UserRepresentation user = this.getUser(userId);
            Assert.assertNotNull((Object)user);
            Assert.assertNotNull((Object)user.getCreatedTimestamp());
            Assert.assertTrue((System.currentTimeMillis() - user.getCreatedTimestamp() < 10000L ? 1 : 0) != 0);
        }
    }

    @Test
    public void registerWithLoginHint() throws IOException {
        this.registerPage.openWithLoginHint("username_test");
        Assert.assertEquals((Object)"username_test", (Object)this.registerPage.getUsername());
    }

    @Test
    public void registerWithLoginHint_emailAsUsername() throws IOException {
        try (RealmAttributeUpdater rau = (RealmAttributeUpdater)this.configureRealmRegistrationEmailAsUsername(true).update();){
            this.registerPage.openWithLoginHint("test@test.com");
            Assert.assertEquals((Object)"test@test.com", (Object)this.registerPage.getEmail());
        }
    }

    @Test
    public void customRegistrationPageFormTest() {
        String newFlowAlias = "register - custom";
        this.configureRegistrationFlowWithCustomRegistrationPageForm(newFlowAlias);
        this.loginPage.open();
        this.loginPage.clickRegister();
        this.registerPage.assertCurrent();
    }

    protected RealmAttributeUpdater configureRealmRegistrationEmailAsUsername(boolean value) {
        return this.getRealmAttributeUpdater().setRegistrationEmailAsUsername(Boolean.valueOf(value));
    }

    protected RealmAttributeUpdater setDuplicateEmailsAllowed(boolean allowed) {
        return this.getRealmAttributeUpdater().setDuplicateEmailsAllowed(Boolean.valueOf(allowed));
    }

    protected RealmAttributeUpdater setVerifyEmail(boolean value) {
        return this.getRealmAttributeUpdater().setVerifyEmail(Boolean.valueOf(value));
    }

    private RealmAttributeUpdater getRealmAttributeUpdater() {
        return new RealmAttributeUpdater(this.testRealm());
    }

    private String registerUpperCaseAndGetUserId(boolean emailAsUsername) {
        String EMAIL = "TEST@localhost";
        String USERNAME = "UPPERCASE";
        String EMAIL_OR_USERNAME = emailAsUsername ? "TEST@localhost" : "UPPERCASE";
        this.loginPage.open();
        this.loginPage.clickRegister();
        this.registerPage.assertCurrent();
        if (emailAsUsername) {
            this.registerPage.registerWithEmailAsUsername("firstName", "lastName", "TEST@localhost", "password", "password");
        } else {
            this.registerPage.register("firstName", "lastName", "TEST@localhost", "UPPERCASE", "password", "password");
        }
        String userId = this.events.expectRegister(EMAIL_OR_USERNAME, "TEST@localhost").assertEvent().getUserId();
        this.events.expectLogin().detail("username", EMAIL_OR_USERNAME.toLowerCase()).user(userId).assertEvent();
        this.assertUserBasicRegisterAttributes(userId, emailAsUsername ? null : "UPPERCASE", "TEST@localhost", "firstName", "lastName");
        return userId;
    }

    private void assertUserBasicRegisterAttributes(String userId, String username, String email, String firstName, String lastName) {
        UserRepresentation user = this.getUser(userId);
        MatcherAssert.assertThat((Object)user, (Matcher)CoreMatchers.notNullValue());
        if (username != null) {
            MatcherAssert.assertThat((Object)username.toLowerCase(), (Matcher)Matchers.is((Object)user.getUsername()));
        }
        MatcherAssert.assertThat((Object)email.toLowerCase(), (Matcher)Matchers.is((Object)user.getEmail()));
        MatcherAssert.assertThat((Object)firstName, (Matcher)Matchers.is((Object)user.getFirstName()));
        MatcherAssert.assertThat((Object)lastName, (Matcher)Matchers.is((Object)user.getLastName()));
    }

    private void configureRegistrationFlowWithCustomRegistrationPageForm(String newFlowAlias) {
        this.testingClient.server("test").run((RunOnServer & Serializable)session -> FlowUtil.inCurrentRealm(session).copyRegistrationFlow(newFlowAlias));
        this.testingClient.server("test").run((RunOnServer & Serializable)session -> FlowUtil.inCurrentRealm(session).selectFlow(newFlowAlias).clear().addAuthenticatorExecution(AuthenticationExecutionModel.Requirement.ALTERNATIVE, "auth-cookie").addSubFlowExecution("Sub Flow", "basic-flow", AuthenticationExecutionModel.Requirement.ALTERNATIVE, subflow -> subflow.addSubFlowExecution("Sub sub Form Flow", "form-flow", AuthenticationExecutionModel.Requirement.REQUIRED, subsubflow -> subsubflow.addAuthenticatorExecution(AuthenticationExecutionModel.Requirement.REQUIRED, "registration-user-creation").addAuthenticatorExecution(AuthenticationExecutionModel.Requirement.REQUIRED, "registration-profile-action").addAuthenticatorExecution(AuthenticationExecutionModel.Requirement.REQUIRED, "registration-password-action").addAuthenticatorExecution(AuthenticationExecutionModel.Requirement.DISABLED, "registration-recaptcha-action"))).defineAsRegistrationFlow());
    }
}

