/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.forms;

import java.io.Serializable;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.ws.rs.BadRequestException;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.common.Profile;
import org.keycloak.common.util.Base64;
import org.keycloak.credential.CredentialModel;
import org.keycloak.credential.hash.Pbkdf2PasswordHashProvider;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.credential.PasswordCredentialModel;
import org.keycloak.representations.idm.ErrorRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.AbstractTestRealmKeycloakTest;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.arquillian.annotation.DisableFeature;
import org.keycloak.testsuite.pages.AccountUpdateProfilePage;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.runonserver.FetchOnServer;
import org.keycloak.testsuite.util.UserBuilder;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class PasswordHashingTest
extends AbstractTestRealmKeycloakTest {
    @Page
    private AccountUpdateProfilePage updateProfilePage;
    @Page
    protected LoginPage loginPage;

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
    }

    @Test
    public void testSetInvalidProvider() throws Exception {
        try {
            this.setPasswordPolicy("hashAlgorithm(nosuch)");
            Assert.fail((String)"Expected error");
        }
        catch (BadRequestException e) {
            ErrorRepresentation error = (ErrorRepresentation)e.getResponse().readEntity(ErrorRepresentation.class);
            Assert.assertEquals((Object)"Invalid config for hashAlgorithm: Password hashing provider not found", (Object)error.getErrorMessage());
        }
    }

    @Test
    public void testPasswordRehashedOnAlgorithmChanged() throws Exception {
        this.setPasswordPolicy("hashAlgorithm(pbkdf2-sha256) and hashIterations(1)");
        String username = "testPasswordRehashedOnAlgorithmChanged";
        this.createUser(username);
        PasswordCredentialModel credential = PasswordCredentialModel.createFromCredentialModel((CredentialModel)this.fetchCredentials(username));
        Assert.assertEquals((Object)"pbkdf2-sha256", (Object)credential.getPasswordCredentialData().getAlgorithm());
        this.assertEncoded(credential, "password", credential.getPasswordSecretData().getSalt(), "PBKDF2WithHmacSHA256", 1);
        this.setPasswordPolicy("hashAlgorithm(pbkdf2) and hashIterations(1)");
        this.loginPage.open();
        this.loginPage.login(username, "password");
        credential = PasswordCredentialModel.createFromCredentialModel((CredentialModel)this.fetchCredentials(username));
        Assert.assertEquals((Object)"pbkdf2", (Object)credential.getPasswordCredentialData().getAlgorithm());
        this.assertEncoded(credential, "password", credential.getPasswordSecretData().getSalt(), "PBKDF2WithHmacSHA1", 1);
    }

    @Test
    public void testPasswordRehashedOnIterationsChanged() throws Exception {
        this.setPasswordPolicy("hashIterations(10000)");
        String username = "testPasswordRehashedOnIterationsChanged";
        this.createUser(username);
        PasswordCredentialModel credential = PasswordCredentialModel.createFromCredentialModel((CredentialModel)this.fetchCredentials(username));
        Assert.assertEquals((long)10000L, (long)credential.getPasswordCredentialData().getHashIterations());
        this.setPasswordPolicy("hashIterations(1)");
        this.loginPage.open();
        this.loginPage.login(username, "password");
        credential = PasswordCredentialModel.createFromCredentialModel((CredentialModel)this.fetchCredentials(username));
        Assert.assertEquals((long)1L, (long)credential.getPasswordCredentialData().getHashIterations());
        this.assertEncoded(credential, "password", credential.getPasswordSecretData().getSalt(), "PBKDF2WithHmacSHA256", 1);
    }

    @Test
    @DisableFeature(value=Profile.Feature.ACCOUNT2, skipRestart=true)
    public void testPasswordNotRehasedUnchangedIterations() {
        this.setPasswordPolicy("");
        String username = "testPasswordNotRehasedUnchangedIterations";
        this.createUser(username);
        PasswordCredentialModel credential = PasswordCredentialModel.createFromCredentialModel((CredentialModel)this.fetchCredentials(username));
        String credentialId = credential.getId();
        byte[] salt = credential.getPasswordSecretData().getSalt();
        this.setPasswordPolicy("hashIterations");
        this.loginPage.open();
        this.loginPage.login(username, "password");
        credential = PasswordCredentialModel.createFromCredentialModel((CredentialModel)this.fetchCredentials(username));
        Assert.assertEquals((Object)credentialId, (Object)credential.getId());
        Assert.assertArrayEquals((byte[])salt, (byte[])credential.getPasswordSecretData().getSalt());
        this.setPasswordPolicy("hashIterations(27500)");
        this.updateProfilePage.open();
        this.updateProfilePage.logout();
        this.loginPage.open();
        this.loginPage.login(username, "password");
        credential = PasswordCredentialModel.createFromCredentialModel((CredentialModel)this.fetchCredentials(username));
        Assert.assertEquals((Object)credentialId, (Object)credential.getId());
        Assert.assertArrayEquals((byte[])salt, (byte[])credential.getPasswordSecretData().getSalt());
    }

    @Test
    public void testPasswordRehashedWhenCredentialImportedWithDifferentKeySize() {
        this.setPasswordPolicy("hashAlgorithm(pbkdf2-sha512) and hashIterations(30000)");
        String username = "testPasswordRehashedWhenCredentialImportedWithDifferentKeySize";
        String password = "password";
        Pbkdf2PasswordHashProvider specificKeySizeHashProvider = new Pbkdf2PasswordHashProvider("pbkdf2-sha512", "PBKDF2WithHmacSHA512", 30000, 256);
        String encodedPassword = specificKeySizeHashProvider.encode(password, -1);
        UserRepresentation user = UserBuilder.create().username(username).password(encodedPassword).build();
        ApiUtil.createUserWithAdminClient((RealmResource)this.adminClient.realm("test"), (UserRepresentation)user);
        this.loginPage.open();
        this.loginPage.login(username, password);
        PasswordCredentialModel postLoginCredentials = PasswordCredentialModel.createFromCredentialModel((CredentialModel)this.fetchCredentials(username));
        Assert.assertEquals((long)(encodedPassword.length() * 2), (long)postLoginCredentials.getPasswordSecretData().getValue().length());
    }

    @Test
    public void testPbkdf2Sha1() throws Exception {
        this.setPasswordPolicy("hashAlgorithm(pbkdf2)");
        String username = "testPbkdf2Sha1";
        this.createUser(username);
        PasswordCredentialModel credential = PasswordCredentialModel.createFromCredentialModel((CredentialModel)this.fetchCredentials(username));
        this.assertEncoded(credential, "password", credential.getPasswordSecretData().getSalt(), "PBKDF2WithHmacSHA1", 20000);
    }

    @Test
    public void testDefault() throws Exception {
        this.setPasswordPolicy("");
        String username = "testDefault";
        this.createUser(username);
        PasswordCredentialModel credential = PasswordCredentialModel.createFromCredentialModel((CredentialModel)this.fetchCredentials(username));
        this.assertEncoded(credential, "password", credential.getPasswordSecretData().getSalt(), "PBKDF2WithHmacSHA256", 27500);
    }

    @Test
    public void testPbkdf2Sha256() throws Exception {
        this.setPasswordPolicy("hashAlgorithm(pbkdf2-sha256)");
        String username = "testPbkdf2Sha256";
        this.createUser(username);
        PasswordCredentialModel credential = PasswordCredentialModel.createFromCredentialModel((CredentialModel)this.fetchCredentials(username));
        this.assertEncoded(credential, "password", credential.getPasswordSecretData().getSalt(), "PBKDF2WithHmacSHA256", 27500);
    }

    @Test
    public void testPbkdf2Sha512() throws Exception {
        this.setPasswordPolicy("hashAlgorithm(pbkdf2-sha512)");
        String username = "testPbkdf2Sha512";
        this.createUser(username);
        PasswordCredentialModel credential = PasswordCredentialModel.createFromCredentialModel((CredentialModel)this.fetchCredentials(username));
        this.assertEncoded(credential, "password", credential.getPasswordSecretData().getSalt(), "PBKDF2WithHmacSHA512", 30000);
    }

    private void createUser(String username) {
        ApiUtil.createUserAndResetPasswordWithAdminClient((RealmResource)this.adminClient.realm("test"), (UserRepresentation)UserBuilder.create().username(username).build(), (String)"password");
    }

    private void setPasswordPolicy(String policy) {
        RealmRepresentation realmRep = this.testRealm().toRepresentation();
        realmRep.setPasswordPolicy(policy);
        this.testRealm().update(realmRep);
    }

    private CredentialModel fetchCredentials(String username) {
        return (CredentialModel)this.testingClient.server("test").fetch((FetchOnServer & Serializable)session -> {
            RealmModel realm = session.getContext().getRealm();
            UserModel user = session.users().getUserByUsername(realm, username);
            return session.userCredentialManager().getStoredCredentialsByTypeStream(realm, user, "password").findFirst().orElse(null);
        }, CredentialModel.class);
    }

    private void assertEncoded(PasswordCredentialModel credential, String password, byte[] salt, String algorithm, int iterations) throws Exception {
        PBEKeySpec spec = new PBEKeySpec(password.toCharArray(), salt, iterations, 512);
        byte[] key = SecretKeyFactory.getInstance(algorithm).generateSecret(spec).getEncoded();
        Assert.assertEquals((Object)Base64.encodeBytes((byte[])key), (Object)credential.getPasswordSecretData().getValue());
    }
}

