/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.forms;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.page.Page;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.common.Profile;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.utils.TimeBasedOTP;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.AbstractTestRealmKeycloakTest;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.arquillian.annotation.EnableFeature;
import org.keycloak.testsuite.client.KeycloakTestingClient;
import org.keycloak.testsuite.forms.BrowserFlowTest;
import org.keycloak.testsuite.pages.ErrorPage;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.pages.LoginTotpPage;
import org.keycloak.testsuite.pages.LoginUsernameOnlyPage;
import org.keycloak.testsuite.pages.PasswordPage;
import org.keycloak.testsuite.pages.SelectAuthenticatorPage;
import org.keycloak.testsuite.runonserver.RunOnServer;
import org.keycloak.testsuite.util.FlowUtil;
import org.keycloak.testsuite.util.OAuthClient;
import org.openqa.selenium.WebDriver;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class MultiFactorAuthenticationTest
extends AbstractTestRealmKeycloakTest {
    @ArquillianResource
    protected OAuthClient oauth;
    @Drone
    protected WebDriver driver;
    @Page
    protected LoginPage loginPage;
    @Page
    protected LoginUsernameOnlyPage loginUsernameOnlyPage;
    @Page
    protected PasswordPage passwordPage;
    @Page
    protected ErrorPage errorPage;
    @Page
    protected LoginTotpPage loginTotpPage;
    @Page
    protected SelectAuthenticatorPage selectAuthenticatorPage;
    @Rule
    public AssertEvents events = new AssertEvents(this);

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
    }

    private RealmRepresentation loadTestRealm() {
        RealmRepresentation res = AbstractAdminTest.loadJson(this.getClass().getResourceAsStream("/testrealm.json"), RealmRepresentation.class);
        res.setBrowserFlow("browser");
        return res;
    }

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        this.log.debug((Object)"Adding test realm for import from testrealm.json");
        testRealms.add(this.loadTestRealm());
    }

    @Test
    public void testAlternativeCredentials() {
        try {
            this.configureBrowserFlowWithAlternativeCredentials();
            this.loginUsernameOnlyPage.open();
            this.loginUsernameOnlyPage.login("test-user@localhost");
            this.passwordPage.assertCurrent();
            this.loginTotpPage.assertTryAnotherWayLinkAvailability(false);
            this.loginUsernameOnlyPage.open();
            this.loginUsernameOnlyPage.login("user-with-one-configured-otp");
            this.passwordPage.assertCurrent();
            this.passwordPage.assertTryAnotherWayLinkAvailability(true);
            this.passwordPage.clickTryAnotherWayLink();
            this.selectAuthenticatorPage.assertCurrent();
            Assert.assertEquals(Arrays.asList("Password", "Authenticator Application"), (Object)this.selectAuthenticatorPage.getAvailableLoginMethods());
            Assert.assertEquals((Object)"Sign in by entering your password.", (Object)this.selectAuthenticatorPage.getLoginMethodHelpText("Password"));
            Assert.assertEquals((Object)"Enter a verification code from authenticator application.", (Object)this.selectAuthenticatorPage.getLoginMethodHelpText("Authenticator Application"));
            this.selectAuthenticatorPage.selectLoginMethod("Authenticator Application");
            this.loginTotpPage.assertCurrent();
            this.loginTotpPage.assertTryAnotherWayLinkAvailability(true);
            this.loginTotpPage.assertOtpCredentialSelectorAvailability(false);
            this.loginUsernameOnlyPage.open();
            this.loginUsernameOnlyPage.login("user-with-two-configured-otp");
            this.loginTotpPage.assertCurrent();
            this.loginTotpPage.assertTryAnotherWayLinkAvailability(true);
            this.loginTotpPage.assertOtpCredentialSelectorAvailability(true);
            this.loginTotpPage.clickTryAnotherWayLink();
            this.selectAuthenticatorPage.assertCurrent();
            Assert.assertEquals(Arrays.asList("Authenticator Application", "Password"), (Object)this.selectAuthenticatorPage.getAvailableLoginMethods());
        }
        finally {
            BrowserFlowTest.revertFlows(this.testRealm(), "browser - alternative");
        }
    }

    private void configureBrowserFlowWithAlternativeCredentials() {
        MultiFactorAuthenticationTest.configureBrowserFlowWithAlternativeCredentials(this.testingClient);
    }

    static void configureBrowserFlowWithAlternativeCredentials(KeycloakTestingClient testingClient) {
        String newFlowAlias = "browser - alternative";
        testingClient.server("test").run((RunOnServer & Serializable)session -> FlowUtil.inCurrentRealm(session).copyBrowserFlow("browser - alternative"));
        testingClient.server("test").run((RunOnServer & Serializable)session -> FlowUtil.inCurrentRealm(session).selectFlow("browser - alternative").inForms(forms -> forms.clear().addAuthenticatorExecution(AuthenticationExecutionModel.Requirement.REQUIRED, "auth-username-form").addSubFlowExecution(AuthenticationExecutionModel.Requirement.REQUIRED, altSubFlow -> altSubFlow.addAuthenticatorExecution(AuthenticationExecutionModel.Requirement.ALTERNATIVE, "auth-password-form").addAuthenticatorExecution(AuthenticationExecutionModel.Requirement.ALTERNATIVE, "auth-otp-form"))).defineAsBrowserFlow());
    }

    @Test
    public void testAlternativeMechanismsInDifferentSubflows() {
        String newFlowAlias = "browser - alternative mechanisms";
        this.testingClient.server("test").run((RunOnServer & Serializable)session -> FlowUtil.inCurrentRealm(session).copyBrowserFlow("browser - alternative mechanisms"));
        this.testingClient.server("test").run((RunOnServer & Serializable)session -> FlowUtil.inCurrentRealm(session).selectFlow("browser - alternative mechanisms").inForms(forms -> forms.clear().addAuthenticatorExecution(AuthenticationExecutionModel.Requirement.REQUIRED, "auth-username-form").addSubFlowExecution(AuthenticationExecutionModel.Requirement.REQUIRED, reqSubFlow -> reqSubFlow.addAuthenticatorExecution(AuthenticationExecutionModel.Requirement.ALTERNATIVE, "auth-password-form").addSubFlowExecution("otp subflow", "basic-flow", AuthenticationExecutionModel.Requirement.ALTERNATIVE, altSubFlow -> altSubFlow.addAuthenticatorExecution(AuthenticationExecutionModel.Requirement.REQUIRED, "auth-otp-form")))).defineAsBrowserFlow());
        try {
            this.loginUsernameOnlyPage.open();
            this.loginUsernameOnlyPage.login("user-with-one-configured-otp");
            this.passwordPage.assertCurrent();
            this.passwordPage.assertTryAnotherWayLinkAvailability(true);
            this.passwordPage.clickTryAnotherWayLink();
            this.selectAuthenticatorPage.assertCurrent();
            Assert.assertEquals(Arrays.asList("Password", "Authenticator Application"), (Object)this.selectAuthenticatorPage.getAvailableLoginMethods());
            this.selectAuthenticatorPage.selectLoginMethod("Authenticator Application");
            this.loginTotpPage.assertCurrent();
            this.loginTotpPage.assertTryAnotherWayLinkAvailability(true);
            this.loginTotpPage.clickTryAnotherWayLink();
            this.selectAuthenticatorPage.assertCurrent();
            Assert.assertEquals(Arrays.asList("Password", "Authenticator Application"), (Object)this.selectAuthenticatorPage.getAvailableLoginMethods());
            this.selectAuthenticatorPage.selectLoginMethod("Password");
            this.passwordPage.assertCurrent();
            this.passwordPage.login("password");
            Assert.assertFalse((boolean)this.passwordPage.isCurrent());
            Assert.assertFalse((boolean)this.loginPage.isCurrent());
            this.events.expectLogin().user(((UserRepresentation)this.testRealm().users().search("user-with-one-configured-otp").get(0)).getId()).detail("username", "user-with-one-configured-otp").assertEvent();
        }
        finally {
            BrowserFlowTest.revertFlows(this.testRealm(), "browser - alternative mechanisms");
        }
    }

    @Test
    @EnableFeature(value=Profile.Feature.WEB_AUTHN, skipRestart=true, onlyForProduct=true)
    public void testAlternativeMechanismsInDifferentSubflows_firstMechanismUnavailable() {
        String newFlowAlias = "browser - alternative mechanisms";
        this.testingClient.server("test").run((RunOnServer & Serializable)session -> FlowUtil.inCurrentRealm(session).copyBrowserFlow("browser - alternative mechanisms"));
        this.testingClient.server("test").run((RunOnServer & Serializable)session -> FlowUtil.inCurrentRealm(session).selectFlow("browser - alternative mechanisms").inForms(forms -> forms.clear().addAuthenticatorExecution(AuthenticationExecutionModel.Requirement.REQUIRED, "auth-username-form").addSubFlowExecution(AuthenticationExecutionModel.Requirement.REQUIRED, reqSubFlow -> reqSubFlow.addAuthenticatorExecution(AuthenticationExecutionModel.Requirement.ALTERNATIVE, "webauthn-authenticator").addSubFlowExecution("password and otp subflow", "basic-flow", AuthenticationExecutionModel.Requirement.ALTERNATIVE, altSubFlow -> altSubFlow.addAuthenticatorExecution(AuthenticationExecutionModel.Requirement.REQUIRED, "auth-password-form").addAuthenticatorExecution(AuthenticationExecutionModel.Requirement.REQUIRED, "auth-otp-form")))).defineAsBrowserFlow());
        try {
            this.loginUsernameOnlyPage.open();
            this.loginUsernameOnlyPage.login("user-with-one-configured-otp");
            this.passwordPage.assertCurrent();
            this.passwordPage.assertTryAnotherWayLinkAvailability(false);
            this.passwordPage.login("password");
            this.loginTotpPage.assertCurrent();
            this.loginTotpPage.assertTryAnotherWayLinkAvailability(false);
            this.loginTotpPage.login(new TimeBasedOTP().generateTOTP("DJmQfC73VGFhw7D4QJ8A"));
            Assert.assertFalse((boolean)this.loginTotpPage.isCurrent());
            this.events.expectLogin().user(((UserRepresentation)this.testRealm().users().search("user-with-one-configured-otp").get(0)).getId()).detail("username", "user-with-one-configured-otp").assertEvent();
        }
        finally {
            BrowserFlowTest.revertFlows(this.testRealm(), "browser - alternative mechanisms");
        }
    }

    @Test
    public void testUsernameLabelAndResetLogin() {
        try {
            this.configureBrowserFlowWithAlternativeCredentials();
            this.loginUsernameOnlyPage.open();
            this.loginUsernameOnlyPage.assertAttemptedUsernameAvailability(false);
            this.loginUsernameOnlyPage.login("user-with-one-configured-otp");
            this.passwordPage.assertCurrent();
            this.passwordPage.assertAttemptedUsernameAvailability(true);
            Assert.assertEquals((Object)"user-with-one-configured-otp", (Object)this.passwordPage.getAttemptedUsername());
            this.passwordPage.clickTryAnotherWayLink();
            this.selectAuthenticatorPage.assertCurrent();
            this.selectAuthenticatorPage.assertAttemptedUsernameAvailability(true);
            Assert.assertEquals((Object)"user-with-one-configured-otp", (Object)this.passwordPage.getAttemptedUsername());
            this.selectAuthenticatorPage.clickResetLogin();
            this.loginUsernameOnlyPage.assertCurrent();
            this.loginUsernameOnlyPage.assertAttemptedUsernameAvailability(false);
            this.loginUsernameOnlyPage.login("otp1@redhat.com");
            this.passwordPage.assertCurrent();
            this.passwordPage.assertAttemptedUsernameAvailability(true);
            Assert.assertEquals((Object)"otp1@redhat.com", (Object)this.passwordPage.getAttemptedUsername());
            this.passwordPage.login("password");
            this.events.expectLogin().user(((UserRepresentation)this.testRealm().users().search("user-with-one-configured-otp").get(0)).getId()).detail("username", "otp1@redhat.com").assertEvent();
        }
        finally {
            BrowserFlowTest.revertFlows(this.testRealm(), "browser - alternative");
        }
    }
}

